/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.guice.GuiceBundle;
import com.intellij.guice.constants.GuiceAnnotations;
import com.intellij.guice.inspections.BaseInspection;
import com.intellij.guice.inspections.BaseInspectionVisitor;
import com.intellij.guice.utils.AnnotationUtils;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class SessionScopedInjectsRequestScopedInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = GuiceBundle.message("session.scoped.injects.request.scoped.problem.descriptor", new Object[0]);
        if (string == null) {
            SessionScopedInjectsRequestScopedInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/inspections/SessionScopedInjectsRequestScopedInspection", "buildErrorString"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            super.visitAnnotation(annotation);
            String qualifiedName = annotation.getQualifiedName();
            if (!GuiceAnnotations.INJECTS.contains(qualifiedName)) {
                return;
            }
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiClass.class);
            if (containingClass == null) {
                return;
            }
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)containingClass, (String)"com.google.inject.servlet.SessionScoped", (int)1)) {
                return;
            }
            PsiElement owner = annotation.getParent().getParent();
            if (owner instanceof PsiField) {
                PsiField field = (PsiField)owner;
                this.checkForScopedInjection(field.getTypeElement());
            } else if (owner instanceof PsiMethod) {
                PsiParameter[] parameters;
                PsiMethod method = (PsiMethod)owner;
                for (PsiParameter parameter : parameters = method.getParameterList().getParameters()) {
                    this.checkForScopedInjection(parameter.getTypeElement());
                }
            }
        }

        private void checkForScopedInjection(PsiTypeElement typeElement) {
            PsiType type = typeElement.getType();
            if (!(type instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClass referencedClass = classType.resolve();
            if (referencedClass == null) {
                return;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)referencedClass, (String)"com.google.inject.servlet.RequestScoped", (int)1)) {
                this.registerError((PsiElement)typeElement, new Object[0]);
                return;
            }
            PsiAnnotation implementedByAnnotation = referencedClass.getModifierList().findAnnotation("com.google.inject.ImplementedBy");
            if (implementedByAnnotation == null) {
                return;
            }
            PsiElement defaultValue = AnnotationUtils.findDefaultValue(implementedByAnnotation);
            if (defaultValue == null) {
                return;
            }
            if (!(defaultValue instanceof PsiClassObjectAccessExpression)) {
                return;
            }
            PsiTypeElement classTypeElement = ((PsiClassObjectAccessExpression)defaultValue).getOperand();
            PsiType implementedByClassType = classTypeElement.getType();
            if (!(implementedByClassType instanceof PsiClassType)) {
                return;
            }
            PsiClass implementedByClass = ((PsiClassType)implementedByClassType).resolve();
            if (implementedByClass == null) {
                return;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)implementedByClass, (String)"com.google.inject.servlet.RequestScoped", (int)1)) {
                this.registerError((PsiElement)typeElement, new Object[0]);
            }
        }
    }
}

