/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.model;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.guice.GuiceBundle;
import com.intellij.guice.model.GuiceInjectionUtil;
import com.intellij.guice.model.GuiceInjectorManager;
import com.intellij.guice.model.InjectionPointDescriptor;
import com.intellij.guice.model.beans.BindDescriptor;
import com.intellij.guice.model.jam.GuiceProvides;
import com.intellij.guice.model.renderers.GuiceBindingClassPsiElementListCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import icons.GuiceIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class GuiceInjectionsClassAnnotator
extends RelatedItemLineMarkerProvider {
    private final PsiElementListCellRenderer BINDING_CLASS_CELL_RENDERER = new GuiceBindingClassPsiElementListCellRenderer();

    protected void collectNavigationMarkers(@NotNull PsiElement psiElement, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        Module module;
        if (psiElement == null) {
            GuiceInjectionsClassAnnotator.$$$reportNull$$$0(0);
        }
        if (result == null) {
            GuiceInjectionsClassAnnotator.$$$reportNull$$$0(1);
        }
        if (psiElement instanceof PsiClass) {
            module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
            if (module == null) {
                return;
            }
            PsiClass psiClass = (PsiClass)psiElement;
            this.annotateClassBindings(result, module, psiClass);
        }
        if (psiElement instanceof PsiMethod) {
            module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
            if (module == null) {
                return;
            }
            if ("configure".equals(((PsiMethod)psiElement).getName())) {
                GuiceInjectionsClassAnnotator.annotateInjectionPoints(result, module, (PsiMethod)psiElement);
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiMethod)psiElement), (String)"com.google.inject.Provides", (int)0)) {
                GuiceInjectionsClassAnnotator.annotateProvidesInjectionPoints(result, module, (PsiMethod)psiElement);
            }
        }
    }

    private void annotateClassBindings(Collection<? super RelatedItemLineMarkerInfo> result, Module module, PsiClass psiClass) {
        Set<InjectionPointDescriptor> points = GuiceInjectionUtil.getInjectionPoints(psiClass, false);
        PsiFile containingFile = psiClass.getContainingFile();
        if (points.size() > 0) {
            Set<BindDescriptor> allDescriptors = GuiceInjectorManager.getBindingDescriptors(module);
            List<GuiceProvides> allProvides = GuiceInjectionUtil.getProvides(module.getProject(), GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
            for (InjectionPointDescriptor ip : points) {
                PsiElement identifier;
                PsiModifierListOwner owner = ip.getOwner();
                if (!containingFile.equals(owner.getContainingFile())) continue;
                Set<BindDescriptor> descriptors = GuiceInjectorManager.getInjectBindingDescriptors(ip, allDescriptors);
                Set<GuiceProvides> providesSet = GuiceInjectorManager.getInjectProvidesDescriptors(ip, allProvides);
                if (!(owner instanceof PsiNameIdentifierOwner) || (identifier = ((PsiNameIdentifierOwner)owner).getNameIdentifier()) == null) continue;
                this.addInjectedGutterIcon(result, descriptors, providesSet, identifier);
            }
        }
    }

    private static void annotateInjectionPoints(Collection<? super RelatedItemLineMarkerInfo> result, @NotNull Module module, @NotNull PsiMethod scope) {
        Set<InjectionPointDescriptor> allInjectionPoints;
        Set<BindDescriptor> descriptors;
        if (module == null) {
            GuiceInjectionsClassAnnotator.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            GuiceInjectionsClassAnnotator.$$$reportNull$$$0(3);
        }
        if ((descriptors = GuiceInjectorManager.getBindingDescriptors((PsiElement)scope)).size() > 0 && (allInjectionPoints = GuiceInjectionUtil.getInjectionPoints(module.getProject(), GlobalSearchScope.moduleWithDependenciesScope((Module)module))).size() > 0) {
            for (BindDescriptor descriptor : descriptors) {
                GuiceInjectionsClassAnnotator.addInjectionPointsGutterIcon(result, GuiceInjectionUtil.getInjectionPoints(descriptor, allInjectionPoints), PsiTreeUtil.getDeepestFirst((PsiElement)descriptor.getBindExpression()));
            }
        }
    }

    private static void annotateProvidesInjectionPoints(Collection<? super RelatedItemLineMarkerInfo> result, @NotNull Module module, @NotNull PsiMethod psiMethod) {
        Set<InjectionPointDescriptor> allInjectionPoints;
        Set<InjectionPointDescriptor> injectionPoints;
        GuiceProvides provides;
        if (module == null) {
            GuiceInjectionsClassAnnotator.$$$reportNull$$$0(4);
        }
        if (psiMethod == null) {
            GuiceInjectionsClassAnnotator.$$$reportNull$$$0(5);
        }
        if ((provides = (GuiceProvides)JamService.getJamService((Project)module.getProject()).getJamElement((PsiElement)psiMethod, new JamMemberMeta[]{GuiceProvides.METHOD_META})) != null && (injectionPoints = GuiceInjectionUtil.getInjectionPoints(provides, allInjectionPoints = GuiceInjectionUtil.getInjectionPoints(module.getProject(), GlobalSearchScope.moduleWithDependenciesScope((Module)module)))).size() > 0) {
            GuiceInjectionsClassAnnotator.addInjectionPointsGutterIcon(result, injectionPoints, (PsiElement)psiMethod.getNameIdentifier());
        }
    }

    private void addInjectedGutterIcon(@NotNull Collection<? super RelatedItemLineMarkerInfo> result, @NotNull Set<BindDescriptor> descriptors, @NotNull Set<GuiceProvides> provides, @NotNull PsiElement identifier) {
        if (result == null) {
            GuiceInjectionsClassAnnotator.$$$reportNull$$$0(6);
        }
        if (descriptors == null) {
            GuiceInjectionsClassAnnotator.$$$reportNull$$$0(7);
        }
        if (provides == null) {
            GuiceInjectionsClassAnnotator.$$$reportNull$$$0(8);
        }
        if (identifier == null) {
            GuiceInjectionsClassAnnotator.$$$reportNull$$$0(9);
        }
        ArrayList<Object> allTargets = new ArrayList<Object>();
        for (BindDescriptor descriptor : descriptors) {
            allTargets.add(descriptor.getBindExpression());
        }
        for (GuiceProvides provide : provides) {
            allTargets.add(provide.getPsiElement());
        }
        if (allTargets.size() > 0) {
            NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)GuiceIcons.Inject).setPopupTitle(GuiceBundle.message("GuiceClassAnnotator.popup.title", new Object[0])).setTooltipText(GuiceBundle.message("GuiceClassAnnotator.popup.tooltip.text", new Object[0])).setCellRenderer(this.BINDING_CLASS_CELL_RENDERER).setTargets(allTargets);
            result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo(identifier));
        }
    }

    private static void addInjectionPointsGutterIcon(@NotNull Collection<? super RelatedItemLineMarkerInfo> result, @NotNull Set<InjectionPointDescriptor> ips, @NotNull PsiElement owner) {
        if (result == null) {
            GuiceInjectionsClassAnnotator.$$$reportNull$$$0(10);
        }
        if (ips == null) {
            GuiceInjectionsClassAnnotator.$$$reportNull$$$0(11);
        }
        if (owner == null) {
            GuiceInjectionsClassAnnotator.$$$reportNull$$$0(12);
        }
        if (ips.size() > 0) {
            List members = ContainerUtil.map(ips, descriptor -> descriptor.getOwner());
            NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)GuiceIcons.Inject).setTargets((Collection)members).setPopupTitle(GuiceBundle.message("gutter.choose.injected.point", new Object[0])).setTooltipText(GuiceBundle.message("gutter.navigate.to.injection.point", new Object[0]));
            result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo(owner));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provides";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ips";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        objectArray2[1] = "com/intellij/guice/model/GuiceInjectionsClassAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectNavigationMarkers";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateInjectionPoints";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateProvidesInjectionPoints";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addInjectedGutterIcon";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "addInjectionPointsGutterIcon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

