/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.tasks;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.execution.ParametersListUtil;
import icons.MavenIcons;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenEditGoalDialog;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.tasks.MavenBeforeRunTask;
import org.jetbrains.idea.maven.tasks.TasksBundle;
import org.jetbrains.idea.maven.utils.MavenLog;

public class MavenBeforeRunTasksProvider
extends BeforeRunTaskProvider<MavenBeforeRunTask> {
    public static final Key<MavenBeforeRunTask> ID = Key.create((String)"Maven.BeforeRunTask");
    private final Project myProject;

    public MavenBeforeRunTasksProvider(Project project) {
        this.myProject = project;
    }

    public Key<MavenBeforeRunTask> getId() {
        return ID;
    }

    public String getName() {
        return TasksBundle.message("maven.tasks.before.run.empty", new Object[0]);
    }

    public Icon getIcon() {
        return MavenIcons.MavenLogo;
    }

    @Nullable
    public Icon getTaskIcon(MavenBeforeRunTask task) {
        return MavenIcons.MavenLogo;
    }

    public String getDescription(MavenBeforeRunTask task) {
        MavenProject mavenProject = this.getMavenProject(task);
        if (mavenProject == null) {
            return TasksBundle.message("maven.tasks.before.run.empty", new Object[0]);
        }
        String desc = mavenProject.getDisplayName() + ": " + StringUtil.notNullize((String)task.getGoal()).trim();
        return TasksBundle.message("maven.tasks.before.run", desc);
    }

    @Nullable
    private MavenProject getMavenProject(MavenBeforeRunTask task) {
        VirtualFile file;
        String pomXmlPath = task.getProjectPath();
        if (StringUtil.isEmpty((String)pomXmlPath)) {
            return null;
        }
        String pomFileName = MavenBeforeRunTasksProvider.getPomFileName(task.getGoal());
        if (!pomFileName.equals(PathUtil.getFileName((String)pomXmlPath))) {
            pomXmlPath = PathUtil.getParentPath((String)pomXmlPath) + "/" + pomFileName;
        }
        if ((file = LocalFileSystem.getInstance().findFileByPath(pomXmlPath)) == null) {
            return null;
        }
        return MavenProjectsManager.getInstance(this.myProject).findProject(file);
    }

    public boolean isConfigurable() {
        return true;
    }

    public MavenBeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            MavenBeforeRunTasksProvider.$$$reportNull$$$0(0);
        }
        return new MavenBeforeRunTask();
    }

    public boolean configureTask(@NotNull RunConfiguration runConfiguration, @NotNull MavenBeforeRunTask task) {
        if (runConfiguration == null) {
            MavenBeforeRunTasksProvider.$$$reportNull$$$0(1);
        }
        if (task == null) {
            MavenBeforeRunTasksProvider.$$$reportNull$$$0(2);
        }
        MavenEditGoalDialog dialog = new MavenEditGoalDialog(this.myProject);
        dialog.setTitle(TasksBundle.message("maven.tasks.select.goal.title", new Object[0]));
        if (task.getGoal() == null) {
            MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(this.myProject);
            List<MavenProject> rootProjects = projectsManager.getRootProjects();
            if (rootProjects.size() > 0) {
                dialog.setSelectedMavenProject(rootProjects.get(0));
            } else {
                dialog.setSelectedMavenProject(null);
            }
        } else {
            dialog.setGoals(task.getGoal());
            MavenProject mavenProject = this.getMavenProject(task);
            if (mavenProject != null) {
                dialog.setSelectedMavenProject(mavenProject);
            } else {
                dialog.setSelectedMavenProject(null);
            }
        }
        if (!dialog.showAndGet()) {
            return false;
        }
        task.setProjectPath(dialog.getWorkDirectory() + "/" + MavenBeforeRunTasksProvider.getPomFileName(dialog.getGoals()));
        task.setGoal(dialog.getGoals());
        return true;
    }

    public boolean canExecuteTask(@NotNull RunConfiguration configuration, @NotNull MavenBeforeRunTask task) {
        if (configuration == null) {
            MavenBeforeRunTasksProvider.$$$reportNull$$$0(3);
        }
        if (task == null) {
            MavenBeforeRunTasksProvider.$$$reportNull$$$0(4);
        }
        return task.getGoal() != null && task.getProjectPath() != null;
    }

    public boolean executeTask(DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, final @NotNull MavenBeforeRunTask task) {
        if (configuration == null) {
            MavenBeforeRunTasksProvider.$$$reportNull$$$0(5);
        }
        if (env == null) {
            MavenBeforeRunTasksProvider.$$$reportNull$$$0(6);
        }
        if (task == null) {
            MavenBeforeRunTasksProvider.$$$reportNull$$$0(7);
        }
        final Semaphore targetDone = new Semaphore();
        final boolean[] result = new boolean[]{true};
        try {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                if (task == null) {
                    MavenBeforeRunTasksProvider.$$$reportNull$$$0(10);
                }
                final Project project = (Project)CommonDataKeys.PROJECT.getData(context);
                final MavenProject mavenProject = this.getMavenProject(task);
                if (project == null || project.isDisposed() || mavenProject == null) {
                    return;
                }
                FileDocumentManager.getInstance().saveAllDocuments();
                final MavenExplicitProfiles explicitProfiles = MavenProjectsManager.getInstance(project).getExplicitProfiles();
                final MavenRunner mavenRunner = MavenRunner.getInstance(project);
                targetDone.down();
                new Task.Backgroundable(project, TasksBundle.message("maven.tasks.executing", new Object[0]), true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        try {
                            MavenRunnerParameters params = new MavenRunnerParameters(true, mavenProject.getDirectory(), mavenProject.getFile().getName(), ParametersListUtil.parse((String)task.getGoal()), explicitProfiles.getEnabledProfiles(), explicitProfiles.getDisabledProfiles());
                            result[0] = mavenRunner.runBatch(Collections.singletonList(params), null, null, TasksBundle.message("maven.tasks.executing", new Object[0]), indicator);
                        }
                        finally {
                            targetDone.up();
                        }
                    }

                    public boolean shouldStartInBackground() {
                        return MavenRunner.getInstance(project).getSettings().isRunMavenInBackground();
                    }

                    public void processSentToBackground() {
                        MavenRunner.getInstance(project).getSettings().setRunMavenInBackground(true);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/maven/tasks/MavenBeforeRunTasksProvider$1", "run"));
                    }
                }.queue();
            }, ModalityState.NON_MODAL);
        }
        catch (Exception e) {
            MavenLog.LOG.error((Throwable)e);
            return false;
        }
        targetDone.waitFor();
        return result[0];
    }

    @NotNull
    private static String getPomFileName(@Nullable String goals) {
        List commandLine;
        int pomFileNameIndex;
        if (goals != null && (pomFileNameIndex = 1 + (commandLine = ParametersListUtil.parse((String)goals)).indexOf("-f")) != 0 && pomFileNameIndex < commandLine.size()) {
            String string = (String)commandLine.get(pomFileNameIndex);
            if (string == null) {
                MavenBeforeRunTasksProvider.$$$reportNull$$$0(8);
            }
            return string;
        }
        if ("pom.xml" == null) {
            MavenBeforeRunTasksProvider.$$$reportNull$$$0(9);
        }
        return "pom.xml";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/tasks/MavenBeforeRunTasksProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/tasks/MavenBeforeRunTasksProvider";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPomFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "configureTask";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canExecuteTask";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "executeTask";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$executeTask$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

