/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ws.http.request.environment.HttpRequestEnvironment;
import com.intellij.ws.http.request.psi.HttpRequestCompositeElement;
import com.intellij.ws.http.request.psi.HttpVariable;
import com.intellij.ws.http.request.run.HttpRequestGlobalContext;
import com.intellij.ws.http.request.run.HttpRequestValidationException;
import org.jetbrains.annotations.NotNull;

public class HttpRequestVariableSubstitutor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ws.http.request.HttpRequestVariableSubstitutor");
    private static final HttpRequestVariableSubstitutor EMPTY = new HttpRequestVariableSubstitutor(HttpRequestEnvironment.empty(), new HttpRequestGlobalContext());
    private HttpRequestEnvironment myEnvironment;
    private HttpRequestGlobalContext myGlobalContext;

    private HttpRequestVariableSubstitutor(@NotNull HttpRequestEnvironment environment, @NotNull HttpRequestGlobalContext context) {
        if (environment == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(0);
        }
        if (context == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(1);
        }
        this.myEnvironment = environment;
        this.myGlobalContext = context;
    }

    @NotNull
    public static HttpRequestVariableSubstitutor getDefault(@NotNull Project project) {
        block5: {
            HttpRequestVariableSubstitutor httpRequestVariableSubstitutor;
            if (project == null) {
                HttpRequestVariableSubstitutor.$$$reportNull$$$0(2);
            }
            try {
                HttpRequestEnvironment env = HttpRequestEnvironment.getDefault(project);
                if (env == null) break block5;
                httpRequestVariableSubstitutor = HttpRequestVariableSubstitutor.create(project, env);
            }
            catch (HttpRequestValidationException e) {
                LOG.debug((Throwable)((Object)e));
            }
            if (httpRequestVariableSubstitutor == null) {
                HttpRequestVariableSubstitutor.$$$reportNull$$$0(3);
            }
            return httpRequestVariableSubstitutor;
        }
        HttpRequestVariableSubstitutor httpRequestVariableSubstitutor = HttpRequestVariableSubstitutor.empty();
        if (httpRequestVariableSubstitutor == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(4);
        }
        return httpRequestVariableSubstitutor;
    }

    @NotNull
    public static HttpRequestVariableSubstitutor create(@NotNull Project project, @NotNull HttpRequestEnvironment environment) {
        if (project == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(5);
        }
        if (environment == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(6);
        }
        HttpRequestGlobalContext context = HttpRequestGlobalContext.getInstance(project);
        if (environment == HttpRequestEnvironment.empty() && context.isEmpty()) {
            HttpRequestVariableSubstitutor httpRequestVariableSubstitutor = HttpRequestVariableSubstitutor.empty();
            if (httpRequestVariableSubstitutor == null) {
                HttpRequestVariableSubstitutor.$$$reportNull$$$0(7);
            }
            return httpRequestVariableSubstitutor;
        }
        HttpRequestVariableSubstitutor httpRequestVariableSubstitutor = new HttpRequestVariableSubstitutor(environment, context);
        if (httpRequestVariableSubstitutor == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(8);
        }
        return httpRequestVariableSubstitutor;
    }

    @NotNull
    public static HttpRequestVariableSubstitutor empty() {
        HttpRequestVariableSubstitutor httpRequestVariableSubstitutor = EMPTY;
        if (httpRequestVariableSubstitutor == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(9);
        }
        return httpRequestVariableSubstitutor;
    }

    @NotNull
    public String getValue(@NotNull PsiElement element) {
        if (element == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(10);
        }
        String string = this.getValue(element, (Condition<PsiElement>)Conditions.alwaysTrue());
        if (string == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public String getValue(@NotNull PsiElement element, @NotNull Condition<PsiElement> filter) {
        if (element == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(12);
        }
        if (filter == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(13);
        }
        if (element instanceof HttpVariable) {
            String string = this.getVariableValue((HttpVariable)element);
            if (string == null) {
                HttpRequestVariableSubstitutor.$$$reportNull$$$0(14);
            }
            return string;
        }
        if (element instanceof HttpRequestCompositeElement) {
            StringBuilder builder = new StringBuilder();
            for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child instanceof HttpVariable) {
                    builder.append(this.getVariableValue((HttpVariable)child));
                    continue;
                }
                if (!filter.value((Object)child)) continue;
                builder.append(child.getText());
            }
            String string = builder.toString();
            if (string == null) {
                HttpRequestVariableSubstitutor.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = element.getText();
        if (string == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private String getVariableValue(@NotNull HttpVariable variable) {
        String name;
        if (variable == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(17);
        }
        if (StringUtil.isNotEmpty((String)(name = variable.getName()))) {
            String global = this.myGlobalContext.getValue(name);
            if (StringUtil.isNotEmpty((String)global)) {
                String string = global;
                if (string == null) {
                    HttpRequestVariableSubstitutor.$$$reportNull$$$0(18);
                }
                return string;
            }
            String envVariable = this.myEnvironment.getVariableValue(StringUtil.notNullize((String)name));
            if (StringUtil.isNotEmpty((String)envVariable)) {
                String string = envVariable;
                if (string == null) {
                    HttpRequestVariableSubstitutor.$$$reportNull$$$0(19);
                }
                return string;
            }
        }
        String string = variable.getText();
        if (string == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(20);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/HttpRequestVariableSubstitutor";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/HttpRequestVariableSubstitutor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefault";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "empty";
                break;
            }
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefault";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getVariableValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

