/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.intellij.ws.http.request.completion.HttpSuffixInsertHandler;
import com.intellij.ws.http.request.environment.HttpRequestIndex;
import com.intellij.ws.http.request.run.HttpRequestGlobalContext;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class HttpVariableCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final HttpSuffixInsertHandler CLOSING_BRACES = new HttpSuffixInsertHandler("}}");

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        PsiElement element;
        if (parameters == null) {
            HttpVariableCompletionProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            HttpVariableCompletionProvider.$$$reportNull$$$0(1);
        }
        if ((element = parameters.getOriginalPosition()) == null) {
            return;
        }
        TextRange range = element.getTextRange();
        if (range.contains(parameters.getOffset()) || range.getEndOffset() == parameters.getOffset()) {
            int endOffset = parameters.getOffset() - range.getStartOffset();
            result = result.withPrefixMatcher(endOffset != 0 ? element.getText().substring(0, endOffset) : "");
        }
        Project project = element.getProject();
        HttpVariableCompletionProvider.fillVariables(result, HttpRequestIndex.getAllVariables(project));
        HttpVariableCompletionProvider.fillVariables(result, HttpRequestGlobalContext.getInstance(project).getAllVariables());
    }

    private static void fillVariables(@NotNull CompletionResultSet result, @NotNull Collection<String> variables) {
        if (result == null) {
            HttpVariableCompletionProvider.$$$reportNull$$$0(2);
        }
        if (variables == null) {
            HttpVariableCompletionProvider.$$$reportNull$$$0(3);
        }
        for (String var : variables) {
            result.addElement((LookupElement)LookupElementBuilder.create((String)var).withIcon(PlatformIcons.VARIABLE_ICON).withInsertHandler((InsertHandler)CLOSING_BRACES));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/http/request/completion/HttpVariableCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fillVariables";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

