/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.lexer;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.ws.http.request.lexer._HttpRequestFileLexer;
import com.intellij.ws.http.request.psi.HttpRequestElementTypes;

public class HttpRequestMultipartManager {
    private boolean myIsStarted = false;
    private CharSequence myBoundary = null;

    public void start() {
        this.myIsStarted = true;
    }

    public boolean isStarted() {
        return this.myIsStarted;
    }

    public boolean isStartedAndDefined() {
        return this.isStarted() && this.myBoundary != null;
    }

    public boolean isMultipartBoundary(CharSequence text) {
        return StringUtil.startsWith((CharSequence)text, (CharSequence)this.myBoundary);
    }

    public IElementType tryDetectBoundary(_HttpRequestFileLexer lexer) {
        if (lexer.yystate() == 30 && this.isStartedAndDefined() && this.isMultipartBoundary(lexer.yytext())) {
            lexer.switchState(26);
            return HttpRequestElementTypes.MESSAGE_BOUNDARY;
        }
        return HttpRequestElementTypes.MESSAGE_TEXT;
    }

    public void trySetBoundary(_HttpRequestFileLexer lexer) {
        CharSequence option;
        if (this.isStarted() && StringUtil.startsWith((CharSequence)(option = lexer.yytext()), (CharSequence)"boundary=")) {
            CharSequence boundary = option.subSequence("boundary=".length(), option.length());
            int length = boundary.length();
            if (length > 1 && HttpRequestMultipartManager.isQuote(boundary.charAt(0)) && HttpRequestMultipartManager.isQuote(boundary.charAt(length - 1))) {
                boundary = boundary.subSequence(1, length - 1);
            }
            this.myBoundary = "--" + boundary;
        }
    }

    private static boolean isQuote(char ch) {
        return ch == '\'' || ch == '\"';
    }

    public void reset() {
        this.myIsStarted = false;
        this.myBoundary = null;
    }
}

