/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ws.http.request.run.RestClientSession;
import com.intellij.ws.rest.client.RestClientBundle;
import com.intellij.ws.rest.client.RestClientResponse;
import java.io.IOException;
import java.io.Writer;
import org.apache.http.entity.ContentType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.script.IdeScriptEngine;
import org.jetbrains.ide.script.IdeScriptEngineManager;
import org.jetbrains.ide.script.IdeScriptException;

public class HttpClientResponseHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ws.http.request.run.HttpClientResponseHandler");
    private String myJsScript;

    public HttpClientResponseHandler(@NotNull String jsScript) {
        if (jsScript == null) {
            HttpClientResponseHandler.$$$reportNull$$$0(0);
        }
        this.myJsScript = jsScript;
    }

    public void handle(@NotNull Project project, @NotNull RestClientResponse response, @Nullable Writer stdout, @Nullable Writer stderr) throws ExecutionException {
        IdeScriptEngine engine;
        if (project == null) {
            HttpClientResponseHandler.$$$reportNull$$$0(1);
        }
        if (response == null) {
            HttpClientResponseHandler.$$$reportNull$$$0(2);
        }
        if ((engine = IdeScriptEngineManager.getInstance().getEngineForFileExtension("js", null)) == null) {
            throw new ExecutionException(RestClientBundle.message("rest.client.cannot.execute.response.handler.engine.doesnot.exists", new Object[0]));
        }
        if (stdout != null) {
            engine.setStdOut(stdout);
        }
        if (stderr != null) {
            engine.setStdErr(stderr);
        }
        try {
            RestClientSession session = RestClientSession.create(project, response);
            engine.setBinding("HTTP_CLIENT_SESSION", (Object)session);
            boolean isJson = StringUtil.equalsIgnoreCase((CharSequence)response.getContentType().getMimeType(), (CharSequence)ContentType.APPLICATION_JSON.getMimeType());
            String responseBody = isJson ? "JSON.parse(HTTP_CLIENT_SESSION.content)" : "HTTP_CLIENT_SESSION.content";
            String variableDefinition = "var client = { global: HTTP_CLIENT_SESSION.global };var response = { body: " + responseBody + ", status: HTTP_CLIENT_SESSION.statusCode, headers: HTTP_CLIENT_SESSION.headers, contentType: HTTP_CLIENT_SESSION.contentType};";
            engine.eval(variableDefinition + this.myJsScript);
            if (LOG.isDebugEnabled()) {
                LOG.debug(session.global.toString());
            }
        }
        catch (IdeScriptException e) {
            try {
                engine.getStdErr().write(e.getMessage());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new ExecutionException(e.getMessage());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsScript";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/http/request/run/HttpClientResponseHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "handle";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

