/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ws.http.request.run.HttpRequestGlobalContext;
import com.intellij.ws.rest.client.RestClientResponse;
import org.apache.http.Header;
import org.apache.http.entity.ContentType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestClientSession {
    public HttpRequestGlobalContext.RestClientVariables global;
    public HttpResponseHeaders headers;
    public HttpResponseContentType contentType;
    public String content;
    public int statusCode;

    public RestClientSession(@NotNull HttpRequestGlobalContext.RestClientVariables global, @NotNull HttpResponseHeaders headers, @NotNull HttpResponseContentType contentType, @NotNull String content, int statusCode) {
        if (global == null) {
            RestClientSession.$$$reportNull$$$0(0);
        }
        if (headers == null) {
            RestClientSession.$$$reportNull$$$0(1);
        }
        if (contentType == null) {
            RestClientSession.$$$reportNull$$$0(2);
        }
        if (content == null) {
            RestClientSession.$$$reportNull$$$0(3);
        }
        this.global = global;
        this.headers = headers;
        this.contentType = contentType;
        this.content = content;
        this.statusCode = statusCode;
    }

    @NotNull
    public static RestClientSession create(@NotNull Project project, @NotNull RestClientResponse response) {
        if (project == null) {
            RestClientSession.$$$reportNull$$$0(4);
        }
        if (response == null) {
            RestClientSession.$$$reportNull$$$0(5);
        }
        HttpRequestGlobalContext.RestClientVariables global = HttpRequestGlobalContext.getInstance(project).getGlobal();
        HttpResponseHeaders headers = new HttpResponseHeaders(response.getAllHeaders());
        ContentType type = response.getContentType();
        HttpResponseContentType contentType = new HttpResponseContentType(type.getMimeType(), type.getCharset().name());
        RestClientSession restClientSession = new RestClientSession(global, headers, contentType, response.getContent(), response.getStatusLine().getStatusCode());
        if (restClientSession == null) {
            RestClientSession.$$$reportNull$$$0(6);
        }
        return restClientSession;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "global";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/run/RestClientSession";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/run/RestClientSession";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class HttpResponseHeaders {
        public Header[] headers;

        public HttpResponseHeaders(Header[] headers) {
            this.headers = headers;
        }

        @Nullable
        public String valueOf(@NotNull String name) {
            if (name == null) {
                HttpResponseHeaders.$$$reportNull$$$0(0);
            }
            for (Header header : this.headers) {
                if (!StringUtil.equalsIgnoreCase((CharSequence)header.getName(), (CharSequence)name)) continue;
                return header.getValue();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ws/http/request/run/RestClientSession$HttpResponseHeaders", "valueOf"));
        }
    }

    public static class HttpResponseContentType {
        public String mimeType;
        public String charset;

        public HttpResponseContentType(String mimeType, String charset) {
            this.mimeType = mimeType;
            this.charset = charset;
        }
    }
}

