/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.client;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.HtmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class HttpHeadersDictionary {
    private static List<String> CONTENT_TYPES = ContainerUtil.newArrayList((Object[])new String[]{"application/javascript", "application/json", "application/x-www-form-urlencoded", "application/xml", "application/zip", "application/pdf", "application/sql", "application/msword", "application/vnd.ms-excel", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "application/vnd.ms-powerpoint", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "audio/mpeg", "audio/vorbis", "multipart/form-data", "text/css", "text/html", "text/csv", "text/plain", "image/png", "image/jpeg", "image/gif"});
    private static List<String> ENCODINGS = ContainerUtil.newArrayList((Object[])new String[]{"compress", "deflate", "exi", "gzip", "identity", "pack200-gzip", "br", "bzip2", "lzma", "peerdist", "sdch", "xpress", "xz"});
    private static Set<String> ourHeaders;
    private static Map<String, List<String>> ourHeaderValues;
    private static Map<String, List<String>> ourHeaderOptionNames;

    public static Collection<String> getHeaders() {
        if (ourHeaders == null) {
            ourHeaders = HttpHeadersDictionary.readHeaders();
        }
        return ourHeaders;
    }

    private static Set<String> readHeaders() {
        TreeSet<String> result = new TreeSet<String>();
        Collections.addAll(result, HtmlUtil.RFC2616_HEADERS);
        HttpHeadersDictionary.readHeadersFile(result, "/com/intellij/ws/rest/client/perm-headers.csv");
        HttpHeadersDictionary.readHeadersFile(result, "/com/intellij/ws/rest/client/prov-headers.csv");
        return result;
    }

    @NotNull
    public static Collection<String> getHeaderValues(@NotNull String headerName) {
        if (headerName == null) {
            HttpHeadersDictionary.$$$reportNull$$$0(0);
        }
        if (ourHeaderValues == null) {
            ourHeaderValues = HttpHeadersDictionary.readHeaderValues();
        }
        Collection collection = ourHeaderValues.containsKey(headerName) ? (Collection)ourHeaderValues.get(headerName) : ContainerUtil.emptyList();
        if (collection == null) {
            HttpHeadersDictionary.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    public static Collection<String> getHeaderOptionNames(@NotNull String headerName) {
        if (headerName == null) {
            HttpHeadersDictionary.$$$reportNull$$$0(2);
        }
        Collection collection = ourHeaderOptionNames.containsKey(headerName) ? (Collection)ourHeaderOptionNames.get(headerName) : ContainerUtil.emptyList();
        if (collection == null) {
            HttpHeadersDictionary.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    private static Map<String, List<String>> readHeaderValues() {
        HashMap values = ContainerUtil.newHashMap();
        values.put("Accept", CONTENT_TYPES);
        values.put("Content-Type", CONTENT_TYPES);
        values.put("Accept-Encoding", ENCODINGS);
        HashMap hashMap = values;
        if (hashMap == null) {
            HttpHeadersDictionary.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    private static void readHeadersFile(Collection<String> result, String path) {
        InputStream stream = HttpHeadersDictionary.class.getResourceAsStream(path);
        String csv = "";
        try {
            csv = stream != null ? FileUtil.loadTextAndClose((InputStream)stream) : "";
        }
        catch (IOException e) {
            Logger.getInstance(HttpHeadersDictionary.class).error((Throwable)e);
        }
        for (String line : StringUtil.splitByLines((String)csv)) {
            String[] split = line.split(",");
            if (split.length <= 2 || !"http".equals(split[2])) continue;
            result.add(split[0]);
        }
    }

    static {
        ourHeaderOptionNames = ContainerUtil.newHashMap();
        ourHeaderOptionNames.put("Content-Type", ContainerUtil.newArrayList((Object[])new String[]{"charset", "boundary"}));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerName";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/rest/client/HttpHeadersDictionary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/rest/client/HttpHeadersDictionary";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderValues";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderOptionNames";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "readHeaderValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHeaderValues";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getHeaderOptionNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

