/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.client;

import com.intellij.ws.rest.client.RestClientRequest;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.FormBodyPartBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RestClientFormBodyPart {
    protected String myFieldName;
    protected ContentType myContentType;
    protected List<RestClientRequest.KeyValuePair> myHeaders;

    public RestClientFormBodyPart(@NotNull String fieldName, @NotNull ContentType contentType) {
        if (fieldName == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(0);
        }
        if (contentType == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(1);
        }
        this.myFieldName = fieldName;
        this.myContentType = contentType;
        this.myHeaders = new ArrayList<RestClientRequest.KeyValuePair>();
    }

    @NotNull
    public static RestClientFormBodyPart create(@NotNull String fieldName, @NotNull File file) {
        if (fieldName == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(2);
        }
        if (file == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(3);
        }
        RestClientFileBodyPart restClientFileBodyPart = new RestClientFileBodyPart(fieldName, file.getName(), file, ContentType.DEFAULT_BINARY);
        if (restClientFileBodyPart == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(4);
        }
        return restClientFileBodyPart;
    }

    @NotNull
    public static RestClientFormBodyPart create(@NotNull String fieldName, @NotNull String fileName, @NotNull File file, @NotNull ContentType contentType) {
        if (fieldName == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(5);
        }
        if (fileName == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(6);
        }
        if (file == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(7);
        }
        if (contentType == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(8);
        }
        RestClientFileBodyPart restClientFileBodyPart = new RestClientFileBodyPart(fieldName, fileName, file, contentType);
        if (restClientFileBodyPart == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(9);
        }
        return restClientFileBodyPart;
    }

    @NotNull
    public static RestClientFormBodyPart create(@NotNull String fieldName, @NotNull String content, @NotNull ContentType contentType) {
        if (fieldName == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(10);
        }
        if (content == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(11);
        }
        if (contentType == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(12);
        }
        RestClientStringBodyPart restClientStringBodyPart = new RestClientStringBodyPart(fieldName, content, contentType);
        if (restClientStringBodyPart == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(13);
        }
        return restClientStringBodyPart;
    }

    @NotNull
    public RestClientFormBodyPart addHeader(@NotNull String name, @Nullable String value) {
        if (name == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(14);
        }
        this.myHeaders.add(new RestClientRequest.KeyValuePair(name, value));
        RestClientFormBodyPart restClientFormBodyPart = this;
        if (restClientFormBodyPart == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(15);
        }
        return restClientFormBodyPart;
    }

    @NotNull
    protected FormBodyPartBuilder fillHeaders(@NotNull FormBodyPartBuilder builder) {
        if (builder == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(16);
        }
        for (RestClientRequest.KeyValuePair header : this.myHeaders) {
            builder.addField(header.getKey(), header.getValue());
        }
        FormBodyPartBuilder formBodyPartBuilder = builder;
        if (formBodyPartBuilder == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(17);
        }
        return formBodyPartBuilder;
    }

    @NotNull
    public abstract FormBodyPart toBodyPart();

    @NotNull
    public String toPsiRepresentation() {
        String string = this.myHeaders.stream().map(field -> field.getKey() + ": " + field.getValue()).collect(Collectors.joining("\n"));
        if (string == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(18);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestClientFormBodyPart part = (RestClientFormBodyPart)o;
        return Objects.equals(this.myFieldName, part.myFieldName) && Objects.equals(this.myContentType.getMimeType(), part.myContentType.getMimeType()) && Objects.equals(this.myContentType.getCharset().name(), part.myContentType.getCharset().name()) && Objects.equals(this.myHeaders, part.myHeaders);
    }

    public int hashCode() {
        return Objects.hash(this.myFieldName, this.myContentType.getMimeType(), this.myContentType.getCharset().name(), this.myHeaders);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 1: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 9: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/rest/client/RestClientFormBodyPart";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/rest/client/RestClientFormBodyPart";
                break;
            }
            case 4: 
            case 9: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "addHeader";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "fillHeaders";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "toPsiRepresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: 
            case 9: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addHeader";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "fillHeaders";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RestClientFileBodyPart
    extends RestClientFormBodyPart {
        private File myFile;
        private String myFileName;

        public RestClientFileBodyPart(@NotNull String name, @NotNull String fileName, @NotNull File file, @NotNull ContentType contentType) {
            if (name == null) {
                RestClientFileBodyPart.$$$reportNull$$$0(0);
            }
            if (fileName == null) {
                RestClientFileBodyPart.$$$reportNull$$$0(1);
            }
            if (file == null) {
                RestClientFileBodyPart.$$$reportNull$$$0(2);
            }
            if (contentType == null) {
                RestClientFileBodyPart.$$$reportNull$$$0(3);
            }
            super(name, contentType);
            this.myFile = file;
            this.myFileName = fileName;
        }

        @Override
        @NotNull
        public FormBodyPart toBodyPart() {
            FormBodyPartBuilder builder = FormBodyPartBuilder.create((String)this.myFieldName, (ContentBody)new FileBody(this.myFile, this.myContentType, this.myFileName));
            FormBodyPart formBodyPart = this.fillHeaders(builder).build();
            if (formBodyPart == null) {
                RestClientFileBodyPart.$$$reportNull$$$0(4);
            }
            return formBodyPart;
        }

        @Override
        @NotNull
        public String toPsiRepresentation() {
            String string = super.toPsiRepresentation() + "\n\n< " + this.myFile.getAbsolutePath();
            if (string == null) {
                RestClientFileBodyPart.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RestClientFileBodyPart part = (RestClientFileBodyPart)o;
            return Objects.equals(this.myFile.getName(), part.myFile.getName()) && Objects.equals(this.myFileName, part.myFileName);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.myFile.getName(), this.myFileName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentType";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ws/rest/client/RestClientFormBodyPart$RestClientFileBodyPart";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ws/rest/client/RestClientFormBodyPart$RestClientFileBodyPart";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toBodyPart";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toPsiRepresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RestClientStringBodyPart
    extends RestClientFormBodyPart {
        private String myContent;

        public RestClientStringBodyPart(@NotNull String fieldName, @NotNull String content, @NotNull ContentType contentType) {
            if (fieldName == null) {
                RestClientStringBodyPart.$$$reportNull$$$0(0);
            }
            if (content == null) {
                RestClientStringBodyPart.$$$reportNull$$$0(1);
            }
            if (contentType == null) {
                RestClientStringBodyPart.$$$reportNull$$$0(2);
            }
            super(fieldName, contentType);
            this.myContent = content;
        }

        @Override
        @NotNull
        public FormBodyPart toBodyPart() {
            FormBodyPartBuilder builder = FormBodyPartBuilder.create((String)this.myFieldName, (ContentBody)new StringBody(this.myContent, this.myContentType));
            FormBodyPart formBodyPart = this.fillHeaders(builder).build();
            if (formBodyPart == null) {
                RestClientStringBodyPart.$$$reportNull$$$0(3);
            }
            return formBodyPart;
        }

        @Override
        @NotNull
        public String toPsiRepresentation() {
            String string = super.toPsiRepresentation() + "\n\n" + this.myContent;
            if (string == null) {
                RestClientStringBodyPart.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RestClientStringBodyPart part = (RestClientStringBodyPart)o;
            return Objects.equals(this.myContent, part.myContent);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.myContent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentType";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ws/rest/client/RestClientFormBodyPart$RestClientStringBodyPart";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ws/rest/client/RestClientFormBodyPart$RestClientStringBodyPart";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toBodyPart";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toPsiRepresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

