/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.client;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.ToggleActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.border.IdeaTitledBorder;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.table.EditorTextFieldJBTableRowRenderer;
import com.intellij.util.ui.table.JBListTable;
import com.intellij.util.ui.table.JBTableRow;
import com.intellij.util.ui.table.JBTableRowEditor;
import com.intellij.util.ui.table.JBTableRowRenderer;
import com.intellij.ws.rest.client.HttpHeadersDictionary;
import com.intellij.ws.rest.client.NameValueTableModel;
import com.intellij.ws.rest.client.RestClientDataProvider;
import com.intellij.ws.rest.client.RestClientFileUtil;
import com.intellij.ws.rest.client.RestClientFormBodyPart;
import com.intellij.ws.rest.client.RestClientRequest;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NonNls;

public class RestClientRequestPanel
extends JPanel
implements Disposable {
    private final Project myProject;
    private final ToggleSendParamsAction myToggleSendParamsAction;
    private JPanel myMainPanel;
    private boolean myDoNotSendParams;
    private JPanel myParametersPanel;
    private TextFieldWithBrowseButton myFile;
    private JLabel myFileLabel;
    private JBRadioButton myRbEmpty;
    private JBRadioButton myRbFileContents;
    private JBRadioButton myRbFileUpload;
    private JBRadioButton myRbText;
    private TextFieldWithBrowseButton myTextToSend;
    private JPanel myHeaderPanel;
    private JPanel myRequestBodyPanel;
    private final NameValueTableModel myHeaderData = new NameValueTableModel();
    private final NameValueTableModel myRequestData = new NameValueTableModel();
    private JBListTable myHeaderTable;
    private JBListTable myRequestTable;
    @NonNls
    public static final String ACCEPT = "Accept";
    @NonNls
    public static final String CONTENT_TYPE = "Content-Type";
    @NonNls
    public static final String CONTENT_LENGTH = "Content-Length";
    @NonNls
    public static final String CACHE_CONTROL = "Cache-Control";
    @NonNls
    public static final String[] IMMUTABLE_HEADER_PARAMS = new String[]{"Accept", "Content-Length", "Cache-Control"};
    private String[] myMimeTypes;

    private void layoutMainPanel() {
        this.myMainPanel = new JPanel((LayoutManager)new MigLayout("ins 3 0 0 0, fill"));
        this.myHeaderPanel = new JPanel(new BorderLayout());
        this.myParametersPanel = new JPanel(new BorderLayout());
        this.myRequestBodyPanel = new JPanel((LayoutManager)new MigLayout("ins 0, fillx, flowy"));
        this.createMyFile();
        this.createMyTextToSend();
        this.myRbEmpty = new JBRadioButton("Empty");
        this.myRbText = new JBRadioButton("Text");
        this.myRbFileContents = new JBRadioButton("File contents");
        this.myRbFileUpload = new JBRadioButton("File upload (multipart/form-data)");
        this.myFileLabel = new JLabel("File to send:");
        this.myRequestBodyPanel.add((Component)this.myRbEmpty);
        JComponent textPane = this.createGrowComponent((JComponent)this.myRbText, (JComponent)this.myTextToSend);
        this.myRequestBodyPanel.add((Component)textPane, "growx");
        this.myRequestBodyPanel.add((Component)this.myRbFileContents);
        this.myRequestBodyPanel.add((Component)this.myRbFileUpload);
        JComponent filePane = this.createGrowComponent(this.myFileLabel, (JComponent)this.myFile);
        this.myRequestBodyPanel.add((Component)filePane, "gapbefore 19, growx");
        JBSplitter mainSplitter = new JBSplitter(false, 0.33333334f);
        JBSplitter rightSplitter = new JBSplitter(false, 0.5f);
        rightSplitter.setFirstComponent((JComponent)this.myParametersPanel);
        rightSplitter.setSecondComponent((JComponent)this.myRequestBodyPanel);
        mainSplitter.setFirstComponent((JComponent)this.myHeaderPanel);
        mainSplitter.setSecondComponent((JComponent)rightSplitter);
        this.myMainPanel.add((Component)mainSplitter, "grow");
    }

    private JComponent createGrowComponent(JComponent label, JComponent component) {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("ins 0, fillx", "[min!][grow]"));
        panel.add(label);
        panel.add((Component)component, "growx");
        return panel;
    }

    public RestClientRequestPanel(Project project, Disposable parent) {
        super(new BorderLayout());
        this.myProject = project;
        this.layoutMainPanel();
        this.add((Component)this.myMainPanel, "Center");
        ActionListener listener = event -> this.updateFileEnabled();
        this.myRbEmpty.addActionListener(listener);
        this.myRbText.addActionListener(listener);
        this.myRbFileContents.addActionListener(listener);
        this.myRbFileUpload.addActionListener(listener);
        this.myMimeTypes = RestClientRequestPanel.collectMimeTypes(project);
        JBInsets insets = JBUI.insets((int)0, (int)0, (int)5, (int)3);
        this.myHeaderPanel.setBorder((Border)new IdeaTitledBorder("  Headers", 5, (Insets)insets));
        JBTable headerParameters = new JBTable((TableModel)this.myHeaderData);
        this.myHeaderTable = new NameValueListTable(project, headerParameters, ": ", HttpHeadersDictionary.getHeaders(), parent);
        JPanel panel = ToolbarDecorator.createDecorator((JTable)this.myHeaderTable.getTable()).disableUpDownActions().createPanel();
        this.myHeaderPanel.add((Component)panel, "Center");
        this.myHeaderData.setImmutableFields(IMMUTABLE_HEADER_PARAMS);
        this.myHeaderData.setImmutableHeaderExceptions(ACCEPT, CACHE_CONTROL);
        this.setHeader(ACCEPT, "*/*");
        this.setHeader(CACHE_CONTROL, "no-cache");
        this.myParametersPanel.setBorder((Border)new IdeaTitledBorder(" Request Parameters", 2, (Insets)insets));
        JBTable parameters = new JBTable((TableModel)this.myRequestData);
        parameters.setModel((TableModel)this.myRequestData);
        this.myRequestTable = new NameValueListTable(project, parameters, "=", null, parent);
        this.myToggleSendParamsAction = new ToggleSendParamsAction();
        JPanel requestPanel = ToolbarDecorator.createDecorator((JTable)this.myRequestTable.getTable()).disableUpDownActions().addExtraAction((AnActionButton)this.myToggleSendParamsAction).createPanel();
        this.myParametersPanel.add((Component)requestPanel, "Center");
        this.myRequestBodyPanel.setBorder((Border)new IdeaTitledBorder("Request Body", 0, (Insets)insets));
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public void setCanHasBody(boolean canHasBody) {
        if (!canHasBody) {
            this.myRbEmpty.setSelected(true);
        }
        this.myRbEmpty.setEnabled(canHasBody);
        this.myRbText.setEnabled(canHasBody);
        this.myRbFileContents.setEnabled(canHasBody);
        this.myRbFileUpload.setEnabled(canHasBody);
    }

    void updateFileEnabled() {
        boolean canHasFile = this.myRbFileUpload.isSelected() || this.myRbFileContents.isSelected();
        this.myFile.setEnabled(canHasFile);
        this.myFileLabel.setEnabled(canHasFile);
        this.myTextToSend.setEnabled(this.myRbText.isSelected());
    }

    public void updateHeaderEditor() {
        this.myMimeTypes = RestClientRequestPanel.collectMimeTypes(this.myProject);
    }

    public void saveToRequest(RestClientRequest request) {
        RestClientRequestPanel.collectKeyValuePairs(this.myHeaderData, request.headers);
        RestClientRequestPanel.collectKeyValuePairs(this.myRequestData, request.parameters);
        request.parametersEnabled = !this.myDoNotSendParams;
        request.haveTextToSend = this.myRbText.isSelected();
        request.haveFileToSend = this.myRbFileContents.isSelected() || this.myRbFileUpload.isSelected();
        request.textToSend = this.myTextToSend.getText();
        request.filesToSend = this.myFile.getText();
        if (this.myRbFileUpload.isSelected()) {
            request.isFileUpload = true;
            request.formBodyPart = request.getFiles().stream().map(file -> RestClientFormBodyPart.create(file.getName(), file)).collect(Collectors.toList());
        } else {
            request.isFileUpload = false;
            request.formBodyPart = ContainerUtil.emptyList();
        }
    }

    public void loadFromRequest(RestClientRequest request) {
        this.stopEditing();
        RestClientRequestPanel.applyKeyValuePairs(this.myHeaderData, request.headers, this.myHeaderTable);
        RestClientRequestPanel.applyKeyValuePairs(this.myRequestData, request.parameters, this.myRequestTable);
        this.setDoNotSendParams(!request.parametersEnabled);
        if (request.haveTextToSend) {
            this.myRbText.setSelected(true);
            this.myTextToSend.setText(request.textToSend);
        } else if (request.haveFileToSend) {
            this.myFile.setText(request.filesToSend);
            if (request.isFileUpload) {
                this.myRbFileUpload.setSelected(true);
            } else {
                this.myRbFileContents.setSelected(true);
            }
        } else {
            this.myRbEmpty.setSelected(true);
        }
    }

    private void setDoNotSendParams(boolean enabled) {
        this.myDoNotSendParams = enabled;
        this.myRequestTable.getTable().setEnabled(!this.myDoNotSendParams);
        this.myToggleSendParamsAction.setEnabled(true);
    }

    private void createMyTextToSend() {
        this.myTextToSend = new TextFieldWithBrowseButton(event -> {
            ArrayList<RestClientRequest.KeyValuePair> list = new ArrayList<RestClientRequest.KeyValuePair>();
            RestClientRequestPanel.collectKeyValuePairs(this.myHeaderData, list);
            String mimeType = "";
            for (RestClientRequest.KeyValuePair pair : list) {
                if (!CONTENT_TYPE.equals(pair.getKey())) continue;
                mimeType = pair.getValue();
                break;
            }
            VirtualFile file = RestClientFileUtil.createFile(this.myTextToSend.getText(), RestClientFileUtil.findFileType(mimeType));
            Document document = FileDocumentManager.getInstance().getDocument(file);
            assert (document != null) : "Failed to get document for " + mimeType;
            Editor editor = EditorFactory.getInstance().createEditor(document, this.myProject, file, false);
            DialogBuilder builder = new DialogBuilder(this.myProject);
            builder.setDimensionServiceKey("RestClientTextRequest");
            builder.setTitle("Specify the text to send:");
            editor.getComponent().setPreferredSize(new Dimension(400, 300));
            builder.setCenterPanel(editor.getComponent());
            builder.setPreferredFocusComponent(editor.getContentComponent());
            builder.addOkAction();
            builder.setOkOperation(() -> {
                this.myTextToSend.setText(document.getText());
                builder.getDialogWrapper().close(0);
            });
            builder.addCancelAction();
            builder.show();
            RestClientFileUtil.deleteFile(file);
            EditorFactory.getInstance().releaseEditor(editor);
        }, (Disposable)this);
        this.myTextToSend.setButtonIcon(AllIcons.Actions.ShowViewer);
    }

    private void createMyFile() {
        this.myFile = new TextFieldWithBrowseButton(e -> {
            FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, true, true, false, true);
            VirtualFile[] files = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)this.myProject, null);
            if (files.length > 0) {
                ArrayList<String> paths = new ArrayList<String>();
                for (VirtualFile file : files) {
                    paths.add(file.getPath());
                }
                this.myFile.setText(StringUtil.join(paths, (String)File.pathSeparator));
            } else {
                this.myFile.setText("");
            }
        }, (Disposable)this);
    }

    public void dispose() {
    }

    private static void collectKeyValuePairs(NameValueTableModel data, List<RestClientRequest.KeyValuePair> keyValuePairs) {
        for (int i = 0; i < data.getElementsCount(); ++i) {
            keyValuePairs.add(new RestClientRequest.KeyValuePair(data.getName(i), data.getValue(i)));
        }
    }

    private static void applyKeyValuePairs(NameValueTableModel data, List<RestClientRequest.KeyValuePair> keyValuePairs, JBListTable table) {
        data.clear();
        for (RestClientRequest.KeyValuePair header : keyValuePairs) {
            data.addPropertyRow(header.getKey(), header.getValue());
        }
        ((AbstractTableModel)table.getTable().getModel()).fireTableDataChanged();
    }

    public void setHeader(String name, String value) {
        this.myHeaderData.addProperty(name, value);
        ((AbstractTableModel)this.myHeaderTable.getTable().getModel()).fireTableDataChanged();
    }

    public void addRequestParameter(String name, String value) {
        this.myRequestData.addPropertyRow(name, value);
        ((AbstractTableModel)this.myRequestTable.getTable().getModel()).fireTableDataChanged();
    }

    private static String[] collectMimeTypes(Project project) {
        ArrayList result = new ArrayList();
        Collections.addAll(result, "*/*", "text/plain", "text/html", "application/xml", "application/json", "application/atom+xml");
        for (RestClientDataProvider provider : (RestClientDataProvider[])Extensions.getExtensions(RestClientDataProvider.EP_NAME)) {
            Collections.addAll(result, provider.getAllMimeTypes(project));
        }
        return ArrayUtil.toStringArray(result);
    }

    public void stopEditing() {
        this.myHeaderTable.stopEditing();
        this.myRequestTable.stopEditing();
    }

    private class ToggleSendParamsAction
    extends ToggleActionButton {
        public ToggleSendParamsAction() {
            super("Do not send parameters", AllIcons.Actions.Clean);
        }

        public boolean isSelected(AnActionEvent e) {
            return RestClientRequestPanel.this.myDoNotSendParams;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            RestClientRequestPanel.this.setDoNotSendParams(state);
        }
    }

    private class NameValueListTable
    extends JBListTable {
        private final Project myProject;
        private final String myNameValueSeparator;
        private final Collection<String> myNames;
        private final EditorTextFieldJBTableRowRenderer myRowRenderer;

        public NameValueListTable(Project project, JBTable baseTable, String nameValueSeparator, Collection<String> names, Disposable parent) {
            super((JTable)baseTable, parent);
            this.myProject = project;
            this.myNameValueSeparator = nameValueSeparator;
            this.myNames = names;
            this.myRowRenderer = new EditorTextFieldJBTableRowRenderer(this.myProject, null, parent){

                protected String getText(JTable table, int row) {
                    String headerName = (String)NameValueListTable.this.myInternalTable.getValueAt(row, 0);
                    String headerValue = (String)NameValueListTable.this.myInternalTable.getValueAt(row, 1);
                    int index = headerValue.indexOf("\n");
                    if (index >= 0) {
                        headerValue = headerValue.substring(0, index) + "...";
                    }
                    return " " + headerName + NameValueListTable.this.myNameValueSeparator + headerValue;
                }
            };
        }

        protected JBTableRowRenderer getRowRenderer(int row) {
            return this.myRowRenderer;
        }

        protected JBTableRowEditor getRowEditor(final int row) {
            return new JBTableRowEditor(){
                private EditorTextField myNameEditor;
                private EditorComboBox myValueEditor;

                public void prepareEditor(JTable table, int row2) {
                    String headerName = row2 < NameValueListTable.this.myInternalTable.getRowCount() ? (String)NameValueListTable.this.myInternalTable.getValueAt(row2, 0) : "";
                    String headerValue = row2 < NameValueListTable.this.myInternalTable.getRowCount() ? (String)NameValueListTable.this.myInternalTable.getValueAt(row2, 1) : "";
                    this.setLayout(new GridLayout(1, 2));
                    this.myNameEditor = new TextFieldWithAutoCompletion(NameValueListTable.this.myProject, (TextFieldWithAutoCompletionListProvider)new TextFieldWithAutoCompletion.StringsCompletionProvider(NameValueListTable.this.myNames, null), NameValueListTable.this.myNames != null, headerName);
                    this.myNameEditor.addDocumentListener((DocumentListener)new JBTableRowEditor.RowEditorChangeListener((JBTableRowEditor)this, 0));
                    this.add(2.createLabeledPanel((String)"Name:", (JComponent)this.myNameEditor));
                    this.myValueEditor = new EditorComboBox(headerValue){

                        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                            if (e.getID() == 401 && e.getKeyCode() == 10) {
                                NameValueListTable.this.stopEditing();
                                e.consume();
                                return true;
                            }
                            return super.processKeyBinding(ks, e, condition, pressed);
                        }
                    };
                    if (headerName.equals(RestClientRequestPanel.ACCEPT)) {
                        this.myValueEditor.setHistory(RestClientRequestPanel.this.myMimeTypes);
                    }
                    this.myValueEditor.prependItem(headerValue);
                    this.myValueEditor.addDocumentListener((DocumentListener)new JBTableRowEditor.RowEditorChangeListener((JBTableRowEditor)this, 1));
                    this.add(2.createLabeledPanel((String)"Value:", (JComponent)this.myValueEditor));
                }

                public JBTableRow getValue() {
                    return new JBTableRow(){

                        public Object getValueAt(int column) {
                            switch (column) {
                                case 0: {
                                    return myNameEditor.getText().trim();
                                }
                                case 1: {
                                    return myValueEditor.getText().trim();
                                }
                            }
                            return null;
                        }
                    };
                }

                public JComponent getPreferredFocusedComponent() {
                    String headerName = row >= NameValueListTable.this.myInternalTable.getRowCount() ? null : (String)NameValueListTable.this.myInternalTable.getValueAt(row, 0);
                    return StringUtil.isEmpty(headerName) ? this.myNameEditor.getFocusTarget() : this.myValueEditor;
                }

                public JComponent[] getFocusableComponents() {
                    return new JComponent[]{this.myNameEditor.getFocusTarget(), this.myValueEditor};
                }
            };
        }
    }
}

