/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.notification.BrowseNotificationAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RemoteDifferenceStrategy;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsOutgoingChangesProvider;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.RevisionSelector;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.roots.VcsRootDetector;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.AnnotationProviderEx;
import com.intellij.vcs.log.VcsUserRegistry;
import git4idea.GitRevisionNumber;
import git4idea.GitRevisionSelector;
import git4idea.GitRootConverter;
import git4idea.GitUserRegistry;
import git4idea.GitUtil;
import git4idea.annotate.GitAnnotationProvider;
import git4idea.annotate.GitRepositoryForAnnotationsListener;
import git4idea.changes.GitCommittedChangeListProvider;
import git4idea.changes.GitOutgoingChangesProvider;
import git4idea.checkin.GitCheckinEnvironment;
import git4idea.checkin.GitCommitAndPushExecutor;
import git4idea.checkout.GitCheckoutProvider;
import git4idea.commands.Git;
import git4idea.config.GitExecutableDetector;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitExecutableValidator;
import git4idea.config.GitSharedSettings;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVcsConfigurable;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersion;
import git4idea.diff.GitDiffProvider;
import git4idea.history.GitHistoryProvider;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitMergeProvider;
import git4idea.rollback.GitRollbackEnvironment;
import git4idea.roots.GitIntegrationEnabler;
import git4idea.status.GitChangeProvider;
import git4idea.ui.branch.GitBranchWidget;
import git4idea.update.GitUpdateEnvironment;
import git4idea.util.GitVcsConsoleWriter;
import git4idea.vfs.GitVFSListener;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitVcs
extends AbstractVcs<CommittedChangeList> {
    public static final String NAME = "Git";
    public static final String ID = "git";
    private static final Logger LOG = Logger.getInstance((String)GitVcs.class.getName());
    private static final VcsKey ourKey = GitVcs.createKey((String)"Git");
    @Nullable
    private final ChangeProvider myChangeProvider;
    @Nullable
    private final GitCheckinEnvironment myCheckinEnvironment;
    private final RollbackEnvironment myRollbackEnvironment;
    private final GitUpdateEnvironment myUpdateEnvironment;
    private final GitAnnotationProvider myAnnotationProvider;
    private final DiffProvider myDiffProvider;
    private final GitHistoryProvider myHistoryProvider;
    @NotNull
    private final Git myGit;
    private final GitVcsConsoleWriter myVcsConsoleWriter;
    private final GitVcsApplicationSettings myAppSettings;
    private final Configurable myConfigurable;
    private final RevisionSelector myRevSelector;
    private final GitCommittedChangeListProvider myCommittedChangeListProvider;
    private GitVFSListener myVFSListener;
    private final ReadWriteLock myCommandLock;
    @Nullable
    private final GitCommitAndPushExecutor myCommitAndPushExecutor;
    private final GitExecutableManager myGitExecutableManager;
    private final GitExecutableValidator myExecutableValidator;
    private GitBranchWidget myBranchWidget;
    private GitVersion myVersion;
    private GitRepositoryForAnnotationsListener myRepositoryForAnnotationsListener;
    private final VcsOutgoingChangesProvider<CommittedChangeList> myOutgoingChangesProvider;

    @NotNull
    public static GitVcs getInstance(@NotNull Project project) {
        if (project == null) {
            GitVcs.$$$reportNull$$$0(0);
        }
        GitVcs gitVcs = (GitVcs)((Object)ObjectUtils.notNull((Object)((Object)((GitVcs)ProjectLevelVcsManager.getInstance((Project)project).findVcsByName(NAME)))));
        if (gitVcs == null) {
            GitVcs.$$$reportNull$$$0(1);
        }
        return gitVcs;
    }

    public GitVcs(@NotNull Project project, @NotNull Git git, @NotNull GitVcsConsoleWriter vcsConsoleWriter, @NotNull GitAnnotationProvider gitAnnotationProvider, @NotNull GitDiffProvider gitDiffProvider, @NotNull GitHistoryProvider gitHistoryProvider, @NotNull GitRollbackEnvironment gitRollbackEnvironment, @NotNull GitVcsApplicationSettings gitSettings, @NotNull GitVcsSettings gitProjectSettings, @NotNull GitSharedSettings sharedSettings, @NotNull GitExecutableManager gitExecutableManager) {
        if (project == null) {
            GitVcs.$$$reportNull$$$0(2);
        }
        if (git == null) {
            GitVcs.$$$reportNull$$$0(3);
        }
        if (vcsConsoleWriter == null) {
            GitVcs.$$$reportNull$$$0(4);
        }
        if (gitAnnotationProvider == null) {
            GitVcs.$$$reportNull$$$0(5);
        }
        if (gitDiffProvider == null) {
            GitVcs.$$$reportNull$$$0(6);
        }
        if (gitHistoryProvider == null) {
            GitVcs.$$$reportNull$$$0(7);
        }
        if (gitRollbackEnvironment == null) {
            GitVcs.$$$reportNull$$$0(8);
        }
        if (gitSettings == null) {
            GitVcs.$$$reportNull$$$0(9);
        }
        if (gitProjectSettings == null) {
            GitVcs.$$$reportNull$$$0(10);
        }
        if (sharedSettings == null) {
            GitVcs.$$$reportNull$$$0(11);
        }
        if (gitExecutableManager == null) {
            GitVcs.$$$reportNull$$$0(12);
        }
        super(project, NAME);
        this.myCommandLock = new ReentrantReadWriteLock(true);
        this.myVersion = GitVersion.NULL;
        this.myGit = git;
        this.myVcsConsoleWriter = vcsConsoleWriter;
        this.myAppSettings = gitSettings;
        this.myChangeProvider = project.isDefault() ? null : (ChangeProvider)ServiceManager.getService((Project)project, GitChangeProvider.class);
        this.myCheckinEnvironment = project.isDefault() ? null : (GitCheckinEnvironment)ServiceManager.getService((Project)project, GitCheckinEnvironment.class);
        this.myAnnotationProvider = gitAnnotationProvider;
        this.myDiffProvider = gitDiffProvider;
        this.myHistoryProvider = gitHistoryProvider;
        this.myRollbackEnvironment = gitRollbackEnvironment;
        this.myGitExecutableManager = gitExecutableManager;
        this.myRevSelector = new GitRevisionSelector();
        this.myConfigurable = new GitVcsConfigurable(gitSettings, this.myProject, gitProjectSettings, sharedSettings);
        this.myUpdateEnvironment = new GitUpdateEnvironment(this.myProject, gitProjectSettings);
        this.myCommittedChangeListProvider = new GitCommittedChangeListProvider(this.myProject);
        this.myOutgoingChangesProvider = new GitOutgoingChangesProvider(this.myProject);
        this.myCommitAndPushExecutor = this.myCheckinEnvironment != null ? new GitCommitAndPushExecutor(this.myCheckinEnvironment) : null;
        this.myExecutableValidator = new GitExecutableValidator(this.myProject);
    }

    public ReadWriteLock getCommandLock() {
        return this.myCommandLock;
    }

    public static void runInBackground(Task.Backgroundable task) {
        task.queue();
    }

    public CommittedChangesProvider getCommittedChangesProvider() {
        return this.myCommittedChangeListProvider;
    }

    public String getRevisionPattern() {
        return "[0-9a-fA-F]+";
    }

    @Nullable
    public CheckinEnvironment createCheckinEnvironment() {
        return this.myCheckinEnvironment;
    }

    @NotNull
    public MergeProvider getMergeProvider() {
        MergeProvider mergeProvider = GitMergeProvider.detect(this.myProject);
        if (mergeProvider == null) {
            GitVcs.$$$reportNull$$$0(13);
        }
        return mergeProvider;
    }

    @NotNull
    public RollbackEnvironment createRollbackEnvironment() {
        RollbackEnvironment rollbackEnvironment = this.myRollbackEnvironment;
        if (rollbackEnvironment == null) {
            GitVcs.$$$reportNull$$$0(14);
        }
        return rollbackEnvironment;
    }

    @NotNull
    public GitHistoryProvider getVcsHistoryProvider() {
        GitHistoryProvider gitHistoryProvider = this.myHistoryProvider;
        if (gitHistoryProvider == null) {
            GitVcs.$$$reportNull$$$0(15);
        }
        return gitHistoryProvider;
    }

    public GitHistoryProvider getVcsBlockHistoryProvider() {
        return this.myHistoryProvider;
    }

    @NotNull
    public String getDisplayName() {
        if (NAME == null) {
            GitVcs.$$$reportNull$$$0(16);
        }
        return NAME;
    }

    @Nullable
    public UpdateEnvironment createUpdateEnvironment() {
        return this.myUpdateEnvironment;
    }

    @NotNull
    public AnnotationProviderEx getAnnotationProvider() {
        GitAnnotationProvider gitAnnotationProvider = this.myAnnotationProvider;
        if (gitAnnotationProvider == null) {
            GitVcs.$$$reportNull$$$0(17);
        }
        return gitAnnotationProvider;
    }

    @NotNull
    public DiffProvider getDiffProvider() {
        DiffProvider diffProvider = this.myDiffProvider;
        if (diffProvider == null) {
            GitVcs.$$$reportNull$$$0(18);
        }
        return diffProvider;
    }

    @Nullable
    public RevisionSelector getRevisionSelector() {
        return this.myRevSelector;
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(@Nullable String revision, @Nullable FilePath path) throws VcsException {
        if (revision == null || revision.length() == 0) {
            return null;
        }
        if (revision.length() > 40) {
            String dateString = revision.substring(0, revision.indexOf("["));
            String rev = revision.substring(revision.indexOf("[") + 1, 40);
            Date d = new Date(Date.parse(dateString));
            return new GitRevisionNumber(rev, d);
        }
        if (path != null) {
            try {
                VirtualFile root = GitUtil.getGitRoot(path);
                return GitRevisionNumber.resolve(this.myProject, root, revision);
            }
            catch (VcsException e) {
                LOG.info("Unexpected problem with resolving the git revision number: ", (Throwable)e);
                throw e;
            }
        }
        return new GitRevisionNumber(revision);
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(@Nullable String revision) throws VcsException {
        return this.parseRevisionNumber(revision, null);
    }

    public boolean isVersionedDirectory(VirtualFile dir) {
        return dir.isDirectory() && GitUtil.gitRootOrNull(dir) != null;
    }

    protected void start() {
    }

    protected void shutdown() {
    }

    protected void activate() {
        this.checkExecutableAndVersion();
        if (this.myVFSListener == null) {
            this.myVFSListener = new GitVFSListener(this.myProject, this, this.myGit, this.myVcsConsoleWriter);
        }
        ServiceManager.getService((Project)this.myProject, VcsUserRegistry.class);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.myBranchWidget = new GitBranchWidget(this.myProject);
            this.myBranchWidget.activate();
        }
        if (this.myRepositoryForAnnotationsListener == null) {
            this.myRepositoryForAnnotationsListener = new GitRepositoryForAnnotationsListener(this.myProject);
        }
        GitUserRegistry.getInstance(this.myProject).activate();
    }

    private void checkExecutableAndVersion() {
        boolean executableIsAlreadyCheckedAndFine = false;
        String pathToGit = this.myGitExecutableManager.getPathToGit(this.myProject);
        if (!pathToGit.contains(File.separator)) {
            if (!this.myExecutableValidator.isExecutableValid()) {
                this.myAppSettings.setPathToGit(new GitExecutableDetector().detect());
            } else {
                executableIsAlreadyCheckedAndFine = true;
            }
        }
        if (executableIsAlreadyCheckedAndFine || this.myExecutableValidator.checkExecutableAndNotifyIfNeeded()) {
            this.checkVersion();
        }
    }

    protected void deactivate() {
        if (this.myVFSListener != null) {
            Disposer.dispose((Disposable)this.myVFSListener);
            this.myVFSListener = null;
        }
        if (this.myBranchWidget != null) {
            this.myBranchWidget.deactivate();
            this.myBranchWidget = null;
        }
    }

    @NotNull
    public synchronized Configurable getConfigurable() {
        Configurable configurable = this.myConfigurable;
        if (configurable == null) {
            GitVcs.$$$reportNull$$$0(19);
        }
        return configurable;
    }

    @Nullable
    public ChangeProvider getChangeProvider() {
        return this.myChangeProvider;
    }

    public void showErrors(@NotNull List<VcsException> list, @NotNull String action) {
        if (list == null) {
            GitVcs.$$$reportNull$$$0(20);
        }
        if (action == null) {
            GitVcs.$$$reportNull$$$0(21);
        }
        if (list.size() > 0) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("\n");
            buffer.append(GitBundle.message("error.list.title", action));
            for (VcsException exception : list) {
                buffer.append("\n");
                buffer.append(exception.getMessage());
            }
            String msg = buffer.toString();
            UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((Project)this.myProject, (String)msg, (String)GitBundle.getString("error.dialog.title")));
        }
    }

    public void checkVersion() {
        block3: {
            String executable = this.myGitExecutableManager.getPathToGit(this.myProject);
            try {
                this.myVersion = GitVersion.identifyVersion(executable);
                LOG.info("Git version: " + this.myVersion);
                if (!this.myVersion.isSupported()) {
                    String title = String.format("Git %s Is Not Supported", this.myVersion.getPresentation());
                    String message = String.format("At least %s is required.", GitVersion.MIN.getPresentation());
                    Notification notification = VcsNotifier.STANDARD_NOTIFICATION.createNotification(title, message, NotificationType.ERROR, null);
                    notification.addAction((AnAction)new BrowseNotificationAction("Download...", "http://git-scm.com/download"));
                    notification.addAction((AnAction)NotificationAction.createSimple((String)"Configure...", () -> ShowSettingsUtil.getInstance().showSettingsDialog(this.myProject, this.getConfigurable().getDisplayName())));
                    VcsNotifier.getInstance((Project)this.myProject).notify(notification);
                }
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                if (!this.getExecutableValidator().checkExecutableAndNotifyIfNeeded()) break block3;
                String reason = (e.getCause() != null ? e.getCause() : e).getMessage();
                String message = GitBundle.message("vcs.unable.to.run.git", executable, reason);
                VcsBalloonProblemNotifier.showOverVersionControlView((Project)this.myProject, (String)message, (MessageType)MessageType.ERROR);
            }
        }
    }

    @NotNull
    public GitVersion getVersion() {
        GitVersion gitVersion = this.myVersion;
        if (gitVersion == null) {
            GitVcs.$$$reportNull$$$0(22);
        }
        return gitVersion;
    }

    @Deprecated
    public void showCommandLine(String cmdLine) {
        this.myVcsConsoleWriter.showCommandLine(cmdLine);
    }

    public boolean allowsNestedRoots() {
        return true;
    }

    @NotNull
    public <S> List<S> filterUniqueRoots(@NotNull List<S> in, @NotNull Function<S, VirtualFile> convertor) {
        if (in == null) {
            GitVcs.$$$reportNull$$$0(23);
        }
        if (convertor == null) {
            GitVcs.$$$reportNull$$$0(24);
        }
        Collections.sort(in, Comparator.comparing(convertor, FilePathComparator.getInstance()));
        block0: for (int i = 1; i < in.size(); ++i) {
            S sChild = in.get(i);
            VirtualFile child = convertor.apply(sChild);
            VirtualFile childRoot = GitUtil.gitRootOrNull(child);
            if (childRoot == null) continue;
            for (int j = i - 1; j >= 0; --j) {
                S sParent = in.get(j);
                VirtualFile parent = convertor.apply(sParent);
                if (!VfsUtilCore.isAncestor((VirtualFile)parent, (VirtualFile)child, (boolean)false) || !VfsUtilCore.isAncestor((VirtualFile)childRoot, (VirtualFile)parent, (boolean)false)) continue;
                in.remove(i);
                --i;
                continue block0;
            }
        }
        List<S> list = in;
        if (list == null) {
            GitVcs.$$$reportNull$$$0(25);
        }
        return list;
    }

    public AbstractVcs.RootsConvertor getCustomConvertor() {
        return GitRootConverter.INSTANCE;
    }

    public static VcsKey getKey() {
        return ourKey;
    }

    public VcsType getType() {
        return VcsType.distributed;
    }

    protected VcsOutgoingChangesProvider<CommittedChangeList> getOutgoingProviderImpl() {
        return this.myOutgoingChangesProvider;
    }

    public RemoteDifferenceStrategy getRemoteDifferenceStrategy() {
        return RemoteDifferenceStrategy.ASK_TREE_PROVIDER;
    }

    public List<CommitExecutor> getCommitExecutors() {
        return this.myCommitAndPushExecutor != null ? Collections.singletonList(this.myCommitAndPushExecutor) : Collections.emptyList();
    }

    @NotNull
    public GitExecutableValidator getExecutableValidator() {
        GitExecutableValidator gitExecutableValidator = this.myExecutableValidator;
        if (gitExecutableValidator == null) {
            GitVcs.$$$reportNull$$$0(26);
        }
        return gitExecutableValidator;
    }

    public boolean fileListenerIsSynchronous() {
        return false;
    }

    public void enableIntegration() {
        Runnable task = () -> {
            Collection roots = ((VcsRootDetector)ServiceManager.getService((Project)this.myProject, VcsRootDetector.class)).detect();
            new GitIntegrationEnabler(this, this.myGit).enable(roots);
        };
        BackgroundTaskUtil.executeOnPooledThread((Disposable)this.myProject, (Runnable)task);
    }

    public CheckoutProvider getCheckoutProvider() {
        return new GitCheckoutProvider(Git.getInstance());
    }

    public boolean arePartialChangelistsSupported() {
        return Registry.is((String)"vcs.enable.partial.changelists");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/GitVcs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = ID;
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsConsoleWriter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitAnnotationProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitDiffProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitHistoryProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitRollbackEnvironment";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitSettings";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitProjectSettings";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sharedSettings";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitExecutableManager";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/GitVcs";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergeProvider";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createRollbackEnvironment";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsHistoryProvider";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationProvider";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffProvider";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurable";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "filterUniqueRoots";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutableValidator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 26: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "showErrors";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "filterUniqueRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

