/*
 * Decompiled with CFR 0.152.
 */
package git4idea.annotate;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsCacheableHistorySessionFactory;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsHistoryCache;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import com.intellij.vcs.AnnotationProviderEx;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.annotate.GitFileAnnotation;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.history.GitFileHistory;
import git4idea.history.GitHistoryProvider;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import git4idea.util.StringScanner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitAnnotationProvider
implements AnnotationProviderEx {
    private final Project myProject;
    @NonNls
    private static final String SUBJECT_KEY = "summary";
    @NonNls
    private static final String FILENAME_KEY = "filename";
    @NonNls
    private static final String PREVIOUS_KEY = "previous";
    @NonNls
    private static final String AUTHOR_KEY = "author";
    @NonNls
    private static final String AUTHOR_EMAIL_KEY = "author-mail";
    @NonNls
    private static final String COMMITTER_TIME_KEY = "committer-time";
    @NonNls
    private static final String AUTHOR_TIME_KEY = "author-time";
    private static final Logger LOG = Logger.getInstance(GitAnnotationProvider.class);
    @NotNull
    private final VcsHistoryCache myCache;
    @NotNull
    private final VcsUserRegistry myUserRegistry;

    public GitAnnotationProvider(@NotNull Project project) {
        if (project == null) {
            GitAnnotationProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myCache = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsHistoryCache();
        this.myUserRegistry = (VcsUserRegistry)ServiceManager.getService((Project)project, VcsUserRegistry.class);
    }

    public boolean isCaching() {
        return true;
    }

    @NotNull
    public FileAnnotation annotate(@NotNull VirtualFile file) throws VcsException {
        if (file == null) {
            GitAnnotationProvider.$$$reportNull$$$0(1);
        }
        FileAnnotation fileAnnotation = this.annotate(file, null);
        if (fileAnnotation == null) {
            GitAnnotationProvider.$$$reportNull$$$0(2);
        }
        return fileAnnotation;
    }

    @NotNull
    public FileAnnotation annotate(@NotNull VirtualFile file, @Nullable VcsFileRevision revision) throws VcsException {
        if (file == null) {
            GitAnnotationProvider.$$$reportNull$$$0(3);
        }
        if (file.isDirectory()) {
            throw new VcsException("Cannot annotate a directory");
        }
        FilePath currentFilePath = VcsUtil.getFilePath((String)file.getPath());
        FilePath realFilePath = revision == null ? GitHistoryUtils.getLastCommitName(this.myProject, currentFilePath) : ((VcsFileRevisionEx)revision).getPath();
        VcsRevisionNumber revisionNumber = revision != null ? revision.getRevisionNumber() : null;
        GitFileAnnotation gitFileAnnotation = this.annotate(realFilePath, revisionNumber, file);
        if (gitFileAnnotation == null) {
            GitAnnotationProvider.$$$reportNull$$$0(4);
        }
        return gitFileAnnotation;
    }

    @NotNull
    public FileAnnotation annotate(@NotNull FilePath path, @NotNull VcsRevisionNumber revision) throws VcsException {
        if (path == null) {
            GitAnnotationProvider.$$$reportNull$$$0(5);
        }
        if (revision == null) {
            GitAnnotationProvider.$$$reportNull$$$0(6);
        }
        GitFileRevision fileRevision = new GitFileRevision(this.myProject, path, (GitRevisionNumber)revision);
        VcsVirtualFile file = new VcsVirtualFile(path.getPath(), (VcsFileRevision)fileRevision, (VirtualFileSystem)VcsFileSystem.getInstance());
        GitFileAnnotation gitFileAnnotation = this.annotate(path, revision, (VirtualFile)file);
        if (gitFileAnnotation == null) {
            GitAnnotationProvider.$$$reportNull$$$0(7);
        }
        return gitFileAnnotation;
    }

    private static void setProgressIndicatorText(@Nullable String text) {
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        if (progress != null) {
            progress.setText(text);
        }
    }

    @NotNull
    private GitFileAnnotation annotate(@NotNull FilePath repositoryFilePath, @Nullable VcsRevisionNumber revision, @NotNull VirtualFile file) throws VcsException {
        Object annotatedData;
        VcsRevisionNumber actualRevision;
        if (repositoryFilePath == null) {
            GitAnnotationProvider.$$$reportNull$$$0(8);
        }
        if (file == null) {
            GitAnnotationProvider.$$$reportNull$$$0(9);
        }
        GitVcs vcs = GitVcs.getInstance(this.myProject);
        VcsRevisionNumber vcsRevisionNumber = actualRevision = revision != null ? revision : vcs.getDiffProvider().getCurrentRevision(file);
        if (actualRevision != null && (annotatedData = this.myCache.get(repositoryFilePath, GitVcs.getKey(), actualRevision)) instanceof CachedData) {
            GitFileAnnotation gitFileAnnotation = this.restoreFromCache(file, actualRevision, (CachedData)annotatedData);
            if (gitFileAnnotation == null) {
                GitAnnotationProvider.$$$reportNull$$$0(10);
            }
            return gitFileAnnotation;
        }
        GitFileAnnotation fileAnnotation = this.doAnnotate(repositoryFilePath, actualRevision, file);
        if (actualRevision != null) {
            this.myCache.put(repositoryFilePath, GitVcs.getKey(), actualRevision, (Object)this.cacheData(fileAnnotation));
        }
        GitFileAnnotation gitFileAnnotation = fileAnnotation;
        if (gitFileAnnotation == null) {
            GitAnnotationProvider.$$$reportNull$$$0(11);
        }
        return gitFileAnnotation;
    }

    @NotNull
    private GitFileAnnotation doAnnotate(@NotNull FilePath repositoryFilePath, @Nullable VcsRevisionNumber revision, @NotNull VirtualFile file) throws VcsException {
        if (repositoryFilePath == null) {
            GitAnnotationProvider.$$$reportNull$$$0(12);
        }
        if (file == null) {
            GitAnnotationProvider.$$$reportNull$$$0(13);
        }
        GitAnnotationProvider.setProgressIndicatorText(GitBundle.message("computing.annotation", file.getName()));
        VirtualFile root = GitUtil.getGitRoot(repositoryFilePath);
        GitLineHandler h = new GitLineHandler(this.myProject, root, GitCommand.BLAME);
        h.setStdoutSuppressed(true);
        h.addParameters("--porcelain", "-l", "-t", "-w");
        h.addParameters("--encoding=UTF-8");
        if (revision == null) {
            h.addParameters("HEAD");
        } else {
            h.addParameters(revision.asString());
        }
        h.endOptions();
        h.addRelativePaths(repositoryFilePath);
        String output = Git.getInstance().runCommand(h).getOutputOrThrow();
        GitFileAnnotation fileAnnotation = this.parseAnnotations(revision, file, root, output);
        this.loadFileHistoryInBackground(fileAnnotation);
        GitFileAnnotation gitFileAnnotation = fileAnnotation;
        if (gitFileAnnotation == null) {
            GitAnnotationProvider.$$$reportNull$$$0(14);
        }
        return gitFileAnnotation;
    }

    private void loadFileHistoryInBackground(@NotNull GitFileAnnotation fileAnnotation) {
        List fileRevisions;
        if (fileAnnotation == null) {
            GitAnnotationProvider.$$$reportNull$$$0(15);
        }
        if ((fileRevisions = (List)BackgroundTaskUtil.computeInBackgroundAndTryWait(() -> {
            if (fileAnnotation == null) {
                GitAnnotationProvider.$$$reportNull$$$0(28);
            }
            return (List)BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this.myProject, () -> {
                if (fileAnnotation == null) {
                    GitAnnotationProvider.$$$reportNull$$$0(29);
                }
                try {
                    VirtualFile file = fileAnnotation.getFile();
                    FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
                    VcsRevisionNumber currentRevision = fileAnnotation.getCurrentRevision();
                    if (file.isInLocalFileSystem() || currentRevision == null) {
                        return this.loadFileHistory(filePath);
                    }
                    return GitFileHistory.collectHistoryForRevision(this.myProject, filePath, currentRevision, new String[0]);
                }
                catch (VcsException e) {
                    LOG.error((Throwable)e);
                    return null;
                }
            });
        }, revisions -> {
            if (fileAnnotation == null) {
                GitAnnotationProvider.$$$reportNull$$$0(26);
            }
            if (revisions == null) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (fileAnnotation == null) {
                    GitAnnotationProvider.$$$reportNull$$$0(27);
                }
                GitFileAnnotation newFileAnnotation = new GitFileAnnotation(fileAnnotation);
                newFileAnnotation.setRevisions((List<VcsFileRevision>)revisions);
                fileAnnotation.reload(newFileAnnotation);
            }, this.myProject.getDisposed());
        }, (long)300L)) != null) {
            fileAnnotation.setRevisions(fileRevisions);
        }
    }

    @Nullable
    private List<VcsFileRevision> loadFileHistory(@NotNull FilePath filePath) throws VcsException {
        if (filePath == null) {
            GitAnnotationProvider.$$$reportNull$$$0(16);
        }
        GitVcs vcs = GitVcs.getInstance(this.myProject);
        GitHistoryProvider historyProvider = vcs.getVcsHistoryProvider();
        VcsAbstractHistorySession cachedSession = this.myCache.getFull(filePath, vcs.getKeyInstanceMethod(), (VcsCacheableHistorySessionFactory)historyProvider);
        if (cachedSession != null && !ContainerUtil.isEmpty((Collection)cachedSession.getRevisionList())) {
            return cachedSession.getRevisionList();
        }
        VcsAbstractHistorySession session = historyProvider.createSessionFor(filePath);
        if (session == null) {
            return null;
        }
        this.myCache.put(filePath, null, vcs.getKeyInstanceMethod(), session, (VcsCacheableHistorySessionFactory)historyProvider, true);
        return session.getRevisionList();
    }

    @NotNull
    private GitFileAnnotation parseAnnotations(@Nullable VcsRevisionNumber revision, @NotNull VirtualFile file, @NotNull VirtualFile root, @NotNull String output) throws VcsException {
        GitFileAnnotation gitFileAnnotation;
        block20: {
            if (file == null) {
                GitAnnotationProvider.$$$reportNull$$$0(17);
            }
            if (root == null) {
                GitAnnotationProvider.$$$reportNull$$$0(18);
            }
            if (output == null) {
                GitAnnotationProvider.$$$reportNull$$$0(19);
            }
            Interner pathInterner = new Interner();
            try {
                ArrayList<GitFileAnnotation.LineInfo> lines = new ArrayList<GitFileAnnotation.LineInfo>();
                HashMap<String, GitFileAnnotation.LineInfo> commits2 = new HashMap<String, GitFileAnnotation.LineInfo>();
                StringScanner s = new StringScanner(output);
                while (s.hasMoreData()) {
                    String commitHash = s.spaceToken();
                    if (commitHash.equals(GitRevisionNumber.NOT_COMMITTED_HASH)) {
                        commitHash = null;
                    }
                    s.spaceToken();
                    String s1 = s.spaceToken();
                    int lineNum = Integer.parseInt(s1);
                    s.nextLine();
                    GitFileAnnotation.LineInfo commit2 = (GitFileAnnotation.LineInfo)commits2.get(commitHash);
                    if (commit2 != null || commitHash == null) {
                        while (s.hasMoreData() && !s.startsWith('\t')) {
                            s.nextLine();
                        }
                    } else {
                        Date committerDate = null;
                        FilePath filePath = null;
                        String subject = null;
                        String authorName = null;
                        String authorEmail = null;
                        Date authorDate = null;
                        String previousRevision = null;
                        FilePath previousFilePath = null;
                        while (s.hasMoreData() && !s.startsWith('\t')) {
                            int index;
                            String key = s.spaceToken();
                            String value = s.line();
                            if (SUBJECT_KEY.equals(key)) {
                                subject = value;
                                continue;
                            }
                            if (AUTHOR_KEY.equals(key)) {
                                authorName = value;
                                continue;
                            }
                            if (AUTHOR_TIME_KEY.equals(key)) {
                                authorDate = GitUtil.parseTimestamp(value);
                                continue;
                            }
                            if (COMMITTER_TIME_KEY.equals(key)) {
                                committerDate = GitUtil.parseTimestamp(value);
                                continue;
                            }
                            if (FILENAME_KEY.equals(key)) {
                                filePath = VcsUtil.getFilePath((VirtualFile)root, (String)value);
                                continue;
                            }
                            if (AUTHOR_EMAIL_KEY.equals(key)) {
                                authorEmail = value;
                                if (!authorEmail.startsWith("<") || !authorEmail.endsWith(">")) continue;
                                authorEmail = authorEmail.substring(1, authorEmail.length() - 1);
                                continue;
                            }
                            if (!PREVIOUS_KEY.equals(key) || (index = value.indexOf(32)) == -1) continue;
                            previousRevision = value.substring(0, index);
                            previousFilePath = VcsUtil.getFilePath((VirtualFile)root, (String)value.substring(index + 1, value.length()));
                        }
                        if (authorDate == null || committerDate == null || filePath == null || authorName == null || authorEmail == null || subject == null) {
                            throw new VcsException("Output for line " + lineNum + " lacks necessary data");
                        }
                        GitRevisionNumber revisionNumber = new GitRevisionNumber(commitHash);
                        VcsUser author = this.myUserRegistry.createUser(authorName, authorEmail);
                        GitRevisionNumber previousRevisionNumber = previousRevision != null ? new GitRevisionNumber(previousRevision) : null;
                        filePath = (FilePath)pathInterner.intern(filePath);
                        if (previousFilePath != null) {
                            previousFilePath = (FilePath)pathInterner.intern(previousFilePath);
                        }
                        commit2 = new GitFileAnnotation.LineInfo(this.myProject, revisionNumber, filePath, committerDate, authorDate, author, subject, previousRevisionNumber, previousFilePath);
                        commits2.put(commitHash, commit2);
                    }
                    s.nextLine();
                    int expectedLineNum = lines.size() + 1;
                    if (lineNum != expectedLineNum) {
                        throw new VcsException("Adding for info for line " + lineNum + " but we are expecting it to be for " + expectedLineNum);
                    }
                    lines.add(commit2);
                }
                gitFileAnnotation = new GitFileAnnotation(this.myProject, file, revision, lines);
                if (gitFileAnnotation != null) break block20;
            }
            catch (Exception e) {
                LOG.error("Couldn't parse annotation: " + e, new Attachment[]{new Attachment("output.txt", output)});
                throw new VcsException((Throwable)e);
            }
            GitAnnotationProvider.$$$reportNull$$$0(20);
        }
        return gitFileAnnotation;
    }

    @NotNull
    private GitFileAnnotation restoreFromCache(@NotNull VirtualFile file, @Nullable VcsRevisionNumber revisionNumber, @NotNull CachedData data) {
        if (file == null) {
            GitAnnotationProvider.$$$reportNull$$$0(21);
        }
        if (data == null) {
            GitAnnotationProvider.$$$reportNull$$$0(22);
        }
        GitFileAnnotation fileAnnotation = new GitFileAnnotation(this.myProject, file, revisionNumber, data.lines);
        this.loadFileHistoryInBackground(fileAnnotation);
        GitFileAnnotation gitFileAnnotation = fileAnnotation;
        if (gitFileAnnotation == null) {
            GitAnnotationProvider.$$$reportNull$$$0(23);
        }
        return gitFileAnnotation;
    }

    @NotNull
    private CachedData cacheData(@NotNull GitFileAnnotation annotation) {
        if (annotation == null) {
            GitAnnotationProvider.$$$reportNull$$$0(24);
        }
        CachedData cachedData = new CachedData(annotation.getLines());
        if (cachedData == null) {
            GitAnnotationProvider.$$$reportNull$$$0(25);
        }
        return cachedData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 20: 
            case 23: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 20: 
            case 23: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 13: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 20: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/annotate/GitAnnotationProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryFilePath";
                break;
            }
            case 15: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileAnnotation";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/annotate/GitAnnotationProvider";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "annotate";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "doAnnotate";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAnnotations";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "restoreFromCache";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "cacheData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 20: 
            case 23: 
            case 25: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doAnnotate";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadFileHistoryInBackground";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadFileHistory";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "parseAnnotations";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "restoreFromCache";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "cacheData";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadFileHistoryInBackground$3";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadFileHistoryInBackground$1";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 20: 
            case 23: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CachedData {
        public final List<GitFileAnnotation.LineInfo> lines;

        public CachedData(List<GitFileAnnotation.LineInfo> lines) {
            this.lines = lines;
        }
    }
}

