/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.CommonBundle;
import com.intellij.diff.util.Side;
import com.intellij.dvcs.AmendComponent;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.ui.VcsPushDialog;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.ui.SelectFilePathsDialog;
import com.intellij.openapi.vcs.checkin.CheckinChangeListSpecificComponent;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.impl.PartialChangesUtil;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.FunctionUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairConsumer;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.textCompletion.DefaultTextCompletionValueDescriptor;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionValueDescriptor;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.intellij.util.textCompletion.ValuesCompletionProvider;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUserRegistry;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.checkin.GitCommitAuthorCorrector;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersionSpecialty;
import git4idea.i18n.GitBundle;
import git4idea.index.GitIndexUtil;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitFileUtils;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCheckinEnvironment
implements CheckinEnvironment {
    private static final Logger LOG = Logger.getInstance(GitCheckinEnvironment.class);
    @NonNls
    private static final String GIT_COMMIT_MSG_FILE_PREFIX = "git-commit-msg-";
    @NonNls
    private static final String GIT_COMMIT_MSG_FILE_EXT = ".txt";
    private final Project myProject;
    public static final SimpleDateFormat COMMIT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final VcsDirtyScopeManager myDirtyScopeManager;
    private final GitVcsSettings mySettings;
    private String myNextCommitAuthor;
    private boolean myNextCommitAmend;
    private Boolean myNextCommitIsPushed;
    private Date myNextCommitAuthorDate;
    private boolean myNextCommitSignOff;
    private boolean myNextCommitSkipHook;

    public GitCheckinEnvironment(@NotNull Project project, @NotNull VcsDirtyScopeManager dirtyScopeManager, GitVcsSettings settings) {
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(0);
        }
        if (dirtyScopeManager == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(1);
        }
        this.myNextCommitAuthor = null;
        this.myNextCommitIsPushed = null;
        this.myProject = project;
        this.myDirtyScopeManager = dirtyScopeManager;
        this.mySettings = settings;
    }

    public boolean keepChangeListAfterCommit(ChangeList changeList) {
        return false;
    }

    public boolean isRefreshAfterCommitNeeded() {
        return true;
    }

    @Nullable
    public RefreshableOnComponent createAdditionalOptionsPanel(CheckinProjectPanel panel, PairConsumer<Object, Object> additionalDataConsumer) {
        return new GitCheckinOptions(this.myProject, panel);
    }

    @Nullable
    public String getDefaultMessageFor(FilePath[] filesToCheckin) {
        LinkedHashSet messages = ContainerUtil.newLinkedHashSet();
        GitRepositoryManager manager = GitUtil.getRepositoryManager(this.myProject);
        for (VirtualFile root : GitUtil.gitRoots(Arrays.asList(filesToCheckin))) {
            GitRepository repository = (GitRepository)manager.getRepositoryForRoot(root);
            if (repository == null) {
                LOG.warn("Unregistered repository: " + root);
                continue;
            }
            File mergeMsg = repository.getRepositoryFiles().getMergeMessageFile();
            File squashMsg = repository.getRepositoryFiles().getSquashMessageFile();
            try {
                if (!mergeMsg.exists() && !squashMsg.exists()) continue;
                String encoding = GitConfigUtil.getCommitEncoding(this.myProject, root);
                if (mergeMsg.exists()) {
                    messages.add(GitCheckinEnvironment.loadMessage(mergeMsg, encoding));
                    continue;
                }
                messages.add(GitCheckinEnvironment.loadMessage(squashMsg, encoding));
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Unable to load merge message", (Throwable)e);
            }
        }
        return DvcsUtil.joinMessagesOrNull((Collection)messages);
    }

    private static String loadMessage(@NotNull File messageFile, @NotNull String encoding) throws IOException {
        if (messageFile == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(2);
        }
        if (encoding == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(3);
        }
        return FileUtil.loadFile((File)messageFile, (String)encoding);
    }

    public String getHelpId() {
        return null;
    }

    public String getCheckinOperationName() {
        return GitBundle.getString("commit.action.name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VcsException> commit(@NotNull List<Change> changes, @NotNull String message, @NotNull NullableFunction<Object, Object> parametersHolder, Set<String> feedback) {
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(4);
        }
        if (message == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(5);
        }
        if (parametersHolder == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(6);
        }
        GitRepositoryManager manager = GitUtil.getRepositoryManager(this.myProject);
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        Map<VirtualFile, Collection<Change>> sortedChanges = GitCheckinEnvironment.sortChangesByGitRoot(changes, exceptions);
        LOG.assertTrue(!sortedChanges.isEmpty(), (Object)("Trying to commit an empty list of changes: " + changes));
        List<GitRepository> repositories = manager.sortByDependency(GitUtil.getRepositoriesFromRoots(manager, sortedChanges.keySet()));
        for (GitRepository repository : repositories) {
            File messageFile;
            VirtualFile root = repository.getRoot();
            try {
                messageFile = GitCheckinEnvironment.createCommitMessageFile(this.myProject, root, message);
            }
            catch (IOException ex) {
                exceptions.add(new VcsException("Creation of commit message file failed", (Throwable)ex));
                continue;
            }
            try {
                block25: {
                    Collection<Change> rootChanges = sortedChanges.get(root);
                    Pair<Runnable, List<Change>> partialAddResult = this.addPartialChangesToIndex(repository, rootChanges);
                    Runnable callback = (Runnable)partialAddResult.first;
                    HashSet partialChanges = ContainerUtil.newHashSet((Iterable)((Iterable)partialAddResult.second));
                    HashSet<FilePath> added = new HashSet<FilePath>();
                    HashSet<FilePath> removed = new HashSet<FilePath>();
                    HashSet<Change> caseOnlyRenames = new HashSet<Change>();
                    block15: for (Change change : rootChanges) {
                        if (partialChanges.contains(change)) continue;
                        switch (change.getType()) {
                            case NEW: 
                            case MODIFICATION: {
                                added.add(change.getAfterRevision().getFile());
                                continue block15;
                            }
                            case DELETED: {
                                removed.add(change.getBeforeRevision().getFile());
                                continue block15;
                            }
                            case MOVED: {
                                FilePath afterPath = change.getAfterRevision().getFile();
                                FilePath beforePath = change.getBeforeRevision().getFile();
                                if (!SystemInfo.isFileSystemCaseSensitive && GitUtil.isCaseOnlyChange(beforePath.getPath(), afterPath.getPath())) {
                                    caseOnlyRenames.add(change);
                                    continue block15;
                                }
                                added.add(afterPath);
                                removed.add(beforePath);
                                continue block15;
                            }
                        }
                        throw new IllegalStateException("Unknown change type: " + change.getType());
                    }
                    if (!caseOnlyRenames.isEmpty() || !partialChanges.isEmpty()) {
                        List<VcsException> exs = this.commitUsingIndex(this.myProject, root, caseOnlyRenames, partialChanges, added, removed, messageFile);
                        exceptions.addAll(exs);
                        if (exceptions.isEmpty()) {
                            callback.run();
                        }
                    } else {
                        try {
                            HashSet<FilePath> files = new HashSet<FilePath>();
                            files.addAll(added);
                            files.addAll(removed);
                            this.commit(this.myProject, root, files, messageFile);
                        }
                        catch (VcsException ex) {
                            PartialOperation partialOperation = GitCheckinEnvironment.isMergeCommit(ex);
                            if (partialOperation == PartialOperation.NONE) {
                                throw ex;
                            }
                            if (this.mergeCommit(this.myProject, root, added, removed, messageFile, exceptions, partialOperation)) break block25;
                            throw ex;
                        }
                    }
                }
                manager.updateRepository(root);
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
            finally {
                if (messageFile.delete()) continue;
                LOG.warn("Failed to remove temporary file: " + messageFile);
            }
        }
        if (this.myNextCommitIsPushed != null && this.myNextCommitIsPushed.booleanValue() && exceptions.isEmpty()) {
            ModalityState modality = ModalityState.defaultModalityState();
            TransactionGuard.getInstance().assertWriteSafeContext(modality);
            ArrayList preselectedRepositories = ContainerUtil.newArrayList(repositories);
            GuiUtils.invokeLaterIfNeeded(() -> new VcsPushDialog(this.myProject, preselectedRepositories, (Repository)GitBranchUtil.getCurrentRepository(this.myProject)).show(), (ModalityState)modality, (Condition)this.myProject.getDisposed());
        }
        return exceptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    private List<VcsException> commitUsingIndex(@NotNull Project project, @NotNull VirtualFile root, @NotNull Set<Change> caseOnlyRenames, @NotNull Set<Change> partialChanges, @NotNull Set<FilePath> added, @NotNull Set<FilePath> removed, @NotNull File messageFile) {
        ArrayList<VcsException> exceptions;
        block24: {
            List excludedStagedChanges;
            String rootPath;
            block22: {
                ArrayList<VcsException> arrayList;
                block23: {
                    Collection<Change> stagedChanges;
                    if (project == null) {
                        GitCheckinEnvironment.$$$reportNull$$$0(7);
                    }
                    if (root == null) {
                        GitCheckinEnvironment.$$$reportNull$$$0(8);
                    }
                    if (caseOnlyRenames == null) {
                        GitCheckinEnvironment.$$$reportNull$$$0(9);
                    }
                    if (partialChanges == null) {
                        GitCheckinEnvironment.$$$reportNull$$$0(10);
                    }
                    if (added == null) {
                        GitCheckinEnvironment.$$$reportNull$$$0(11);
                    }
                    if (removed == null) {
                        GitCheckinEnvironment.$$$reportNull$$$0(12);
                    }
                    if (messageFile == null) {
                        GitCheckinEnvironment.$$$reportNull$$$0(13);
                    }
                    exceptions = new ArrayList<VcsException>();
                    rootPath = root.getPath();
                    LOG.info("Committing case only rename: " + GitUtil.getLogString(rootPath, caseOnlyRenames) + " in " + DvcsUtil.getShortRepositoryName((Project)project, (VirtualFile)root));
                    try {
                        stagedChanges = GitChangeUtils.getStagedChanges(project, root);
                        LOG.debug("Found staged changes: " + GitUtil.getLogString(rootPath, stagedChanges));
                    }
                    catch (VcsException e) {
                        List<VcsException> list = Collections.singletonList(e);
                        if (list == null) {
                            GitCheckinEnvironment.$$$reportNull$$$0(14);
                        }
                        return list;
                    }
                    excludedStagedChanges = ContainerUtil.filter(stagedChanges, change -> {
                        if (caseOnlyRenames == null) {
                            GitCheckinEnvironment.$$$reportNull$$$0(41);
                        }
                        if (partialChanges == null) {
                            GitCheckinEnvironment.$$$reportNull$$$0(42);
                        }
                        if (added == null) {
                            GitCheckinEnvironment.$$$reportNull$$$0(43);
                        }
                        if (removed == null) {
                            GitCheckinEnvironment.$$$reportNull$$$0(44);
                        }
                        return !caseOnlyRenames.contains(change) && !partialChanges.contains(change) && !added.contains(ChangesUtil.getAfterPath((Change)change)) && !removed.contains(ChangesUtil.getBeforePath((Change)change));
                    });
                    if (!excludedStagedChanges.isEmpty()) {
                        LOG.info("Staged changes excluded for commit: " + GitUtil.getLogString(rootPath, excludedStagedChanges));
                        GitCheckinEnvironment.reset(project, root, excludedStagedChanges);
                    }
                    List newPathsOfCaseRenames = ContainerUtil.map(caseOnlyRenames, ChangesUtil::getAfterPath);
                    LOG.debug("Updating index for added:" + added + "\n, removed: " + removed + "\n, and case-renames: " + newPathsOfCaseRenames);
                    HashSet<FilePath> toAdd = new HashSet<FilePath>(added);
                    toAdd.addAll(newPathsOfCaseRenames);
                    GitCheckinEnvironment.updateIndex(project, root, toAdd, removed, exceptions);
                    if (exceptions.isEmpty()) break block22;
                    arrayList = exceptions;
                    if (excludedStagedChanges.isEmpty()) break block23;
                    LOG.debug("Restoring changes which were unstaged before commit: " + GitUtil.getLogString(rootPath, excludedStagedChanges));
                    Set toAdd2 = ContainerUtil.map2SetNotNull((Collection)excludedStagedChanges, ChangesUtil::getAfterPath);
                    Condition isMovedOrDeleted = change -> change.getType() == Change.Type.MOVED || change.getType() == Change.Type.DELETED;
                    Set toRemove = ContainerUtil.map2SetNotNull((Collection)ContainerUtil.filter((Collection)excludedStagedChanges, (Condition)isMovedOrDeleted), ChangesUtil::getBeforePath);
                    GitCheckinEnvironment.updateIndex(project, root, toAdd2, toRemove, exceptions);
                }
                ArrayList<VcsException> arrayList2 = arrayList;
                if (arrayList2 == null) {
                    GitCheckinEnvironment.$$$reportNull$$$0(15);
                }
                return arrayList2;
            }
            try {
                LOG.debug("Performing commit...");
                this.commitWithoutPaths(project, root, messageFile);
                break block24;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                finally {
                    if (!excludedStagedChanges.isEmpty()) {
                        LOG.debug("Restoring changes which were unstaged before commit: " + GitUtil.getLogString(rootPath, excludedStagedChanges));
                        Set toAdd = ContainerUtil.map2SetNotNull((Collection)excludedStagedChanges, ChangesUtil::getAfterPath);
                        Condition isMovedOrDeleted = change -> change.getType() == Change.Type.MOVED || change.getType() == Change.Type.DELETED;
                        Set toRemove = ContainerUtil.map2SetNotNull((Collection)ContainerUtil.filter((Collection)excludedStagedChanges, (Condition)isMovedOrDeleted), ChangesUtil::getBeforePath);
                        GitCheckinEnvironment.updateIndex(project, root, toAdd, toRemove, exceptions);
                    }
                }
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
        }
        ArrayList<VcsException> arrayList = exceptions;
        if (arrayList == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @NotNull
    private Pair<Runnable, List<Change>> addPartialChangesToIndex(@NotNull GitRepository repository, @NotNull Collection<Change> changes) throws VcsException {
        Set changelistIds;
        if (repository == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(17);
        }
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(18);
        }
        if ((changelistIds = ContainerUtil.map2SetNotNull(changes, change -> change instanceof ChangeListChange ? ((ChangeListChange)change).getChangeListId() : null)).isEmpty()) {
            Pair pair = Pair.create((Object)EmptyRunnable.INSTANCE, (Object)ContainerUtil.emptyList());
            if (pair == null) {
                GitCheckinEnvironment.$$$reportNull$$$0(19);
            }
            return pair;
        }
        if (changelistIds.size() != 1) {
            throw new VcsException("Can't commit changes from multiple changelists at once");
        }
        String changelistId = (String)changelistIds.iterator().next();
        Pair result2 = (Pair)GitCheckinEnvironment.computeAfterLSTManagerUpdate(repository.getProject(), () -> {
            if (changes == null) {
                GitCheckinEnvironment.$$$reportNull$$$0(40);
            }
            ArrayList<PartialLocalLineStatusTracker.PartialCommitHelper> helpers = new ArrayList<PartialLocalLineStatusTracker.PartialCommitHelper>();
            ArrayList<Change> partialChanges = new ArrayList<Change>();
            for (Change change : changes) {
                PartialLocalLineStatusTracker tracker;
                if (!(change instanceof ChangeListChange) || (tracker = PartialChangesUtil.getPartialTracker((Project)this.myProject, (Change)change)) == null) continue;
                if (!tracker.isOperational()) {
                    LOG.warn("Tracker is not operational for " + tracker.getVirtualFile().getPresentableUrl());
                    return null;
                }
                helpers.add(tracker.handlePartialCommit(Side.LEFT, changelistId));
                partialChanges.add(change);
            }
            return Pair.create(helpers, partialChanges);
        });
        if (result2 == null) {
            throw new VcsException("Can't collect partial changes to commit");
        }
        List helpers = (List)result2.first;
        List partialChanges = (List)result2.second;
        for (int i = 0; i < partialChanges.size(); ++i) {
            CurrentContentRevision revision = (CurrentContentRevision)((Change)partialChanges.get(i)).getAfterRevision();
            assert (revision != null);
            FilePath path = revision.getFile();
            PartialLocalLineStatusTracker.PartialCommitHelper helper = (PartialLocalLineStatusTracker.PartialCommitHelper)helpers.get(i);
            VirtualFile file = revision.getVirtualFile();
            if (file == null) {
                throw new VcsException("Can't find file: " + path.getPath());
            }
            GitIndexUtil.StagedFile stagedFile = GitIndexUtil.list(repository, path);
            boolean isExecutable = stagedFile != null && stagedFile.isExecutable();
            Pair.NonNull fileContent = LoadTextUtil.charsetForWriting((Project)repository.getProject(), (VirtualFile)file, (String)helper.getContent(), (Charset)file.getCharset());
            GitIndexUtil.write(repository, path, (byte[])fileContent.second, isExecutable);
        }
        Runnable callback = () -> ApplicationManager.getApplication().invokeLater(() -> {
            for (PartialLocalLineStatusTracker.PartialCommitHelper helper : helpers) {
                try {
                    helper.applyChanges();
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        });
        Pair pair = Pair.create((Object)callback, (Object)partialChanges);
        if (pair == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(20);
        }
        return pair;
    }

    @Nullable
    private static <T> T computeAfterLSTManagerUpdate(@NotNull Project project, @NotNull Computable<T> computation) {
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(21);
        }
        if (computation == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(22);
        }
        assert (!ApplicationManager.getApplication().isDispatchThread());
        FutureResult ref = new FutureResult();
        LineStatusTrackerManager.getInstance((Project)project).invokeAfterUpdate(() -> {
            if (computation == null) {
                GitCheckinEnvironment.$$$reportNull$$$0(39);
            }
            try {
                ref.set(computation.compute());
            }
            catch (Throwable e) {
                ref.setException(e);
            }
        });
        try {
            return (T)ref.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
    }

    private static void reset(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<Change> changes) throws VcsException {
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(23);
        }
        if (root == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(24);
        }
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(25);
        }
        HashSet<FilePath> paths = new HashSet<FilePath>();
        paths.addAll(ContainerUtil.mapNotNull(changes, ChangesUtil::getAfterPath));
        paths.addAll(ContainerUtil.mapNotNull(changes, ChangesUtil::getBeforePath));
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.RESET);
        handler.endOptions();
        handler.addRelativePaths(paths);
        Git.getInstance().runCommand(handler).getOutputOrThrow();
    }

    public List<VcsException> commit(List<Change> changes, String preparedComment) {
        return this.commit(changes, preparedComment, (NullableFunction<Object, Object>)FunctionUtil.nullConstant(), null);
    }

    private boolean mergeCommit(Project project, VirtualFile root, Set<FilePath> added, Set<FilePath> removed, File messageFile, List<VcsException> exceptions, @NotNull PartialOperation partialOperation) {
        String output;
        if (partialOperation == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(26);
        }
        HashSet<FilePath> realAdded = new HashSet<FilePath>();
        HashSet<FilePath> realRemoved = new HashSet<FilePath>();
        GitLineHandler diff = new GitLineHandler(project, root, GitCommand.DIFF);
        diff.setSilent(true);
        diff.setStdoutSuppressed(true);
        diff.addParameters("--diff-filter=ADMRUX", "--name-status", "--no-renames", "HEAD");
        diff.endOptions();
        try {
            output = Git.getInstance().runCommand(diff).getOutputOrThrow();
        }
        catch (VcsException ex) {
            exceptions.add(ex);
            return false;
        }
        String rootPath = root.getPath();
        StringTokenizer lines = new StringTokenizer(output, "\n", false);
        block11: while (lines.hasMoreTokens()) {
            String line = lines.nextToken().trim();
            if (line.length() == 0) continue;
            String[] tk = line.split("\t");
            switch (tk[0].charAt(0)) {
                case 'A': 
                case 'M': {
                    realAdded.add(VcsUtil.getFilePath((String)(rootPath + "/" + tk[1])));
                    continue block11;
                }
                case 'D': {
                    realRemoved.add(VcsUtil.getFilePath((String)(rootPath + "/" + tk[1]), (boolean)false));
                    continue block11;
                }
            }
            throw new IllegalStateException("Unexpected status: " + line);
        }
        realAdded.removeAll(added);
        realRemoved.removeAll(removed);
        if (realAdded.size() != 0 || realRemoved.size() != 0) {
            ArrayList<FilePath> files = new ArrayList<FilePath>();
            files.addAll(realAdded);
            files.addAll(realRemoved);
            Ref mergeAll = new Ref();
            try {
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    if (partialOperation == null) {
                        GitCheckinEnvironment.$$$reportNull$$$0(38);
                    }
                    String message = GitBundle.message("commit.partial.merge.message", partialOperation.getName());
                    SelectFilePathsDialog dialog = new SelectFilePathsDialog(project, files, message, null, "Commit All Files", CommonBundle.getCancelButtonText(), false);
                    dialog.setTitle(GitBundle.getString("commit.partial.merge.title"));
                    dialog.show();
                    mergeAll.set((Object)dialog.isOK());
                });
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to invoke a message box on AWT thread", ex);
            }
            if (!((Boolean)mergeAll.get()).booleanValue()) {
                return false;
            }
            if (!GitCheckinEnvironment.updateIndex(project, root, realAdded, realRemoved, exceptions)) {
                return false;
            }
            for (FilePath f : realAdded) {
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(f);
            }
            for (FilePath f : realRemoved) {
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(f);
            }
        }
        try {
            this.commitWithoutPaths(project, root, messageFile);
        }
        catch (VcsException ex) {
            exceptions.add(ex);
            return false;
        }
        return true;
    }

    private void commitWithoutPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull File messageFile) throws VcsException {
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(27);
        }
        if (root == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(28);
        }
        if (messageFile == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(29);
        }
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.COMMIT);
        handler.setStdoutSuppressed(false);
        handler.addParameters("-F", messageFile.getAbsolutePath());
        if (this.myNextCommitAmend) {
            handler.addParameters("--amend");
        }
        if (this.myNextCommitAuthor != null) {
            handler.addParameters("--author=" + this.myNextCommitAuthor);
        }
        if (this.myNextCommitAuthorDate != null) {
            handler.addParameters("--date", COMMIT_DATE_FORMAT.format(this.myNextCommitAuthorDate));
        }
        if (this.myNextCommitSignOff) {
            handler.addParameters("--signoff");
        }
        if (this.myNextCommitSkipHook) {
            handler.addParameters("--no-verify");
        }
        handler.endOptions();
        Git.getInstance().runCommand(handler).getOutputOrThrow();
    }

    private static PartialOperation isMergeCommit(VcsException ex) {
        String message = ex.getMessage();
        if (message.contains("cannot do a partial commit during a merge")) {
            return PartialOperation.MERGE;
        }
        if (message.contains("cannot do a partial commit during a cherry-pick")) {
            return PartialOperation.CHERRY_PICK;
        }
        return PartialOperation.NONE;
    }

    private static boolean updateIndex(Project project, VirtualFile root, Collection<FilePath> added, Collection<FilePath> removed, List<VcsException> exceptions) {
        boolean rc = true;
        if (!added.isEmpty()) {
            try {
                GitFileUtils.addPaths(project, root, added);
            }
            catch (VcsException ex) {
                exceptions.add(ex);
                rc = false;
            }
        }
        if (!removed.isEmpty()) {
            try {
                GitFileUtils.delete(project, root, removed, "--ignore-unmatch");
            }
            catch (VcsException ex) {
                exceptions.add(ex);
                rc = false;
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static File createCommitMessageFile(@NotNull Project project, @NotNull VirtualFile root, String message) throws IOException {
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(30);
        }
        if (root == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(31);
        }
        File file = FileUtil.createTempFile((String)GIT_COMMIT_MSG_FILE_PREFIX, (String)GIT_COMMIT_MSG_FILE_EXT);
        file.deleteOnExit();
        String encoding = GitConfigUtil.getCommitEncoding(project, root);
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);){
            out.write(message);
        }
        File file2 = file;
        if (file2 == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(32);
        }
        return file2;
    }

    public List<VcsException> scheduleMissingFileForDeletion(List<FilePath> files) {
        Map<VirtualFile, List<FilePath>> sortedFiles;
        ArrayList<VcsException> rc = new ArrayList<VcsException>();
        try {
            sortedFiles = GitUtil.sortFilePathsByGitRoot(files);
        }
        catch (VcsException e) {
            rc.add(e);
            return rc;
        }
        for (Map.Entry<VirtualFile, List<FilePath>> e : sortedFiles.entrySet()) {
            try {
                VirtualFile root = e.getKey();
                GitFileUtils.delete(this.myProject, root, (Collection<FilePath>)e.getValue(), new String[0]);
                this.markRootDirty(root);
            }
            catch (VcsException ex) {
                rc.add(ex);
            }
        }
        return rc;
    }

    private void commit(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<FilePath> files, @NotNull File message) throws VcsException {
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(33);
        }
        if (root == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(34);
        }
        if (files == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(35);
        }
        if (message == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(36);
        }
        boolean amend = this.myNextCommitAmend;
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)root, files)) {
            GitLineHandler handler = new GitLineHandler(project, root, GitCommand.COMMIT);
            handler.setStdoutSuppressed(false);
            if (this.myNextCommitSignOff) {
                handler.addParameters("--signoff");
            }
            if (amend) {
                handler.addParameters("--amend");
            } else {
                amend = true;
            }
            if (this.myNextCommitSkipHook) {
                handler.addParameters("--no-verify");
            }
            handler.addParameters("--only", "-F", message.getAbsolutePath());
            if (this.myNextCommitAuthor != null) {
                handler.addParameters("--author=" + this.myNextCommitAuthor);
            }
            if (this.myNextCommitAuthorDate != null) {
                handler.addParameters("--date", COMMIT_DATE_FORMAT.format(this.myNextCommitAuthorDate));
            }
            handler.endOptions();
            handler.addParameters(paths);
            Git.getInstance().runCommand(handler).getOutputOrThrow();
        }
    }

    public List<VcsException> scheduleUnversionedFilesForAddition(List<VirtualFile> files) {
        Map<VirtualFile, List<VirtualFile>> sortedFiles;
        ArrayList<VcsException> rc = new ArrayList<VcsException>();
        try {
            sortedFiles = GitUtil.sortFilesByGitRoot(files);
        }
        catch (VcsException e) {
            rc.add(e);
            return rc;
        }
        for (Map.Entry<VirtualFile, List<VirtualFile>> e : sortedFiles.entrySet()) {
            try {
                VirtualFile root = e.getKey();
                GitFileUtils.addFiles(this.myProject, root, (Collection<VirtualFile>)e.getValue());
                this.markRootDirty(root);
            }
            catch (VcsException ex) {
                rc.add(ex);
            }
        }
        return rc;
    }

    private static Map<VirtualFile, Collection<Change>> sortChangesByGitRoot(@NotNull List<Change> changes, List<VcsException> exceptions) {
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(37);
        }
        HashMap<VirtualFile, Collection<Change>> result2 = new HashMap<VirtualFile, Collection<Change>>();
        for (Change change : changes) {
            VirtualFile vcsRoot;
            ContentRevision afterRevision = change.getAfterRevision();
            ContentRevision beforeRevision = change.getBeforeRevision();
            assert (beforeRevision != null || afterRevision != null);
            FilePath filePath = afterRevision != null ? afterRevision.getFile() : beforeRevision.getFile();
            try {
                vcsRoot = GitUtil.getGitRoot(filePath.getParentPath());
            }
            catch (VcsException e) {
                exceptions.add(e);
                continue;
            }
            ArrayList<Change> changeList = (ArrayList<Change>)result2.get(vcsRoot);
            if (changeList == null) {
                changeList = new ArrayList<Change>();
                result2.put(vcsRoot, changeList);
            }
            changeList.add(change);
        }
        return result2;
    }

    private void markRootDirty(VirtualFile root) {
        this.myDirtyScopeManager.dirDirtyRecursively(root);
    }

    public void reset() {
        this.myNextCommitAmend = false;
        this.myNextCommitAuthor = null;
        this.myNextCommitIsPushed = null;
        this.myNextCommitAuthorDate = null;
        this.myNextCommitSkipHook = false;
    }

    public void setNextCommitIsPushed(Boolean nextCommitIsPushed) {
        this.myNextCommitIsPushed = nextCommitIsPushed;
    }

    public void setSkipHooksForNextCommit(boolean skipHooksForNextCommit) {
        this.myNextCommitSkipHook = skipHooksForNextCommit;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyScopeManager";
                break;
            }
            case 2: 
            case 13: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 4: 
            case 18: 
            case 25: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 5: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersHolder";
                break;
            }
            case 8: 
            case 24: 
            case 28: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 9: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caseOnlyRenames";
                break;
            }
            case 10: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partialChanges";
                break;
            }
            case 11: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "added";
                break;
            }
            case 12: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removed";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/checkin/GitCheckinEnvironment";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 22: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 26: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partialOperation";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/checkin/GitCheckinEnvironment";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "commitUsingIndex";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "addPartialChangesToIndex";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommitMessageFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadMessage";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "commit";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "commitUsingIndex";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 32: {
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addPartialChangesToIndex";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "computeAfterLSTManagerUpdate";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "mergeCommit";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "commitWithoutPaths";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createCommitMessageFile";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "sortChangesByGitRoot";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$mergeCommit$8";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "lambda$computeAfterLSTManagerUpdate$7";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addPartialChangesToIndex$4";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lambda$commitUsingIndex$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class GitCheckinOptions
    implements CheckinChangeListSpecificComponent,
    RefreshableOnComponent {
        @NotNull
        private final GitVcs myVcs;
        @NotNull
        private final CheckinProjectPanel myCheckinProjectPanel;
        @NotNull
        private JPanel myPanel;
        @NotNull
        private final EditorTextField myAuthorField;
        @Nullable
        private Date myAuthorDate;
        @NotNull
        private AmendComponent myAmendComponent;
        @NotNull
        private final JCheckBox mySignOffCheckbox;
        @NotNull
        private final BalloonBuilder myAuthorNotificationBuilder;
        @Nullable
        private Balloon myAuthorBalloon;

        GitCheckinOptions(@NotNull Project project, CheckinProjectPanel panel) {
            if (project == null) {
                GitCheckinOptions.$$$reportNull$$$0(0);
            }
            if (panel == null) {
                GitCheckinOptions.$$$reportNull$$$0(1);
            }
            this.myVcs = GitVcs.getInstance(project);
            this.myCheckinProjectPanel = panel;
            this.myAuthorField = this.createTextField(project, this.getAuthors(project));
            this.myAuthorField.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    GitCheckinOptions.this.clearAuthorWarn();
                }
            });
            this.myAuthorNotificationBuilder = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)new JLabel(GitBundle.getString("commit.author.diffs"))).setBorderInsets(UIManager.getInsets("Balloon.error.textInsets")).setBorderColor(DialogWrapper.BALLOON_WARNING_BORDER).setFillColor(DialogWrapper.BALLOON_WARNING_BACKGROUND).setHideOnClickOutside(true).setHideOnFrameResize(false);
            this.myAuthorField.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 4L) != 0L && GitCheckinOptions.this.myAuthorField.isShowing() && !StringUtil.isEmptyOrSpaces((String)GitCheckinOptions.this.myAuthorField.getText())) {
                        GitCheckinOptions.this.showAuthorBalloonNotification();
                        GitCheckinOptions.this.myAuthorField.removeHierarchyListener((HierarchyListener)this);
                    }
                }
            });
            JBLabel authorLabel = new JBLabel(GitBundle.message("commit.author", new Object[0]));
            authorLabel.setLabelFor((Component)this.myAuthorField);
            this.myAmendComponent = new MyAmendComponent(project, GitUtil.getRepositoryManager(project), panel);
            this.mySignOffCheckbox = new JBCheckBox("Sign-off commit", GitCheckinEnvironment.this.mySettings.shouldSignOffCommit());
            this.mySignOffCheckbox.setMnemonic(71);
            this.mySignOffCheckbox.setToolTipText(this.getToolTip(project, panel));
            GridBag gb = new GridBag().setDefaultAnchor(17).setDefaultInsets((Insets)JBUI.insets((int)2));
            this.myPanel = new JPanel(new GridBagLayout());
            this.myPanel.add((Component)authorLabel, gb.nextLine().next());
            this.myPanel.add((Component)this.myAuthorField, gb.next().fillCellHorizontally().weightx(1.0));
            this.myPanel.add(this.myAmendComponent.getComponent(), gb.nextLine().next().coverLine());
            this.myPanel.add((Component)this.mySignOffCheckbox, gb.nextLine().next().coverLine());
        }

        public boolean isAmend() {
            return this.myAmendComponent.isAmend();
        }

        @NotNull
        private String getToolTip(@NotNull Project project, @NotNull CheckinProjectPanel panel) {
            VcsUser user;
            if (project == null) {
                GitCheckinOptions.$$$reportNull$$$0(2);
            }
            if (panel == null) {
                GitCheckinOptions.$$$reportNull$$$0(3);
            }
            String signature = (user = (VcsUser)ContainerUtil.getFirstItem((List)ContainerUtil.mapNotNull((Collection)panel.getRoots(), it -> {
                if (project == null) {
                    GitCheckinOptions.$$$reportNull$$$0(15);
                }
                return GitUserRegistry.getInstance(project).getUser((VirtualFile)it);
            }))) != null ? StringUtil.escapeXml((String)VcsUserUtil.toExactString((VcsUser)user)) : "";
            String string = "<html>Adds the following line at the end of the commit message:<br/>Signed-off by: " + signature + "</html>";
            if (string == null) {
                GitCheckinOptions.$$$reportNull$$$0(4);
            }
            return string;
        }

        private void showAuthorBalloonNotification() {
            if (this.myAuthorBalloon == null || this.myAuthorBalloon.isDisposed()) {
                this.myAuthorBalloon = this.myAuthorNotificationBuilder.createBalloon();
                this.myAuthorBalloon.show(new RelativePoint((Component)this.myAuthorField, new Point(this.myAuthorField.getWidth() / 2, this.myAuthorField.getHeight())), Balloon.Position.below);
            }
        }

        @NotNull
        private List<String> getAuthors(@NotNull Project project) {
            if (project == null) {
                GitCheckinOptions.$$$reportNull$$$0(5);
            }
            HashSet<String> authors = new HashSet<String>(this.getUsersList(project));
            ContainerUtil.addAll(authors, (Object[])GitCheckinEnvironment.this.mySettings.getCommitAuthors());
            ArrayList<String> list = new ArrayList<String>(authors);
            Collections.sort(list);
            ArrayList<String> arrayList = list;
            if (arrayList == null) {
                GitCheckinOptions.$$$reportNull$$$0(6);
            }
            return arrayList;
        }

        @NotNull
        private EditorTextField createTextField(@NotNull Project project, @NotNull List<String> list) {
            if (project == null) {
                GitCheckinOptions.$$$reportNull$$$0(7);
            }
            if (list == null) {
                GitCheckinOptions.$$$reportNull$$$0(8);
            }
            ValuesCompletionProvider.ValuesCompletionProviderDumbAware completionProvider = new ValuesCompletionProvider.ValuesCompletionProviderDumbAware((TextCompletionValueDescriptor)new DefaultTextCompletionValueDescriptor.StringValueDescriptor(), list);
            TextFieldWithCompletion textFieldWithCompletion = new TextFieldWithCompletion(project, (TextCompletionProvider)completionProvider, "", true, true, true);
            if (textFieldWithCompletion == null) {
                GitCheckinOptions.$$$reportNull$$$0(9);
            }
            return textFieldWithCompletion;
        }

        @NotNull
        private List<String> getUsersList(@NotNull Project project) {
            if (project == null) {
                GitCheckinOptions.$$$reportNull$$$0(10);
            }
            VcsUserRegistry userRegistry = (VcsUserRegistry)ServiceManager.getService((Project)project, VcsUserRegistry.class);
            List list = ContainerUtil.map((Collection)userRegistry.getUsers(), VcsUserUtil::toExactString);
            if (list == null) {
                GitCheckinOptions.$$$reportNull$$$0(11);
            }
            return list;
        }

        public void refresh() {
            this.myAmendComponent.refresh();
            this.myAuthorField.setText(null);
            this.clearAuthorWarn();
            this.myAuthorDate = null;
            GitCheckinEnvironment.this.reset();
        }

        public void saveState() {
            String author = this.myAuthorField.getText();
            if (StringUtil.isEmptyOrSpaces((String)author)) {
                GitCheckinEnvironment.this.myNextCommitAuthor = null;
            } else {
                GitCheckinEnvironment.this.myNextCommitAuthor = GitCommitAuthorCorrector.correct(author);
                GitCheckinEnvironment.this.mySettings.saveCommitAuthor(GitCheckinEnvironment.this.myNextCommitAuthor);
            }
            GitCheckinEnvironment.this.myNextCommitAmend = this.isAmend();
            GitCheckinEnvironment.this.myNextCommitAuthorDate = this.myAuthorDate;
            GitCheckinEnvironment.this.mySettings.setSignOffCommit(this.mySignOffCheckbox.isSelected());
            GitCheckinEnvironment.this.myNextCommitSignOff = this.mySignOffCheckbox.isSelected();
        }

        public void restoreState() {
            this.refresh();
        }

        public void onChangeListSelected(LocalChangeList list) {
            Object data = list.getData();
            this.clearAuthorWarn();
            if (data instanceof ChangeListData) {
                this.fillAuthorAndDateFromData((ChangeListData)data);
            } else {
                this.myAuthorField.setText(null);
                this.myAuthorDate = null;
            }
            this.myPanel.revalidate();
            this.myPanel.repaint();
        }

        private void fillAuthorAndDateFromData(@NotNull ChangeListData data) {
            VcsUser author;
            if (data == null) {
                GitCheckinOptions.$$$reportNull$$$0(12);
            }
            if ((author = data.getAuthor()) != null && !this.isDefaultAuthor(author)) {
                this.myAuthorField.setText(VcsUserUtil.toExactString((VcsUser)author));
                this.myAuthorField.putClientProperty((Object)"JComponent.outline", (Object)"warning");
                if (this.myAuthorField.isShowing()) {
                    this.showAuthorBalloonNotification();
                }
            } else {
                this.myAuthorField.setText(null);
            }
            this.myAuthorDate = data.getDate();
        }

        private void clearAuthorWarn() {
            this.myAuthorField.putClientProperty((Object)"JComponent.outline", null);
            if (this.myAuthorBalloon != null) {
                this.myAuthorBalloon.hide();
                this.myAuthorBalloon = null;
            }
        }

        public JComponent getComponent() {
            return this.myPanel;
        }

        public boolean isDefaultAuthor(@NotNull VcsUser author) {
            if (author == null) {
                GitCheckinOptions.$$$reportNull$$$0(13);
            }
            List affectedGitRoots = ContainerUtil.filter((Collection)this.myCheckinProjectPanel.getRoots(), virtualFile -> GitUtil.findGitDir(virtualFile) != null);
            GitUserRegistry gitUserRegistry = GitUserRegistry.getInstance(GitCheckinEnvironment.this.myProject);
            return StreamEx.of((Collection)affectedGitRoots).map(vf -> gitUserRegistry.getUser((VirtualFile)vf)).allMatch(user -> {
                if (author == null) {
                    GitCheckinOptions.$$$reportNull$$$0(14);
                }
                return user != null && VcsUserUtil.isSamePerson((VcsUser)author, (VcsUser)user);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "author";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getToolTip";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAuthors";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTextField";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUsersList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getToolTip";
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getAuthors";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createTextField";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getUsersList";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "fillAuthorAndDateFromData";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "isDefaultAuthor";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$isDefaultAuthor$3";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$getToolTip$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class MyAmendComponent
        extends AmendComponent {
            public MyAmendComponent(@NotNull Project project, @NotNull GitRepositoryManager manager, CheckinProjectPanel panel) {
                if (project == null) {
                    MyAmendComponent.$$$reportNull$$$0(0);
                }
                if (manager == null) {
                    MyAmendComponent.$$$reportNull$$$0(1);
                }
                if (panel == null) {
                    MyAmendComponent.$$$reportNull$$$0(2);
                }
                super(project, (RepositoryManager)manager, panel);
            }

            @NotNull
            protected Set<VirtualFile> getVcsRoots(@NotNull Collection<FilePath> files) {
                if (files == null) {
                    MyAmendComponent.$$$reportNull$$$0(3);
                }
                Set<VirtualFile> set = GitUtil.gitRoots(files);
                if (set == null) {
                    MyAmendComponent.$$$reportNull$$$0(4);
                }
                return set;
            }

            @Nullable
            protected String getLastCommitMessage(@NotNull VirtualFile root) throws VcsException {
                if (root == null) {
                    MyAmendComponent.$$$reportNull$$$0(5);
                }
                GitLineHandler h = new GitLineHandler(GitCheckinEnvironment.this.myProject, root, GitCommand.LOG);
                h.addParameters("--max-count=1");
                h.addParameters("--encoding=UTF-8");
                String formatPattern = GitVersionSpecialty.STARTED_USING_RAW_BODY_IN_FORMAT.existsIn(GitCheckinOptions.this.myVcs.getVersion()) ? "%B" : "%s%n%n%-b";
                h.addParameters("--pretty=format:" + formatPattern);
                return Git.getInstance().runCommand(h).getOutputOrThrow();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "manager";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "panel";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "files";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions$MyAmendComponent";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "root";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions$MyAmendComponent";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVcsRoots";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getVcsRoots";
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "getLastCommitMessage";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }

    private static enum PartialOperation {
        NONE("none"),
        MERGE("merge"),
        CHERRY_PICK("cherry-pick");

        private final String myName;

        private PartialOperation(String name) {
            this.myName = name;
        }

        String getName() {
            return this.myName;
        }
    }
}

