/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.ExecutionException;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandler;
import git4idea.commands.GitHandlerListener;
import git4idea.commands.GitImpl;
import git4idea.util.GitVcsConsoleWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class GitBinaryHandler
extends GitHandler {
    private static final int BUFFER_SIZE = 8192;
    @NotNull
    private final ByteArrayOutputStream myStdout = new ByteArrayOutputStream();
    @NotNull
    private final ByteArrayOutputStream myStderr = new ByteArrayOutputStream();
    @NotNull
    private final Semaphore mySteamSemaphore = new Semaphore(0);
    @NotNull
    private final AtomicReference<VcsException> myException = new AtomicReference();

    public GitBinaryHandler(Project project, VirtualFile vcsRoot, GitCommand command) {
        super(project, vcsRoot, command, Collections.emptyList());
    }

    @Override
    protected Process startProcess() throws ExecutionException {
        return this.myCommandLine.createProcess();
    }

    @Override
    protected void startHandlingStreams() {
        this.handleStream(this.myProcess.getErrorStream(), this.myStderr, "Error stream copy of " + this.myCommandLine.getCommandLineString());
        this.handleStream(this.myProcess.getInputStream(), this.myStdout, "Output stream copy of " + this.myCommandLine.getCommandLineString());
    }

    private void handleStream(InputStream in, ByteArrayOutputStream out, @NotNull String cmd) {
        if (cmd == null) {
            GitBinaryHandler.$$$reportNull$$$0(0);
        }
        Thread t = new Thread(() -> {
            try {
                int rc;
                byte[] buffer = new byte[8192];
                while ((rc = in.read(buffer)) != -1) {
                    out.write(buffer, 0, rc);
                }
            }
            catch (IOException e) {
                if (!this.myException.compareAndSet(null, new VcsException("Stream IO problem", (Throwable)e))) {
                    LOG.error("Problem reading stream", (Throwable)e);
                }
            }
            finally {
                this.mySteamSemaphore.release(1);
            }
        }, cmd);
        t.setDaemon(true);
        t.start();
    }

    @Override
    public void destroyProcess() {
        this.myProcess.destroy();
    }

    @Override
    protected void waitForProcess() {
        try {
            this.mySteamSemaphore.acquire(2);
            this.myProcess.waitFor();
            int exitCode = this.myProcess.exitValue();
            this.setExitCode(exitCode);
        }
        catch (InterruptedException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring process exception: ", (Throwable)e);
            }
            this.setExitCode(255);
        }
        this.listeners().processTerminated(this.getExitCode());
    }

    public byte[] run() throws VcsException {
        Project project = this.project();
        final GitVcsConsoleWriter vcsConsoleWriter = project != null ? GitVcsConsoleWriter.getInstance(project) : null;
        this.addListener(new GitHandlerListener(){

            public void processTerminated(int exitCode) {
                if (exitCode != 0 && !GitBinaryHandler.this.isIgnoredErrorCode(exitCode)) {
                    VcsException e;
                    Charset cs = GitBinaryHandler.this.getCharset();
                    String message = new String(GitBinaryHandler.this.myStderr.toByteArray(), cs);
                    if (message.length() == 0) {
                        message = GitBinaryHandler.this.myException.get() != null ? IdeBundle.message((String)"finished.with.exit.code.text.message", (Object[])new Object[]{exitCode}) : null;
                    } else if (vcsConsoleWriter != null && !GitBinaryHandler.this.isStderrSuppressed()) {
                        vcsConsoleWriter.showErrorMessage(message);
                    }
                    if (message != null && (e = GitBinaryHandler.this.myException.getAndSet(new VcsException(message))) != null) {
                        GitHandler.LOG.warn("Dropping previous exception: ", (Throwable)e);
                    }
                }
            }

            public void startFailed(Throwable exception) {
                VcsException e = GitBinaryHandler.this.myException.getAndSet(new VcsException("Start failed: " + exception.getMessage(), exception));
                if (e != null) {
                    GitHandler.LOG.warn("Dropping previous exception: ", (Throwable)e);
                }
            }
        });
        if (vcsConsoleWriter != null && !this.mySilent) {
            vcsConsoleWriter.showCommandLine("[" + GitImpl.stringifyWorkingDir(project.getBasePath(), this.getWorkingDirectory()) + "] " + this.printableCommandLine());
        }
        this.runInCurrentThread();
        if (this.myException.get() != null) {
            throw this.myException.get();
        }
        return this.myStdout.toByteArray();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cmd", "git4idea/commands/GitBinaryHandler", "handleStream"));
    }
}

