/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandlerAuthenticationManager;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerAdapter;
import git4idea.commands.GitLineHandlerListener;
import git4idea.util.GitVcsConsoleWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class GitImplBase
implements Git {
    public static final String[] ERROR_INDICATORS = new String[]{"warning:", "error:", "fatal:", "remote: error", "Cannot", "Could not", "Interactive rebase already started", "refusing to pull", "cannot rebase:", "conflict", "unable", "runnerw:"};

    GitImplBase() {
    }

    @Override
    @NotNull
    public GitCommandResult runCommand(@NotNull GitLineHandler handler) {
        if (handler == null) {
            GitImplBase.$$$reportNull$$$0(0);
        }
        GitCommandResult gitCommandResult = this.runCommand((Computable<GitLineHandler>)((Computable)() -> {
            if (handler == null) {
                GitImplBase.$$$reportNull$$$0(24);
            }
            return handler;
        }));
        if (gitCommandResult == null) {
            GitImplBase.$$$reportNull$$$0(1);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult runCommand(@NotNull Computable<GitLineHandler> handlerConstructor) {
        if (handlerConstructor == null) {
            GitImplBase.$$$reportNull$$$0(2);
        }
        GitCommandResult gitCommandResult = GitImplBase.run(handlerConstructor, (Computable<OutputCollector>)((Computable)() -> new OutputCollector(){

            @Override
            public void outputLineReceived(@NotNull String line) {
                if (line == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.addOutputLine(line);
            }

            @Override
            public void errorLineReceived(@NotNull String line) {
                if (line == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!GitImplBase.looksLikeError(line)) {
                    this.addOutputLine(line);
                } else {
                    this.addErrorLine(line);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "line";
                objectArray2[1] = "git4idea/commands/GitImplBase$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "outputLineReceived";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorLineReceived";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }));
        if (gitCommandResult == null) {
            GitImplBase.$$$reportNull$$$0(3);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult runCommandWithoutCollectingOutput(@NotNull GitLineHandler handler) {
        if (handler == null) {
            GitImplBase.$$$reportNull$$$0(4);
        }
        GitCommandResult gitCommandResult = GitImplBase.run((Computable<GitLineHandler>)((Computable)() -> {
            if (handler == null) {
                GitImplBase.$$$reportNull$$$0(23);
            }
            return handler;
        }), (Computable<OutputCollector>)((Computable)() -> new OutputCollector(){

            @Override
            protected void outputLineReceived(@NotNull String line) {
                if (line == null) {
                    2.$$$reportNull$$$0(0);
                }
            }

            @Override
            protected void errorLineReceived(@NotNull String line) {
                if (line == null) {
                    2.$$$reportNull$$$0(1);
                }
                this.addErrorLine(line);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "line";
                objectArray2[1] = "git4idea/commands/GitImplBase$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "outputLineReceived";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorLineReceived";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }));
        if (gitCommandResult == null) {
            GitImplBase.$$$reportNull$$$0(5);
        }
        return gitCommandResult;
    }

    @NotNull
    private static GitCommandResult run(@NotNull Computable<GitLineHandler> handlerConstructor, @NotNull Computable<OutputCollector> outputCollectorConstructor) {
        GitCommandResultListener resultListener;
        OutputCollector outputCollector;
        GitLineHandler handler;
        if (handlerConstructor == null) {
            GitImplBase.$$$reportNull$$$0(6);
        }
        if (outputCollectorConstructor == null) {
            GitImplBase.$$$reportNull$$$0(7);
        }
        Ref authFailedRef = Ref.create((Object)false);
        int authAttempt = 0;
        do {
            handler = (GitLineHandler)handlerConstructor.compute();
            outputCollector = (OutputCollector)outputCollectorConstructor.compute();
            resultListener = new GitCommandResultListener(outputCollector);
            handler.addLineListener(resultListener);
            try (AccessToken locking = GitImplBase.lock(handler);
                 AccessToken auth = GitImplBase.remoteAuth(handler, arg_0 -> ((Ref)authFailedRef).set(arg_0));){
                GitImplBase.writeOutputToConsole(handler);
                handler.runInCurrentThread();
            }
            catch (IOException e) {
                resultListener.startFailed(e);
            }
        } while (((Boolean)authFailedRef.get()).booleanValue() && authAttempt++ < 2);
        GitCommandResult gitCommandResult = new GitCommandResult(!resultListener.myStartFailed && (handler.isIgnoredErrorCode(resultListener.myExitCode) || resultListener.myExitCode == 0), resultListener.myExitCode, (Boolean)authFailedRef.get(), outputCollector.myErrorOutput, outputCollector.myOutput);
        if (gitCommandResult == null) {
            GitImplBase.$$$reportNull$$$0(8);
        }
        return gitCommandResult;
    }

    private static void writeOutputToConsole(final @NotNull GitLineHandler handler) {
        Project project;
        if (handler == null) {
            GitImplBase.$$$reportNull$$$0(9);
        }
        if ((project = handler.project()) != null && !project.isDefault()) {
            final GitVcsConsoleWriter vcsConsoleWriter = GitVcsConsoleWriter.getInstance(project);
            handler.addLineListener(new GitLineHandlerAdapter(){

                @Override
                public void onLineAvailable(String line, Key outputType) {
                    if (!handler.isSilent() && !StringUtil.isEmptyOrSpaces((String)line)) {
                        if (outputType == ProcessOutputTypes.STDOUT && !handler.isStdoutSuppressed()) {
                            vcsConsoleWriter.showMessage(line);
                        } else if (outputType == ProcessOutputTypes.STDERR && !handler.isStderrSuppressed()) {
                            vcsConsoleWriter.showErrorMessage(line);
                        }
                    }
                }
            });
            if (!handler.isSilent()) {
                vcsConsoleWriter.showCommandLine("[" + GitImplBase.stringifyWorkingDir(project.getBasePath(), handler.getWorkingDirectory()) + "] " + handler.printableCommandLine());
            }
        }
    }

    @NotNull
    private static AccessToken lock(@NotNull GitLineHandler handler) {
        Project project;
        if (handler == null) {
            GitImplBase.$$$reportNull$$$0(10);
        }
        if ((project = handler.project()) != null && !project.isDefault() && GitCommand.LockingPolicy.WRITE == handler.getCommand().lockingPolicy()) {
            final ReadWriteLock executionLock = GitVcs.getInstance(project).getCommandLock();
            executionLock.writeLock().lock();
            AccessToken accessToken = new AccessToken(){

                public void finish() {
                    executionLock.writeLock().unlock();
                }
            };
            if (accessToken == null) {
                GitImplBase.$$$reportNull$$$0(11);
            }
            return accessToken;
        }
        AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
        if (accessToken == null) {
            GitImplBase.$$$reportNull$$$0(12);
        }
        return accessToken;
    }

    @NotNull
    private static AccessToken remoteAuth(@NotNull GitLineHandler handler, final @NotNull Consumer<Boolean> authResultConsumer) throws IOException {
        Project project;
        if (handler == null) {
            GitImplBase.$$$reportNull$$$0(13);
        }
        if (authResultConsumer == null) {
            GitImplBase.$$$reportNull$$$0(14);
        }
        if ((project = handler.project()) != null && handler.isRemote()) {
            final GitHandlerAuthenticationManager authManager = GitHandlerAuthenticationManager.prepare(project, handler);
            AccessToken accessToken = new AccessToken(){

                public void finish() {
                    authResultConsumer.accept(authManager.isHttpAuthFailed());
                    authManager.cleanup();
                }
            };
            if (accessToken == null) {
                GitImplBase.$$$reportNull$$$0(15);
            }
            return accessToken;
        }
        AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
        if (accessToken == null) {
            GitImplBase.$$$reportNull$$$0(16);
        }
        return accessToken;
    }

    private static boolean looksLikeError(@NotNull String text) {
        if (text == null) {
            GitImplBase.$$$reportNull$$$0(17);
        }
        return ContainerUtil.exists((Object[])ERROR_INDICATORS, indicator -> {
            if (text == null) {
                GitImplBase.$$$reportNull$$$0(22);
            }
            return StringUtil.startsWithIgnoreCase((String)text.trim(), (String)indicator);
        });
    }

    @NotNull
    static String stringifyWorkingDir(@Nullable String basePath, @NotNull File workingDir) {
        if (workingDir == null) {
            GitImplBase.$$$reportNull$$$0(18);
        }
        if (basePath != null) {
            String relPath = FileUtil.getRelativePath((String)basePath, (String)FileUtil.toSystemIndependentName((String)workingDir.getPath()), (char)'/');
            if (".".equals(relPath)) {
                String string = workingDir.getName();
                if (string == null) {
                    GitImplBase.$$$reportNull$$$0(19);
                }
                return string;
            }
            if (relPath != null) {
                String string = FileUtil.toSystemDependentName((String)relPath);
                if (string == null) {
                    GitImplBase.$$$reportNull$$$0(20);
                }
                return string;
            }
        }
        String string = workingDir.getPath();
        if (string == null) {
            GitImplBase.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/commands/GitImplBase";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handlerConstructor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputCollectorConstructor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authResultConsumer";
                break;
            }
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/commands/GitImplBase";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "runCommand";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "runCommandWithoutCollectingOutput";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "run";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "lock";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "remoteAuth";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "stringifyWorkingDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runCommand";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runCommandWithoutCollectingOutput";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeOutputToConsole";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lock";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "remoteAuth";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "looksLikeError";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "stringifyWorkingDir";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$looksLikeError$4";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runCommandWithoutCollectingOutput$2";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runCommand$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class OutputCollector {
        final List<String> myOutput = new ArrayList<String>();
        final List<String> myErrorOutput = new ArrayList<String>();

        private OutputCollector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void addOutputLine(@NotNull String line) {
            if (line == null) {
                OutputCollector.$$$reportNull$$$0(0);
            }
            List<String> list = this.myOutput;
            synchronized (list) {
                this.myOutput.add(line);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void addErrorLine(@NotNull String line) {
            if (line == null) {
                OutputCollector.$$$reportNull$$$0(1);
            }
            List<String> list = this.myErrorOutput;
            synchronized (list) {
                this.myErrorOutput.add(line);
            }
        }

        abstract void outputLineReceived(@NotNull String var1);

        abstract void errorLineReceived(@NotNull String var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "line";
            objectArray2[1] = "git4idea/commands/GitImplBase$OutputCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addOutputLine";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addErrorLine";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class GitCommandResultListener
    implements GitLineHandlerListener {
        private final OutputCollector myOutputCollector;
        private int myExitCode = 0;
        private boolean myStartFailed = false;

        public GitCommandResultListener(OutputCollector outputCollector) {
            this.myOutputCollector = outputCollector;
        }

        @Override
        public void onLineAvailable(String line, Key outputType) {
            if (outputType == ProcessOutputTypes.STDOUT) {
                this.myOutputCollector.outputLineReceived(line);
            } else if (outputType == ProcessOutputTypes.STDERR) {
                this.myOutputCollector.errorLineReceived(line);
            }
        }

        public void processTerminated(int code) {
            this.myExitCode = code;
        }

        public void startFailed(Throwable t) {
            this.myStartFailed = true;
            this.myOutputCollector.errorLineReceived("Failed to start Git process " + t.getLocalizedMessage());
        }
    }
}

