/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProcessEventListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitTextHandler;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitLineHandler
extends GitTextHandler {
    private final EventDispatcher<GitLineHandlerListener> myLineListeners;
    private final boolean myWithMediator;
    @NotNull
    private Collection<String> myUrls;

    public GitLineHandler(@NotNull Project project, @NotNull File directory, @NotNull GitCommand command) {
        if (project == null) {
            GitLineHandler.$$$reportNull$$$0(0);
        }
        if (directory == null) {
            GitLineHandler.$$$reportNull$$$0(1);
        }
        if (command == null) {
            GitLineHandler.$$$reportNull$$$0(2);
        }
        super(project, directory, command);
        this.myLineListeners = EventDispatcher.create(GitLineHandlerListener.class);
        this.myUrls = Collections.emptyList();
        this.myWithMediator = true;
    }

    public GitLineHandler(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull GitCommand command) {
        if (project == null) {
            GitLineHandler.$$$reportNull$$$0(3);
        }
        if (vcsRoot == null) {
            GitLineHandler.$$$reportNull$$$0(4);
        }
        if (command == null) {
            GitLineHandler.$$$reportNull$$$0(5);
        }
        this(project, vcsRoot, command, Collections.emptyList());
    }

    public GitLineHandler(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull GitCommand command, @NotNull List<String> configParameters) {
        if (project == null) {
            GitLineHandler.$$$reportNull$$$0(6);
        }
        if (vcsRoot == null) {
            GitLineHandler.$$$reportNull$$$0(7);
        }
        if (command == null) {
            GitLineHandler.$$$reportNull$$$0(8);
        }
        if (configParameters == null) {
            GitLineHandler.$$$reportNull$$$0(9);
        }
        this(project, vcsRoot, command, configParameters, true);
    }

    public GitLineHandler(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull GitCommand command, @NotNull List<String> configParameters, boolean withMediator) {
        if (project == null) {
            GitLineHandler.$$$reportNull$$$0(10);
        }
        if (vcsRoot == null) {
            GitLineHandler.$$$reportNull$$$0(11);
        }
        if (command == null) {
            GitLineHandler.$$$reportNull$$$0(12);
        }
        if (configParameters == null) {
            GitLineHandler.$$$reportNull$$$0(13);
        }
        super(project, vcsRoot, command, configParameters);
        this.myLineListeners = EventDispatcher.create(GitLineHandlerListener.class);
        this.myUrls = Collections.emptyList();
        this.myWithMediator = withMediator;
    }

    public GitLineHandler(@Nullable Project project, @NotNull File directory, @NotNull String pathToExecutable, @NotNull GitCommand command, @NotNull List<String> configParameters) {
        if (directory == null) {
            GitLineHandler.$$$reportNull$$$0(14);
        }
        if (pathToExecutable == null) {
            GitLineHandler.$$$reportNull$$$0(15);
        }
        if (command == null) {
            GitLineHandler.$$$reportNull$$$0(16);
        }
        if (configParameters == null) {
            GitLineHandler.$$$reportNull$$$0(17);
        }
        super(project, directory, pathToExecutable, command, configParameters);
        this.myLineListeners = EventDispatcher.create(GitLineHandlerListener.class);
        this.myUrls = Collections.emptyList();
        this.myWithMediator = true;
    }

    public void setUrl(@NotNull String url) {
        if (url == null) {
            GitLineHandler.$$$reportNull$$$0(18);
        }
        this.setUrls(Collections.singletonList(url));
    }

    public void setUrls(@NotNull Collection<String> urls) {
        if (urls == null) {
            GitLineHandler.$$$reportNull$$$0(19);
        }
        this.myUrls = urls;
    }

    @NotNull
    public Collection<String> getUrls() {
        Collection<String> collection = this.myUrls;
        if (collection == null) {
            GitLineHandler.$$$reportNull$$$0(20);
        }
        return collection;
    }

    protected boolean isRemote() {
        return !this.myUrls.isEmpty();
    }

    @Override
    protected void processTerminated(int exitCode) {
    }

    public void addLineListener(GitLineHandlerListener listener) {
        super.addListener((ProcessEventListener)listener);
        this.myLineListeners.addListener((EventListener)((Object)listener));
    }

    @Override
    protected void onTextAvailable(String text, Key outputType) {
        this.notifyLine(text, outputType);
    }

    private void notifyLine(String line, Key outputType) {
        if (outputType == ProcessOutputTypes.STDOUT) {
            if (!(this.isStdoutSuppressed() || this.mySilent || StringUtil.isEmptyOrSpaces((String)line))) {
                LOG.info(line.trim());
            } else {
                OUTPUT_LOG.debug(line.trim());
            }
        } else if (!(outputType != ProcessOutputTypes.STDERR || this.isStderrSuppressed() || this.mySilent || StringUtil.isEmptyOrSpaces((String)line))) {
            LOG.info(line.trim());
        } else {
            LOG.debug(line.trim());
        }
        ((GitLineHandlerListener)((Object)this.myLineListeners.getMulticaster())).onLineAvailable(line, outputType);
    }

    @Override
    protected ProcessHandler createProcess(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            GitLineHandler.$$$reportNull$$$0(21);
        }
        return new GitTextHandler.MyOSProcessHandler(commandLine, this.myWithMediator){

            @Override
            @NotNull
            protected BaseOutputReader.Options readerOptions() {
                BaseOutputReader.Options options = new BaseOutputReader.Options(){

                    public BaseDataReader.SleepingPolicy policy() {
                        return BaseDataReader.SleepingPolicy.BLOCKING;
                    }

                    public boolean splitToLines() {
                        return true;
                    }

                    public boolean sendIncompleteLines() {
                        return false;
                    }

                    public boolean withSeparators() {
                        return false;
                    }
                };
                if (options == null) {
                    1.$$$reportNull$$$0(0);
                }
                return options;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitLineHandler$1", "readerOptions"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 9: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configParameters";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToExecutable";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/commands/GitLineHandler";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/commands/GitLineHandler";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setUrl";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setUrls";
                break;
            }
            case 20: {
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

