/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import git4idea.config.GitExecutableDetector;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVcsSettings;
import org.jetbrains.annotations.NotNull;

public class GitExecutableManager {
    @NotNull
    private final GitVcsApplicationSettings myApplicationSettings;
    @NotNull
    private final AtomicNotNullLazyValue<String> myDetectedExecutable;

    public static GitExecutableManager getInstance() {
        return (GitExecutableManager)ServiceManager.getService(GitExecutableManager.class);
    }

    public GitExecutableManager(@NotNull GitVcsApplicationSettings applicationSettings) {
        if (applicationSettings == null) {
            GitExecutableManager.$$$reportNull$$$0(0);
        }
        this.myApplicationSettings = applicationSettings;
        this.myDetectedExecutable = AtomicNotNullLazyValue.createValue(new GitExecutableDetector()::detect);
    }

    @NotNull
    public String getPathToGit() {
        String path = this.myApplicationSettings.getSavedPathToGit();
        String string = path == null ? this.getDetectedExecutable() : path;
        if (string == null) {
            GitExecutableManager.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getPathToGit(@NotNull Project project) {
        String path;
        if (project == null) {
            GitExecutableManager.$$$reportNull$$$0(2);
        }
        String string = (path = GitVcsSettings.getInstance(project).getPathToGit()) == null ? this.getPathToGit() : path;
        if (string == null) {
            GitExecutableManager.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getDetectedExecutable() {
        String string = (String)this.myDetectedExecutable.getValue();
        if (string == null) {
            GitExecutableManager.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationSettings";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/config/GitExecutableManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/config/GitExecutableManager";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToGit";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetectedExecutable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPathToGit";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

