/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import git4idea.GitVcs;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitSharedSettings;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVcsConfigurable;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersion;
import git4idea.config.UpdateMethod;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepositoryManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitVcsPanel
implements ConfigurableUi<GitVcsConfigurable.GitVcsSettingsHolder> {
    private static final String IDEA_SSH = GitBundle.getString("git.vcs.config.ssh.mode.idea");
    private static final String NATIVE_SSH = GitBundle.getString("git.vcs.config.ssh.mode.native");
    @NotNull
    private final Project myProject;
    private String myDetectedGitPath;
    private String myApplicationGitPath;
    private JButton myTestButton;
    private JComponent myRootPanel;
    private TextFieldWithBrowseButton myGitField;
    private JBCheckBox myProjectGitPathCheckBox;
    private JComboBox mySSHExecutableComboBox;
    private JCheckBox myAutoUpdateIfPushRejected;
    private JBCheckBox mySyncControl;
    private JCheckBox myAutoCommitOnCherryPick;
    private JBCheckBox myWarnAboutCrlf;
    private JCheckBox myWarnAboutDetachedHead;
    private JTextField myProtectedBranchesField;
    private JBLabel myProtectedBranchesLabel;
    private JComboBox myUpdateMethodComboBox;

    public GitVcsPanel(@NotNull Project project) {
        if (project == null) {
            GitVcsPanel.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.mySSHExecutableComboBox.addItem(IDEA_SSH);
        this.mySSHExecutableComboBox.addItem(NATIVE_SSH);
        this.mySSHExecutableComboBox.setSelectedItem(IDEA_SSH);
        this.mySSHExecutableComboBox.setToolTipText(GitBundle.message("git.vcs.config.ssh.mode.tooltip", ApplicationNamesInfo.getInstance().getFullProductName()));
        this.myTestButton.addActionListener(e -> this.testExecutable());
        this.myGitField.addBrowseFolderListener(GitBundle.getString("find.git.title"), GitBundle.getString("find.git.description"), project, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        this.myProjectGitPathCheckBox.addActionListener(e -> this.handleProjectOverrideStateChanged());
        if (!project.isDefault()) {
            GitRepositoryManager repositoryManager = GitRepositoryManager.getInstance(project);
            this.mySyncControl.setVisible(repositoryManager != null && repositoryManager.moreThanOneRoot());
        } else {
            this.mySyncControl.setVisible(true);
        }
        this.mySyncControl.setToolTipText(DvcsBundle.message((String)"sync.setting.description", (Object[])new Object[]{"Git"}));
        this.myProtectedBranchesLabel.setLabelFor((Component)this.myProtectedBranchesField);
    }

    private void testExecutable() {
        GitVersion version;
        final String executable = (String)ObjectUtils.notNull((Object)this.getCurrentExecutablePath(), (Object)this.myDetectedGitPath);
        try {
            version = (GitVersion)ProgressManager.getInstance().runProcessWithProgressSynchronously((ThrowableComputable)new ThrowableComputable<GitVersion, Exception>(){

                public GitVersion compute() throws Exception {
                    return GitVersion.identifyVersion(executable);
                }
            }, "Testing Git Executable...", true, this.myProject);
        }
        catch (ProcessCanceledException pce) {
            return;
        }
        catch (Exception e) {
            Messages.showErrorDialog((Component)this.myRootPanel, (String)e.getMessage(), (String)GitBundle.getString("find.git.error.title"));
            return;
        }
        if (version.isSupported()) {
            Messages.showInfoMessage((Component)this.myRootPanel, (String)String.format("<html>%s<br>Git version is %s</html>", GitBundle.getString("find.git.success.title"), version.getPresentation()), (String)GitBundle.getString("find.git.success.title"));
        } else {
            Messages.showWarningDialog((Component)this.myRootPanel, (String)GitBundle.message("find.git.unsupported.message", version.getPresentation(), GitVersion.MIN.getPresentation()), (String)GitBundle.getString("find.git.success.title"));
        }
    }

    private void handleProjectOverrideStateChanged() {
        if (!this.myProjectGitPathCheckBox.isSelected() && !Objects.equals(this.getCurrentExecutablePath(), this.myApplicationGitPath)) {
            switch (Messages.showYesNoCancelDialog((Component)this.myRootPanel, (String)VcsBundle.getString((String)"executable.project.override.reset.message"), (String)VcsBundle.getString((String)"executable.project.override.reset.title"), (String)VcsBundle.getString((String)"executable.project.override.reset.globalize"), (String)VcsBundle.getString((String)"executable.project.override.reset.revert"), (String)Messages.CANCEL_BUTTON, null)) {
                case 1: {
                    this.myGitField.setText(this.myApplicationGitPath);
                    break;
                }
                case 2: {
                    this.myProjectGitPathCheckBox.setSelected(true);
                }
            }
        }
    }

    @Nullable
    private String getCurrentExecutablePath() {
        return StringUtil.nullize((String)this.myGitField.getText().trim());
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myRootPanel;
        if (jComponent == null) {
            GitVcsPanel.$$$reportNull$$$0(1);
        }
        return jComponent;
    }

    public void reset(@NotNull GitVcsConfigurable.GitVcsSettingsHolder settings) {
        if (settings == null) {
            GitVcsPanel.$$$reportNull$$$0(2);
        }
        GitVcsApplicationSettings applicationSettings = settings.getApplicationSettings();
        GitVcsSettings projectSettings = settings.getProjectSettings();
        GitSharedSettings sharedSettings = settings.getSharedSettings();
        this.myApplicationGitPath = applicationSettings.getSavedPathToGit();
        String projectSettingsPathToGit = projectSettings.getPathToGit();
        this.myGitField.setText((String)ObjectUtils.coalesce((Object)projectSettingsPathToGit, (Object)this.myApplicationGitPath));
        this.myDetectedGitPath = GitExecutableManager.getInstance().getDetectedExecutable();
        ((JBTextField)this.myGitField.getTextField()).getEmptyText().setText("Auto-detected: " + this.myDetectedGitPath);
        this.myProjectGitPathCheckBox.setSelected(projectSettingsPathToGit != null);
        this.mySSHExecutableComboBox.setSelectedItem(projectSettings.isIdeaSsh() ? IDEA_SSH : NATIVE_SSH);
        this.myAutoUpdateIfPushRejected.setSelected(projectSettings.autoUpdateIfPushRejected());
        this.mySyncControl.setSelected(projectSettings.getSyncSetting() == DvcsSyncSettings.Value.SYNC);
        this.myAutoCommitOnCherryPick.setSelected(projectSettings.isAutoCommitOnCherryPick());
        this.myWarnAboutCrlf.setSelected(projectSettings.warnAboutCrlf());
        this.myWarnAboutDetachedHead.setSelected(projectSettings.warnAboutDetachedHead());
        this.myUpdateMethodComboBox.setSelectedItem((Object)projectSettings.getUpdateType());
        this.myProtectedBranchesField.setText((String)ParametersListUtil.COLON_LINE_JOINER.fun(sharedSettings.getForcePushProhibitedPatterns()));
    }

    public boolean isModified(@NotNull GitVcsConfigurable.GitVcsSettingsHolder settings) {
        if (settings == null) {
            GitVcsPanel.$$$reportNull$$$0(3);
        }
        GitVcsApplicationSettings applicationSettings = settings.getApplicationSettings();
        GitVcsSettings projectSettings = settings.getProjectSettings();
        GitSharedSettings sharedSettings = settings.getSharedSettings();
        return this.isGitPathModified(applicationSettings, projectSettings) || projectSettings.isIdeaSsh() != IDEA_SSH.equals(this.mySSHExecutableComboBox.getSelectedItem()) || !projectSettings.autoUpdateIfPushRejected() == this.myAutoUpdateIfPushRejected.isSelected() || projectSettings.getSyncSetting() == DvcsSyncSettings.Value.SYNC != this.mySyncControl.isSelected() || projectSettings.isAutoCommitOnCherryPick() != this.myAutoCommitOnCherryPick.isSelected() || projectSettings.warnAboutCrlf() != this.myWarnAboutCrlf.isSelected() || projectSettings.warnAboutDetachedHead() != this.myWarnAboutDetachedHead.isSelected() || projectSettings.getUpdateType() != this.myUpdateMethodComboBox.getModel().getSelectedItem() || !ContainerUtil.sorted(sharedSettings.getForcePushProhibitedPatterns()).equals(ContainerUtil.sorted(this.getProtectedBranchesPatterns()));
    }

    private boolean isGitPathModified(@NotNull GitVcsApplicationSettings applicationSettings, @NotNull GitVcsSettings projectSettings) {
        if (applicationSettings == null) {
            GitVcsPanel.$$$reportNull$$$0(4);
        }
        if (projectSettings == null) {
            GitVcsPanel.$$$reportNull$$$0(5);
        }
        return this.myProjectGitPathCheckBox.isSelected() ? !Objects.equals(this.getCurrentExecutablePath(), projectSettings.getPathToGit()) : !Objects.equals(this.getCurrentExecutablePath(), applicationSettings.getSavedPathToGit()) || projectSettings.getPathToGit() != null;
    }

    public void apply(@NotNull GitVcsConfigurable.GitVcsSettingsHolder settings) {
        if (settings == null) {
            GitVcsPanel.$$$reportNull$$$0(6);
        }
        GitVcsApplicationSettings applicationSettings = settings.getApplicationSettings();
        GitVcsSettings projectSettings = settings.getProjectSettings();
        GitSharedSettings sharedSettings = settings.getSharedSettings();
        if (this.myProjectGitPathCheckBox.isSelected()) {
            projectSettings.setPathToGit(this.getCurrentExecutablePath());
        } else {
            this.myApplicationGitPath = this.getCurrentExecutablePath();
            applicationSettings.setPathToGit(this.getCurrentExecutablePath());
            projectSettings.setPathToGit(null);
        }
        applicationSettings.setIdeaSsh(IDEA_SSH.equals(this.mySSHExecutableComboBox.getSelectedItem()) ? GitVcsApplicationSettings.SshExecutable.IDEA_SSH : GitVcsApplicationSettings.SshExecutable.NATIVE_SSH);
        projectSettings.setAutoUpdateIfPushRejected(this.myAutoUpdateIfPushRejected.isSelected());
        projectSettings.setSyncSetting(this.mySyncControl.isSelected() ? DvcsSyncSettings.Value.SYNC : DvcsSyncSettings.Value.DONT_SYNC);
        projectSettings.setAutoCommitOnCherryPick(this.myAutoCommitOnCherryPick.isSelected());
        projectSettings.setWarnAboutCrlf(this.myWarnAboutCrlf.isSelected());
        projectSettings.setWarnAboutDetachedHead(this.myWarnAboutDetachedHead.isSelected());
        projectSettings.setUpdateType((UpdateMethod)((Object)this.myUpdateMethodComboBox.getSelectedItem()));
        sharedSettings.setForcePushProhibitedPatters(this.getProtectedBranchesPatterns());
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> GitVcs.getInstance(this.myProject).checkVersion(), "Testing Git Executable...", true, null, this.myRootPanel);
    }

    @NotNull
    private List<String> getProtectedBranchesPatterns() {
        List list = (List)ParametersListUtil.COLON_LINE_PARSER.fun((Object)this.myProtectedBranchesField.getText());
        if (list == null) {
            GitVcsPanel.$$$reportNull$$$0(7);
        }
        return list;
    }

    private void createUIComponents() {
        this.myGitField = new TextFieldWithBrowseButton((JTextField)new JBTextField());
        this.myProtectedBranchesField = new ExpandableTextField(ParametersListUtil.COLON_LINE_PARSER, ParametersListUtil.COLON_LINE_JOINER);
        this.myUpdateMethodComboBox = new ComboBox((ComboBoxModel)new EnumComboBoxModel(UpdateMethod.class));
        this.myUpdateMethodComboBox.setRenderer(new ListCellRendererWrapper<UpdateMethod>(){

            public void customize(JList list, UpdateMethod value, int index, boolean selected, boolean hasFocus) {
                this.setText(StringUtil.capitalize((String)StringUtil.toLowerCase((String)value.name().replace('_', ' '))));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/config/GitVcsPanel";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/config/GitVcsPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtectedBranchesPatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isGitPathModified";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JCheckBox jCheckBox;
        JBCheckBox jBCheckBox;
        JCheckBox jCheckBox2;
        JBCheckBox jBCheckBox2;
        JCheckBox jCheckBox3;
        JBCheckBox jBCheckBox3;
        JButton jButton;
        JComboBox jComboBox;
        this.createUIComponents();
        JPanel jPanel = new JPanel();
        this.myRootPanel = jPanel;
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 7, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("git.vcs.config.path.label"));
        jLabel.setVerifyInputWhenFocusTarget(false);
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("git.vcs.config.ssh.mode"));
        jPanel2.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySSHExecutableComboBox = jComboBox = new JComboBox();
        jPanel3.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.myGitField;
        jPanel4.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        this.myTestButton = jButton = new JButton();
        jButton.setHorizontalAlignment(0);
        jButton.setLabel(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("git.vcs.config.test.label"));
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("git.vcs.config.test"));
        jPanel4.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 4, 0, 0, 2, null, null, null));
        this.myProjectGitPathCheckBox = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setEnabled(true);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, ResourceBundle.getBundle("com/intellij/dvcs/ui/DvcsBundle").getString("executable.path.project.override"));
        jPanel2.add((Component)jBCheckBox3, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(7, 8, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAutoCommitOnCherryPick = jCheckBox3 = new JCheckBox();
        jCheckBox3.setIconTextGap(4);
        jCheckBox3.setText("Commit automatically on cherry-pick");
        jPanel5.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 8, 8, 0, 3, 0, null, null, null));
        this.myWarnAboutCrlf = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Warn if CRLF line separators are about to be committed");
        jBCheckBox2.setMnemonic('C');
        jBCheckBox2.setDisplayedMnemonicIndex(8);
        jPanel5.add((Component)jBCheckBox2, new GridConstraints(2, 0, 1, 8, 8, 0, 0, 0, null, null, null));
        this.myWarnAboutDetachedHead = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(true);
        jCheckBox2.setText("Warn when committing in detached HEAD or during rebase");
        jPanel5.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 8, 8, 0, 3, 0, null, null, null));
        this.mySyncControl = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("com/intellij/dvcs/ui/DvcsBundle").getString("sync.setting"));
        jBCheckBox.setToolTipText("");
        jPanel5.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 8, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Update method:");
        jPanel5.add((Component)jBLabel2, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myAutoUpdateIfPushRejected = jCheckBox = new JCheckBox();
        jCheckBox.setIconTextGap(4);
        jCheckBox.setText("Auto-update if push of the current branch was rejected");
        jCheckBox.setMnemonic('P');
        jCheckBox.setDisplayedMnemonicIndex(15);
        jPanel5.add((Component)jCheckBox, new GridConstraints(5, 0, 1, 8, 8, 0, 3, 0, null, null, null));
        JComboBox jComboBox2 = this.myUpdateMethodComboBox;
        jPanel5.add((Component)jComboBox2, new GridConstraints(4, 1, 1, 1, 8, 1, 3, 0, null, null, null));
        JTextField jTextField = this.myProtectedBranchesField;
        jTextField.setText("");
        jPanel5.add((Component)jTextField, new GridConstraints(6, 1, 1, 6, 0, 1, 6, 0, null, null, null));
        this.myProtectedBranchesLabel = jBLabel = new JBLabel();
        jBLabel.setText("Protected branches:");
        jPanel5.add((Component)jBLabel, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        Spacer spacer3 = new Spacer();
        jPanel5.add((Component)spacer3, new GridConstraints(4, 2, 1, 6, 0, 1, 6, 1, null, null, null));
        jLabel2.setLabelFor(jComboBox);
        jBLabel2.setLabelFor(jComboBox2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

