/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogRecord;
import git4idea.history.GitLogUtil;
import git4idea.util.GitUIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

abstract class GitLogRecordCollector
implements Consumer<GitLogRecord> {
    private static final Logger LOG = Logger.getInstance(GitLogRecordCollector.class);
    private static final int STATUS_LINES_THRESHOLD = 20000;
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    private final MultiMap<String, GitLogRecord> myHashToRecord;
    @NotNull
    private final MultiMap<String, GitLogRecord> myHashToIncompleteRecords;
    private int myIncompleteStatusLinesCount;

    protected GitLogRecordCollector(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            GitLogRecordCollector.$$$reportNull$$$0(0);
        }
        if (root == null) {
            GitLogRecordCollector.$$$reportNull$$$0(1);
        }
        this.myHashToRecord = MultiMap.create();
        this.myHashToIncompleteRecords = MultiMap.create();
        this.myIncompleteStatusLinesCount = 0;
        this.myProject = project;
        this.myRoot = root;
    }

    public void consume(@NotNull GitLogRecord record) {
        String[] parents;
        if (record == null) {
            GitLogRecordCollector.$$$reportNull$$$0(2);
        }
        if ((parents = record.getParentsHashes()).length <= 1) {
            this.consume(Collections.singletonList(record));
        } else {
            this.myHashToRecord.putValue((Object)record.getHash(), (Object)record);
            if (parents.length == this.myHashToRecord.get((Object)record.getHash()).size()) {
                this.processCollectedRecords(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCollectedRecords(boolean processIncompleteRecords) {
        for (String hash : this.myHashToRecord.keySet()) {
            ArrayList records = ContainerUtil.newArrayList((Iterable)((Iterable)ObjectUtils.notNull((Object)this.myHashToRecord.get((Object)hash))));
            GitLogRecord firstRecord = (GitLogRecord)records.get(0);
            if (firstRecord.getParentsHashes().length != 0 && records.size() != firstRecord.getParentsHashes().length) {
                this.myHashToIncompleteRecords.put((Object)hash, (Collection)records);
                records.forEach(r -> this.myIncompleteStatusLinesCount += r.getStatusInfos().size());
                continue;
            }
            this.consume(records);
        }
        this.myHashToRecord.clear();
        if (!this.myHashToIncompleteRecords.isEmpty() && (processIncompleteRecords || this.myIncompleteStatusLinesCount >= 20000)) {
            try {
                Map<String, String> hashToTreeMap = this.getHashToTreeMap(ContainerUtil.map((Collection)this.myHashToIncompleteRecords.entrySet(), e -> (GitLogRecord)ContainerUtil.getFirstItem((Collection)((Collection)e.getValue()))));
                for (String hash : this.myHashToIncompleteRecords.keySet()) {
                    ArrayList records = ContainerUtil.newArrayList((Iterable)((Iterable)ObjectUtils.notNull((Object)this.myHashToIncompleteRecords.get((Object)hash))));
                    GitLogRecordCollector.fillWithEmptyRecords(records, hashToTreeMap);
                    this.consume(records);
                }
            }
            catch (VcsException e2) {
                LOG.error((Throwable)e2);
            }
            finally {
                this.myHashToIncompleteRecords.clear();
                this.myIncompleteStatusLinesCount = 0;
            }
        }
    }

    public void finish() {
        this.processCollectedRecords(true);
    }

    public abstract void consume(@NotNull List<GitLogRecord> var1);

    @NotNull
    private Map<String, String> getHashToTreeMap(@NotNull Collection<GitLogRecord> records) throws VcsException {
        if (records == null) {
            GitLogRecordCollector.$$$reportNull$$$0(3);
        }
        HashSet hashes2 = ContainerUtil.newHashSet();
        for (GitLogRecord r : records) {
            hashes2.add(r.getHash());
            ContainerUtil.addAll((Collection)hashes2, (Object[])r.getParentsHashes());
        }
        GitLineHandler handler = new GitLineHandler(this.myProject, this.myRoot, GitCommand.LOG);
        GitLogParser parser = new GitLogParser(this.myProject, GitLogParser.NameStatus.NONE, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.TREE);
        GitVcs vcs = GitVcs.getInstance(this.myProject);
        handler.setStdoutSuppressed(true);
        handler.addParameters(parser.getPretty());
        handler.addParameters(GitLogUtil.getNoWalkParameter(vcs));
        handler.addParameters("--stdin");
        handler.endOptions();
        GitLogUtil.sendHashesToStdin(vcs, hashes2, handler);
        String output = Git.getInstance().runCommand(handler).getOutputOrThrow();
        if (!handler.errors().isEmpty()) {
            throw new VcsException(GitUIUtil.stringifyErrors(handler.errors()));
        }
        List<GitLogRecord> hashAndTreeRecords = parser.parse(output);
        Map map = ContainerUtil.map2Map(hashAndTreeRecords, record -> Pair.create((Object)record.getHash(), (Object)record.getTreeHash()));
        if (map == null) {
            GitLogRecordCollector.$$$reportNull$$$0(4);
        }
        return map;
    }

    private static void fillWithEmptyRecords(@NotNull List<GitLogRecord> records, @NotNull Map<String, String> hashToTreeMap) {
        if (records == null) {
            GitLogRecordCollector.$$$reportNull$$$0(5);
        }
        if (hashToTreeMap == null) {
            GitLogRecordCollector.$$$reportNull$$$0(6);
        }
        GitLogRecord firstRecord = records.get(0);
        String commit2 = firstRecord.getHash();
        String[] parents = firstRecord.getParentsHashes();
        String commitTreeHash = hashToTreeMap.get(commit2);
        LOG.assertTrue(commitTreeHash != null, (Object)("Could not get tree hash for commit " + commit2));
        for (int parentIndex = 0; parentIndex < parents.length; ++parentIndex) {
            String parent = parents[parentIndex];
            String parentTreeHash = hashToTreeMap.get(parent);
            LOG.assertTrue(parentTreeHash != null, (Object)("Could not get tree hash for commit " + parent));
            if (!parentTreeHash.equals(commitTreeHash) || records.size() >= parents.length) continue;
            records.add(parentIndex, new GitLogRecord(firstRecord.getOptions(), ContainerUtil.emptyList(), firstRecord.isSupportsRawBody()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "record";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "records";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/history/GitLogRecordCollector";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashToTreeMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/history/GitLogRecordCollector";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHashToTreeMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "consume";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getHashToTreeMap";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fillWithEmptyRecords";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

