/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.util.containers.ContainerUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.push.GitPushNativeResult;
import git4idea.update.GitUpdateResult;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitPushRepoResult {
    static Comparator<Type> TYPE_COMPARATOR = (o1, o2) -> o1.ordinal() - o2.ordinal();
    @NotNull
    private final Type myType;
    private final int myCommits;
    @NotNull
    private final String mySourceBranch;
    @NotNull
    private final String myTargetBranch;
    @NotNull
    private final String myTargetRemote;
    @NotNull
    private final List<String> myPushedTags;
    @Nullable
    private final String myError;
    @Nullable
    private final GitUpdateResult myUpdateResult;

    @NotNull
    static GitPushRepoResult convertFromNative(@NotNull GitPushNativeResult result2, @NotNull List<GitPushNativeResult> tagResults, int commits2, @NotNull GitLocalBranch source, @NotNull GitRemoteBranch target) {
        if (result2 == null) {
            GitPushRepoResult.$$$reportNull$$$0(0);
        }
        if (tagResults == null) {
            GitPushRepoResult.$$$reportNull$$$0(1);
        }
        if (source == null) {
            GitPushRepoResult.$$$reportNull$$$0(2);
        }
        if (target == null) {
            GitPushRepoResult.$$$reportNull$$$0(3);
        }
        List tags = ContainerUtil.map(tagResults, result1 -> result1.getSourceRef());
        GitPushRepoResult gitPushRepoResult = new GitPushRepoResult(GitPushRepoResult.convertType(result2), commits2, source.getFullName(), target.getFullName(), target.getRemote().getName(), tags, null, null);
        if (gitPushRepoResult == null) {
            GitPushRepoResult.$$$reportNull$$$0(4);
        }
        return gitPushRepoResult;
    }

    @NotNull
    static GitPushRepoResult error(@NotNull GitLocalBranch source, @NotNull GitRemoteBranch target, @NotNull String error) {
        if (source == null) {
            GitPushRepoResult.$$$reportNull$$$0(5);
        }
        if (target == null) {
            GitPushRepoResult.$$$reportNull$$$0(6);
        }
        if (error == null) {
            GitPushRepoResult.$$$reportNull$$$0(7);
        }
        GitPushRepoResult gitPushRepoResult = new GitPushRepoResult(Type.ERROR, -1, source.getFullName(), target.getFullName(), target.getRemote().getName(), Collections.emptyList(), error, null);
        if (gitPushRepoResult == null) {
            GitPushRepoResult.$$$reportNull$$$0(8);
        }
        return gitPushRepoResult;
    }

    @NotNull
    static GitPushRepoResult notPushed(GitLocalBranch source, GitRemoteBranch target) {
        GitPushRepoResult gitPushRepoResult = new GitPushRepoResult(Type.NOT_PUSHED, -1, source.getFullName(), target.getFullName(), target.getRemote().getName(), Collections.emptyList(), null, null);
        if (gitPushRepoResult == null) {
            GitPushRepoResult.$$$reportNull$$$0(9);
        }
        return gitPushRepoResult;
    }

    @NotNull
    static GitPushRepoResult addUpdateResult(GitPushRepoResult original, GitUpdateResult updateResult) {
        GitPushRepoResult gitPushRepoResult = new GitPushRepoResult(original.getType(), original.getNumberOfPushedCommits(), original.getSourceBranch(), original.getTargetBranch(), original.getTargetRemote(), original.getPushedTags(), original.getError(), updateResult);
        if (gitPushRepoResult == null) {
            GitPushRepoResult.$$$reportNull$$$0(10);
        }
        return gitPushRepoResult;
    }

    private GitPushRepoResult(@NotNull Type type, int pushedCommits, @NotNull String sourceBranch, @NotNull String targetBranch, @NotNull String targetRemote, @NotNull List<String> pushedTags, @Nullable String error, @Nullable GitUpdateResult result2) {
        if (type == null) {
            GitPushRepoResult.$$$reportNull$$$0(11);
        }
        if (sourceBranch == null) {
            GitPushRepoResult.$$$reportNull$$$0(12);
        }
        if (targetBranch == null) {
            GitPushRepoResult.$$$reportNull$$$0(13);
        }
        if (targetRemote == null) {
            GitPushRepoResult.$$$reportNull$$$0(14);
        }
        if (pushedTags == null) {
            GitPushRepoResult.$$$reportNull$$$0(15);
        }
        this.myType = type;
        this.myCommits = pushedCommits;
        this.mySourceBranch = sourceBranch;
        this.myTargetBranch = targetBranch;
        this.myTargetRemote = targetRemote;
        this.myPushedTags = pushedTags;
        this.myError = error;
        this.myUpdateResult = result2;
    }

    @NotNull
    Type getType() {
        Type type = this.myType;
        if (type == null) {
            GitPushRepoResult.$$$reportNull$$$0(16);
        }
        return type;
    }

    @Nullable
    GitUpdateResult getUpdateResult() {
        return this.myUpdateResult;
    }

    int getNumberOfPushedCommits() {
        return this.myCommits;
    }

    @NotNull
    String getSourceBranch() {
        String string = this.mySourceBranch;
        if (string == null) {
            GitPushRepoResult.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    String getTargetBranch() {
        String string = this.myTargetBranch;
        if (string == null) {
            GitPushRepoResult.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Nullable
    String getError() {
        return this.myError;
    }

    @NotNull
    List<String> getPushedTags() {
        List<String> list = this.myPushedTags;
        if (list == null) {
            GitPushRepoResult.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    public String getTargetRemote() {
        String string = this.myTargetRemote;
        if (string == null) {
            GitPushRepoResult.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    private static Type convertType(@NotNull GitPushNativeResult nativeResult) {
        if (nativeResult == null) {
            GitPushRepoResult.$$$reportNull$$$0(21);
        }
        switch (nativeResult.getType()) {
            case SUCCESS: {
                Type type = Type.SUCCESS;
                if (type == null) {
                    GitPushRepoResult.$$$reportNull$$$0(22);
                }
                return type;
            }
            case FORCED_UPDATE: {
                Type type = Type.FORCED;
                if (type == null) {
                    GitPushRepoResult.$$$reportNull$$$0(23);
                }
                return type;
            }
            case NEW_REF: {
                Type type = Type.NEW_BRANCH;
                if (type == null) {
                    GitPushRepoResult.$$$reportNull$$$0(24);
                }
                return type;
            }
            case REJECTED: {
                Type type = nativeResult.isNonFFUpdate() ? Type.REJECTED_NO_FF : Type.REJECTED_OTHER;
                if (type == null) {
                    GitPushRepoResult.$$$reportNull$$$0(25);
                }
                return type;
            }
            case UP_TO_DATE: {
                Type type = Type.UP_TO_DATE;
                if (type == null) {
                    GitPushRepoResult.$$$reportNull$$$0(26);
                }
                return type;
            }
            case ERROR: {
                Type type = Type.ERROR;
                if (type == null) {
                    GitPushRepoResult.$$$reportNull$$$0(27);
                }
                return type;
            }
        }
        throw new IllegalArgumentException("Conversion is not supported: " + (Object)((Object)nativeResult.getType()));
    }

    public String toString() {
        return String.format("%s (%d, '%s'), update: %s}", new Object[]{this.myType, this.myCommits, this.mySourceBranch, this.myUpdateResult});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagResults";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/push/GitPushRepoResult";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceBranch";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetBranch";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRemote";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushedTags";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/push/GitPushRepoResult";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "convertFromNative";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "error";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "notPushed";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "addUpdateResult";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceBranch";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetBranch";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPushedTags";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetRemote";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "convertType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertFromNative";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "convertType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum Type {
        SUCCESS,
        NEW_BRANCH,
        UP_TO_DATE,
        FORCED,
        REJECTED_NO_FF,
        REJECTED_OTHER,
        ERROR,
        NOT_PUSHED;

    }
}

