/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitRebaseParams;
import git4idea.checkin.GitCheckinEnvironment;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitLogUtil;
import git4idea.rebase.GitAutomaticRebaseEditor;
import git4idea.rebase.GitRebaseEntry;
import git4idea.rebase.GitRebaseProcess;
import git4idea.rebase.GitRebaseSpec;
import git4idea.rebase.GitRebaseUtils;
import git4idea.rebase.GitRebaseUtilsKt;
import git4idea.rebase.GitRewordOperation;
import git4idea.rebase.GitSuccessfulRebase;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.reset.GitResetMode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001:\u0002*+B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\u0019J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001c\u001a\u00020\u0007H\u0002J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J\b\u0010!\u001a\u00020\u0015H\u0002J\b\u0010\"\u001a\u00020\u0019H\u0002J\b\u0010#\u001a\u00020\u0015H\u0002J\b\u0010$\u001a\u00020\u0015H\u0002J\u0010\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u0007H\u0002J\r\u0010'\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b(J\b\u0010)\u001a\u00020\u0019H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lgit4idea/rebase/GitRewordOperation;", "", "repository", "Lgit4idea/repo/GitRepository;", "commit", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "newMessage", "", "(Lgit4idea/repo/GitRepository;Lcom/intellij/vcs/log/VcsCommitMetadata;Ljava/lang/String;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "headAfterReword", "initialHeadPosition", "notifier", "Lcom/intellij/openapi/vcs/VcsNotifier;", "kotlin.jvm.PlatformType", "project", "Lcom/intellij/openapi/project/Project;", "rewordedCommit", "Lcom/intellij/vcs/log/Hash;", "canRewordViaAmend", "", "checkUndoPossibility", "Lgit4idea/rebase/GitRewordOperation$UndoPossibility;", "doUndo", "", "execute", "findNewHashOfRewordedCommit", "newHead", "injectRewordAction", "", "Lgit4idea/rebase/GitRebaseEntry;", "list", "isLatestCommit", "notifySuccess", "rewordViaAmend", "rewordViaRebase", "supplyNewMessage", "editorText", "undo", "undo$git4idea", "undoInBackground", "RewordProcess", "UndoPossibility", "git4idea"})
public final class GitRewordOperation {
    private final Logger LOG;
    private final Project project;
    private final VcsNotifier notifier;
    private final String initialHeadPosition;
    private String headAfterReword;
    private Hash rewordedCommit;
    private final GitRepository repository;
    private final VcsCommitMetadata commit;
    private final String newMessage;

    public final void execute() {
        boolean reworded = false;
        if (this.canRewordViaAmend()) {
            reworded = this.rewordViaAmend();
        }
        if (!reworded) {
            reworded = this.rewordViaRebase();
        }
        if (reworded) {
            String string = this.headAfterReword = this.repository.getCurrentRevision();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            this.rewordedCommit = this.findNewHashOfRewordedCommit(string);
        }
    }

    private final boolean canRewordViaAmend() {
        return this.isLatestCommit() && GitVersionSpecialty.CAN_AMEND_WITHOUT_FILES.existsIn(GitVcs.getInstance(this.project).getVersion());
    }

    private final boolean isLatestCommit() {
        return Intrinsics.areEqual((Object)((Hash)this.commit.getId()).asString(), (Object)this.initialHeadPosition);
    }

    private final boolean rewordViaRebase() {
        GitRebaseSpec spec;
        Project project = this.project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        VirtualFile virtualFile = this.commit.getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"commit.root");
        GitAutomaticRebaseEditor rebaseEditor2 = new GitAutomaticRebaseEditor(project, virtualFile, (Function1<? super List<? extends GitRebaseEntry>, ? extends List<? extends GitRebaseEntry>>)((Function1)new Function1<List<? extends GitRebaseEntry>, List<? extends GitRebaseEntry>>(this){
            final /* synthetic */ GitRewordOperation this$0;

            @NotNull
            public final List<GitRebaseEntry> invoke(@NotNull List<? extends GitRebaseEntry> list) {
                Intrinsics.checkParameterIsNotNull(list, (String)"list");
                return GitRewordOperation.access$injectRewordAction(this.this$0, list);
            }
            {
                this.this$0 = gitRewordOperation;
                super(1);
            }
        }), (Function1<? super String, String>)((Function1)new Function1<String, String>(this){
            final /* synthetic */ GitRewordOperation this$0;

            @NotNull
            public final String invoke(@NotNull String editorText) {
                Intrinsics.checkParameterIsNotNull((Object)editorText, (String)"editorText");
                return GitRewordOperation.access$supplyNewMessage(this.this$0, editorText);
            }
            {
                this.this$0 = gitRewordOperation;
                super(1);
            }
        }));
        GitRebaseParams params = GitRebaseParams.editCommits(((Hash)CollectionsKt.first((List)this.commit.getParents())).asString(), rebaseEditor2, true);
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator == null) {
            progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
        }
        ProgressIndicator indicator = progressIndicator;
        GitRebaseSpec gitRebaseSpec = spec = GitRebaseSpec.forNewRebase(this.project, params, CollectionsKt.listOf((Object)this.repository), indicator);
        Intrinsics.checkExpressionValueIsNotNull((Object)gitRebaseSpec, (String)"spec");
        RewordProcess rewordProcess = new RewordProcess(gitRebaseSpec);
        rewordProcess.rebase();
        return rewordProcess.getSucceeded();
    }

    private final boolean rewordViaAmend() {
        File messageFile;
        GitLineHandler handler = new GitLineHandler(this.project, this.repository.getRoot(), GitCommand.COMMIT);
        try {
            File file = GitCheckinEnvironment.createCommitMessageFile(this.project, this.repository.getRoot(), this.newMessage);
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"GitCheckinEnvironment.cr\u2026ository.root, newMessage)");
            messageFile = file;
        }
        catch (IOException e) {
            this.LOG.warn("Couldn't create message file", (Throwable)e);
            return false;
        }
        handler.addParameters("--amend");
        handler.addParameters("-F", messageFile.getAbsolutePath());
        handler.addParameters("--only");
        GitCommandResult result2 = Git.getInstance().runCommand(handler);
        this.repository.update();
        if (result2.success()) {
            this.notifySuccess();
            return true;
        }
        this.LOG.warn("Couldn't reword via amend: " + result2.getErrorOutputAsJoinedString());
        return false;
    }

    public final void undo$git4idea() {
        Project project = this.project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        UndoPossibility possibility = this.checkUndoPossibility(project);
        String errorTitle = "Can't Undo Reword";
        UndoPossibility undoPossibility = possibility;
        if (undoPossibility instanceof UndoPossibility.HeadMoved) {
            Intrinsics.checkExpressionValueIsNotNull((Object)this.notifier.notifyError(errorTitle, "Repository has already been changed"), (String)"notifier.notifyError(err\u2026as already been changed\")");
        } else if (undoPossibility instanceof UndoPossibility.PushedToProtectedBranch) {
            Intrinsics.checkExpressionValueIsNotNull((Object)this.notifier.notifyError(errorTitle, "Commit has already been pushed to " + ((UndoPossibility.PushedToProtectedBranch)possibility).getBranch()), (String)"notifier.notifyError(err\u2026o ${possibility.branch}\")");
        } else if (undoPossibility instanceof UndoPossibility.Error) {
            Intrinsics.checkExpressionValueIsNotNull((Object)this.notifier.notifyError(errorTitle, ""), (String)"notifier.notifyError(errorTitle, \"\")");
        } else {
            this.doUndo();
        }
    }

    private final void doUndo() {
        GitCommandResult res = Git.getInstance().reset(this.repository, GitResetMode.KEEP, this.initialHeadPosition, new GitLineHandlerListener[0]);
        this.repository.update();
        if (!res.success()) {
            this.notifier.notifyError("Undo Reword Failed", res.getErrorOutputAsHtmlString());
        }
    }

    /*
     * Unable to fully structure code
     */
    private final List<GitRebaseEntry> injectRewordAction(List<? extends GitRebaseEntry> list) {
        var3_3 = $receiver$iv = (Iterable)list;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (T item$iv$iv : $receiver$iv$iv) {
            var7_7 = (GitRebaseEntry)item$iv$iv;
            var11_8 = destination$iv$iv;
            if (!Intrinsics.areEqual((Object)entry.getAction(), (Object)GitRebaseEntry.Action.pick)) ** GOTO lbl-1000
            v0 = ((Hash)this.commit.getId()).asString();
            v1 = entry.getCommit();
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"entry.commit");
            if (StringsKt.startsWith$default((String)v0, (String)v1, (boolean)false, (int)2, null)) {
                v2 = new GitRebaseEntry(GitRebaseEntry.Action.reword, entry.getCommit(), entry.getSubject());
            } else lbl-1000:
            // 2 sources

            {
                v2 = entry;
            }
            var12_9 = v2;
            var11_8.add(var12_9);
        }
        return (List)destination$iv$iv;
    }

    private final String supplyNewMessage(String editorText) {
        String string = this.commit.getFullMessage();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"commit.fullMessage");
        if (StringsKt.startsWith$default((String)editorText, (String)string, (boolean)false, (int)2, null)) {
            return this.newMessage;
        }
        this.LOG.error("Unexpected editor content. Charset: " + GitConfigUtil.getCommitEncoding(this.project, this.commit.getRoot()), new Attachment[]{new Attachment("actual.txt", editorText), new Attachment("expected.txt", this.commit.getFullMessage())});
        throw (Throwable)new IllegalStateException("Unexpected editor content");
    }

    private final Hash findNewHashOfRewordedCommit(String newHead) {
        String newCommitsRange = "" + ((Hash)CollectionsKt.first((List)this.commit.getParents())).asString() + ".." + newHead;
        List newCommits = GitLogUtil.collectMetadata(this.project, this.repository.getRoot(), newCommitsRange).getCommits();
        if (newCommits.isEmpty()) {
            this.LOG.error("Couldn't find commits after reword in range " + newCommitsRange);
            return null;
        }
        VcsCommitMetadata newCommit = (VcsCommitMetadata)CollectionsKt.last((List)newCommits);
        if (!StringUtil.equalsIgnoreWhitespaces((CharSequence)newCommit.getFullMessage(), (CharSequence)this.newMessage)) {
            this.LOG.error("Couldn't find the reworded commit. Expected message: \n[" + this.newMessage + "]\nActual message: \n[" + newCommit.getFullMessage() + ']');
            return null;
        }
        return (Hash)newCommit.getId();
    }

    private final UndoPossibility checkUndoPossibility(Project project) {
        Collection<String> containingBranches;
        this.repository.update();
        if (Intrinsics.areEqual((Object)this.repository.getCurrentRevision(), (Object)this.headAfterReword) ^ true) {
            return UndoPossibility.HeadMoved.INSTANCE;
        }
        if (this.rewordedCommit == null) {
            this.LOG.error("Couldn't find the reworded commit");
            return UndoPossibility.Error.INSTANCE;
        }
        VirtualFile virtualFile = this.repository.getRoot();
        Hash hash = this.rewordedCommit;
        if (hash == null) {
            Intrinsics.throwNpe();
        }
        Collection<String> collection = containingBranches = GitBranchUtil.getBranches(project, virtualFile, false, true, hash.asString());
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"containingBranches");
        String protectedBranch = GitRebaseUtilsKt.findProtectedRemoteBranch(this.repository, collection);
        if (protectedBranch != null) {
            return new UndoPossibility.PushedToProtectedBranch(protectedBranch);
        }
        return UndoPossibility.Possible.INSTANCE;
    }

    private final void notifySuccess() {
        Notification notification = VcsNotifier.STANDARD_NOTIFICATION.createNotification("Reworded Successfully", "", NotificationType.INFORMATION, null);
        notification.addAction((AnAction)NotificationAction.createSimple((String)"Undo", (Runnable)new Runnable(this, notification){
            final /* synthetic */ GitRewordOperation this$0;
            final /* synthetic */ Notification $notification;

            public final void run() {
                this.$notification.expire();
                GitRewordOperation.access$undoInBackground(this.this$0);
            }
            {
                this.this$0 = gitRewordOperation;
                this.$notification = notification;
            }
        }));
        MessageBusConnection connection = this.project.getMessageBus().connect();
        notification.whenExpired(new Runnable(connection){
            final /* synthetic */ MessageBusConnection $connection;

            public final void run() {
                this.$connection.disconnect();
            }
            {
                this.$connection = messageBusConnection;
            }
        });
        connection.subscribe(GitRepository.GIT_REPO_CHANGE, (Object)new GitRepositoryChangeListener(this, notification){
            final /* synthetic */ GitRewordOperation this$0;
            final /* synthetic */ Notification $notification;

            public final void repositoryChanged(@NotNull GitRepository it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                BackgroundTaskUtil.executeOnPooledThread((Disposable)((Disposable)GitRewordOperation.access$getRepository$p(this.this$0)), (Runnable)new Runnable(this){
                    final /* synthetic */ notifySuccess.3 this$0;

                    public final void run() {
                        GitRewordOperation gitRewordOperation = this.this$0.this$0;
                        Project project = GitRewordOperation.access$getProject$p(this.this$0.this$0);
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                        if (!(GitRewordOperation.access$checkUndoPossibility(gitRewordOperation, project) instanceof UndoPossibility.Possible)) {
                            this.this$0.$notification.expire();
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = gitRewordOperation;
                this.$notification = notification;
            }
        });
        this.notifier.notify(notification);
    }

    private final void undoInBackground() {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, this.project, "Undoing Reword"){
            final /* synthetic */ GitRewordOperation this$0;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                this.this$0.undo$git4idea();
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2);
            }
        });
    }

    public GitRewordOperation(@NotNull GitRepository repository, @NotNull VcsCommitMetadata commit2, @NotNull String newMessage) {
        Logger logger;
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Intrinsics.checkParameterIsNotNull((Object)commit2, (String)"commit");
        Intrinsics.checkParameterIsNotNull((Object)newMessage, (String)"newMessage");
        this.repository = repository;
        this.commit = commit2;
        this.newMessage = newMessage;
        this.repository.update();
        GitRewordOperation gitRewordOperation = this;
        Logger logger2 = Logger.getInstance(GitRewordOperation.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        gitRewordOperation.LOG = logger = logger2;
        this.project = this.repository.getProject();
        this.notifier = VcsNotifier.getInstance((Project)this.project);
        String string = this.repository.getCurrentRevision();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        this.initialHeadPosition = string;
    }

    @NotNull
    public static final /* synthetic */ List access$injectRewordAction(GitRewordOperation $this, @NotNull List list) {
        return $this.injectRewordAction(list);
    }

    @NotNull
    public static final /* synthetic */ String access$supplyNewMessage(GitRewordOperation $this, @NotNull String editorText) {
        return $this.supplyNewMessage(editorText);
    }

    public static final /* synthetic */ void access$undoInBackground(GitRewordOperation $this) {
        $this.undoInBackground();
    }

    @NotNull
    public static final /* synthetic */ GitRepository access$getRepository$p(GitRewordOperation $this) {
        return $this.repository;
    }

    @NotNull
    public static final /* synthetic */ UndoPossibility access$checkUndoPossibility(GitRewordOperation $this, @NotNull Project project) {
        return $this.checkUndoPossibility(project);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0004\u0007\b\t\n\u00a8\u0006\u000b"}, d2={"Lgit4idea/rebase/GitRewordOperation$UndoPossibility;", "", "()V", "Error", "HeadMoved", "Possible", "PushedToProtectedBranch", "Lgit4idea/rebase/GitRewordOperation$UndoPossibility$Possible;", "Lgit4idea/rebase/GitRewordOperation$UndoPossibility$HeadMoved;", "Lgit4idea/rebase/GitRewordOperation$UndoPossibility$PushedToProtectedBranch;", "Lgit4idea/rebase/GitRewordOperation$UndoPossibility$Error;", "git4idea"})
    private static abstract class UndoPossibility {
        private UndoPossibility() {
        }

        public /* synthetic */ UndoPossibility(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lgit4idea/rebase/GitRewordOperation$UndoPossibility$Possible;", "Lgit4idea/rebase/GitRewordOperation$UndoPossibility;", "()V", "git4idea"})
        public static final class Possible
        extends UndoPossibility {
            public static final Possible INSTANCE;

            private Possible() {
                super(null);
            }

            static {
                Possible possible;
                INSTANCE = possible = new Possible();
            }
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lgit4idea/rebase/GitRewordOperation$UndoPossibility$HeadMoved;", "Lgit4idea/rebase/GitRewordOperation$UndoPossibility;", "()V", "git4idea"})
        public static final class HeadMoved
        extends UndoPossibility {
            public static final HeadMoved INSTANCE;

            private HeadMoved() {
                super(null);
            }

            static {
                HeadMoved headMoved;
                INSTANCE = headMoved = new HeadMoved();
            }
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/rebase/GitRewordOperation$UndoPossibility$PushedToProtectedBranch;", "Lgit4idea/rebase/GitRewordOperation$UndoPossibility;", "branch", "", "(Ljava/lang/String;)V", "getBranch", "()Ljava/lang/String;", "git4idea"})
        public static final class PushedToProtectedBranch
        extends UndoPossibility {
            @NotNull
            private final String branch;

            @NotNull
            public final String getBranch() {
                return this.branch;
            }

            public PushedToProtectedBranch(@NotNull String branch) {
                Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
                super(null);
                this.branch = branch;
            }
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lgit4idea/rebase/GitRewordOperation$UndoPossibility$Error;", "Lgit4idea/rebase/GitRewordOperation$UndoPossibility;", "()V", "git4idea"})
        public static final class Error
        extends UndoPossibility {
            public static final Error INSTANCE;

            private Error() {
                super(null);
            }

            static {
                Error error;
                INSTANCE = error = new Error();
            }
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00130\u0012H\u0014J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0014R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lgit4idea/rebase/GitRewordOperation$RewordProcess;", "Lgit4idea/rebase/GitRebaseProcess;", "spec", "Lgit4idea/rebase/GitRebaseSpec;", "(Lgit4idea/rebase/GitRewordOperation;Lgit4idea/rebase/GitRebaseSpec;)V", "succeeded", "", "getSucceeded", "()Z", "setSucceeded", "(Z)V", "notifySuccess", "", "successful", "", "Lgit4idea/repo/GitRepository;", "Lgit4idea/rebase/GitSuccessfulRebase;", "skippedCommits", "Lcom/intellij/util/containers/MultiMap;", "Lgit4idea/rebase/GitRebaseUtils$CommitInfo;", "shouldRefreshOnSuccess", "successType", "Lgit4idea/rebase/GitSuccessfulRebase$SuccessType;", "git4idea"})
    private final class RewordProcess
    extends GitRebaseProcess {
        private boolean succeeded;

        public final boolean getSucceeded() {
            return this.succeeded;
        }

        public final void setSucceeded(boolean bl) {
            this.succeeded = bl;
        }

        @Override
        protected void notifySuccess(@NotNull Map<GitRepository, GitSuccessfulRebase> successful, @NotNull MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
            Intrinsics.checkParameterIsNotNull(successful, (String)"successful");
            Intrinsics.checkParameterIsNotNull(skippedCommits, (String)"skippedCommits");
            GitRewordOperation.this.notifySuccess();
            this.succeeded = true;
        }

        @Override
        protected boolean shouldRefreshOnSuccess(@NotNull GitSuccessfulRebase.SuccessType successType) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)successType), (String)"successType");
            return false;
        }

        public RewordProcess(GitRebaseSpec spec) {
            Intrinsics.checkParameterIsNotNull((Object)spec, (String)"spec");
            super(GitRewordOperation.this.project, spec, null);
        }
    }
}

