/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitBinaryHandler;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitFileUtils {
    private static final Logger LOG = Logger.getInstance(GitFileUtils.class);

    private GitFileUtils() {
    }

    public static void delete(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<FilePath> files, String ... additionalOptions) throws VcsException {
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(0);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(1);
        }
        if (files == null) {
            GitFileUtils.$$$reportNull$$$0(2);
        }
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)root, files)) {
            GitFileUtils.doDelete(project, root, paths, additionalOptions);
        }
    }

    public static void deleteFiles(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<VirtualFile> files, String ... additionalOptions) throws VcsException {
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(3);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(4);
        }
        if (files == null) {
            GitFileUtils.$$$reportNull$$$0(5);
        }
        for (List paths : VcsFileUtil.chunkFiles((VirtualFile)root, files)) {
            GitFileUtils.doDelete(project, root, paths, additionalOptions);
        }
    }

    public static void deleteFiles(@NotNull Project project, @NotNull VirtualFile root, VirtualFile ... files) throws VcsException {
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(6);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(7);
        }
        GitFileUtils.deleteFiles(project, root, Arrays.asList(files), new String[0]);
    }

    private static void doDelete(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> paths, String ... additionalOptions) throws VcsException {
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(8);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(9);
        }
        if (paths == null) {
            GitFileUtils.$$$reportNull$$$0(10);
        }
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.RM);
        handler.addParameters(additionalOptions);
        handler.endOptions();
        handler.addParameters(paths);
        Git.getInstance().runCommand(handler).getOutputOrThrow();
    }

    public static void deleteFilesFromCache(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<VirtualFile> files) throws VcsException {
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(11);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(12);
        }
        if (files == null) {
            GitFileUtils.$$$reportNull$$$0(13);
        }
        GitFileUtils.deleteFiles(project, root, files, "--cached");
        GitFileUtils.updateUntrackedFilesHolderOnFileRemove(project, root, files);
    }

    public static void addFiles(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<VirtualFile> files) throws VcsException {
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(14);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(15);
        }
        if (files == null) {
            GitFileUtils.$$$reportNull$$$0(16);
        }
        GitFileUtils.addPaths(project, root, VcsFileUtil.chunkFiles((VirtualFile)root, files));
        GitFileUtils.updateUntrackedFilesHolderOnFileAdd(project, root, files);
    }

    private static void updateUntrackedFilesHolderOnFileAdd(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<VirtualFile> addedFiles) {
        GitRepository repository;
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(17);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(18);
        }
        if (addedFiles == null) {
            GitFileUtils.$$$reportNull$$$0(19);
        }
        if ((repository = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root)) == null) {
            LOG.error("Repository not found for root " + root.getPresentableUrl());
            return;
        }
        repository.getUntrackedFilesHolder().remove(addedFiles);
    }

    private static void updateUntrackedFilesHolderOnFileRemove(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<VirtualFile> removedFiles) {
        GitRepository repository;
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(20);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(21);
        }
        if (removedFiles == null) {
            GitFileUtils.$$$reportNull$$$0(22);
        }
        if ((repository = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root)) == null) {
            LOG.error("Repository not found for root " + root.getPresentableUrl());
            return;
        }
        repository.getUntrackedFilesHolder().add(removedFiles);
    }

    public static void addFiles(Project project, VirtualFile root, VirtualFile ... files) throws VcsException {
        GitFileUtils.addFiles(project, root, Arrays.asList(files));
    }

    public static void addPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<FilePath> files) throws VcsException {
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(23);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(24);
        }
        if (files == null) {
            GitFileUtils.$$$reportNull$$$0(25);
        }
        GitFileUtils.addPaths(project, root, VcsFileUtil.chunkPaths((VirtualFile)root, files));
        GitFileUtils.updateUntrackedFilesHolderOnFileAdd(project, root, GitFileUtils.getVirtualFilesFromFilePaths(files));
    }

    @NotNull
    private static Collection<VirtualFile> getVirtualFilesFromFilePaths(@NotNull Collection<FilePath> paths) {
        if (paths == null) {
            GitFileUtils.$$$reportNull$$$0(26);
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(paths.size());
        for (FilePath path : paths) {
            VirtualFile file = path.getVirtualFile();
            if (file == null) continue;
            files.add(file);
        }
        ArrayList<VirtualFile> arrayList = files;
        if (arrayList == null) {
            GitFileUtils.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    private static void addPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<List<String>> chunkedPaths) throws VcsException {
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(28);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(29);
        }
        if (chunkedPaths == null) {
            GitFileUtils.$$$reportNull$$$0(30);
        }
        for (List<String> paths : chunkedPaths) {
            if ((paths = GitFileUtils.excludeIgnoredFiles(project, root, paths)).isEmpty()) continue;
            GitLineHandler handler = new GitLineHandler(project, root, GitCommand.ADD);
            handler.addParameters("--ignore-errors");
            handler.endOptions();
            handler.addParameters(paths);
            Git.getInstance().runCommand(handler).getOutputOrThrow();
        }
    }

    @NotNull
    private static List<String> excludeIgnoredFiles(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> paths) throws VcsException {
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(31);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(32);
        }
        if (paths == null) {
            GitFileUtils.$$$reportNull$$$0(33);
        }
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.LS_FILES);
        handler.setSilent(true);
        handler.addParameters("--ignored", "--others", "--exclude-standard");
        handler.endOptions();
        handler.addParameters(paths);
        String output = Git.getInstance().runCommand(handler).getOutputOrThrow();
        ArrayList<String> nonIgnoredFiles = new ArrayList<String>(paths.size());
        HashSet<String> ignoredPaths = new HashSet<String>(Arrays.asList(StringUtil.splitByLines((String)output)));
        for (String pathToCheck : paths) {
            if (ignoredPaths.contains(pathToCheck)) continue;
            nonIgnoredFiles.add(pathToCheck);
        }
        ArrayList<String> arrayList = nonIgnoredFiles;
        if (arrayList == null) {
            GitFileUtils.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    public static byte[] getFileContent(Project project, VirtualFile root, String revisionOrBranch, String relativePath) throws VcsException {
        GitBinaryHandler h = new GitBinaryHandler(project, root, GitCommand.SHOW);
        h.setSilent(true);
        h.addParameters(revisionOrBranch + ":" + relativePath);
        h.endOptions();
        return h.run();
    }

    public static String stripFileProtocolPrefix(String path) {
        String FILE_PROTOCOL = "file://";
        if (path.startsWith("file://")) {
            return path.substring("file://".length());
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 27: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 27: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 21: 
            case 24: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 5: 
            case 13: 
            case 16: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 10: 
            case 26: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedFiles";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removedFiles";
                break;
            }
            case 27: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/util/GitFileUtils";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunkedPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/util/GitFileUtils";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFilesFromFilePaths";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "excludeIgnoredFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deleteFiles";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doDelete";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "deleteFilesFromCache";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addFiles";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "updateUntrackedFilesHolderOnFileAdd";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "updateUntrackedFilesHolderOnFileRemove";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addPaths";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFilesFromFilePaths";
                break;
            }
            case 27: 
            case 34: {
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "excludeIgnoredFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 27: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

