/*
 * Decompiled with CFR 0.152.
 */
package git4idea.vfs;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsVFSListener;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.util.GitFileUtils;
import git4idea.util.GitVcsConsoleWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class GitVFSListener
extends VcsVFSListener {
    private final AtomicInteger myEventsSuppressLevel;
    private final Git myGit;
    private final GitVcsConsoleWriter myVcsConsoleWriter;

    public GitVFSListener(@NotNull Project project, @NotNull GitVcs vcs, @NotNull Git git, @NotNull GitVcsConsoleWriter vcsConsoleWriter) {
        if (project == null) {
            GitVFSListener.$$$reportNull$$$0(0);
        }
        if (vcs == null) {
            GitVFSListener.$$$reportNull$$$0(1);
        }
        if (git == null) {
            GitVFSListener.$$$reportNull$$$0(2);
        }
        if (vcsConsoleWriter == null) {
            GitVFSListener.$$$reportNull$$$0(3);
        }
        super(project, (AbstractVcs)vcs);
        this.myEventsSuppressLevel = new AtomicInteger(0);
        this.myGit = git;
        this.myVcsConsoleWriter = vcsConsoleWriter;
    }

    public void setEventsSuppressed(boolean value) {
        if (value) {
            this.myEventsSuppressLevel.incrementAndGet();
        } else {
            int v = this.myEventsSuppressLevel.decrementAndGet();
            assert (v >= 0);
        }
    }

    protected boolean isEventIgnored(VirtualFileEvent event, boolean putInDirty) {
        return super.isEventIgnored(event, putInDirty) || this.myEventsSuppressLevel.get() != 0;
    }

    protected String getAddTitle() {
        return GitBundle.getString("vfs.listener.add.title");
    }

    protected String getSingleFileAddTitle() {
        return GitBundle.getString("vfs.listener.add.single.title");
    }

    protected String getSingleFileAddPromptTemplate() {
        return GitBundle.getString("vfs.listener.add.single.prompt");
    }

    protected void executeAdd(final List<VirtualFile> addedFiles, final Map<VirtualFile, VirtualFile> copiedFiles) {
        Map<VirtualFile, List<VirtualFile>> sortedFiles;
        try {
            sortedFiles = GitUtil.sortFilesByGitRoot(addedFiles, true);
        }
        catch (VcsException e) {
            throw new RuntimeException("The exception is not expected here", e);
        }
        final HashSet retainedFiles = new HashSet();
        ProgressManager progressManager = ProgressManager.getInstance();
        progressManager.run((Task)new Task.Backgroundable(this.myProject, GitBundle.getString("vfs.listener.checking.ignored"), true){

            public void run(@NotNull ProgressIndicator pi) {
                if (pi == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (Map.Entry e : sortedFiles.entrySet()) {
                    VirtualFile root = (VirtualFile)e.getKey();
                    List files = (List)e.getValue();
                    pi.setText(root.getPresentableUrl());
                    try {
                        retainedFiles.addAll(GitVFSListener.this.myGit.untrackedFiles(this.myProject, root, files));
                    }
                    catch (VcsException ex) {
                        GitVFSListener.this.myVcsConsoleWriter.showMessage(ex.getMessage());
                    }
                }
                addedFiles.retainAll(retainedFiles);
                AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, () -> GitVFSListener.this.originalExecuteAdd(addedFiles, copiedFiles));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "git4idea/vfs/GitVFSListener$1", "run"));
            }
        });
    }

    private void originalExecuteAdd(List<VirtualFile> addedFiles, Map<VirtualFile, VirtualFile> copiedFiles) {
        super.executeAdd(addedFiles, copiedFiles);
    }

    protected void performAdding(Collection<VirtualFile> addedFiles, Map<VirtualFile, VirtualFile> copyFromMap) {
        this.performAdding(ObjectsConvertor.vf2fp(new ArrayList<VirtualFile>(addedFiles)));
    }

    private GitVcs gitVcs() {
        return (GitVcs)this.myVcs;
    }

    private void performAdding(Collection<FilePath> filesToAdd) {
        this.performBackgroundOperation(filesToAdd, GitBundle.getString("add.adding"), new LongOperationPerRootExecutor(){

            @Override
            public void execute(@NotNull VirtualFile root, @NotNull List<FilePath> files) throws VcsException {
                if (root == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (files == null) {
                    2.$$$reportNull$$$0(1);
                }
                LOG.debug("Git: adding files: " + files);
                GitFileUtils.addPaths(GitVFSListener.this.myProject, root, files);
                VcsFileUtil.markFilesDirty((Project)GitVFSListener.this.myProject, files);
            }

            @Override
            public Collection<File> getFilesToRefresh() {
                return Collections.emptyList();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "root";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "files";
                        break;
                    }
                }
                objectArray[1] = "git4idea/vfs/GitVFSListener$2";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    protected String getDeleteTitle() {
        return GitBundle.getString("vfs.listener.delete.title");
    }

    protected String getSingleFileDeleteTitle() {
        return GitBundle.getString("vfs.listener.delete.single.title");
    }

    protected String getSingleFileDeletePromptTemplate() {
        return GitBundle.getString("vfs.listener.delete.single.prompt");
    }

    protected void performDeletion(List<FilePath> filesToDelete) {
        this.performBackgroundOperation(filesToDelete, GitBundle.getString("remove.removing"), new LongOperationPerRootExecutor(){
            HashSet<File> filesToRefresh = new HashSet();

            @Override
            public void execute(@NotNull VirtualFile root, @NotNull List<FilePath> files) throws VcsException {
                if (root == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (files == null) {
                    3.$$$reportNull$$$0(1);
                }
                GitFileUtils.delete(GitVFSListener.this.myProject, root, files, "--ignore-unmatch", "--cached");
                if (!GitVFSListener.this.myProject.isDisposed()) {
                    VcsFileUtil.markFilesDirty((Project)GitVFSListener.this.myProject, files);
                }
                File rootFile = new File(root.getPath());
                for (FilePath p : files) {
                    for (File f = p.getIOFile(); f != null && !FileUtil.filesEqual((File)f, (File)rootFile); f = f.getParentFile()) {
                        this.filesToRefresh.add(f);
                    }
                }
            }

            @Override
            public Collection<File> getFilesToRefresh() {
                return this.filesToRefresh;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "root";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "files";
                        break;
                    }
                }
                objectArray[1] = "git4idea/vfs/GitVFSListener$3";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    protected void performMoveRename(List<VcsVFSListener.MovedFileInfo> movedFiles) {
        ArrayList toAdd = ContainerUtil.newArrayList();
        ArrayList toRemove = ContainerUtil.newArrayList();
        ArrayList toForceMove = ContainerUtil.newArrayList();
        for (VcsVFSListener.MovedFileInfo movedInfo : movedFiles) {
            String oldPath = movedInfo.myOldPath;
            String newPath = movedInfo.myNewPath;
            if (!SystemInfo.isFileSystemCaseSensitive && GitUtil.isCaseOnlyChange(oldPath, newPath)) {
                toForceMove.add(movedInfo);
                continue;
            }
            toRemove.add(VcsUtil.getFilePath((String)oldPath));
            toAdd.add(VcsUtil.getFilePath((String)newPath));
        }
        LOG.debug("performMoveRename. \ntoAdd: " + toAdd + "\ntoRemove: " + toRemove + "\ntoForceMove: " + toForceMove);
        this.performAdding(toAdd);
        this.performDeletion(toRemove);
        this.performForceMove(toForceMove);
    }

    private void performForceMove(@NotNull List<VcsVFSListener.MovedFileInfo> files) {
        if (files == null) {
            GitVFSListener.$$$reportNull$$$0(4);
        }
        final Map filesToMove = ContainerUtil.map2Map(files, info -> Pair.create((Object)VcsUtil.getFilePath((String)info.myNewPath), (Object)info));
        final HashSet toRefresh = ContainerUtil.newHashSet();
        this.performBackgroundOperation(filesToMove.keySet(), "Moving Files...", new LongOperationPerRootExecutor(){

            @Override
            public void execute(@NotNull VirtualFile root, @NotNull List<FilePath> files) {
                if (root == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (files == null) {
                    4.$$$reportNull$$$0(1);
                }
                for (FilePath file : files) {
                    VcsVFSListener.MovedFileInfo info = (VcsVFSListener.MovedFileInfo)filesToMove.get(file);
                    GitLineHandler h = new GitLineHandler(GitVFSListener.this.myProject, root, GitCommand.MV);
                    h.addParameters("-f", info.myOldPath, info.myNewPath);
                    GitVFSListener.this.myGit.runCommand(h);
                    toRefresh.add(new File(info.myOldPath));
                    toRefresh.add(new File(info.myNewPath));
                }
            }

            @Override
            public Collection<File> getFilesToRefresh() {
                return toRefresh;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "root";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "files";
                        break;
                    }
                }
                objectArray[1] = "git4idea/vfs/GitVFSListener$4";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    protected boolean isDirectoryVersioningSupported() {
        return false;
    }

    protected Collection<FilePath> selectFilePathsToDelete(List<FilePath> deletedFiles) {
        return deletedFiles;
    }

    private void performBackgroundOperation(@NotNull Collection<FilePath> files, @NotNull String operationTitle, final @NotNull LongOperationPerRootExecutor executor) {
        Map<VirtualFile, List<FilePath>> sortedFiles;
        if (files == null) {
            GitVFSListener.$$$reportNull$$$0(5);
        }
        if (operationTitle == null) {
            GitVFSListener.$$$reportNull$$$0(6);
        }
        if (executor == null) {
            GitVFSListener.$$$reportNull$$$0(7);
        }
        try {
            sortedFiles = GitUtil.sortFilePathsByGitRoot(files, true);
        }
        catch (VcsException e) {
            this.myVcsConsoleWriter.showMessage(e.getMessage());
            return;
        }
        GitVcs.runInBackground(new Task.Backgroundable(this.myProject, operationTitle){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    5.$$$reportNull$$$0(0);
                }
                for (Map.Entry e : sortedFiles.entrySet()) {
                    try {
                        executor.execute((VirtualFile)e.getKey(), (List)e.getValue());
                    }
                    catch (VcsException ex) {
                        GitVFSListener.this.myVcsConsoleWriter.showMessage(ex.getMessage());
                    }
                }
                RefreshVFsSynchronously.refreshFiles(executor.getFilesToRefresh());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/vfs/GitVFSListener$5", "run"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsConsoleWriter";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationTitle";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
        }
        objectArray2[1] = "git4idea/vfs/GitVFSListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "performForceMove";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "performBackgroundOperation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static interface LongOperationPerRootExecutor {
        public void execute(@NotNull VirtualFile var1, @NotNull List<FilePath> var2) throws VcsException;

        public Collection<File> getFilesToRefresh();
    }
}

