/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.util.containers.HashMap;
import java.util.Map;

public class DocumentBasedReplaceHandler
extends StructuralReplaceHandler {
    private final Project myProject;
    private final Map<ReplacementInfo, RangeMarker> myRangeMarkers = new HashMap();

    public DocumentBasedReplaceHandler(Project project) {
        this.myProject = project;
    }

    @Override
    public void replace(ReplacementInfo info, ReplaceOptions options) {
        if (info.getMatchesCount() == 0) {
            return;
        }
        RangeMarker rangeMarker = this.myRangeMarkers.get(info);
        Document document = rangeMarker.getDocument();
        document.replaceString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), (CharSequence)info.getReplacement());
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
    }

    @Override
    public void prepare(ReplacementInfo info) {
        MatchResult result = info.getMatchResult();
        PsiElement element = result.getMatch();
        PsiFile file = element instanceof PsiFile ? (PsiFile)element : element.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file);
        assert (document != null);
        RangeMarker rangeMarker = document.createRangeMarker(element.getTextRange());
        rangeMarker.setGreedyToLeft(true);
        rangeMarker.setGreedyToRight(true);
        this.myRangeMarkers.put(info, rangeMarker);
    }
}

