/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.handlers;

import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.iterators.SiblingNodeIterator;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.handlers.DelegatingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.iterators.SsrFilteringNodeIterator;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class TopLevelMatchingHandler
extends MatchingHandler
implements DelegatingHandler {
    private final MatchingHandler delegate;

    public TopLevelMatchingHandler(@NotNull MatchingHandler _delegate) {
        if (_delegate == null) {
            TopLevelMatchingHandler.$$$reportNull$$$0(0);
        }
        this.delegate = _delegate;
        this.setFilter(_delegate.getFilter());
    }

    @Override
    public boolean match(PsiElement patternNode, PsiElement matchedNode, MatchContext matchContext) {
        boolean matched = this.delegate.match(patternNode, matchedNode, matchContext);
        if (matched) {
            List<PsiElement> matchedNodes = matchContext.getMatchedNodes();
            if (matchedNodes == null) {
                matchedNodes = new ArrayList<PsiElement>();
                matchContext.setMatchedNodes(matchedNodes);
            }
            PsiElement elementToAdd = matchedNode;
            if (patternNode instanceof PsiComment && StructuralSearchUtil.isDocCommentOwner(matchedNode)) {
                elementToAdd = matchedNode.getFirstChild();
                assert (elementToAdd instanceof PsiComment);
            }
            matchedNodes.add(elementToAdd);
        }
        if ((!matched || matchContext.getOptions().isRecursiveSearch()) && matchContext.getPattern().getStrategy().continueMatching(matchedNode) && matchContext.shouldRecursivelyMatch()) {
            matchContext.getMatcher().matchContext(new SsrFilteringNodeIterator(new SiblingNodeIterator(matchedNode.getFirstChild())));
        }
        return matched;
    }

    @Override
    public boolean canMatch(PsiElement patternNode, PsiElement matchedNode, MatchContext context) {
        return this.delegate.canMatch(patternNode, matchedNode, context);
    }

    @Override
    public boolean matchSequentially(NodeIterator nodes, NodeIterator nodes2, MatchContext context) {
        return this.delegate.matchSequentially(nodes, nodes2, context);
    }

    @Override
    public boolean isMatchSequentiallySucceeded(NodeIterator nodes2) {
        return true;
    }

    @Override
    public boolean shouldAdvanceTheMatchFor(PsiElement patternElement, PsiElement matchedElement) {
        return this.delegate.shouldAdvanceTheMatchFor(patternElement, matchedElement);
    }

    @Override
    public MatchingHandler getDelegate() {
        return this.delegate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_delegate", "com/intellij/structuralsearch/impl/matcher/handlers/TopLevelMatchingHandler", "<init>"));
    }
}

