/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.inplace.reference.property;

import com.intellij.javaee.web.ServletMappingInfo;
import com.intellij.javaee.web.WebUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.struts.StrutsManager;
import com.intellij.struts.StrutsModel;
import com.intellij.struts.core.PsiBeanProperty;
import com.intellij.struts.dom.Action;
import com.intellij.struts.dom.FormBean;
import com.intellij.struts.inplace.reference.BaseReferenceProvider;
import com.intellij.struts.inplace.reference.XmlReferenceUtil;
import com.intellij.struts.inplace.reference.property.PropertyReference;
import com.intellij.struts.inplace.reference.property.PropertyReferenceSet;
import com.intellij.struts.util.PsiClassUtil;
import com.intellij.util.xml.DomElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FormPropertyReference
extends PropertyReference {
    private final boolean myInJsp;

    public FormPropertyReference(PropertyReferenceSet set, int index, TextRange range, boolean inJsp, BaseReferenceProvider provider) {
        super(set, index, range, provider);
        this.myInJsp = inJsp;
    }

    @Override
    @NotNull
    protected PsiBeanProperty[] getPropertiesForTag(boolean forVariants) {
        StrutsModel model;
        boolean[] soft = new boolean[1];
        FormBean form = this.getFormBean(soft);
        if (form != null && (model = this.getStrutsModel()) != null) {
            PsiBeanProperty[] psiBeanPropertyArray = model.getFormProperties(form);
            if (psiBeanPropertyArray == null) {
                FormPropertyReference.$$$reportNull$$$0(0);
            }
            return psiBeanPropertyArray;
        }
        this.setSoft(soft[0]);
        if (PsiBeanProperty.EMPTY_ARRAY == null) {
            FormPropertyReference.$$$reportNull$$$0(1);
        }
        return PsiBeanProperty.EMPTY_ARRAY;
    }

    @Override
    @Nullable
    protected DomElement getScope() {
        return this.getFormBean(new boolean[1]);
    }

    @Nullable
    protected FormBean getFormBean(boolean[] soft) {
        XmlTag enclosingFormTag;
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myValue, XmlTag.class);
        if (tag == null) {
            return null;
        }
        XmlTag xmlTag = enclosingFormTag = this.myInJsp ? XmlReferenceUtil.findEnclosingTagByClass(tag, "form", "org.apache.struts.taglib.html.FormTag") : tag.getParentTag();
        if (enclosingFormTag == null) {
            return null;
        }
        StrutsModel model = this.getStrutsModel();
        if (model == null) {
            return null;
        }
        if (!this.myInJsp) {
            FormBean formBean;
            String formName = enclosingFormTag.getAttributeValue("name");
            if (formName != null && (formBean = this.findFormBean(model, formName)) != null) {
                return FormPropertyReference.checkFormBean(formBean, soft);
            }
            return null;
        }
        XmlAttribute actionAttr = enclosingFormTag.getAttribute("action", null);
        if (actionAttr != null && actionAttr.getValue() != null) {
            Action a;
            String path = actionAttr.getValue();
            int paramPos = WebUtil.getLastPosOfURL((String)path);
            int dynaPos = WebUtil.indexOfDynamicJSP((String)path);
            if (dynaPos != -1 && (paramPos == -1 || dynaPos < paramPos)) {
                soft[0] = true;
                return null;
            }
            String actionPath = WebUtil.trimURL((String)path);
            ServletMappingInfo mappingInfo = model.getServletMappingInfo();
            String action = mappingInfo.stripMapping(actionPath);
            if (action == null) {
                action = actionPath;
            }
            if ((a = model.findAction(action)) != null) {
                FormBean formBean = (FormBean)a.getName().getValue();
                return FormPropertyReference.checkFormBean(formBean, soft);
            }
        }
        return null;
    }

    @Nullable
    protected StrutsModel getStrutsModel() {
        return StrutsManager.getInstance().getStrutsModel((PsiElement)this.myValue);
    }

    @Nullable
    protected FormBean findFormBean(StrutsModel model, String name) {
        return model.findFormBean(name);
    }

    @Nullable
    protected static FormBean checkFormBean(@Nullable FormBean formBean, boolean[] soft) {
        PsiClass psiClass;
        if (formBean != null && (psiClass = (PsiClass)formBean.getType().getValue()) != null && PsiClassUtil.isSuper(psiClass, "org.apache.commons.beanutils.DynaBean")) {
            soft[0] = true;
        }
        return formBean;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/inplace/reference/property/FormPropertyReference", "getPropertiesForTag"));
    }
}

