/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.cloud;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.javaee.openshift.cloud.OS3JsonTemplate;
import com.intellij.javaee.openshift.cloud.OSCloudConfiguration;
import com.intellij.javaee.openshift.cloud.OSDeploymentConfiguration;
import com.intellij.javaee.openshift.cloud.TemplateDeploymentEditorBase;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OS3LocalTemplateDeploymentEditor
extends TemplateDeploymentEditorBase {
    private JPanel myPanel;
    private JPanel myTemplateParametersEditorPlaceHolder;
    private JComboBox myProjectsComboBox;
    private JPanel myErrorMessagePlaceholder;
    private File myTemplateFile;

    public OS3LocalTemplateDeploymentEditor(File templateFile, RemoteServer<OSCloudConfiguration> server) {
        this.$$$setupUI$$$();
        this.setupComponents();
        this.myTemplateFile = templateFile;
        this.setTemplateParameters(this.getTemplate().getParameters());
        this.loadServerData(server);
    }

    @Nullable
    private OS3JsonTemplate getTemplate() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        try {
            return (OS3JsonTemplate)objectMapper.readValue(this.myTemplateFile, OS3JsonTemplate.class);
        }
        catch (IOException e) {
            this.showError(e.getMessage());
            return null;
        }
    }

    protected void resetEditorFrom(@NotNull OSDeploymentConfiguration s) {
        if (s == null) {
            OS3LocalTemplateDeploymentEditor.$$$reportNull$$$0(0);
        }
        this.setStoredProjectName(s.getProjectName());
        this.setTemplateParameters(s.getTemplateParameters());
    }

    protected void applyEditorTo(@NotNull OSDeploymentConfiguration s) throws ConfigurationException {
        if (s == null) {
            OS3LocalTemplateDeploymentEditor.$$$reportNull$$$0(1);
        }
        this.checkRequiredParameters();
        String selectedProjectName = this.getSelectedItem(this.myProjectsComboBox, "Project");
        s.setProjectName(selectedProjectName);
        s.setTemplateName(this.getTemplate().getMeta().getName());
        s.setTemplateParameters(this.getTemplateParameters());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            OS3LocalTemplateDeploymentEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @Override
    protected void updateLoadingState() {
        this.myProjectsComboBox.setEnabled(this.areProjectsLoaded());
    }

    @Override
    protected JComboBox<String> getProjectsComboBox() {
        return this.myProjectsComboBox;
    }

    @Override
    protected JPanel getErrorMessagePlaceholder() {
        return this.myErrorMessagePlaceholder;
    }

    @Override
    protected JPanel getTemplateParametersEditorPlaceHolder() {
        return this.myTemplateParametersEditorPlaceHolder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/openshift/cloud/OS3LocalTemplateDeploymentEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/openshift/cloud/OS3LocalTemplateDeploymentEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JComboBox jComboBox;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTemplateParametersEditorPlaceHolder = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(3, 0, 1, 2, 0, 3, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(4, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Projects:");
        jLabel.setDisplayedMnemonic('P');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(80, -1), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 3, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 0, null, null, null));
        this.myProjectsComboBox = jComboBox = new JComboBox();
        jComboBox.setEditable(false);
        jPanel4.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 7, 7, null, null, null));
        this.myErrorMessagePlaceholder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        ((Component)jPanel).setEnabled(true);
        ((Component)jPanel).setVisible(false);
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 7, 7, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Parameters:");
        jPanel3.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

