/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run;

import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.RunDashboardAnimator;
import com.intellij.execution.dashboard.RunDashboardContributor;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.RunDashboardNode;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.dashboard.hyperlink.RunDashboardHyperlinkComponent;
import com.intellij.execution.dashboard.hyperlink.RunDashboardHyperlinkIconComponent;
import com.intellij.execution.dashboard.hyperlink.RunDashboardHyperlinkTextComponent;
import com.intellij.execution.dashboard.tree.RunDashboardAnimatorImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.run.SpringBootApplicationConfigurationTypeBase;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManager;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManagerImpl;
import com.intellij.spring.boot.run.lifecycle.mappings.LiveRequestMapping;
import com.intellij.spring.boot.run.lifecycle.mappings.LiveRequestMappingsModel;
import com.intellij.spring.boot.run.lifecycle.tabs.RequestMappingsConfigurable;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public class SpringBootApplicationRunDashboardContributor
extends RunDashboardContributor {
    private static final Key<Pair<RunDashboardHyperlinkTextComponent, RunDashboardHyperlinkIconComponent>> NODE_LINKS = new Key("SpringBootApplicationRunDashboardContributorNodeLink");

    public SpringBootApplicationRunDashboardContributor() {
        super((ConfigurationType)SpringBootApplicationConfigurationTypeBase.getInstance());
    }

    public void updatePresentation(@NotNull PresentationData presentation, @NotNull RunDashboardNode node) {
        ProcessHandler handler;
        if (presentation == null) {
            SpringBootApplicationRunDashboardContributor.$$$reportNull$$$0(0);
        }
        if (node == null) {
            SpringBootApplicationRunDashboardContributor.$$$reportNull$$$0(1);
        }
        if (!(node instanceof RunDashboardRunConfigurationNode)) {
            return;
        }
        RunDashboardRunConfigurationNode runConfigurationNode = (RunDashboardRunConfigurationNode)node;
        RunConfiguration runConfiguration = runConfigurationNode.getConfigurationSettings().getConfiguration();
        if (!(runConfiguration instanceof SpringBootApplicationRunConfiguration)) {
            return;
        }
        SpringBootApplicationRunConfiguration springBootRunConfiguration = (SpringBootApplicationRunConfiguration)runConfiguration;
        if (!DumbService.getInstance((Project)runConfigurationNode.getProject()).isDumb() && SpringBootLibraryUtil.hasDevtools((Module)springBootRunConfiguration.getModule())) {
            presentation.addText(" [devtools]", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        SpringBootApplicationInfo info = null;
        RunContentDescriptor descriptor = node.getDescriptor();
        if (descriptor != null && descriptor.getProcessHandler() != null && !(handler = descriptor.getProcessHandler()).isProcessTerminated()) {
            info = SpringBootApplicationLifecycleManager.getInstance((Project)node.getProject()).getSpringBootApplicationInfo(handler);
        }
        boolean startAnimation = false;
        if (info != null) {
            Pair links;
            if (Boolean.FALSE.equals(info.getReadyState().getValue())) {
                XDebugSession session = SpringBootApplicationLifecycleManagerImpl.getDebugSession(node.getProject(), descriptor.getProcessHandler());
                if (session == null || !session.isPaused()) {
                    presentation.setIcon(RunDashboardAnimatorImpl.getCurrentFrame());
                    startAnimation = true;
                } else {
                    presentation.setIcon(AllIcons.Process.Step_4);
                }
            }
            String applicationLink = "";
            Integer serverPort = (Integer)info.getServerPort().getValue();
            if (serverPort != null && serverPort > 0) {
                presentation.addText(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                String path = springBootRunConfiguration.getUrlPath();
                applicationLink = ":" + serverPort + (StringUtil.isEmpty((String)path) ? "/" : path);
            }
            if ((links = (Pair)runConfigurationNode.getUserData(NODE_LINKS)) == null) {
                SpringBootApplicationInfo linkInfo = info;
                RunDashboardHyperlinkTextComponent textComponent = new RunDashboardHyperlinkTextComponent(e -> {
                    String applicationUrl = (String)linkInfo.getApplicationUrl().getValue();
                    if (applicationUrl != null) {
                        BrowserUtil.browse((String)LiveRequestMapping.appendMappingPath((String)applicationUrl, (String)springBootRunConfiguration.getUrlPath()));
                    }
                }, applicationLink);
                SpringBootApplicationInfo nodeInfo = info;
                RunDashboardHyperlinkIconComponent editIcon = new RunDashboardHyperlinkIconComponent(e -> {
                    LiveRequestMappingsModel mappingsModel = (LiveRequestMappingsModel)nodeInfo.getRequestMappingsModel().getValue();
                    List<LiveRequestMapping> mappings = mappingsModel == null ? Collections.emptyList() : mappingsModel.getRequestMappings().stream().filter(LiveRequestMapping::canNavigate).collect(Collectors.toList());
                    new RequestMappingsConfigurable(runConfigurationNode.getProject(), springBootRunConfiguration, mappings).show();
                }, AllIcons.General.Inline_edit, AllIcons.General.Inline_edit_hovered);
                links = Pair.create((Object)textComponent, (Object)editIcon);
                runConfigurationNode.putUserData(NODE_LINKS, (Object)links);
            } else {
                ((RunDashboardHyperlinkTextComponent)links.first).setText(applicationLink);
            }
        } else {
            runConfigurationNode.putUserData(NODE_LINKS, null);
        }
        RunDashboardAnimator animator = RunDashboardManager.getInstance((Project)node.getProject()).getAnimator();
        if (animator != null) {
            if (startAnimation) {
                animator.addNode(node);
            } else {
                animator.removeNode(node);
            }
        }
    }

    public boolean customizeCellRenderer(@NotNull ColoredTreeCellRenderer cellRenderer, @NotNull JLabel label, @NotNull RunDashboardNode node, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (cellRenderer == null) {
            SpringBootApplicationRunDashboardContributor.$$$reportNull$$$0(2);
        }
        if (label == null) {
            SpringBootApplicationRunDashboardContributor.$$$reportNull$$$0(3);
        }
        if (node == null) {
            SpringBootApplicationRunDashboardContributor.$$$reportNull$$$0(4);
        }
        if (!(node instanceof RunDashboardRunConfigurationNode)) {
            return false;
        }
        RunDashboardRunConfigurationNode runConfigurationNode = (RunDashboardRunConfigurationNode)node;
        Pair links = (Pair)runConfigurationNode.getUserData(NODE_LINKS);
        if (links == null || ((RunDashboardHyperlinkTextComponent)links.first).getText().isEmpty()) {
            return false;
        }
        ((RunDashboardHyperlinkTextComponent)links.first).setSelected(selected);
        ((RunDashboardHyperlinkTextComponent)links.first).render((SimpleColoredComponent)cellRenderer);
        label.setText(null);
        if (selected || node.equals(UIUtil.getClientProperty((Object)cellRenderer.getTree(), (Key)RunDashboardHyperlinkComponent.AIMED_OBJECT))) {
            label.setIcon((Icon)links.second);
        } else {
            label.setIcon(EmptyIcon.ICON_16);
        }
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        return true;
    }

    public boolean handleDoubleClick(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            SpringBootApplicationRunDashboardContributor.$$$reportNull$$$0(5);
        }
        if (!(runConfiguration instanceof SpringBootApplicationRunConfiguration)) {
            return false;
        }
        PsiClass mainClass = ((SpringBootApplicationRunConfiguration)runConfiguration).getMainClass();
        PsiNavigateUtil.navigate((PsiElement)mainClass);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellRenderer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/run/SpringBootApplicationRunDashboardContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updatePresentation";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeCellRenderer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "handleDoubleClick";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

