/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.editor;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.execution.ExecutionBundle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.spring.boot.application.config.SpringBootHintReferencesProvider;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.run.SpringBootAdditionalParameter;
import com.intellij.ui.LanguageTextField;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.table.TableView;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringBootAdditionalParamsTableView
extends TableView<SpringBootAdditionalParameter> {
    private static final Function<Object, String> VARIANT_MAPPER = o -> {
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof LookupElement) {
            return ((LookupElement)o).getLookupString();
        }
        if (o instanceof PsiNamedElement) {
            return ((PsiNamedElement)o).getName();
        }
        return o.toString() + " " + o.getClass();
    };
    private final ListTableModel<SpringBootAdditionalParameter> myAdditionalParamsModel = new ListTableModel(new ColumnInfo[]{new ColumnInfo<SpringBootAdditionalParameter, Boolean>("Enabled"){

        public Boolean valueOf(SpringBootAdditionalParameter parameter) {
            return parameter.isEnabled();
        }

        public Class<?> getColumnClass() {
            return Boolean.class;
        }

        public void setValue(SpringBootAdditionalParameter parameter, Boolean value) {
            parameter.setEnabled(value);
        }

        public boolean isCellEditable(SpringBootAdditionalParameter parameter) {
            return true;
        }

        @Nullable
        public String getMaxStringValue() {
            return this.getName();
        }

        public int getAdditionalWidth() {
            return 20;
        }
    }, new ColumnInfo<SpringBootAdditionalParameter, String>("Name"){
        private final TableCellRenderer myRenderer;
        {
            this.myRenderer = new DefaultTableCellRenderer();
        }

        @Nullable
        public TableCellEditor getEditor(SpringBootAdditionalParameter parameter) {
            if (SpringBootAdditionalParamsTableView.this.myModule == null || DumbService.isDumb((Project)SpringBootAdditionalParamsTableView.this.myModule.getProject())) {
                return super.getEditor((Object)parameter);
            }
            return new MySpringBootNameTableCellEditor(SpringBootAdditionalParamsTableView.this.myModule);
        }

        @Nullable
        public String valueOf(SpringBootAdditionalParameter parameter) {
            return parameter.getName();
        }

        public void setValue(SpringBootAdditionalParameter parameter, String value) {
            parameter.setName(StringUtil.trim((String)value));
        }

        public boolean isCellEditable(SpringBootAdditionalParameter parameter) {
            return parameter.isEnabled();
        }

        @Nullable
        public TableCellRenderer getRenderer(SpringBootAdditionalParameter parameter) {
            return this.myRenderer;
        }

        public TableCellRenderer getCustomizedRenderer(SpringBootAdditionalParameter o, TableCellRenderer renderer) {
            SpringBootApplicationMetaConfigKey key = SpringBootAdditionalParamsTableView.this.findMetaConfigKey(o);
            if (key != null) {
                ((DefaultTableCellRenderer)renderer).setToolTipText(key.getDescriptionText().getFullText());
            }
            return renderer;
        }

        public String getPreferredStringValue() {
            return "012345678901234";
        }
    }, new ColumnInfo<SpringBootAdditionalParameter, String>("Value"){

        @Nullable
        public String valueOf(SpringBootAdditionalParameter parameter) {
            return parameter.getValue();
        }

        public void setValue(SpringBootAdditionalParameter parameter, String value) {
            parameter.setValue(value);
        }

        public boolean isCellEditable(SpringBootAdditionalParameter parameter) {
            return parameter.isEnabled();
        }

        @Nullable
        public TableCellEditor getEditor(SpringBootAdditionalParameter parameter) {
            SpringBootApplicationMetaConfigKey key = SpringBootAdditionalParamsTableView.this.findMetaConfigKey(parameter);
            if (key == null) {
                return super.getEditor((Object)parameter);
            }
            List variants = SpringBootAdditionalParamsTableView.this.getCompletionVariants(key);
            if (variants.isEmpty()) {
                return super.getEditor((Object)parameter);
            }
            return SpringBootAdditionalParamsTableView.this.createValueTableCellEditor(parameter, variants);
        }
    }});
    @Nullable
    private Module myModule;

    SpringBootAdditionalParamsTableView() {
        this.setModelAndUpdateColumns(this.myAdditionalParamsModel);
        this.getTableHeader().setReorderingAllowed(false);
        this.getEmptyText().setText(ExecutionBundle.message((String)"no.parameters", (Object[])new Object[0]));
        this.setShowGrid(false);
        this.setColumnSelectionAllowed(false);
        this.setRowHeight(new LanguageTextField().getPreferredSize().height);
        this.setPreferredScrollableViewportSize((Dimension)new JBDimension(-1, 5 * this.getRowHeight()));
        new TableSpeedSearch((JTable)((Object)this));
    }

    List<SpringBootAdditionalParameter> getAdditionalParameters() {
        return this.myAdditionalParamsModel.getItems();
    }

    void setAdditionalParameters(List<SpringBootAdditionalParameter> parameters) {
        this.myAdditionalParamsModel.setItems(parameters);
    }

    void addAdditionalParameter() {
        this.myAdditionalParamsModel.addRow((Object)new SpringBootAdditionalParameter(true, "", ""));
        int index = this.myAdditionalParamsModel.getRowCount() - 1;
        this.setRowSelectionInterval(index, index);
        TableUtil.scrollSelectionToVisible((JTable)((Object)this));
    }

    void setModule(@Nullable Module module) {
        this.myModule = module;
    }

    @NotNull
    private TableCellEditor createValueTableCellEditor(SpringBootAdditionalParameter parameter, List<String> variants) {
        assert (this.myModule != null);
        final TextFieldWithAutoCompletion field = TextFieldWithAutoCompletion.create((Project)this.myModule.getProject(), variants, (boolean)true, (String)parameter.getValue());
        AbstractTableCellEditor abstractTableCellEditor = new AbstractTableCellEditor(){

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                return field;
            }

            public Object getCellEditorValue() {
                return field.getText();
            }
        };
        if (abstractTableCellEditor == null) {
            SpringBootAdditionalParamsTableView.$$$reportNull$$$0(0);
        }
        return abstractTableCellEditor;
    }

    private List<String> getCompletionVariants(@NotNull SpringBootApplicationMetaConfigKey key) {
        if (key == null) {
            SpringBootAdditionalParamsTableView.$$$reportNull$$$0(1);
        }
        PsiElement dummyValueNode = this.createDummyValueNode();
        List<TextRange> valueTextRanges = Collections.singletonList(ElementManipulators.getValueTextRange((PsiElement)dummyValueNode));
        Object[] references = SpringBootHintReferencesProvider.getInstance().getValueReferences(this.myModule, key, null, dummyValueNode, valueTextRanges, new ProcessingContext());
        PsiReference reference = (PsiReference)ArrayUtil.getFirstElement((Object[])references);
        if (reference == null) {
            return Collections.emptyList();
        }
        return ContainerUtil.mapNotNull((Object[])reference.getVariants(), VARIANT_MAPPER);
    }

    @NotNull
    private PsiElement createDummyValueNode() {
        assert (this.myModule != null);
        PsiFile dummyFile = PsiFileFactory.getInstance((Project)this.myModule.getProject()).createFileFromText("application.properties", (FileType)PropertiesFileType.INSTANCE, (CharSequence)"dummyKey=x\n");
        dummyFile.putUserData(ModuleUtilCore.KEY_MODULE, (Object)this.myModule);
        PropertiesFile propertiesFile = (PropertiesFile)dummyFile;
        IProperty dummyKey = propertiesFile.findPropertyByKey("dummyKey");
        assert (dummyKey != null);
        PropertyImpl dummyProperty = (PropertyImpl)dummyKey.getPsiElement();
        ASTNode valueNode = dummyProperty.getValueNode();
        assert (valueNode != null);
        PsiElement psiElement = valueNode.getPsi();
        if (psiElement == null) {
            SpringBootAdditionalParamsTableView.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @Nullable
    private SpringBootApplicationMetaConfigKey findMetaConfigKey(SpringBootAdditionalParameter parameter) {
        if (this.myModule == null || DumbService.isDumb((Project)this.myModule.getProject())) {
            return null;
        }
        return SpringBootApplicationMetaConfigKeyManager.getInstance().findApplicationMetaConfigKey(this.myModule, parameter.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/editor/SpringBootAdditionalParamsTableView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createValueTableCellEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/editor/SpringBootAdditionalParamsTableView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createDummyValueNode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionVariants";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MySpringBootNameTableCellEditor
    extends AbstractTableCellEditor {
        private final TextFieldWithAutoCompletion<SpringBootApplicationMetaConfigKey> myTextField;
        private final TextFieldWithAutoCompletionListProvider<SpringBootApplicationMetaConfigKey> myProvider;

        private MySpringBootNameTableCellEditor(@NotNull Module module) {
            if (module == null) {
                MySpringBootNameTableCellEditor.$$$reportNull$$$0(0);
            }
            this.myProvider = new TextFieldWithAutoCompletionListProvider<SpringBootApplicationMetaConfigKey>(null){

                @NotNull
                public LookupElementBuilder createLookupBuilder(@NotNull SpringBootApplicationMetaConfigKey item) {
                    if (item == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    LookupElementBuilder lookupElementBuilder = item.getPresentation().getLookupElement();
                    if (lookupElementBuilder == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return lookupElementBuilder;
                }

                @Nullable
                protected Icon getIcon(@NotNull SpringBootApplicationMetaConfigKey item) {
                    if (item == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return null;
                }

                @NotNull
                protected String getLookupString(@NotNull SpringBootApplicationMetaConfigKey item) {
                    if (item == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    String string = item.getName();
                    if (string == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return string;
                }

                @Nullable
                protected String getTailText(@NotNull SpringBootApplicationMetaConfigKey item) {
                    if (item == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    return null;
                }

                @Nullable
                protected String getTypeText(@NotNull SpringBootApplicationMetaConfigKey item) {
                    if (item == null) {
                        1.$$$reportNull$$$0(6);
                    }
                    return null;
                }

                public int compare(SpringBootApplicationMetaConfigKey item1, SpringBootApplicationMetaConfigKey item2) {
                    return item1.getName().compareTo(item2.getName());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: 
                        case 4: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: 
                        case 4: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "item";
                            break;
                        }
                        case 1: 
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/spring/boot/run/editor/SpringBootAdditionalParamsTableView$MySpringBootNameTableCellEditor$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/spring/boot/run/editor/SpringBootAdditionalParamsTableView$MySpringBootNameTableCellEditor$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createLookupBuilder";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getLookupString";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "createLookupBuilder";
                            break;
                        }
                        case 1: 
                        case 4: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "getIcon";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray;
                            objectArray[2] = "getLookupString";
                            break;
                        }
                        case 5: {
                            objectArray = objectArray;
                            objectArray[2] = "getTailText";
                            break;
                        }
                        case 6: {
                            objectArray = objectArray;
                            objectArray[2] = "getTypeText";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: 
                        case 4: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            List allKeys = SpringBootApplicationMetaConfigKeyManager.getInstance().getAllMetaConfigKeys(module);
            this.myProvider.setItems((Collection)allKeys);
            this.myTextField = new TextFieldWithAutoCompletion(module.getProject(), this.myProvider, true, null);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.myTextField.setText((String)value);
            return this.myTextField;
        }

        public Object getCellEditorValue() {
            return this.myTextField.getText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/boot/run/editor/SpringBootAdditionalParamsTableView$MySpringBootNameTableCellEditor", "<init>"));
        }
    }
}

