/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.editor;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.ui.ClassBrowser;
import com.intellij.execution.ui.CommonJavaParametersPanel;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JrePathEditor;
import com.intellij.ide.util.ClassFilter;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.boot.application.SpringBootApplicationUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.editor.SpringBootSettingsPanel;
import com.intellij.ui.EditorTextFieldWithBrowseButton;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootApplicationRunConfigurationEditor
extends SettingsEditor<SpringBootApplicationRunConfiguration>
implements PanelWithAnchor {
    private final Project myProject;
    private JPanel myWholePanel;
    private JComponent myAnchor;
    private LabeledComponent<EditorTextFieldWithBrowseButton> myMainClass;
    private LabeledComponent<ModulesComboBox> myModule;
    private final ConfigurationModuleSelector myModuleSelector;
    private CommonJavaParametersPanel myCommonProgramParameters;
    private JrePathEditor myJrePathEditor;
    private SpringBootSettingsPanel mySpringBootSettings;
    private LabeledComponent<JBCheckBox> myIncludeProvidedCheckbox;

    public SpringBootApplicationRunConfigurationEditor(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myModuleSelector = new ConfigurationModuleSelector(project, (ModulesComboBox)this.myModule.getComponent()){

            public boolean isModuleAccepted(Module module) {
                return SpringBootLibraryUtil.hasSpringBootLibrary((Module)module);
            }
        };
        this.myJrePathEditor.setDefaultJreSelector(DefaultJreSelector.fromSourceRootsDependencies((ModulesComboBox)((ModulesComboBox)this.myModule.getComponent()), (EditorTextFieldWithBrowseButton)this.getMainClassField()));
        this.myCommonProgramParameters.setModuleContext(this.myModuleSelector.getModule());
        ((ModulesComboBox)this.myModule.getComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Module module = SpringBootApplicationRunConfigurationEditor.this.myModuleSelector.getModule();
                SpringBootApplicationRunConfigurationEditor.this.myCommonProgramParameters.setModuleContext(module);
                SpringBootApplicationRunConfigurationEditor.this.mySpringBootSettings.setModule(module);
            }
        });
        new SpringBootClassBrowser(project, this.myModuleSelector).setField((ComponentWithBrowseButton)this.getMainClassField());
        this.myIncludeProvidedCheckbox.setComponent((JComponent)new JBCheckBox(ExecutionBundle.message((String)"application.configuration.include.provided.scope", (Object[])new Object[0])));
        this.myAnchor = UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{this.myMainClass, this.myCommonProgramParameters, this.myJrePathEditor, this.myModule, this.myIncludeProvidedCheckbox, this.mySpringBootSettings});
    }

    private void createUIComponents() {
        this.myMainClass = new LabeledComponent();
        this.myMainClass.setComponent((JComponent)new EditorTextFieldWithBrowseButton(this.myProject, true, new JavaCodeFragment.VisibilityChecker(){

            public JavaCodeFragment.VisibilityChecker.Visibility isDeclarationVisible(PsiElement declaration, PsiElement place) {
                PsiClass aClass;
                if (declaration instanceof PsiClass && SpringBootApplicationUtil.isSpringApplication((PsiClass)(aClass = (PsiClass)declaration)) && SpringBootApplicationUtil.hasMainMethod((PsiClass)aClass)) {
                    return JavaCodeFragment.VisibilityChecker.Visibility.VISIBLE;
                }
                return JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE;
            }
        }));
        this.mySpringBootSettings = new SpringBootSettingsPanel(this.myProject);
    }

    protected void resetEditorFrom(@NotNull SpringBootApplicationRunConfiguration configuration) {
        if (configuration == null) {
            SpringBootApplicationRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        this.myCommonProgramParameters.reset((CommonJavaRunConfigurationParameters)configuration);
        this.myModuleSelector.reset((ModuleBasedConfiguration)configuration);
        this.getMainClassField().setText(configuration.getSpringBootMainClass() != null ? configuration.getSpringBootMainClass().replace('$', '.') : "");
        this.mySpringBootSettings.setEnableDebugOutput(configuration.isDebugMode());
        this.mySpringBootSettings.setEnableLaunchOptimization(configuration.isEnableLaunchOptimization());
        this.mySpringBootSettings.setHideBanner(configuration.isHideBanner());
        this.mySpringBootSettings.setEnableJmxAgent(configuration.isEnableJmxAgent());
        this.mySpringBootSettings.setActiveProfiles(configuration.getActiveProfiles());
        this.mySpringBootSettings.setFrameDeactivationUpdatePolicy(configuration.getFrameDeactivationUpdatePolicy());
        this.mySpringBootSettings.setAdditionalParameters(configuration.getAdditionalParameters());
        this.myJrePathEditor.setPathOrName(configuration.getAlternativeJrePath(), configuration.isAlternativeJrePathEnabled());
        ((JBCheckBox)this.myIncludeProvidedCheckbox.getComponent()).setSelected(configuration.isIncludeProvidedScope());
    }

    protected void applyEditorTo(@NotNull SpringBootApplicationRunConfiguration configuration) {
        if (configuration == null) {
            SpringBootApplicationRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        this.myCommonProgramParameters.applyTo((CommonJavaRunConfigurationParameters)configuration);
        this.myModuleSelector.applyTo((ModuleBasedConfiguration)configuration);
        String className = this.getMainClassField().getText();
        PsiClass aClass = this.myModuleSelector.findClass(className);
        configuration.setSpringBootMainClass(aClass != null ? JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)aClass) : className);
        configuration.setDebugMode(this.mySpringBootSettings.isEnableDebugOutput());
        configuration.setEnableLaunchOptimization(this.mySpringBootSettings.isEnableLaunchOptimization());
        configuration.setHideBanner(this.mySpringBootSettings.isHideBanner());
        configuration.setEnableJmxAgent(this.mySpringBootSettings.isEnableJmxAgent());
        configuration.setActiveProfiles(this.mySpringBootSettings.getActiveProfiles());
        configuration.setFrameDeactivationUpdatePolicy(this.mySpringBootSettings.getFrameDeactivationUpdatePolicy());
        configuration.setAdditionalParameters(this.mySpringBootSettings.getAdditionalParameters());
        configuration.setAlternativeJrePath(this.myJrePathEditor.getJrePathOrName());
        configuration.setAlternativeJrePathEnabled(this.myJrePathEditor.isAlternativeJreSelected());
        configuration.setIncludeProvidedScope(((JBCheckBox)this.myIncludeProvidedCheckbox.getComponent()).isSelected());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myWholePanel;
        if (jPanel == null) {
            SpringBootApplicationRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
        this.myMainClass.setAnchor(anchor);
        this.myModule.setAnchor(anchor);
        this.myCommonProgramParameters.setAnchor(anchor);
        this.myJrePathEditor.setAnchor(anchor);
        this.mySpringBootSettings.setAnchor(anchor);
        this.myIncludeProvidedCheckbox.setAnchor(anchor);
    }

    private EditorTextFieldWithBrowseButton getMainClassField() {
        return (EditorTextFieldWithBrowseButton)this.myMainClass.getComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/editor/SpringBootApplicationRunConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/editor/SpringBootApplicationRunConfigurationEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        LabeledComponent labeledComponent;
        LabeledComponent labeledComponent2;
        JrePathEditor jrePathEditor;
        CommonJavaParametersPanel commonJavaParametersPanel;
        JPanel jPanel;
        this.createUIComponents();
        this.myWholePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCommonProgramParameters = commonJavaParametersPanel = new CommonJavaParametersPanel();
        jPanel.add((Component)commonJavaParametersPanel, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myJrePathEditor = jrePathEditor = new JrePathEditor();
        jPanel.add((Component)jrePathEditor, new GridConstraints(5, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        LabeledComponent<EditorTextFieldWithBrowseButton> labeledComponent3 = this.myMainClass;
        labeledComponent3.setLabelLocation("West");
        labeledComponent3.setText("Main class");
        jPanel.add((Component)labeledComponent3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myModule = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setComponentClass("com.intellij.application.options.ModulesComboBox");
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("application.configuration.use.classpath.and.jdk.of.module.label"));
        jPanel.add((Component)labeledComponent2, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        SpringBootSettingsPanel springBootSettingsPanel = this.mySpringBootSettings;
        JComponent jComponent = springBootSettingsPanel.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(7, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.myIncludeProvidedCheckbox = labeledComponent = new LabeledComponent();
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText("");
        jPanel.add((Component)labeledComponent, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private static class SpringBootClassBrowser
    extends ClassBrowser.MainClassBrowser {
        public SpringBootClassBrowser(Project project, ConfigurationModuleSelector moduleSelector) {
            super(project, moduleSelector, SpringBootRunBundle.message("spring.boot.choose.class.dialog.title", new Object[0]));
        }

        protected ClassFilter createFilter(Module module) {
            return new ClassFilter(){

                public boolean isAccepted(PsiClass aClass) {
                    return SpringBootApplicationUtil.isSpringApplication((PsiClass)aClass) && (Boolean)ReadAction.compute(() -> SpringBootApplicationUtil.hasMainMethod((PsiClass)aClass)) != false;
                }
            };
        }
    }
}

