/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.editor;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.spring.SpringManager;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.run.SpringBootAdditionalParameter;
import com.intellij.spring.boot.run.editor.SpringBootAdditionalParamsTableView;
import com.intellij.spring.boot.run.update.SpringBootApplicationUpdatePolicy;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.TableUtil;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import icons.SpringApiIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nullable;

public class SpringBootSettingsPanel
extends JPanel
implements PanelWithAnchor {
    private JPanel myRootPanel;
    private JComponent myAnchor;
    private JBCheckBox myEnableDebugOutput;
    private JBCheckBox myEnableLaunchOptimization;
    private JBCheckBox myHideBanner;
    private JBCheckBox myEnableJmxAgent;
    private JPanel myAdditionalParametersPanel;
    private LabeledComponent<TextFieldWithAutoCompletion<String>> myActiveProfiles;
    private JLabel myDevToolsMessage;
    private LabeledComponent<ComboBox<SpringBootApplicationUpdatePolicy>> myFrameDeactivationPolicy;
    private SpringBootAdditionalParamsTableView myAdditionalParamsTable;
    private final Project myProject;
    private Module myModule;

    public SpringBootSettingsPanel(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.initAdditionalParamsTable();
        if (Registry.is((String)"compiler.automake.allow.when.app.running")) {
            this.myDevToolsMessage.setIcon(AllIcons.RunConfigurations.ConfigurationWarning);
            this.myDevToolsMessage.setText("Background compilation enabled");
        }
    }

    private void initAdditionalParamsTable() {
        this.myAdditionalParamsTable = new SpringBootAdditionalParamsTableView();
        this.myAdditionalParametersPanel.add((Component)ToolbarDecorator.createDecorator((JTable)((Object)this.myAdditionalParamsTable)).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                SpringBootSettingsPanel.this.myAdditionalParamsTable.addAdditionalParameter();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableUtil.removeSelectedItems((JTable)((Object)SpringBootSettingsPanel.this.myAdditionalParamsTable));
            }
        }).createPanel(), "Center");
    }

    boolean isEnableDebugOutput() {
        return this.myEnableDebugOutput.isSelected();
    }

    void setEnableDebugOutput(boolean value) {
        this.myEnableDebugOutput.setSelected(value);
    }

    boolean isEnableLaunchOptimization() {
        return this.myEnableLaunchOptimization.isSelected();
    }

    void setEnableLaunchOptimization(boolean value) {
        this.myEnableLaunchOptimization.setSelected(value);
    }

    boolean isHideBanner() {
        return this.myHideBanner.isSelected();
    }

    void setHideBanner(boolean value) {
        this.myHideBanner.setSelected(value);
    }

    boolean isEnableJmxAgent() {
        return this.myEnableJmxAgent.isSelected();
    }

    void setEnableJmxAgent(boolean value) {
        this.myEnableJmxAgent.setSelected(value);
    }

    void setAdditionalParameters(List<SpringBootAdditionalParameter> parameters) {
        this.myAdditionalParamsTable.setAdditionalParameters(parameters);
    }

    List<SpringBootAdditionalParameter> getAdditionalParameters() {
        return this.myAdditionalParamsTable.getAdditionalParameters();
    }

    String getActiveProfiles() {
        return ((TextFieldWithAutoCompletion)this.myActiveProfiles.getComponent()).getText();
    }

    void setActiveProfiles(String value) {
        ((TextFieldWithAutoCompletion)this.myActiveProfiles.getComponent()).setText(value);
    }

    SpringBootApplicationUpdatePolicy getFrameDeactivationUpdatePolicy() {
        return (SpringBootApplicationUpdatePolicy)((ComboBox)this.myFrameDeactivationPolicy.getComponent()).getSelectedItem();
    }

    void setFrameDeactivationUpdatePolicy(SpringBootApplicationUpdatePolicy updatePolicy) {
        ((ComboBox)this.myFrameDeactivationPolicy.getComponent()).setSelectedItem((Object)updatePolicy);
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
        this.myActiveProfiles.setAnchor(anchor);
        this.myFrameDeactivationPolicy.setAnchor(anchor);
    }

    public void stopEditing() {
        this.myAdditionalParamsTable.stopEditing();
    }

    public void setModule(Module module) {
        this.myModule = module;
        this.myAdditionalParamsTable.setModule(module);
        this.updateProfilesCompletion();
        this.myEnableJmxAgent.setEnabled(this.myModule == null || SpringBootLibraryUtil.isAtLeastVersion((Module)this.myModule, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_3_0));
    }

    private void updateProfilesCompletion() {
        if (this.myModule == null) {
            ((TextFieldWithAutoCompletion)this.myActiveProfiles.getComponent()).setVariants(Collections.emptyList());
            return;
        }
        SpringModel model = SpringManager.getInstance((Project)this.myProject).getCombinedModel(this.myModule);
        ArrayList allProfileNames = new ArrayList(model.getAllProfiles());
        allProfileNames.remove("_DEFAULT_PROFILE_NAME_");
        Collections.sort(allProfileNames);
        ((TextFieldWithAutoCompletion)this.myActiveProfiles.getComponent()).setVariants(allProfileNames);
    }

    private void createUIComponents() {
        TextFieldWithAutoCompletion field = TextFieldWithAutoCompletion.create((Project)this.myProject, Collections.emptyList(), (Icon)SpringApiIcons.SpringProfile, (boolean)true, (String)"");
        this.myActiveProfiles = LabeledComponent.create((JComponent)field, (String)"Active Profiles");
        ComboBox frameDeactivationComboBox = new ComboBox();
        SpringBootSettingsPanel.initUpdatePolicyComboBox((ComboBox<SpringBootApplicationUpdatePolicy>)frameDeactivationComboBox, true);
        this.myFrameDeactivationPolicy = LabeledComponent.create((JComponent)frameDeactivationComboBox, (String)"On frame deactivation");
    }

    private static void initUpdatePolicyComboBox(ComboBox<SpringBootApplicationUpdatePolicy> comboBox, boolean onFrameDeactivation) {
        comboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<SpringBootApplicationUpdatePolicy>(){

            public void customize(JList list, SpringBootApplicationUpdatePolicy value, int index, boolean selected, boolean hasFocus) {
                if (value == null) {
                    this.setText("Do nothing");
                } else {
                    this.setText(UIUtil.removeMnemonic((String)value.getDescription()));
                }
            }
        });
        if (onFrameDeactivation) {
            comboBox.addItem(null);
        }
        List policies = SpringBootApplicationUpdatePolicy.getAvailablePolicies((boolean)onFrameDeactivation);
        for (SpringBootApplicationUpdatePolicy policy : policies) {
            comboBox.addItem((Object)policy);
        }
        if (comboBox.getItemCount() > 0) {
            comboBox.setSelectedIndex(0);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JLabel jLabel;
        JPanel jPanel;
        JBCheckBox jBCheckBox4;
        JPanel jPanel2;
        this.createUIComponents();
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 6, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Spring Boot Settings", (int)1, (int)0, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 0, 1, 6, 0, 2, 1, 6, null, null, null));
        this.myEnableDebugOutput = jBCheckBox4 = new JBCheckBox();
        jBCheckBox4.setText("Enable debug output");
        jBCheckBox4.setMnemonic('D');
        jBCheckBox4.setDisplayedMnemonicIndex(7);
        jBCheckBox4.setToolTipText("<html>Enables debug output by adding VM option <code>-Ddebug</code></html>");
        jPanel2.add((Component)jBCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 5, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myAdditionalParametersPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(3, 0, 1, 6, 0, 3, 3, 3, null, null, null, 1));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Override parameters", (int)0, (int)0, null, null));
        LabeledComponent<TextFieldWithAutoCompletion<String>> labeledComponent = this.myActiveProfiles;
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText("Active Profiles");
        jPanel2.add((Component)labeledComponent, new GridConstraints(2, 0, 1, 6, 0, 1, 3, 3, null, null, null));
        this.myDevToolsMessage = jLabel = new JLabel();
        jLabel.setText("");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEnableLaunchOptimization = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setText("Enable launch optimization");
        jBCheckBox3.setMnemonic('L');
        jBCheckBox3.setDisplayedMnemonicIndex(7);
        jBCheckBox3.setToolTipText("<html>Adds VM options <code>-XX:TieredStopAtLevel=1</code> and <code>-noverify</code> to speed up startup</html>");
        jPanel2.add((Component)jBCheckBox3, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myHideBanner = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Hide Banner");
        jBCheckBox2.setMnemonic('H');
        jBCheckBox2.setDisplayedMnemonicIndex(0);
        jBCheckBox2.setToolTipText("<html>Hides banner by adding VM option <code>-Dspring.main.banner-mode=OFF</code><br>(<code>-Dspring.main.show_banner=false</code> for Spring Boot 1.4.x or earlier)</html>");
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEnableJmxAgent = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Enable JMX agent");
        jBCheckBox.setMnemonic('M');
        jBCheckBox.setDisplayedMnemonicIndex(8);
        jBCheckBox.setToolTipText("<html>Enables JMX agent to show application endpoints data by adding VM options <code><br>-Dcom.sun.management.jmxremote <br>-Dcom.sun.management.jmxremote.port={random free port} <br>-Dcom.sun.management.jmxremote.authenticate=false <br>-Dcom.sun.management.jmxremote.ssl=false <br>-Djava.rmi.server.hostname=localhost <br>-Dspring.liveBeansView.mbeanDomain <br>-Dspring.application.admin.enabled=true</code><p><code>-Dcom.sun.management.jmxremote.port</code> argument would not be overridden if it is specified in VM options text field above.<p>Requires Spring Boot 1.3.0 or higher.</html>");
        jPanel2.add((Component)jBCheckBox, new GridConstraints(0, 3, 1, 1, 0, 0, 0, 0, null, null, null));
        LabeledComponent<ComboBox<SpringBootApplicationUpdatePolicy>> labeledComponent2 = this.myFrameDeactivationPolicy;
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText("On frame deactivation");
        jPanel2.add((Component)labeledComponent2, new GridConstraints(1, 0, 1, 6, 0, 1, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

