/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.run.lifecycle.AsyncLiveProperty;
import com.intellij.spring.boot.run.lifecycle.LifecycleErrorHandler;
import com.intellij.spring.boot.run.lifecycle.LiveProperty;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationServerConfiguration;
import com.intellij.util.net.NetUtils;

class ApplicationUrlLiveProperty
extends AsyncLiveProperty<String> {
    private LiveProperty<Integer> myServerPort;
    private LiveProperty<SpringBootApplicationServerConfiguration> myServerConfiguration;

    protected ApplicationUrlLiveProperty(LifecycleErrorHandler errorHandler, Disposable parent) {
        super(errorHandler, parent);
    }

    ApplicationUrlLiveProperty withServerPort(LiveProperty<Integer> serverPort) {
        this.myServerPort = serverPort;
        this.myServerPort.addPropertyListener(() -> this.compute());
        return this;
    }

    ApplicationUrlLiveProperty withServerConfiguration(LiveProperty<SpringBootApplicationServerConfiguration> serverConfiguration) {
        this.myServerConfiguration = serverConfiguration;
        this.myServerConfiguration.addPropertyListener(() -> this.compute());
        return this;
    }

    @Override
    protected String doCompute() {
        SpringBootApplicationServerConfiguration serverConfiguration;
        if (this.myServerPort == null) {
            return null;
        }
        Integer serverPort = (Integer)this.myServerPort.getValue();
        if (serverPort == null || serverPort <= 0) {
            return null;
        }
        String path = "";
        String scheme = "http";
        String address = NetUtils.getLocalHostString();
        SpringBootApplicationServerConfiguration springBootApplicationServerConfiguration = serverConfiguration = this.myServerConfiguration != null ? (SpringBootApplicationServerConfiguration)this.myServerConfiguration.getValue() : null;
        if (serverConfiguration != null) {
            String serverAddress;
            String servletPath;
            String contextPath;
            if (serverConfiguration.isSslEnabled()) {
                scheme = "https";
            }
            if ((contextPath = serverConfiguration.getContextPath()) != null) {
                path = path + contextPath;
            }
            if ((servletPath = serverConfiguration.getServletPath()) != null) {
                path = path + servletPath;
            }
            if (StringUtil.isNotEmpty((String)(serverAddress = serverConfiguration.getAddress()))) {
                address = serverAddress;
            }
        }
        return scheme + "://" + address + ":" + serverPort + path;
    }
}

