/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationBase;
import com.intellij.spring.boot.run.update.SpringBootApplicationUpdatePolicy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

class SpringBootApplicationCompileManager
implements Disposable {
    private final Map<ProcessHandler, Pair<SpringBootApplicationRunConfiguration, String>> myRunningApps;
    private final FrameStateListener myCompileRunnable;

    SpringBootApplicationCompileManager(final @NotNull Project project) {
        if (project == null) {
            SpringBootApplicationCompileManager.$$$reportNull$$$0(0);
        }
        this.myRunningApps = new ConcurrentHashMap<ProcessHandler, Pair<SpringBootApplicationRunConfiguration, String>>();
        this.myCompileRunnable = new FrameStateListener.Adapter(){

            public void onFrameDeactivated() {
                if (!(project.isDisposed() || !project.isInitialized() || CompilerManager.getInstance((Project)project).isCompilationActive() || LaterInvocator.isInModalContext() || ProgressManager.getInstance().hasModalProgressIndicator())) {
                    ExecutorRegistry executorRegistry = ExecutorRegistry.getInstance();
                    HashMap<SpringBootApplicationUpdatePolicy, Set> modulesToUpdate = new HashMap<SpringBootApplicationUpdatePolicy, Set>();
                    SpringBootApplicationCompileManager.this.myRunningApps.forEach((handler, value) -> {
                        if (handler.isProcessTerminated() || handler.isProcessTerminating() || !handler.isStartNotified()) {
                            return;
                        }
                        Executor executor = executorRegistry.getExecutorById((String)value.second);
                        if (executor == null) {
                            return;
                        }
                        SpringBootApplicationRunConfiguration configuration = (SpringBootApplicationRunConfiguration)((Object)((Object)value.first));
                        SpringBootApplicationUpdatePolicy policy = configuration.getFrameDeactivationUpdatePolicy();
                        if (policy == null) {
                            return;
                        }
                        if (policy.isAvailableForConfiguration((SpringBootApplicationRunConfigurationBase)configuration) && policy.isAvailableForExecutor(executor) && policy.isAvailableOnFrameDeactivation()) {
                            modulesToUpdate.computeIfAbsent(policy, key -> new HashSet()).add(configuration.getModule());
                        }
                    });
                    modulesToUpdate.forEach((policy, modules) -> {
                        if (project == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        policy.runUpdate(project, modules, true);
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationCompileManager$1", "lambda$onFrameDeactivated$2"));
            }
        };
        this.init(project);
    }

    private void init(@NotNull Project project) {
        if (project == null) {
            SpringBootApplicationCompileManager.$$$reportNull$$$0(1);
        }
        project.getMessageBus().connect((Disposable)this).subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

            public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler) {
                RunnerAndConfigurationSettings configurationSettings;
                if (executorId == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (env == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (handler == null) {
                    2.$$$reportNull$$$0(2);
                }
                if ((configurationSettings = env.getRunnerAndConfigurationSettings()) == null) {
                    return;
                }
                if (configurationSettings.getConfiguration() instanceof SpringBootApplicationRunConfiguration) {
                    SpringBootApplicationRunConfiguration configuration = (SpringBootApplicationRunConfiguration)configurationSettings.getConfiguration();
                    SpringBootApplicationCompileManager.this.myRunningApps.put(handler, Pair.create((Object)((Object)configuration), (Object)executorId));
                }
            }

            public void processTerminating(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler) {
                if (executorId == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (env == null) {
                    2.$$$reportNull$$$0(4);
                }
                if (handler == null) {
                    2.$$$reportNull$$$0(5);
                }
                SpringBootApplicationCompileManager.this.myRunningApps.remove(handler);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executorId";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "env";
                        break;
                    }
                    case 2: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "handler";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationCompileManager$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processStarted";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminating";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        FrameStateManager frameStateManager = FrameStateManager.getInstance();
        if (frameStateManager != null) {
            frameStateManager.addListener(this.myCompileRunnable);
        }
    }

    public void dispose() {
        this.myRunningApps.clear();
        FrameStateManager frameStateManager = FrameStateManager.getInstance();
        if (frameStateManager != null) {
            frameStateManager.removeListener(this.myCompileRunnable);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationCompileManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

