/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.dashboard.RunDashboardListener;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.ApplicationAdminJmxNameLiveProperty;
import com.intellij.spring.boot.run.lifecycle.ApplicationUrlLiveProperty;
import com.intellij.spring.boot.run.lifecycle.AsyncLiveProperty;
import com.intellij.spring.boot.run.lifecycle.EndpointLiveProperty;
import com.intellij.spring.boot.run.lifecycle.LifecycleErrorHandler;
import com.intellij.spring.boot.run.lifecycle.LifecycleException;
import com.intellij.spring.boot.run.lifecycle.LiveProperty;
import com.intellij.spring.boot.run.lifecycle.ReadyStateLiveProperty;
import com.intellij.spring.boot.run.lifecycle.ServerConfigurationLiveProperty;
import com.intellij.spring.boot.run.lifecycle.ServerPortLiveProperty;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationServerConfiguration;
import com.intellij.spring.boot.run.lifecycle.SpringBootLiveBeansConnector;
import com.intellij.spring.boot.run.lifecycle.SpringBootModuleDescriptor;
import com.intellij.spring.boot.run.lifecycle.beans.LiveBeansModel;
import com.intellij.spring.boot.run.lifecycle.beans.LiveBeansSnapshotParser;
import com.intellij.spring.boot.run.lifecycle.mappings.LiveRequestMappingsModel;
import com.intellij.spring.boot.run.lifecycle.mappings.LiveRequestMappingsParser;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringBootApplicationInfoImpl
implements SpringBootApplicationInfo {
    private static final String NOTIFICATION_DISPLAY_ID = "Spring Boot Application Endpoints";
    private final RunProfile myRunProfile;
    private final LiveProperty<String> myApplicationAdminJmxName;
    private final LiveProperty<Boolean> myReadyState;
    private final LiveProperty<Integer> myServerPort;
    private final LiveProperty<SpringBootApplicationServerConfiguration> myServerConfiguration;
    private final LiveProperty<LiveBeansModel> myLiveBeansModel;
    private final LiveProperty<SpringBootModuleDescriptor> myModuleDescriptor;
    private final LiveProperty<Map> myHealth;
    private final LiveProperty<LiveRequestMappingsModel> myRequestMappings;
    private final LiveProperty<String> myApplicationUrl;
    private volatile boolean myDisposed;

    static SpringBootApplicationInfo createInfo(@NotNull Project project, @NotNull Module module, @NotNull ExecutionEnvironment environment, @NotNull RunProfile configuration, @Nullable String activeProfiles, int jmxPort) {
        if (project == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(0);
        }
        if (module == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(1);
        }
        if (environment == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(2);
        }
        if (configuration == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(3);
        }
        SpringBootApplicationInfoImpl info = new SpringBootApplicationInfoImpl(project, module, environment, configuration, activeProfiles, jmxPort);
        info.myApplicationAdminJmxName.compute();
        return info;
    }

    private SpringBootApplicationInfoImpl(final @NotNull Project project, final @NotNull Module module, @NotNull ExecutionEnvironment environment, @NotNull RunProfile configuration, @Nullable String activeProfiles, final int jmxPort) {
        if (project == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(4);
        }
        if (module == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(5);
        }
        if (environment == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(6);
        }
        if (configuration == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(7);
        }
        this.myRunProfile = configuration;
        LifecycleErrorHandler errorHandler = message -> {
            if (project == null) {
                SpringBootApplicationInfoImpl.$$$reportNull$$$0(17);
            }
            if (environment == null) {
                SpringBootApplicationInfoImpl.$$$reportNull$$$0(18);
            }
            if (configuration == null) {
                SpringBootApplicationInfoImpl.$$$reportNull$$$0(19);
            }
            if (this.myDisposed) {
                return;
            }
            String toolWindowId = ExecutionManager.getInstance((Project)project).getContentManager().getToolWindowIdByEnvironment(environment);
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
            if (toolWindowManager.canShowNotification(toolWindowId)) {
                new NotificationGroup(NOTIFICATION_DISPLAY_ID, NotificationDisplayType.NONE, true, toolWindowId).createNotification(configuration.getName(), message, NotificationType.ERROR, null).notify(project);
            }
        };
        this.myApplicationAdminJmxName = new ApplicationAdminJmxNameLiveProperty(errorHandler, (Disposable)this, module, activeProfiles);
        this.myReadyState = new ReadyStateLiveProperty(this.myApplicationAdminJmxName, jmxPort, (Disposable)this);
        this.myServerPort = new ServerPortLiveProperty(this.myApplicationAdminJmxName, jmxPort, errorHandler, (Disposable)this);
        this.myModuleDescriptor = new AsyncLiveProperty<SpringBootModuleDescriptor>(errorHandler, (Disposable)this){

            @Override
            protected SpringBootModuleDescriptor doCompute() {
                return (SpringBootModuleDescriptor)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
                    if (module == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return SpringBootModuleDescriptor.getDescriptor(module);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationInfoImpl$1", "lambda$doCompute$0"));
            }
        };
        this.myServerConfiguration = new ServerConfigurationLiveProperty(this.myApplicationAdminJmxName, jmxPort, errorHandler, (Disposable)this).withServerPort(this.myServerPort).withModuleDescriptor(this.myModuleDescriptor);
        this.myLiveBeansModel = new AsyncLiveProperty<LiveBeansModel>(errorHandler, (Disposable)this){

            @Override
            protected LiveBeansModel doCompute() throws LifecycleException {
                Throwable throwable = null;
                try (SpringBootLiveBeansConnector connector = new SpringBootLiveBeansConnector(jmxPort);){
                    String snapshot = connector.getSnapshot();
                    LiveBeansSnapshotParser parser = new LiveBeansSnapshotParser();
                    LiveBeansModel liveBeansModel = parser.parse(snapshot);
                    return liveBeansModel;
                }
                catch (Exception e) {
                    try {
                        throw new LifecycleException(SpringBootRunBundle.message("spring.boot.application.endpoints.error.failed.to.retrieve.application.beans.snapshot", e.getLocalizedMessage()), e);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }
        };
        this.myHealth = new EndpointLiveProperty<Map>("health", "health", this.myApplicationAdminJmxName, jmxPort, errorHandler, (Disposable)this){

            @Override
            protected Map parseData(@Nullable Object data) {
                return (Map)data;
            }
        }.withModuleDescriptor(this.myModuleDescriptor).withLiveBeansModel(this.myLiveBeansModel);
        this.myRequestMappings = new EndpointLiveProperty<LiveRequestMappingsModel>("mappings", "requestMapping", this.myApplicationAdminJmxName, jmxPort, errorHandler, (Disposable)this){

            @Override
            public LiveRequestMappingsModel doCompute() throws LifecycleException {
                SpringBootModuleDescriptor moduleDescriptor = (SpringBootModuleDescriptor)SpringBootApplicationInfoImpl.this.myModuleDescriptor.getValue();
                if (moduleDescriptor != null && !moduleDescriptor.isMappingsEnabled()) {
                    return null;
                }
                return (LiveRequestMappingsModel)super.doCompute();
            }

            @Override
            protected LiveRequestMappingsModel parseData(@Nullable Object data) {
                return new LiveRequestMappingsParser().parse((Map)data);
            }
        }.withModuleDescriptor(this.myModuleDescriptor).withLiveBeansModel(this.myLiveBeansModel);
        this.myApplicationUrl = new ApplicationUrlLiveProperty(errorHandler, (Disposable)this).withServerPort(this.myServerPort).withServerConfiguration(this.myServerConfiguration);
        this.myApplicationAdminJmxName.addPropertyListener(new LiveProperty.LivePropertyListener(){

            public void propertyChanged() {
            }

            public void computationFinished() {
                SpringBootApplicationInfoImpl.this.myReadyState.compute();
            }
        });
        this.myReadyState.addPropertyListener(new LiveProperty.LivePropertyListener(){

            public void propertyChanged() {
                ((RunDashboardListener)project.getMessageBus().syncPublisher(RunDashboardManager.DASHBOARD_TOPIC)).contentChanged(true);
                SpringBootApplicationInfoImpl.this.myServerPort.compute();
                SpringBootApplicationInfoImpl.this.myLiveBeansModel.compute();
                SpringBootApplicationInfoImpl.this.myModuleDescriptor.compute();
            }

            public void computationFailed(@NotNull Exception e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                ((RunDashboardListener)project.getMessageBus().syncPublisher(RunDashboardManager.DASHBOARD_TOPIC)).contentChanged(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationInfoImpl$6", "computationFailed"));
            }
        });
        this.myServerPort.addPropertyListener(() -> {
            if (project == null) {
                SpringBootApplicationInfoImpl.$$$reportNull$$$0(16);
            }
            ((RunDashboardListener)project.getMessageBus().syncPublisher(RunDashboardManager.DASHBOARD_TOPIC)).contentChanged(false);
        });
        this.myModuleDescriptor.addPropertyListener(() -> {
            this.myHealth.compute();
            this.myRequestMappings.compute();
        });
    }

    @NotNull
    public RunProfile getRunProfile() {
        RunProfile runProfile = this.myRunProfile;
        if (runProfile == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(8);
        }
        return runProfile;
    }

    @NotNull
    public LiveProperty<Boolean> getReadyState() {
        LiveProperty<Boolean> liveProperty = this.myReadyState;
        if (liveProperty == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(9);
        }
        return liveProperty;
    }

    @NotNull
    public LiveProperty<Integer> getServerPort() {
        LiveProperty<Integer> liveProperty = this.myServerPort;
        if (liveProperty == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(10);
        }
        return liveProperty;
    }

    @NotNull
    public LiveProperty<SpringBootApplicationServerConfiguration> getServerConfiguration() {
        LiveProperty<SpringBootApplicationServerConfiguration> liveProperty = this.myServerConfiguration;
        if (liveProperty == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(11);
        }
        return liveProperty;
    }

    @NotNull
    public LiveProperty<LiveBeansModel> getLiveBeansModel() {
        LiveProperty<LiveBeansModel> liveProperty = this.myLiveBeansModel;
        if (liveProperty == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(12);
        }
        return liveProperty;
    }

    @NotNull
    public LiveProperty<Map> getHealth() {
        LiveProperty<Map> liveProperty = this.myHealth;
        if (liveProperty == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(13);
        }
        return liveProperty;
    }

    @NotNull
    public LiveProperty<LiveRequestMappingsModel> getRequestMappingsModel() {
        LiveProperty<LiveRequestMappingsModel> liveProperty = this.myRequestMappings;
        if (liveProperty == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(14);
        }
        return liveProperty;
    }

    @NotNull
    public LiveProperty<String> getApplicationUrl() {
        LiveProperty<String> liveProperty = this.myApplicationUrl;
        if (liveProperty == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(15);
        }
        return liveProperty;
    }

    public void dispose() {
        this.myDisposed = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 3: 
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationInfoImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationInfoImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunProfile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadyState";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerPort";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerConfiguration";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiveBeansModel";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getHealth";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestMappingsModel";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createInfo";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$1";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

