/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.mappings;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.spring.boot.run.lifecycle.mappings.LiveHandlerMethod;
import com.intellij.spring.boot.run.lifecycle.mappings.LiveHandlerMethodImpl;
import com.intellij.spring.boot.run.lifecycle.mappings.LiveRequestMapping;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LiveRequestMappingImpl
implements LiveRequestMapping {
    private static final String REQUEST_METHODS = "methods";
    private static final String PRODUCES = "produces";
    private static final String CONSUMES = "consumes";
    private static final String HEADERS = "headers";
    private static final String PARAMS = "params";
    private static final String PART_PATTERN = ",%s=[";
    @NotNull
    private final String myMapping;
    @NotNull
    private final String myPath;
    @Nullable
    private final String myBean;
    @Nullable
    private final LiveHandlerMethod myMethod;
    @NotNull
    private final List<String> myRequestMethods;
    @NotNull
    private final List<Pair<String, String>> myHeaders;
    @NotNull
    private final List<String> myProduces;
    @NotNull
    private final List<String> myConsumes;
    @NotNull
    private final List<Pair<String, String>> myParams;

    LiveRequestMappingImpl(@NotNull String mapping, @NotNull String path, @Nullable String bean, @Nullable String method) {
        if (mapping == null) {
            LiveRequestMappingImpl.$$$reportNull$$$0(0);
        }
        if (path == null) {
            LiveRequestMappingImpl.$$$reportNull$$$0(1);
        }
        this.myMapping = mapping;
        this.myPath = path;
        this.myBean = bean;
        this.myMethod = method != null ? new LiveHandlerMethodImpl(method) : null;
        this.myRequestMethods = LiveRequestMappingImpl.parsePartValues(mapping, REQUEST_METHODS, "||", Function.identity());
        this.myHeaders = LiveRequestMappingImpl.parsePartValues(mapping, HEADERS, "&&", LiveRequestMappingImpl::parseKeyValuePair);
        this.myProduces = LiveRequestMappingImpl.parsePartValues(mapping, PRODUCES, "||", Function.identity());
        this.myConsumes = LiveRequestMappingImpl.parsePartValues(mapping, CONSUMES, "||", Function.identity());
        this.myParams = LiveRequestMappingImpl.parsePartValues(mapping, PARAMS, "&&", LiveRequestMappingImpl::parseKeyValuePair);
    }

    @NotNull
    public String getMapping() {
        String string = this.myMapping;
        if (string == null) {
            LiveRequestMappingImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            LiveRequestMappingImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public List<String> getRequestMethods() {
        List<String> list = Collections.unmodifiableList(this.myRequestMethods);
        if (list == null) {
            LiveRequestMappingImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<Pair<String, String>> getHeaders() {
        List<Pair<String, String>> list = Collections.unmodifiableList(this.myHeaders);
        if (list == null) {
            LiveRequestMappingImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public List<String> getProduces() {
        List<String> list = Collections.unmodifiableList(this.myProduces);
        if (list == null) {
            LiveRequestMappingImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public List<String> getConsumes() {
        List<String> list = Collections.unmodifiableList(this.myConsumes);
        if (list == null) {
            LiveRequestMappingImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public List<Pair<String, String>> getParams() {
        List<Pair<String, String>> list = Collections.unmodifiableList(this.myParams);
        if (list == null) {
            LiveRequestMappingImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    public String getBean() {
        return this.myBean;
    }

    @Nullable
    public LiveHandlerMethod getMethod() {
        return this.myMethod;
    }

    public boolean canNavigate() {
        return this.myMethod != null && (this.myRequestMethods.isEmpty() || this.myRequestMethods.contains("GET"));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LiveRequestMappingImpl) {
            LiveRequestMappingImpl liveMapping = (LiveRequestMappingImpl)obj;
            return this.myMapping.equals(liveMapping.myMapping) && this.myPath.equals(liveMapping.myPath) && Comparing.equal((String)this.myBean, (String)liveMapping.myBean) && Comparing.equal((Object)this.myMethod, (Object)liveMapping.myMethod);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.myMapping.hashCode();
        result = 31 * result + this.myPath.hashCode();
        result = 31 * result + (this.myBean != null ? this.myBean.hashCode() : 0);
        result = 31 * result + (this.myMethod != null ? this.myMethod.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.myMapping;
    }

    @NotNull
    private static <P> List<P> parsePartValues(String mapping, String part, String separator, Function<String, P> mapper) {
        int end;
        String partPrefix = String.format(PART_PATTERN, part);
        int partIndex = mapping.indexOf(partPrefix);
        if (partIndex >= 0 && (end = mapping.indexOf(93, partIndex)) > partIndex) {
            String values = mapping.substring(partIndex + partPrefix.length(), end);
            List list = Arrays.stream(values.split(Pattern.quote(separator))).map(String::trim).map(mapper).collect(Collectors.toList());
            if (list == null) {
                LiveRequestMappingImpl.$$$reportNull$$$0(9);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            LiveRequestMappingImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static Pair<String, String> parseKeyValuePair(String keyValue) {
        int separatorIndex = keyValue.indexOf("=");
        if (separatorIndex >= 0) {
            String value;
            boolean negative = separatorIndex > 0 && keyValue.charAt(separatorIndex - 1) == '!';
            String key = negative ? keyValue.substring(0, separatorIndex - 1) : keyValue.substring(0, separatorIndex);
            String string = value = separatorIndex < keyValue.length() - 1 ? keyValue.substring(separatorIndex + 1, keyValue.length()) : "";
            if (negative) {
                value = "!" + value;
            }
            return Pair.create((Object)key, (Object)value);
        }
        return Pair.create((Object)keyValue, (Object)"");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/mappings/LiveRequestMappingImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/mappings/LiveRequestMappingImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMapping";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestMethods";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaders";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProduces";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsumes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getParams";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePartValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

