/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.mappings;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.boot.run.lifecycle.mappings.LiveHandlerMethod;
import com.intellij.spring.boot.run.lifecycle.mappings.LiveRequestMapping;
import com.intellij.spring.boot.run.lifecycle.mappings.LiveRequestMappingsModel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class LiveRequestMappingsModelImpl
implements LiveRequestMappingsModel {
    private static final String METHOD_NAME_SEPARATOR = "#";
    private final List<LiveRequestMapping> myMappings = ContainerUtil.newSmartList();
    private final Map<String, List<LiveRequestMapping>> myMethodToMappings = new HashMap();

    LiveRequestMappingsModelImpl(Collection<? extends LiveRequestMapping> mappings) {
        this.myMappings.addAll(mappings);
        this.myMappings.forEach(mapping -> {
            LiveHandlerMethod method = mapping.getMethod();
            if (method == null) {
                return;
            }
            List methodMappings = this.myMethodToMappings.computeIfAbsent(method.getClassName() + METHOD_NAME_SEPARATOR + method.getMethodName(), key -> ContainerUtil.newSmartList());
            methodMappings.add(mapping);
        });
    }

    @NotNull
    public List<LiveRequestMapping> getRequestMappings() {
        List<LiveRequestMapping> list = Collections.unmodifiableList(this.myMappings);
        if (list == null) {
            LiveRequestMappingsModelImpl.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public List<LiveRequestMapping> getRequestMappingsByMethod(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            LiveRequestMappingsModelImpl.$$$reportNull$$$0(1);
        }
        if (!psiMethod.isValid()) {
            List<LiveRequestMapping> list = Collections.emptyList();
            if (list == null) {
                LiveRequestMappingsModelImpl.$$$reportNull$$$0(2);
            }
            return list;
        }
        PsiClass psiClass = psiMethod.getContainingClass();
        if (psiClass == null) {
            List<LiveRequestMapping> list = Collections.emptyList();
            if (list == null) {
                LiveRequestMappingsModelImpl.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<LiveRequestMapping> mappings = this.myMethodToMappings.get(psiClass.getQualifiedName() + METHOD_NAME_SEPARATOR + psiMethod.getName());
        if (mappings == null) {
            List<LiveRequestMapping> list = Collections.emptyList();
            if (list == null) {
                LiveRequestMappingsModelImpl.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<LiveRequestMapping> list = mappings.stream().filter(mapping -> {
            LiveHandlerMethod liveHandlerMethod;
            if (psiMethod == null) {
                LiveRequestMappingsModelImpl.$$$reportNull$$$0(6);
            }
            return (liveHandlerMethod = mapping.getMethod()) != null && liveHandlerMethod.matches(psiMethod);
        }).collect(Collectors.toList());
        if (list == null) {
            LiveRequestMappingsModelImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/mappings/LiveRequestMappingsModelImpl";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestMappings";
                break;
            }
            case 1: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/mappings/LiveRequestMappingsModelImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestMappingsByMethod";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRequestMappingsByMethod";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getRequestMappingsByMethod$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

