/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.tabs;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.LifecycleException;
import com.intellij.spring.boot.run.lifecycle.LiveProperty;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManager;
import com.intellij.spring.boot.run.lifecycle.tabs.SpringBootApplicationEndpointsTab;
import com.intellij.spring.boot.run.lifecycle.tabs.SpringBootEndpointsTabSettings;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.text.DateFormatUtil;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class EndpointTab
implements Disposable {
    private static final String MESSAGE_CARD = "message";
    private static final String ENDPOINT_CARD = "endpoint";
    private final SpringBootApplicationRunConfiguration myRunConfiguration;
    private final ProcessHandler myProcessHandler;
    private final SpringBootEndpointsTabSettings mySettings;
    private final LiveProperty.LivePropertyListener myPropertyListener;
    private final CardLayout myRootPanelLayout;
    private final JPanel myRootPanel;
    private final JBLoadingPanel myMessagePanel;
    private final JLabel myMessageLabel;
    private TooltipChangeListener myTooltipChangeListener;

    protected EndpointTab(@NotNull SpringBootApplicationRunConfiguration runConfiguration, @NotNull ProcessHandler processHandler) {
        if (runConfiguration == null) {
            EndpointTab.$$$reportNull$$$0(0);
        }
        if (processHandler == null) {
            EndpointTab.$$$reportNull$$$0(1);
        }
        this.myProcessHandler = processHandler;
        this.myRunConfiguration = runConfiguration;
        this.mySettings = SpringBootEndpointsTabSettings.getInstance(runConfiguration.getProject());
        this.myPropertyListener = new LiveProperty.LivePropertyListener(){

            public void propertyChanged() {
                AppUIUtil.invokeLaterIfProjectAlive((Project)EndpointTab.this.getProject(), () -> {
                    if (EndpointTab.this.myMessagePanel.isLoading()) {
                        EndpointTab.this.myMessagePanel.stopLoading();
                    }
                    EndpointTab.this.myRootPanelLayout.show(EndpointTab.this.myRootPanel, EndpointTab.ENDPOINT_CARD);
                });
                EndpointTab.this.updateComponent();
            }

            public void computationFailed(@NotNull Exception e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                StringBuilder messageBuilder = new StringBuilder();
                if (!(e instanceof LifecycleException)) {
                    messageBuilder.append(e.getClass().getName()).append(": ");
                }
                messageBuilder.append(e.getLocalizedMessage());
                HashSet<Throwable> causes = new HashSet<Throwable>();
                Throwable parent = e;
                Throwable cause = e.getCause();
                causes.add(parent);
                while (cause != null && !causes.contains(cause)) {
                    messageBuilder.append("<br>").append(SpringBootRunBundle.message("spring.boot.application.endpoints.error.caused.by", cause.getClass().getName(), cause.getLocalizedMessage()));
                    parent = cause;
                    cause = parent.getCause();
                    causes.add(parent);
                }
                EndpointTab.this.showMessage(EndpointTab.this.getErrorMessage(messageBuilder.toString()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/spring/boot/run/lifecycle/tabs/EndpointTab$1", "computationFailed"));
            }
        };
        this.myRootPanelLayout = new CardLayout();
        this.myRootPanel = new JPanel(this.myRootPanelLayout);
        this.myMessagePanel = new JBLoadingPanel((LayoutManager)new GridBagLayout(), (Disposable)this);
        String name = StringUtil.shortenTextWithEllipsis((String)this.myRunConfiguration.getName(), (int)30, (int)3);
        this.myMessagePanel.setLoadingText(SpringBootRunBundle.message("spring.boot.application.endpoints.application.is.starting", name));
        this.myMessagePanel.startLoading();
        this.myMessageLabel = new JBLabel();
        this.myMessageLabel.setForeground((Color)JBColor.GRAY);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.weighty = 0.66;
        this.myMessagePanel.add((Component)this.myMessageLabel, (Object)gbc);
        gbc.weighty = 0.33;
        gbc.gridy = 1;
        this.myMessagePanel.add((Component)new JBLabel(), (Object)gbc);
        this.myRootPanel.add(MESSAGE_CARD, ScrollPaneFactory.createScrollPane((Component)this.myMessagePanel, (int)20, (int)30));
    }

    @NotNull
    public abstract String getId();

    public abstract String getTitle();

    public abstract Icon getIcon();

    public void dispose() {
        SpringBootApplicationInfo info = this.getInfo();
        if (info != null) {
            LiveProperty property = this.getLiveProperty(info);
            property.removePropertyListener(this.myPropertyListener);
            this.getPropertyListeners().forEach(arg_0 -> ((LiveProperty)property).addPropertyListener(arg_0));
        }
        this.myTooltipChangeListener = null;
    }

    public final JComponent getComponent() {
        this.myRootPanel.add(ENDPOINT_CARD, this.getEndpointComponent());
        return this.myRootPanel;
    }

    public final void refresh() {
        SpringBootApplicationInfo info = this.getInfo();
        if (info != null) {
            this.getLiveProperty(info).compute();
        }
    }

    public final void initPropertyListener(@NotNull SpringBootApplicationInfo info) {
        if (info == null) {
            EndpointTab.$$$reportNull$$$0(2);
        }
        LiveProperty property = this.getLiveProperty(info);
        property.addPropertyListener(this.myPropertyListener);
        this.getPropertyListeners().forEach(arg_0 -> ((LiveProperty)property).addPropertyListener(arg_0));
    }

    public final void showMessage(@Nullable String message) {
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.getProject(), () -> {
            if (this.myMessagePanel.isLoading()) {
                this.myMessagePanel.stopLoading();
            }
            this.myRootPanelLayout.show(this.myRootPanel, MESSAGE_CARD);
            this.myMessageLabel.setText(message);
        });
    }

    public final void showLoading() {
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.getProject(), () -> {
            this.myMessageLabel.setText(null);
            this.myMessagePanel.startLoading();
            this.myRootPanelLayout.show(this.myRootPanel, MESSAGE_CARD);
        });
    }

    public final void setTooltipChangeListener(@Nullable TooltipChangeListener tooltipChangeListener) {
        this.myTooltipChangeListener = tooltipChangeListener;
    }

    @NotNull
    protected final Project getProject() {
        Project project = this.myRunConfiguration.getProject();
        if (project == null) {
            EndpointTab.$$$reportNull$$$0(3);
        }
        return project;
    }

    @NotNull
    protected final SpringBootEndpointsTabSettings getSettings() {
        SpringBootEndpointsTabSettings springBootEndpointsTabSettings = this.mySettings;
        if (springBootEndpointsTabSettings == null) {
            EndpointTab.$$$reportNull$$$0(4);
        }
        return springBootEndpointsTabSettings;
    }

    public void updateRefreshAction(AnActionEvent e, @NotNull SpringBootApplicationInfo info) {
        if (info == null) {
            EndpointTab.$$$reportNull$$$0(5);
        }
    }

    @NotNull
    protected final SpringBootApplicationRunConfiguration getRunConfiguration() {
        SpringBootApplicationRunConfiguration springBootApplicationRunConfiguration = this.myRunConfiguration;
        if (springBootApplicationRunConfiguration == null) {
            EndpointTab.$$$reportNull$$$0(6);
        }
        return springBootApplicationRunConfiguration;
    }

    @NotNull
    protected final ProcessHandler getProcessHandler() {
        ProcessHandler processHandler = this.myProcessHandler;
        if (processHandler == null) {
            EndpointTab.$$$reportNull$$$0(7);
        }
        return processHandler;
    }

    @NotNull
    protected final JPanel getRootPanel() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            EndpointTab.$$$reportNull$$$0(8);
        }
        return jPanel;
    }

    protected final boolean isTabSelected(AnActionEvent e) {
        return this.equals(e.getData(SpringBootApplicationEndpointsTab.SELECTED_TAB_KEY));
    }

    protected final void setTimeStampTooltip(long timeStamp) {
        if (this.myTooltipChangeListener != null) {
            String message = null;
            if (timeStamp > 0L) {
                message = SpringBootRunBundle.message("spring.boot.application.endpoints.updated.at", DateFormatUtil.formatTimeWithSeconds((long)timeStamp));
            }
            this.myTooltipChangeListener.tooltipChanged(message);
        }
    }

    protected final boolean isTabLoading() {
        return this.myMessagePanel.isLoading();
    }

    @Nullable
    protected final SpringBootApplicationInfo getInfo() {
        Project project = this.getProject();
        if (!project.isOpen() || project.isDisposed()) {
            return null;
        }
        return SpringBootApplicationLifecycleManager.getInstance((Project)project).getSpringBootApplicationInfo(this.myProcessHandler);
    }

    protected final void infoRemoved() {
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.getProject(), () -> {
            if (this.myMessagePanel.isLoading()) {
                this.myMessagePanel.stopLoading();
            }
        });
    }

    protected void updateActionPresentation(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        boolean visible = this.isTabSelected(e);
        presentation.setVisible(visible);
        if (!visible) {
            presentation.setEnabled(false);
            return;
        }
        SpringBootApplicationInfo info = this.getInfo();
        presentation.setEnabled(info != null && Boolean.TRUE.equals(info.getReadyState().getValue()) && !this.isTabLoading());
    }

    @NotNull
    protected List<AnAction> getToolbarActions() {
        List<AnAction> list = Collections.emptyList();
        if (list == null) {
            EndpointTab.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    protected List<LiveProperty.LivePropertyListener> getPropertyListeners() {
        List<LiveProperty.LivePropertyListener> list = Collections.emptyList();
        if (list == null) {
            EndpointTab.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    protected abstract LiveProperty getLiveProperty(SpringBootApplicationInfo var1);

    @NotNull
    protected abstract JComponent getEndpointComponent();

    protected abstract void updateComponent();

    @Nullable
    protected abstract String getErrorMessage(String var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/tabs/EndpointTab";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/tabs/EndpointTab";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunConfiguration";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessHandler";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootPanel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarActions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyListeners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initPropertyListener";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateRefreshAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected abstract class EndpointToggleAction
    extends ToggleAction {
        protected EndpointToggleAction(String text) {
            super(text);
        }

        protected EndpointToggleAction(@Nullable String text, @Nullable String description, Icon icon) {
            super(text, description, icon);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                EndpointToggleAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            EndpointTab.this.updateActionPresentation(e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/spring/boot/run/lifecycle/tabs/EndpointTab$EndpointToggleAction", "update"));
        }
    }

    static interface TooltipChangeListener {
        public void tooltipChanged(@Nullable String var1);
    }
}

