/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.tabs;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.beans.LiveBean;
import com.intellij.spring.boot.run.lifecycle.beans.LiveBeansModel;
import com.intellij.spring.boot.run.lifecycle.beans.LiveContext;
import com.intellij.spring.boot.run.lifecycle.beans.LiveResource;
import com.intellij.spring.boot.run.lifecycle.tabs.LifecycleFinderRecursivePanel;
import com.intellij.spring.boot.run.lifecycle.tabs.SpringBootEndpointsTabSettings;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.xml.util.PsiElementPointer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiveBeansPanel
extends LifecycleFinderRecursivePanel<LiveBeanItem> {
    public static final ExtensionPointName<LiveBeansPanelContent> EP_NAME = ExtensionPointName.create((String)"com.intellij.spring.boot.run.liveBeanPanelContent");
    private static final String LIVE_BEANS_PANEL_GROUP_ID = "LiveBeansPanel";
    private final NullableFactory<CommonSpringModel> myModelFactory;
    private final NavigateToBeanClassAction myNavigateAction;
    private final LiveContext myContext;
    private final LiveResource myResource;

    public LiveBeansPanel(@NotNull Project project, @NotNull SpringBootApplicationRunConfiguration runConfiguration, @NotNull ProcessHandler processHandler) {
        if (project == null) {
            LiveBeansPanel.$$$reportNull$$$0(0);
        }
        if (runConfiguration == null) {
            LiveBeansPanel.$$$reportNull$$$0(1);
        }
        if (processHandler == null) {
            LiveBeansPanel.$$$reportNull$$$0(2);
        }
        this(project, null, LIVE_BEANS_PANEL_GROUP_ID, runConfiguration, processHandler, null, null);
    }

    public LiveBeansPanel(@NotNull Project project, @Nullable FinderRecursivePanel parent, @Nullable String groupId, @NotNull SpringBootApplicationRunConfiguration runConfiguration, @NotNull ProcessHandler processHandler, @Nullable LiveContext context, @Nullable LiveResource resource) {
        if (project == null) {
            LiveBeansPanel.$$$reportNull$$$0(3);
        }
        if (runConfiguration == null) {
            LiveBeansPanel.$$$reportNull$$$0(4);
        }
        if (processHandler == null) {
            LiveBeansPanel.$$$reportNull$$$0(5);
        }
        super(project, parent, groupId, runConfiguration, processHandler);
        this.myContext = context;
        this.myResource = resource;
        this.myModelFactory = () -> {
            Module module = this.getRunConfiguration().getModule();
            return module == null ? null : SpringManager.getInstance((Project)this.getProject()).getCombinedModel(module);
        };
        this.myNavigateAction = new NavigateToBeanClassAction();
    }

    @NotNull
    protected List<LiveBeanItem> getListItems() {
        List beans;
        if (this.myContext != null) {
            beans = this.myContext.getBeans();
        } else if (this.myResource != null) {
            beans = this.myResource.getBeans();
        } else {
            LiveBeansModel model = this.getModel();
            if (model == null) {
                List<LiveBeanItem> list = Collections.emptyList();
                if (list == null) {
                    LiveBeansPanel.$$$reportNull$$$0(6);
                }
                return list;
            }
            beans = model.getBeans();
        }
        Collections.sort(beans, Comparator.comparing(LiveBean::getName, NaturalComparator.INSTANCE));
        CommonSpringModel springModel = (CommonSpringModel)this.myModelFactory.create();
        HashMap resourceElements = new HashMap();
        SpringBootApplicationRunConfiguration runConfiguration = this.getRunConfiguration();
        Module module = runConfiguration.getModule();
        PsiClass mainClass = runConfiguration.getMainClass();
        GlobalSearchScope searchScope = ((JavaRunConfigurationModule)runConfiguration.getConfigurationModule()).getSearchScope();
        List<LiveBeanItem> list = beans.stream().map(bean -> {
            LiveBeanItem item = new LiveBeanItem(this.getProject(), (LiveBean)bean);
            PsiElement resourceElement = null;
            if (bean.getResource() != null) {
                if (resourceElements.containsKey(bean.getResource())) {
                    resourceElement = (PsiElement)resourceElements.get(bean.getResource());
                } else {
                    resourceElement = bean.getResource().getResourceElement(this.getProject(), module, (PsiElement)mainClass, searchScope);
                    resourceElements.put(bean.getResource(), resourceElement);
                }
            }
            item.updateItem(resourceElement, springModel, searchScope);
            return item;
        }).collect(Collectors.toList());
        if (list == null) {
            LiveBeansPanel.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    protected String getItemText(LiveBeanItem item) {
        String string = item.getBean().getName();
        if (string == null) {
            LiveBeansPanel.$$$reportNull$$$0(8);
        }
        return string;
    }

    protected boolean hasChildren(LiveBeanItem item) {
        return false;
    }

    @Nullable
    protected VirtualFile getContainingFile(LiveBeanItem item) {
        PsiElement beanElement = item.getPointer().getPsiElement();
        if (beanElement != null && beanElement.isValid() && beanElement.getContainingFile() != null) {
            return beanElement.getContainingFile().getVirtualFile();
        }
        return null;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        Object data;
        LiveBeanItem selectedValue = (LiveBeanItem)this.getSelectedValue();
        if (selectedValue != null) {
            PsiElement element;
            if (CommonDataKeys.NAVIGATABLE.is(dataId) || CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                return selectedValue.getPointer().getPsiElement();
            }
            if (CommonDataKeys.PSI_FILE.is(dataId) && (element = selectedValue.getPointer().getPsiElement()) != null) {
                return element.getContainingFile();
            }
        }
        if ((data = super.getData(dataId)) != null) {
            return data;
        }
        for (LiveBeansPanelContent content : (LiveBeansPanelContent[])EP_NAME.getExtensions()) {
            Object contentData = content.getData(this, dataId);
            if (contentData == null) continue;
            return contentData;
        }
        return null;
    }

    @Nullable
    protected Icon getItemIcon(LiveBeanItem item) {
        PsiElementPointer pointer = item.getPointer();
        return pointer instanceof SpringBeanPointer ? SpringPresentationProvider.getSpringIcon((Object)pointer) : item.getBean().getIcon();
    }

    @Nullable
    protected JComponent createDefaultRightComponent() {
        SpringBootEndpointsTabSettings settings = SpringBootEndpointsTabSettings.getInstance(this.getProject());
        if (!(settings.isShowDoc() || settings.isShowLiveBeansGraph() && ((LiveBeansPanelContent[])EP_NAME.getExtensions()).length != 0)) {
            return null;
        }
        return super.createDefaultRightComponent();
    }

    @Nullable
    protected JComponent createRightComponent(LiveBeanItem item) {
        SpringBootEndpointsTabSettings settings = SpringBootEndpointsTabSettings.getInstance(this.getProject());
        LiveBeansPanelContent[] contentExtensions = (LiveBeansPanelContent[])EP_NAME.getExtensions();
        if (!(settings.isShowDoc() || settings.isShowLiveBeansGraph() && contentExtensions.length != 0)) {
            return null;
        }
        FinderRecursivePanel.DisposablePanel panel = new FinderRecursivePanel.DisposablePanel((LayoutManager)new BorderLayout(), (Disposable)this);
        OnePixelSplitter splitter = new OnePixelSplitter(true);
        splitter.setProportion(0.5f);
        panel.add((Component)splitter, (Object)"Center");
        if (settings.isShowDoc()) {
            PsiElement element = item.getPointer().getPsiElement();
            if (item.getPointer() instanceof LiveBean.LiveResourcePointer || element == null) {
                splitter.setFirstComponent((JComponent)new JBPanelWithEmptyText().withEmptyText(CodeInsightBundle.message((String)"no.documentation.found", (Object[])new Object[0])));
            } else {
                DocumentationManager manager = DocumentationManager.getInstance((Project)this.getProject());
                DocumentationComponent documentationComponent = new DocumentationComponent(manager);
                Disposer.register((Disposable)panel, (Disposable)documentationComponent);
                manager.fetchDocInfo(element, documentationComponent);
                splitter.setFirstComponent((JComponent)documentationComponent);
            }
        }
        if (settings.isShowLiveBeansGraph()) {
            SpringBootApplicationRunConfiguration runConfiguration = this.getRunConfiguration();
            LiveBeanContext beanContext = new LiveBeanContext(this.getProject(), runConfiguration.getModule(), runConfiguration.getMainClass(), ((JavaRunConfigurationModule)runConfiguration.getConfigurationModule()).getSearchScope(), this.myModelFactory);
            for (LiveBeansPanelContent content : contentExtensions) {
                splitter.setSecondComponent(content.createComponent(this, (Disposable)panel, item.getBean(), beanContext));
            }
        }
        return panel;
    }

    public void setSecondComponent(@Nullable JComponent component) {
        super.setSecondComponent(component);
        if (!SpringBootEndpointsTabSettings.getInstance(this.getProject()).isShowLiveBeansGraph()) {
            return;
        }
        for (LiveBeansPanelContent content : (LiveBeansPanelContent[])EP_NAME.getExtensions()) {
            content.update(this);
        }
    }

    protected AnAction[] getCustomListActions() {
        return new AnAction[]{this.myNavigateAction};
    }

    @Override
    protected JBList<LiveBeanItem> createList() {
        JBList list = super.createList();
        this.myNavigateAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("EditSource").getShortcutSet(), (JComponent)list);
        return list;
    }

    @Nullable
    protected String getItemTooltipText(LiveBeanItem item) {
        return item.getBean().getClassName();
    }

    @Override
    protected boolean doUpdateItem(@NotNull LiveBeanItem item) {
        if (item == null) {
            LiveBeansPanel.$$$reportNull$$$0(9);
        }
        LiveBean bean = item.getBean();
        SpringBootApplicationRunConfiguration runConfiguration = this.getRunConfiguration();
        GlobalSearchScope searchScope = ((JavaRunConfigurationModule)runConfiguration.getConfigurationModule()).getSearchScope();
        PsiElement resourceElement = null;
        if (bean.getResource() != null) {
            resourceElement = bean.getResource().getResourceElement(this.getProject(), runConfiguration.getModule(), (PsiElement)runConfiguration.getMainClass(), searchScope);
        }
        return item.updateItem(resourceElement, (CommonSpringModel)this.myModelFactory.create(), searchScope);
    }

    @Override
    protected String getEditActionHintMessage(@NotNull LiveBeanItem item) {
        if (item == null) {
            LiveBeansPanel.$$$reportNull$$$0(10);
        }
        return SpringBootRunBundle.message("spring.boot.application.endpoints.bean.definition.not.found", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/tabs/LiveBeansPanel";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/tabs/LiveBeansPanel";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getListItems";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateItem";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getEditActionHintMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class NavigateToBeanClassAction
    extends AnAction {
        NavigateToBeanClassAction() {
            super(SpringBootRunBundle.message("spring.boot.application.endpoints.navigate.to.bean.class.action.name", new Object[0]), SpringBootRunBundle.message("spring.boot.application.endpoints.navigate.to.bean.class.action.description", new Object[0]), AllIcons.Nodes.Class);
        }

        public void update(AnActionEvent e) {
            LiveBeanItem value = (LiveBeanItem)LiveBeansPanel.this.getSelectedValue();
            e.getPresentation().setEnabled(value != null && value.getBeanClass() != null);
        }

        public void actionPerformed(AnActionEvent e) {
            LiveBeanItem value = (LiveBeanItem)LiveBeansPanel.this.getSelectedValue();
            if (value == null) {
                return;
            }
            LiveBeansPanel.this.updateItem(value);
            PsiClass beanClass = value.getBeanClass();
            if (beanClass != null && beanClass.canNavigate()) {
                beanClass.navigate(true);
            } else {
                LiveBeansPanel.this.showHint(SpringBootRunBundle.message("spring.boot.application.endpoints.bean.class.not.found", new Object[0]));
            }
        }
    }

    static class LiveBeanItem {
        @NotNull
        private final Project myProject;
        @NotNull
        private final LiveBean myBean;
        @NotNull
        private PsiElementPointer myPointer;
        @Nullable
        private PsiClass myBeanClass;

        LiveBeanItem(@NotNull Project project, @NotNull LiveBean bean) {
            if (project == null) {
                LiveBeanItem.$$$reportNull$$$0(0);
            }
            if (bean == null) {
                LiveBeanItem.$$$reportNull$$$0(1);
            }
            this.myPointer = () -> null;
            this.myProject = project;
            this.myBean = bean;
        }

        @NotNull
        public LiveBean getBean() {
            LiveBean liveBean = this.myBean;
            if (liveBean == null) {
                LiveBeanItem.$$$reportNull$$$0(2);
            }
            return liveBean;
        }

        @NotNull
        public PsiElementPointer getPointer() {
            if (DumbService.isDumb((Project)this.myProject) || this.myPointer instanceof SpringBeanPointer && !((SpringBeanPointer)this.myPointer).isValid()) {
                PsiElementPointer psiElementPointer = () -> null;
                if (psiElementPointer == null) {
                    LiveBeanItem.$$$reportNull$$$0(3);
                }
                return psiElementPointer;
            }
            PsiElementPointer psiElementPointer = this.myPointer;
            if (psiElementPointer == null) {
                LiveBeanItem.$$$reportNull$$$0(4);
            }
            return psiElementPointer;
        }

        @Nullable
        public PsiClass getBeanClass() {
            return DumbService.isDumb((Project)this.myProject) ? null : this.myBeanClass;
        }

        public boolean updateItem(PsiElement resourceElement, CommonSpringModel springModel, GlobalSearchScope searchScope) {
            boolean changed = this.updateBeanClass(searchScope);
            return this.updateBeanPointer(resourceElement, springModel) || changed;
        }

        private boolean updateBeanClass(GlobalSearchScope searchScope) {
            PsiClass beanClass = this.myBean.getBeanClass(this.myProject, searchScope);
            boolean changed = !Comparing.equal((Object)beanClass, (Object)this.myBeanClass);
            this.myBeanClass = beanClass;
            return changed;
        }

        private boolean updateBeanPointer(@Nullable PsiElement resourceElement, @Nullable CommonSpringModel springModel) {
            if (resourceElement != null && !resourceElement.isValid()) {
                resourceElement = null;
            }
            PsiElementPointer pointer = this.myBean.getBeanPointer(this.myBeanClass, resourceElement, springModel);
            boolean changed = this.myPointer instanceof SpringBeanPointer ? !this.myPointer.equals(pointer) : (pointer instanceof SpringBeanPointer ? !pointer.equals(this.myPointer) : !Comparing.equal((Object)this.myPointer.getPsiElement(), (Object)pointer.getPsiElement()));
            this.myPointer = pointer;
            return changed;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof LiveBeanItem) {
                return this.myBean.equals(((LiveBeanItem)obj).myBean);
            }
            return false;
        }

        public int hashCode() {
            return this.myBean.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bean";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/tabs/LiveBeansPanel$LiveBeanItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/tabs/LiveBeansPanel$LiveBeanItem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBean";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPointer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class LiveBeanContext {
        public final Project project;
        public final Module module;
        public final PsiClass mainClass;
        public final GlobalSearchScope searchScope;
        public final NullableFactory<CommonSpringModel> modelFactory;

        public LiveBeanContext(Project project, Module module, PsiClass mainClass, GlobalSearchScope searchScope, NullableFactory<CommonSpringModel> modelFactory) {
            this.project = project;
            this.module = module;
            this.mainClass = mainClass;
            this.searchScope = searchScope;
            this.modelFactory = modelFactory;
        }
    }

    public static interface LiveBeansPanelContent {
        public JComponent createComponent(FinderRecursivePanel var1, Disposable var2, LiveBean var3, LiveBeanContext var4);

        public void update(FinderRecursivePanel var1);

        public Object getData(FinderRecursivePanel var1, @NonNls String var2);
    }
}

