/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.tabs;

import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.dashboard.hyperlink.RunDashboardHyperlinkComponent;
import com.intellij.execution.dashboard.hyperlink.RunDashboardHyperlinkTextComponent;
import com.intellij.execution.dashboard.tree.RunDashboardLinkMouseListenerBase;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManager;
import com.intellij.spring.boot.run.lifecycle.mappings.LiveHandlerMethod;
import com.intellij.spring.boot.run.lifecycle.mappings.LiveRequestMapping;
import com.intellij.spring.boot.run.lifecycle.tabs.SpringBootEndpointsTabSettings;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.table.BaseTableView;
import com.intellij.ui.table.TableView;
import com.intellij.util.config.Storage;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import icons.SpringApiIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RequestMappingsPanel
extends JPanel
implements Disposable {
    private static final String STORAGE_PREFIX = "RequestMappingsPanel";
    private static final String NOTIFICATION_DISPLAY_ID = "Spring Boot Application Request Mappings";
    private final Project myProject;
    private final SpringBootApplicationRunConfiguration myRunConfiguration;
    private final ProcessHandler myProcessHandler;
    private final NullableFactory<CommonSpringModel> myModelFactory;
    private final TableView<LiveRequestMappingItem> myTableView;
    private final ListTableModel<LiveRequestMappingItem> myModel;
    private String myDefaultPath;
    private final MergingUpdateQueue myMergingUpdateQueue;
    private final Storage myStorage;

    RequestMappingsPanel(@NotNull Project project, @NotNull SpringBootApplicationRunConfiguration runConfiguration, @NotNull ProcessHandler processHandler, List<AnAction> customActions) {
        if (project == null) {
            RequestMappingsPanel.$$$reportNull$$$0(0);
        }
        if (runConfiguration == null) {
            RequestMappingsPanel.$$$reportNull$$$0(1);
        }
        if (processHandler == null) {
            RequestMappingsPanel.$$$reportNull$$$0(2);
        }
        super(new BorderLayout());
        this.myMergingUpdateQueue = new MergingUpdateQueue("RequestMappingsTableView", 100, true, (JComponent)this, (Disposable)this);
        this.myProject = project;
        this.myRunConfiguration = runConfiguration;
        this.myProcessHandler = processHandler;
        this.myModelFactory = () -> {
            Module module = this.myRunConfiguration.getModule();
            return module == null ? null : SpringManager.getInstance((Project)this.myProject).getCombinedModel(module);
        };
        this.myModel = new ListTableModel(new ColumnInfo[]{new RequestMappingsColumnInfo<LiveRequestMapping>(SpringBootRunBundle.message("spring.boot.application.endpoints.mappings.path", new Object[0])){

            public LiveRequestMapping valueOf(LiveRequestMappingItem item) {
                return item.getMapping();
            }

            @Override
            protected String getItemTooltipText(LiveRequestMapping mapping) {
                String tooltip = mapping.getMapping();
                tooltip = StringUtil.trimStart((String)tooltip, (String)"{");
                tooltip = StringUtil.trimEnd((String)tooltip, (String)"}");
                tooltip = tooltip.replaceAll(",", "<br>");
                return String.format("<html><body>%s</body></html>", tooltip);
            }

            @Nullable
            public Comparator<LiveRequestMappingItem> getComparator() {
                return Comparator.comparing(item -> item.getMapping().getPath(), StringUtil::naturalCompare);
            }
        }, new RequestMappingsStringColumnInfo(SpringBootRunBundle.message("spring.boot.application.endpoints.mappings.method", new Object[0])){

            @Nullable
            public String valueOf(LiveRequestMappingItem item) {
                LiveHandlerMethod method = item.getMapping().getMethod();
                return method == null ? null : method.getDisplayName();
            }

            @Override
            @Nullable
            protected String getItemTooltipText(LiveRequestMapping mapping) {
                LiveHandlerMethod method = mapping.getMethod();
                return method == null ? null : method.getRawMethod();
            }
        }, new RequestMappingsStringColumnInfo(SpringBootRunBundle.message("spring.boot.application.endpoints.mappings.bean", new Object[0])){

            @Nullable
            public String valueOf(LiveRequestMappingItem item) {
                return item.getMapping().getBean();
            }
        }});
        this.myTableView = new TableView(this.myModel);
        this.myTableView.getSelectionModel().setSelectionMode(0);
        RequestMappingLinkMouseListener linkMouseListener = new RequestMappingLinkMouseListener();
        linkMouseListener.installOn((Component)this.myTableView);
        new TableSpeedSearch(this.myTableView);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(this.myTableView, (int)20, (int)31);
        this.add((Component)scrollPane, "Center");
        this.installTableActions(customActions);
        this.installDoubleClickListener();
        this.myStorage = new Storage.PropertiesComponentStorage(STORAGE_PREFIX, PropertiesComponent.getInstance((Project)project));
        BaseTableView.restore((Storage)this.myStorage, this.myTableView);
    }

    public void dispose() {
        this.myMergingUpdateQueue.cancelAllUpdates();
        BaseTableView.store((Storage)this.myStorage, this.myTableView);
    }

    void setItems(final List<LiveRequestMapping> mappings) {
        this.myTableView.setPaintBusy(true);
        SpringBootEndpointsTabSettings settings = SpringBootEndpointsTabSettings.getInstance(this.myProject);
        final boolean showLibraryMappings = settings.isShowLibraryMappings();
        final HashSet filteredRequestMethods = ContainerUtil.newHashSet(settings.getFilteredRequestMethods());
        this.myMergingUpdateQueue.queue(new Update("update"){

            public void run() {
                int oldIndex = RequestMappingsPanel.this.myTableView.getSelectedRow();
                ApplicationManager.getApplication().executeOnPooledThread(() -> DumbService.getInstance((Project)RequestMappingsPanel.this.myProject).runReadActionInSmartMode(() -> {
                    try {
                        GlobalSearchScope searchScope = ((JavaRunConfigurationModule)RequestMappingsPanel.this.myRunConfiguration.getConfigurationModule()).getSearchScope();
                        List items = mappings.stream().map(mapping -> {
                            LiveHandlerMethod mappingMethod = mapping.getMethod();
                            VirtualFile file = mappingMethod == null ? null : RequestMappingsPanel.this.getContainingFile(mappingMethod, searchScope);
                            return new LiveRequestMappingItem((LiveRequestMapping)mapping, file);
                        }).filter(item -> {
                            List requestMethods = item.getMapping().getRequestMethods();
                            if (!requestMethods.isEmpty() && filteredRequestMethods.containsAll(item.getMapping().getRequestMethods())) {
                                return false;
                            }
                            if (showLibraryMappings || item.getContainingFile() == null) {
                                return true;
                            }
                            return RequestMappingsPanel.this.myRunConfiguration.getModule().getModuleWithDependenciesScope().contains(item.getContainingFile());
                        }).collect(Collectors.toList());
                        AppUIUtil.invokeLaterIfProjectAlive((Project)RequestMappingsPanel.this.myProject, () -> {
                            RequestMappingsPanel.this.myModel.setItems(items);
                            if (oldIndex >= 0 && oldIndex < RequestMappingsPanel.this.myTableView.getRowCount()) {
                                RequestMappingsPanel.this.myTableView.setRowSelectionInterval(oldIndex, oldIndex);
                            }
                        });
                    }
                    finally {
                        RequestMappingsPanel.this.myTableView.setPaintBusy(false);
                    }
                }));
            }
        });
    }

    void setDefaultPath(String defaultPath) {
        this.myDefaultPath = defaultPath;
        this.myTableView.revalidate();
        this.myTableView.repaint();
    }

    @Nullable
    LiveRequestMapping getSelectedMapping() {
        LiveRequestMappingItem item = (LiveRequestMappingItem)this.myTableView.getSelectedObject();
        return item == null ? null : item.getMapping();
    }

    private void installTableActions(List<AnAction> customActions) {
        DefaultActionGroup contextActionGroup = new DefaultActionGroup();
        AnAction editAction = new AnAction(SpringBootRunBundle.message("spring.boot.application.endpoints.mappings.edit.action.name", new Object[0]), null, AllIcons.Actions.Edit){

            public void update(AnActionEvent e) {
                LiveRequestMapping mapping = RequestMappingsPanel.this.getSelectedMapping();
                LiveHandlerMethod mappingMethod = mapping != null ? mapping.getMethod() : null;
                e.getPresentation().setEnabled(mappingMethod != null);
            }

            public void actionPerformed(AnActionEvent e) {
                RequestMappingsPanel.this.performEditAction(e.getDataContext());
            }
        };
        editAction.registerCustomShortcutSet(CommonShortcuts.ENTER, this.myTableView);
        contextActionGroup.add(editAction);
        contextActionGroup.addSeparator();
        AnAction beanAction = new AnAction(SpringBootRunBundle.message("spring.boot.application.endpoints.mappings.bean.action.name", new Object[0]), null, SpringApiIcons.SpringBean){

            public void update(AnActionEvent e) {
                LiveRequestMapping mapping = RequestMappingsPanel.this.getSelectedMapping();
                String beanName = mapping != null ? mapping.getBean() : null;
                e.getPresentation().setEnabled(beanName != null && SpringCommonUtils.hasSpringFacet((Module)RequestMappingsPanel.this.myRunConfiguration.getModule()));
            }

            public void actionPerformed(AnActionEvent e) {
                RequestMappingsPanel.this.performNavigateToBeanAction(e.getDataContext());
            }
        };
        beanAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("EditSource").getShortcutSet(), this.myTableView);
        contextActionGroup.add(beanAction);
        contextActionGroup.addSeparator();
        contextActionGroup.addAll(customActions);
        PopupHandler.installUnknownPopupHandler(this.myTableView, (ActionGroup)contextActionGroup, (ActionManager)ActionManager.getInstance());
    }

    private void installDoubleClickListener() {
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                RequestMappingsPanel.this.performEditAction(DataManager.getInstance().getDataContext((Component)RequestMappingsPanel.this.myTableView));
                return true;
            }
        }.installOn(this.myTableView);
    }

    private void performEditAction(DataContext dataContext) {
        PsiMethod method;
        LiveHandlerMethod mappingMethod;
        if (DumbService.isDumb((Project)this.myProject)) {
            return;
        }
        LiveRequestMappingItem item = (LiveRequestMappingItem)this.myTableView.getSelectedObject();
        LiveHandlerMethod liveHandlerMethod = mappingMethod = item != null ? item.getMapping().getMethod() : null;
        if (mappingMethod == null) {
            return;
        }
        GlobalSearchScope searchScope = ((JavaRunConfigurationModule)this.myRunConfiguration.getConfigurationModule()).getSearchScope();
        VirtualFile file = this.getContainingFile(mappingMethod, searchScope);
        if (!Comparing.equal((Object)file, (Object)item.getContainingFile())) {
            item.setContainingFile(file);
            this.myTableView.revalidate();
            this.myTableView.repaint();
        }
        if ((method = mappingMethod.getMethod(this.myProject, searchScope)) != null && method.canNavigate()) {
            method.navigate(true);
        } else {
            this.showBalloon(dataContext, SpringBootRunBundle.message("spring.boot.application.endpoints.mappings.method.not.found", new Object[0]));
        }
    }

    private void performNavigateToBeanAction(DataContext dataContext) {
        Navigatable navigatable;
        PsiElement element;
        SpringBeanPointer pointer;
        String beanName;
        if (DumbService.isDumb((Project)this.myProject)) {
            return;
        }
        LiveRequestMapping mapping = this.getSelectedMapping();
        String string = beanName = mapping != null ? mapping.getBean() : null;
        if (beanName == null) {
            return;
        }
        CommonSpringModel model = (CommonSpringModel)this.myModelFactory.create();
        if (model != null && (pointer = SpringModelSearchers.findBean((CommonSpringModel)model, (String)beanName)) != null && pointer.isValid() && (element = pointer.getPsiElement()) instanceof Navigatable && (navigatable = (Navigatable)element).canNavigate()) {
            navigatable.navigate(true);
            return;
        }
        this.showBalloon(dataContext, SpringBootRunBundle.message("spring.boot.application.endpoints.mappings.bean.not.found", new Object[0]));
    }

    private void showBalloon(DataContext dataContext, String message) {
        ToolWindow toolWindow = (ToolWindow)dataContext.getData(PlatformDataKeys.TOOL_WINDOW);
        if (toolWindow instanceof ToolWindowImpl) {
            NotificationGroup.toolWindowGroup((String)NOTIFICATION_DISPLAY_ID, (String)((ToolWindowImpl)toolWindow).getId(), (boolean)false).createNotification(message, MessageType.WARNING).notify(this.myProject);
        }
    }

    @Nullable
    private VirtualFile getContainingFile(@NotNull LiveHandlerMethod method, @NotNull GlobalSearchScope searchScope) {
        PsiClass psiClass;
        if (method == null) {
            RequestMappingsPanel.$$$reportNull$$$0(3);
        }
        if (searchScope == null) {
            RequestMappingsPanel.$$$reportNull$$$0(4);
        }
        if ((psiClass = method.getContainingClass(this.myProject, searchScope)) != null && psiClass.getContainingFile() != null) {
            return psiClass.getContainingFile().getVirtualFile();
        }
        return null;
    }

    @Nullable
    static String getDisplayRequestMethods(LiveRequestMapping mapping) {
        List requestMethods = mapping.getRequestMethods();
        if (requestMethods.isEmpty()) {
            return null;
        }
        return " [" + StringUtil.join((Collection)requestMethods, (String)"|") + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/tabs/RequestMappingsPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getContainingFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class RequestMappingHyperlinkComponent
    extends RunDashboardHyperlinkTextComponent {
        private String myUrl;

        RequestMappingHyperlinkComponent() {
            super(null, "");
            this.setLinkListener(e -> {
                if (this.myUrl != null) {
                    BrowserUtil.browse((String)this.myUrl);
                }
            });
        }

        void setUrl(String url) {
            this.myUrl = url;
        }
    }

    private static class RequestMappingLinkMouseListener
    extends RunDashboardLinkMouseListenerBase {
        private RequestMappingLinkMouseListener() {
        }

        protected void repaintComponent(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int row = table.rowAtPoint(e.getPoint());
            int column = table.columnAtPoint(e.getPoint());
            if (row == -1 || column == -1) {
                table.repaint();
            } else {
                ((ListTableModel)table.getModel()).fireTableCellUpdated(row, column);
            }
        }

        @Nullable
        protected RunDashboardHyperlinkComponent getTagAt(@NotNull MouseEvent e) {
            if (e == null) {
                RequestMappingLinkMouseListener.$$$reportNull$$$0(0);
            }
            JTable table = (JTable)e.getSource();
            int row = table.rowAtPoint(e.getPoint());
            int column = table.columnAtPoint(e.getPoint());
            if (row == -1 || column == -1) {
                return null;
            }
            Object tag = null;
            TableCellRenderer cellRenderer = table.getCellRenderer(row, column);
            if (cellRenderer instanceof ColoredTableCellRenderer) {
                ColoredTableCellRenderer renderer = (ColoredTableCellRenderer)cellRenderer;
                renderer.getTableCellRendererComponent(table, table.getValueAt(row, column), false, false, row, column);
                Rectangle rectangle = table.getCellRect(row, column, false);
                tag = renderer.getFragmentTagAt(e.getX() - rectangle.x);
            }
            if (tag instanceof RunDashboardHyperlinkComponent) {
                return (RunDashboardHyperlinkComponent)tag;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/spring/boot/run/lifecycle/tabs/RequestMappingsPanel$RequestMappingLinkMouseListener", "getTagAt"));
        }
    }

    private static class LiveRequestMappingItem {
        private final LiveRequestMapping myMapping;
        private final RequestMappingHyperlinkComponent myHyperlinkComponent;
        private VirtualFile myContainingFile;

        LiveRequestMappingItem(@NotNull LiveRequestMapping mapping, @Nullable VirtualFile containingFile) {
            if (mapping == null) {
                LiveRequestMappingItem.$$$reportNull$$$0(0);
            }
            this.myMapping = mapping;
            this.myContainingFile = containingFile;
            this.myHyperlinkComponent = new RequestMappingHyperlinkComponent();
        }

        LiveRequestMapping getMapping() {
            return this.myMapping;
        }

        RequestMappingHyperlinkComponent getHyperlinkComponent() {
            return this.myHyperlinkComponent;
        }

        VirtualFile getContainingFile() {
            return this.myContainingFile;
        }

        void setContainingFile(@Nullable VirtualFile containingFile) {
            this.myContainingFile = containingFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/spring/boot/run/lifecycle/tabs/RequestMappingsPanel$LiveRequestMappingItem", "<init>"));
        }
    }

    private static class RequestMappingsTableCellRenderer
    extends ColoredTableCellRenderer {
        private final Project myProject;
        private final ProcessHandler myProcessHandler;
        private boolean myDefault;
        private VirtualFile myFile;
        private RequestMappingHyperlinkComponent myHyperlinkComponent;

        public RequestMappingsTableCellRenderer(@NotNull Project project, @NotNull ProcessHandler processHandler) {
            if (project == null) {
                RequestMappingsTableCellRenderer.$$$reportNull$$$0(0);
            }
            if (processHandler == null) {
                RequestMappingsTableCellRenderer.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myProcessHandler = processHandler;
        }

        void setDefault(boolean defaultPath) {
            this.myDefault = defaultPath;
        }

        void setFile(VirtualFile file) {
            this.myFile = file;
        }

        void setHyperlinkComponent(RequestMappingHyperlinkComponent component) {
            this.myHyperlinkComponent = component;
        }

        protected void customizeCellRenderer(JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
            if (value instanceof LiveRequestMapping) {
                String applicationUrl;
                SpringBootApplicationInfo info;
                LiveRequestMapping mapping = (LiveRequestMapping)value;
                String mappingUrl = null;
                if (mapping.canNavigate() && (info = SpringBootApplicationLifecycleManager.getInstance((Project)this.myProject).getSpringBootApplicationInfo(this.myProcessHandler)) != null && (applicationUrl = (String)info.getApplicationUrl().getValue()) != null) {
                    mappingUrl = LiveRequestMapping.appendMappingPath((String)applicationUrl, (String)mapping.getPath());
                }
                if (StringUtil.isEmpty(mappingUrl) || this.myHyperlinkComponent == null) {
                    this.append(mapping.getPath(), this.myDefault ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                } else {
                    this.myHyperlinkComponent.setText(mapping.getPath());
                    this.myHyperlinkComponent.setBold(this.myDefault);
                    this.myHyperlinkComponent.setSelected(selected);
                    this.myHyperlinkComponent.setUrl(mappingUrl);
                    this.myHyperlinkComponent.render((SimpleColoredComponent)this);
                }
                String requestMethods = RequestMappingsPanel.getDisplayRequestMethods(mapping);
                if (requestMethods != null) {
                    this.append(requestMethods, this.myDefault ? SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
            } else if (value instanceof String) {
                this.append((String)value, this.myDefault ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            if (!selected && this.myFile != null) {
                this.setBackground(EditorTabbedContainer.calcTabColor((Project)this.myProject, (VirtualFile)this.myFile));
            }
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)table, (SimpleColoredComponent)this, (boolean)true, (boolean)selected);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processHandler";
                    break;
                }
            }
            objectArray[1] = "com/intellij/spring/boot/run/lifecycle/tabs/RequestMappingsPanel$RequestMappingsTableCellRenderer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private abstract class RequestMappingsStringColumnInfo
    extends RequestMappingsColumnInfo<String> {
        RequestMappingsStringColumnInfo(String name) {
            super(name);
        }

        @Nullable
        public Comparator<LiveRequestMappingItem> getComparator() {
            return Comparator.comparing(arg_0 -> ((RequestMappingsStringColumnInfo)this).valueOf(arg_0), StringUtil::naturalCompare);
        }
    }

    private abstract class RequestMappingsColumnInfo<T>
    extends ColumnInfo<LiveRequestMappingItem, T> {
        private final RequestMappingsTableCellRenderer myRenderer;

        RequestMappingsColumnInfo(String name) {
            super(name);
            this.myRenderer = new RequestMappingsTableCellRenderer(RequestMappingsPanel.this.myProject, RequestMappingsPanel.this.myProcessHandler);
        }

        @Nullable
        public TableCellRenderer getRenderer(LiveRequestMappingItem item) {
            this.myRenderer.setToolTipText(this.getItemTooltipText(item.getMapping()));
            this.myRenderer.setDefault(item.getMapping().getPath().equals(RequestMappingsPanel.this.myDefaultPath));
            this.myRenderer.setFile(item.getContainingFile());
            this.myRenderer.setHyperlinkComponent(item.getHyperlinkComponent());
            return this.myRenderer;
        }

        @Nullable
        protected String getItemTooltipText(LiveRequestMapping mapping) {
            return null;
        }
    }
}

