/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.tabs;

import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CheckedActionGroup;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.LiveProperty;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManager;
import com.intellij.spring.boot.run.lifecycle.mappings.LiveRequestMapping;
import com.intellij.spring.boot.run.lifecycle.mappings.LiveRequestMappingsModel;
import com.intellij.spring.boot.run.lifecycle.tabs.EndpointTab;
import com.intellij.spring.boot.run.lifecycle.tabs.RequestMappingsConfigurable;
import com.intellij.spring.boot.run.lifecycle.tabs.RequestMappingsPanel;
import com.intellij.spring.boot.run.lifecycle.tabs.SpringBootEndpointsTabSettings;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import icons.SpringApiIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

class RequestMappingsTab
extends EndpointTab {
    private static final String TAB_ID = "mappings";
    private static final String[] REQUEST_METHODS = new String[]{"GET", "HEAD", "POST", "PUT", "PATCH", "DELETE", "OPTIONS", "TRACE"};
    private final List<LiveRequestMapping> myRequestMappings;
    private final JComponent myWrapper;
    private final RequestMappingsPanel myRequestMappingsPanel;

    RequestMappingsTab(@NotNull SpringBootApplicationRunConfiguration runConfiguration, @NotNull ProcessHandler processHandler) {
        if (runConfiguration == null) {
            RequestMappingsTab.$$$reportNull$$$0(0);
        }
        if (processHandler == null) {
            RequestMappingsTab.$$$reportNull$$$0(1);
        }
        super(runConfiguration, processHandler);
        this.myRequestMappings = new ArrayList<LiveRequestMapping>();
        this.myRequestMappingsPanel = new RequestMappingsPanel(this.getProject(), this.getRunConfiguration(), processHandler, ContainerUtil.newArrayList((Object[])new AnAction[]{new MarkAsDefaultAction(), new RestoreEmptyDefaultPathAction()}));
        this.myRequestMappingsPanel.setDefaultPath(runConfiguration.getUrlPath());
        Disposer.register((Disposable)this, (Disposable)this.myRequestMappingsPanel);
        this.myWrapper = DumbService.getInstance((Project)this.getProject()).wrapGently((JComponent)this.myRequestMappingsPanel, (Disposable)this);
        MessageBusConnection connection = this.getProject().getMessageBus().connect((Disposable)this);
        connection.subscribe(RunManagerListener.TOPIC, (Object)new RunManagerListener(){

            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(0);
                }
                RunConfiguration changedConfiguration = settings.getConfiguration();
                if (RequestMappingsTab.this.getRunConfiguration().getName().equals(changedConfiguration.getName()) && changedConfiguration instanceof SpringBootApplicationRunConfiguration) {
                    String defaultPath = ((SpringBootApplicationRunConfiguration)changedConfiguration).getUrlPath();
                    RequestMappingsTab.this.getRunConfiguration().setUrlPath(defaultPath);
                    RequestMappingsTab.this.myRequestMappingsPanel.setDefaultPath(defaultPath);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/spring/boot/run/lifecycle/tabs/RequestMappingsTab$1", "runConfigurationChanged"));
            }
        });
        connection.subscribe(SpringBootEndpointsTabSettings.TOPIC, (Object)new SpringBootEndpointsTabSettings.Listener(){

            @Override
            public void settingsChanged(SpringBootEndpointsTabSettings.ChangeType changeType) {
                switch (changeType) {
                    case REQUEST_MAPPINGS: {
                        RequestMappingsTab.this.myRequestMappingsPanel.setItems(Collections.unmodifiableList(RequestMappingsTab.this.myRequestMappings));
                        break;
                    }
                }
            }
        });
    }

    @Override
    @NotNull
    public String getId() {
        if (TAB_ID == null) {
            RequestMappingsTab.$$$reportNull$$$0(2);
        }
        return TAB_ID;
    }

    @Override
    public String getTitle() {
        return SpringBootRunBundle.message("spring.boot.application.endpoints.request.mappings.tab.title", new Object[0]);
    }

    @Override
    public Icon getIcon() {
        return SpringApiIcons.RequestMapping;
    }

    @Override
    @NotNull
    protected List<AnAction> getToolbarActions() {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        actions.add((AnAction)new LiveRequestMethodActionGroup());
        actions.add((AnAction)Separator.getInstance());
        actions.add((AnAction)new EndpointTab.EndpointToggleAction(SpringBootRunBundle.message("spring.boot.application.endpoints.mappings.show.library.mappings.action.name", new Object[0]), null, AllIcons.Modules.Library){

            public boolean isSelected(AnActionEvent e) {
                return RequestMappingsTab.this.getSettings().isShowLibraryMappings();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                SpringBootEndpointsTabSettings settings = SpringBootEndpointsTabSettings.getInstance(RequestMappingsTab.this.getProject());
                settings.setShowLibraryMappings(state);
                settings.fireSettingsChanged(SpringBootEndpointsTabSettings.ChangeType.REQUEST_MAPPINGS);
            }
        });
        ArrayList<AnAction> arrayList = actions;
        if (arrayList == null) {
            RequestMappingsTab.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected LiveProperty getLiveProperty(SpringBootApplicationInfo info) {
        LiveProperty liveProperty = info.getRequestMappingsModel();
        if (liveProperty == null) {
            RequestMappingsTab.$$$reportNull$$$0(4);
        }
        return liveProperty;
    }

    @Override
    @NotNull
    protected JComponent getEndpointComponent() {
        JComponent jComponent = this.myWrapper;
        if (jComponent == null) {
            RequestMappingsTab.$$$reportNull$$$0(5);
        }
        return jComponent;
    }

    @Override
    protected void updateComponent() {
        SpringBootApplicationInfo info = SpringBootApplicationLifecycleManager.getInstance((Project)this.getRunConfiguration().getProject()).getSpringBootApplicationInfo(this.getProcessHandler());
        LiveRequestMappingsModel model = info != null ? (LiveRequestMappingsModel)info.getRequestMappingsModel().getValue() : null;
        long timeStamp = info != null ? info.getHealth().getTimeStamp() : -1L;
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.getProject(), () -> {
            this.setTimeStampTooltip(timeStamp);
            this.myRequestMappings.clear();
            if (model != null) {
                this.myRequestMappings.addAll(model.getRequestMappings());
            }
            this.myRequestMappingsPanel.setItems(Collections.unmodifiableList(this.myRequestMappings));
        });
    }

    @Override
    protected String getErrorMessage(String cause) {
        return SpringBootRunBundle.message("spring.boot.application.endpoints.error.failed.to.retrieve.endpoint.data.detailed", TAB_ID, cause);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/tabs/RequestMappingsTab";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/tabs/RequestMappingsTab";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiveProperty";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndpointComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LiveRequestMethodActionGroup
    extends DefaultActionGroup
    implements CheckedActionGroup {
        LiveRequestMethodActionGroup() {
            this.setPopup(true);
            this.getTemplatePresentation().setText(SpringBootRunBundle.message("spring.boot.application.endpoints.mappings.request.method.action.name", new Object[0]));
            this.getTemplatePresentation().setIcon(AllIcons.Nodes.Method);
            for (final String method : REQUEST_METHODS) {
                this.add((AnAction)new EndpointTab.EndpointToggleAction(method){

                    public boolean isSelected(AnActionEvent e) {
                        return !RequestMappingsTab.this.getSettings().getFilteredRequestMethods().contains(method);
                    }

                    public void setSelected(AnActionEvent e, boolean state) {
                        SpringBootEndpointsTabSettings settings = RequestMappingsTab.this.getSettings();
                        if (state) {
                            settings.getFilteredRequestMethods().remove(method);
                        } else {
                            settings.getFilteredRequestMethods().add(method);
                        }
                        settings.fireSettingsChanged(SpringBootEndpointsTabSettings.ChangeType.REQUEST_MAPPINGS);
                    }

                    @Override
                    public void update(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        super.update(e);
                        if (!e.getPresentation().isEnabled()) {
                            e.getPresentation().setVisible(false);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/spring/boot/run/lifecycle/tabs/RequestMappingsTab$LiveRequestMethodActionGroup$1", "update"));
                    }
                });
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                LiveRequestMethodActionGroup.$$$reportNull$$$0(0);
            }
            RequestMappingsTab.this.updateActionPresentation(e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/spring/boot/run/lifecycle/tabs/RequestMappingsTab$LiveRequestMethodActionGroup", "update"));
        }
    }

    private class RestoreEmptyDefaultPathAction
    extends AnAction {
        RestoreEmptyDefaultPathAction() {
            super(SpringBootRunBundle.message("spring.boot.application.endpoints.mappings.restore.empty.default.path.action.name", new Object[0]), null, null);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setVisible(RequestMappingsTab.this.isTabSelected(e));
            LiveRequestMapping mapping = RequestMappingsTab.this.myRequestMappingsPanel.getSelectedMapping();
            String path = mapping != null ? mapping.getPath() : null;
            e.getPresentation().setEnabledAndVisible(path != null && path.equals(RequestMappingsTab.this.getRunConfiguration().getUrlPath()));
        }

        public void actionPerformed(AnActionEvent e) {
            RequestMappingsConfigurable.updatePath(RequestMappingsTab.this.getProject(), RequestMappingsTab.this.getRunConfiguration(), "");
        }
    }

    private class MarkAsDefaultAction
    extends AnAction {
        MarkAsDefaultAction() {
            super(SpringBootRunBundle.message("spring.boot.application.endpoints.mappings.mark.default.action.name", new Object[0]), null, AllIcons.Actions.Submit1);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setVisible(RequestMappingsTab.this.isTabSelected(e));
            LiveRequestMapping mapping = RequestMappingsTab.this.myRequestMappingsPanel.getSelectedMapping();
            String path = mapping != null ? mapping.getPath() : null;
            e.getPresentation().setEnabledAndVisible(path != null && !path.equals(RequestMappingsTab.this.getRunConfiguration().getUrlPath()) && mapping.canNavigate());
        }

        public void actionPerformed(AnActionEvent e) {
            String path;
            LiveRequestMapping mapping = RequestMappingsTab.this.myRequestMappingsPanel.getSelectedMapping();
            String string = path = mapping != null ? mapping.getPath() : null;
            if (path == null) {
                return;
            }
            RequestMappingsConfigurable.updatePath(RequestMappingsTab.this.getProject(), RequestMappingsTab.this.getRunConfiguration(), path);
        }
    }
}

