/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.plantuml;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import org.intellij.plugins.markdown.extensions.MarkdownCodeFencePluginGeneratingProvider;
import org.intellij.plugins.markdown.ui.preview.MarkdownCodeFencePluginCacheProvider;
import org.intellij.plugins.markdown.ui.preview.MarkdownUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0003J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\tH\u0016J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\tH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/intellij/plugins/markdown/extensions/plantuml/PlantUMLPluginGeneratingProvider;", "Lorg/intellij/plugins/markdown/extensions/MarkdownCodeFencePluginGeneratingProvider;", "()V", "pluginCache", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownCodeFencePluginCacheProvider;", "(Lorg/intellij/plugins/markdown/ui/preview/MarkdownCodeFencePluginCacheProvider;)V", "cacheDiagram", "", "newDiagramPath", "", "text", "generateDiagram", "", "diagramPath", "generateHtml", "getCacheRootPath", "isApplicable", "", "language", "Companion", "markdown"})
public final class PlantUMLPluginGeneratingProvider
implements MarkdownCodeFencePluginGeneratingProvider {
    private MarkdownCodeFencePluginCacheProvider pluginCache;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getCacheRootPath() {
        return "" + MarkdownCodeFencePluginGeneratingProvider.Companion.getMarkdownCachePath() + "" + File.separator + "plantUML";
    }

    @Override
    @NotNull
    public String generateHtml(@NotNull String text) {
        String newDiagramPath;
        block0: {
            MarkdownCodeFencePluginCacheProvider markdownCodeFencePluginCacheProvider;
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            String string = newDiagramPath = new File("" + this.getCacheRootPath() + "" + File.separator + "" + MarkdownUtil.md5((markdownCodeFencePluginCacheProvider = this.pluginCache) != null && (markdownCodeFencePluginCacheProvider = markdownCodeFencePluginCacheProvider.getFile()) != null ? markdownCodeFencePluginCacheProvider.getPath() : null, "markdown-md5-file-path") + "" + File.separator + "" + MarkdownUtil.md5(text, "plantUML-diagram") + ".png").getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"newDiagramPath");
            this.cacheDiagram(string, text);
            MarkdownCodeFencePluginCacheProvider markdownCodeFencePluginCacheProvider2 = this.pluginCache;
            if (markdownCodeFencePluginCacheProvider2 == null) break block0;
            markdownCodeFencePluginCacheProvider2.addAliveCachedFile(new File(newDiagramPath));
        }
        return "<img src=\"file:" + newDiagramPath + "\"/>";
    }

    private final void cacheDiagram(String newDiagramPath, String text) {
        if (!FileUtil.exists((String)newDiagramPath)) {
            this.generateDiagram(text, newDiagramPath);
        }
    }

    private final void generateDiagram(CharSequence text, String diagramPath) throws IOException {
        String string;
        String string2 = string = ((Object)text).toString();
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String innerText = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        if (!StringsKt.startsWith$default((String)innerText, (String)"@startuml", (boolean)false, (int)2, null)) {
            innerText = "@startuml\n" + innerText;
        }
        if (!StringsKt.endsWith$default((String)innerText, (String)"@enduml", (boolean)false, (int)2, null)) {
            innerText = innerText + "\n@enduml";
        }
        FileUtil.createParentDirs((File)new File(diagramPath));
        PlantUMLPluginGeneratingProvider.Companion.storeDiagram(innerText, diagramPath);
    }

    @Override
    public boolean isApplicable(@Nullable String language) {
        return Intrinsics.areEqual((Object)language, (Object)"puml") || Intrinsics.areEqual((Object)language, (Object)"plantuml");
    }

    public PlantUMLPluginGeneratingProvider(@Nullable MarkdownCodeFencePluginCacheProvider pluginCache) {
        this.pluginCache = pluginCache;
    }

    public PlantUMLPluginGeneratingProvider() {
        this(null);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0003\u00a8\u0006\b"}, d2={"Lorg/intellij/plugins/markdown/extensions/plantuml/PlantUMLPluginGeneratingProvider$Companion;", "", "()V", "storeDiagram", "", "source", "", "fileName", "markdown"})
    public static final class Companion {
        private final void storeDiagram(String source, String fileName) throws IOException {
            SourceStringReader reader = new SourceStringReader(source);
            FileOutputStream fos = new FileOutputStream(fileName);
            reader.outputImage((OutputStream)fos, new FileFormatOption(FileFormat.PNG));
            fos.close();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

