/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.settings;

import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.settings.MarkdownCssSettings;
import org.intellij.plugins.markdown.settings.MarkdownPreviewSettings;
import org.intellij.plugins.markdown.ui.split.SplitFileEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownSettingsForm
implements MarkdownCssSettings.Holder,
MarkdownPreviewSettings.Holder,
Disposable {
    private JPanel myMainPanel;
    private JBCheckBox myCssFromURIEnabled;
    private TextFieldWithBrowseButton myCssURI;
    private JBCheckBox myApplyCustomCssText;
    private JPanel myEditorPanel;
    private JPanel myCssTitledSeparator;
    private ComboBox myDefaultSplitLayout;
    private JBCheckBox myUseGrayscaleRenderingForJBCheckBox;
    private JPanel myPreviewTitledSeparator;
    private JBCheckBox myAutoScrollCheckBox;
    @Nullable
    private EditorEx myEditor;
    @NotNull
    private final ActionListener myCssURIListener;
    @NotNull
    private final ActionListener myCustomCssTextListener;
    private EnumComboBoxModel<SplitFileEditor.SplitEditorLayout> mySplitLayoutModel;

    public MarkdownSettingsForm() {
        this.$$$setupUI$$$();
        this.myCssURIListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MarkdownSettingsForm.this.myCssURI.setEnabled(MarkdownSettingsForm.this.myCssFromURIEnabled.isSelected());
            }
        };
        this.myCustomCssTextListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MarkdownSettingsForm.this.adjustCSSRulesAvailability();
            }
        };
        this.adjustCSSRulesAvailability();
        this.myCssFromURIEnabled.addActionListener(this.myCssURIListener);
        this.myApplyCustomCssText.addActionListener(this.myCustomCssTextListener);
        this.myCssURI.addBrowseFolderListener(new TextBrowseFolderListener(FileChooserDescriptorFactory.createSingleFileDescriptor((String)"css")){

            @NotNull
            protected String chosenFileToResultingText(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    3.$$$reportNull$$$0(0);
                }
                String string = chosenFile.getUrl();
                if (string == null) {
                    3.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "chosenFile";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/intellij/plugins/markdown/settings/MarkdownSettingsForm$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/intellij/plugins/markdown/settings/MarkdownSettingsForm$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "chosenFileToResultingText";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "chosenFileToResultingText";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        this.myDefaultSplitLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MarkdownSettingsForm.this.adjustAutoScroll();
            }
        });
        this.adjustAutoScroll();
    }

    private void adjustAutoScroll() {
        this.myAutoScrollCheckBox.setEnabled(this.myDefaultSplitLayout.getSelectedItem() == SplitFileEditor.SplitEditorLayout.SPLIT);
    }

    private void adjustCSSRulesAvailability() {
        if (this.myEditor != null) {
            boolean enabled = this.myApplyCustomCssText.isSelected();
            this.myEditor.getDocument().setReadOnly(!enabled);
            this.myEditor.getContentComponent().setEnabled(enabled);
            this.myEditor.setCaretEnabled(enabled);
        }
    }

    public JComponent getComponent() {
        return this.myMainPanel;
    }

    private void createUIComponents() {
        this.myEditorPanel = new JPanel(new BorderLayout());
        this.myEditor = MarkdownSettingsForm.createEditor();
        this.myEditorPanel.add((Component)this.myEditor.getComponent(), "Center");
        this.myCssTitledSeparator = new TitledSeparator(MarkdownBundle.message("markdown.settings.css.title.name", new Object[0]));
        this.createPreviewUIComponents();
    }

    public void validate() throws ConfigurationException {
        if (!this.myCssFromURIEnabled.isSelected()) {
            return;
        }
        try {
            new URL(this.myCssURI.getText()).toURI();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new ConfigurationException("URI '" + this.myCssURI.getText() + "' parsing reports the error: " + e.getMessage());
        }
    }

    @NotNull
    private static EditorEx createEditor() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document editorDocument = editorFactory.createDocument((CharSequence)"");
        EditorEx editor = (EditorEx)editorFactory.createEditor(editorDocument);
        MarkdownSettingsForm.fillEditorSettings(editor.getSettings());
        MarkdownSettingsForm.setHighlighting(editor);
        EditorEx editorEx = editor;
        if (editorEx == null) {
            MarkdownSettingsForm.$$$reportNull$$$0(0);
        }
        return editorEx;
    }

    private static void setHighlighting(EditorEx editor) {
        FileType cssFileType = FileTypeManager.getInstance().getFileTypeByExtension("css");
        if (cssFileType == UnknownFileType.INSTANCE) {
            return;
        }
        EditorHighlighter editorHighlighter = HighlighterFactory.createHighlighter((FileType)cssFileType, (EditorColorsScheme)EditorColorsManager.getInstance().getGlobalScheme(), null);
        editor.setHighlighter(editorHighlighter);
    }

    private static void fillEditorSettings(EditorSettings editorSettings) {
        editorSettings.setWhitespacesShown(false);
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setLineNumbersShown(true);
        editorSettings.setFoldingOutlineShown(false);
        editorSettings.setAdditionalColumnsCount(1);
        editorSettings.setAdditionalLinesCount(1);
        editorSettings.setUseSoftWraps(false);
    }

    @Override
    public void setMarkdownCssSettings(@NotNull MarkdownCssSettings settings) {
        if (settings == null) {
            MarkdownSettingsForm.$$$reportNull$$$0(1);
        }
        this.myCssFromURIEnabled.setSelected(settings.isUriEnabled());
        this.myCssURI.setText(settings.getStylesheetUri());
        this.myApplyCustomCssText.setSelected(settings.isTextEnabled());
        this.resetEditor(settings.getStylesheetText());
        this.myCssURIListener.actionPerformed(null);
        this.myCustomCssTextListener.actionPerformed(null);
    }

    void resetEditor(@NotNull String cssText) {
        if (cssText == null) {
            MarkdownSettingsForm.$$$reportNull$$$0(2);
        }
        if (this.myEditor != null && !this.myEditor.isDisposed()) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (cssText == null) {
                    MarkdownSettingsForm.$$$reportNull$$$0(6);
                }
                boolean writable = this.myEditor.getDocument().isWritable();
                this.myEditor.getDocument().setReadOnly(false);
                this.myEditor.getDocument().setText((CharSequence)cssText);
                this.myEditor.getDocument().setReadOnly(!writable);
            });
        }
    }

    @Override
    @NotNull
    public MarkdownCssSettings getMarkdownCssSettings() {
        MarkdownCssSettings markdownCssSettings = new MarkdownCssSettings(this.myCssFromURIEnabled.isSelected(), this.myCssURI.getText(), this.myApplyCustomCssText.isSelected(), this.myEditor != null && !this.myEditor.isDisposed() ? (String)ReadAction.compute(() -> this.myEditor.getDocument().getText()) : "");
        if (markdownCssSettings == null) {
            MarkdownSettingsForm.$$$reportNull$$$0(3);
        }
        return markdownCssSettings;
    }

    public void dispose() {
        if (this.myEditor != null && !this.myEditor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
        }
        this.myEditor = null;
    }

    private void createPreviewUIComponents() {
        this.myPreviewTitledSeparator = new TitledSeparator(MarkdownBundle.message("markdown.settings.preview.name", new Object[0]));
        this.mySplitLayoutModel = new EnumComboBoxModel(SplitFileEditor.SplitEditorLayout.class);
        this.myDefaultSplitLayout = new ComboBox(this.mySplitLayoutModel);
        this.myDefaultSplitLayout.setRenderer((ListCellRenderer)new ListCellRendererWrapper<SplitFileEditor.SplitEditorLayout>(){

            public void customize(JList list, SplitFileEditor.SplitEditorLayout value, int index, boolean selected, boolean hasFocus) {
                this.setText(value.getPresentationText());
            }
        });
    }

    @Override
    public void setMarkdownPreviewSettings(@NotNull MarkdownPreviewSettings settings) {
        if (settings == null) {
            MarkdownSettingsForm.$$$reportNull$$$0(4);
        }
        this.mySplitLayoutModel.setSelectedItem((Enum)settings.getSplitEditorLayout());
        this.myUseGrayscaleRenderingForJBCheckBox.setSelected(settings.isUseGrayscaleRendering());
        this.myAutoScrollCheckBox.setSelected(settings.isAutoScrollPreview());
    }

    @Override
    @NotNull
    public MarkdownPreviewSettings getMarkdownPreviewSettings() {
        MarkdownPreviewSettings markdownPreviewSettings = new MarkdownPreviewSettings((SplitFileEditor.SplitEditorLayout)this.mySplitLayoutModel.getSelectedItem(), this.myUseGrayscaleRenderingForJBCheckBox.isSelected(), this.myAutoScrollCheckBox.isSelected());
        if (markdownPreviewSettings == null) {
            MarkdownSettingsForm.$$$reportNull$$$0(5);
        }
        return markdownPreviewSettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/settings/MarkdownSettingsForm";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cssText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/settings/MarkdownSettingsForm";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMarkdownCssSettings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMarkdownPreviewSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setMarkdownCssSettings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetEditor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setMarkdownPreviewSettings";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resetEditor$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JBCheckBox jBCheckBox4;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myUseGrayscaleRenderingForJBCheckBox = jBCheckBox4 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox4, ResourceBundle.getBundle("org/intellij/plugins/markdown/bundle/MarkdownBundle").getString("markdown.settings.preview.use.grayscale"));
        jPanel2.add((Component)jBCheckBox4, new GridConstraints(1, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("org/intellij/plugins/markdown/bundle/MarkdownBundle").getString("markdown.settings.default.layout"));
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComboBox comboBox = this.myDefaultSplitLayout;
        jPanel2.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        this.myAutoScrollCheckBox = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, ResourceBundle.getBundle("org/intellij/plugins/markdown/bundle/MarkdownBundle").getString("markdown.settings.preview.auto.scroll.checkbox"));
        jPanel2.add((Component)jBCheckBox3, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = this.myCssTitledSeparator;
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myCssFromURIEnabled = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, ResourceBundle.getBundle("org/intellij/plugins/markdown/bundle/MarkdownBundle").getString("markdown.settings.css.enable.uri"));
        jPanel.add((Component)jBCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCssURI = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myApplyCustomCssText = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("org/intellij/plugins/markdown/bundle/MarkdownBundle").getString("markdown.settings.css.enable.inline"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = this.myEditorPanel;
        ((Component)jPanel4).setBackground(new Color(-1118482));
        ((Component)jPanel4).setEnabled(true);
        jPanel.add((Component)jPanel4, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, new Dimension(-1, 150), null, 1));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

