/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.framework;

import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.FrameworkVersion;
import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.framework.addSupport.FrameworkVersionListener;
import com.intellij.framework.library.DownloadableLibraryService;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.newProjectWizard.impl.FrameworkSupportModelBase;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.facet.EjbFacetConfigurationImpl;
import com.intellij.javaee.ejb.facet.EjbFacetType;
import com.intellij.javaee.ejb.framework.EjbFrameworkType;
import com.intellij.javaee.ejb.framework.EjbFrameworkVersion;
import com.intellij.javaee.ejb.framework.EjbLibraryType;
import com.intellij.javaee.framework.JavaeeFrameworkSupportProviderBase;
import com.intellij.javaee.framework.JavaeeFrameworkVersionBase;
import com.intellij.javaee.model.EjbRootDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.util.descriptors.ConfigFileVersion;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EjbFrameworkSupportProvider
extends JavaeeFrameworkSupportProviderBase<EjbFacet> {
    public EjbFrameworkSupportProvider() {
        super(EjbFacetType.getInstance(), EjbRootDescriptor.EJB_JAR_META_DATA, "");
    }

    public String getPresentableName() {
        return "EJB: Enterprise Java Beans";
    }

    @Override
    protected void setupConfiguration(EjbFacet facet, ModifiableRootModel rootModel, ConfigFileVersion configFileVersion) {
        super.setupConfiguration(facet, rootModel, configFileVersion);
        String[] urls = rootModel.getSourceRootUrls();
        if (urls.length > 0) {
            ((EjbFacetConfigurationImpl)facet.getConfiguration()).getSourceRoots().add(urls[0]);
        }
    }

    @NotNull
    public FrameworkTypeEx getFrameworkType() {
        EjbFrameworkType ejbFrameworkType = EjbFrameworkType.getInstance();
        if (ejbFrameworkType == null) {
            EjbFrameworkSupportProvider.$$$reportNull$$$0(0);
        }
        return ejbFrameworkType;
    }

    @NotNull
    public FrameworkSupportInModuleConfigurable createConfigurable(@NotNull FrameworkSupportModel model) {
        if (model == null) {
            EjbFrameworkSupportProvider.$$$reportNull$$$0(1);
        }
        EjbFrameworkConfigurable ejbFrameworkConfigurable = new EjbFrameworkConfigurable(model);
        if (ejbFrameworkConfigurable == null) {
            EjbFrameworkSupportProvider.$$$reportNull$$$0(2);
        }
        return ejbFrameworkConfigurable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ejb/framework/EjbFrameworkSupportProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ejb/framework/EjbFrameworkSupportProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class EjbFrameworkConfigurable
    extends JavaeeFrameworkSupportProviderBase.JavaeeFrameworkSupportConfigurable {
        private JPanel myPanel;
        private JCheckBox myCreateEjbJarBox;
        private boolean myCreateEjbJar;

        public EjbFrameworkConfigurable(FrameworkSupportModel model) {
            super(EjbFrameworkSupportProvider.this, model);
            this.myPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
            this.myCreateEjbJarBox = new JCheckBox("Create ejb-jar.xml");
            this.myPanel.add((Component)this.myCreateEjbJarBox, "Center");
            this.myCreateEjbJarBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EjbFrameworkConfigurable.this.myCreateEjbJar = EjbFrameworkConfigurable.this.myCreateEjbJarBox.isSelected();
                }
            });
            ((FrameworkSupportModelBase)model).addFrameworkVersionListener(new FrameworkVersionListener(){

                public void versionChanged(FrameworkVersion version) {
                    if (version instanceof EjbFrameworkVersion) {
                        EjbFrameworkConfigurable.this.updateCheckBox();
                    }
                }
            }, (Disposable)this);
        }

        @Override
        @Nullable
        protected ConfigFileVersion getVersionToCreate(JavaeeFrameworkVersionBase frameworkVersion) {
            if (!this.myCreateEjbJarBox.isSelected()) {
                return null;
            }
            return super.getVersionToCreate(frameworkVersion);
        }

        private void updateCheckBox() {
            FrameworkVersion version = ((FrameworkSupportModelBase)this.myModel).getSelectedVersion(EjbFrameworkType.getInstance().getId());
            boolean isEjbJarOptional = version instanceof EjbFrameworkVersion && ((EjbFrameworkVersion)version).isEjbJarDescriptorOptional();
            this.myCreateEjbJarBox.setSelected(!isEjbJarOptional || this.myCreateEjbJar);
            this.myCreateEjbJarBox.setVisible(isEjbJarOptional);
        }

        @Override
        @Nullable
        public JComponent createComponent() {
            return this.myPanel;
        }

        @Nullable
        public CustomLibraryDescription createLibraryDescription() {
            return DownloadableLibraryService.getInstance().createDescriptionForType(EjbLibraryType.class);
        }
    }
}

