/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.process.common;

import com.intellij.javaee.process.common.EncodingUtil;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class WrappedException
extends Exception {
    private static final String SPLITTER = "#";
    private final String myStackTrace;

    public static WrappedException deserialize(String serialized) {
        String[] parts = serialized.split(SPLITTER);
        return new WrappedException(EncodingUtil.decodeBase64(parts[0]), EncodingUtil.decodeBase64(parts[1]));
    }

    private WrappedException(String message, String stackTrace) {
        super(message);
        this.myStackTrace = stackTrace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WrappedException(Exception e) {
        super(e.toString(), e);
        StringWriter exceptionWriter = new StringWriter();
        PrintWriter exceptionPrintWriter = new PrintWriter(exceptionWriter);
        try {
            e.printStackTrace(exceptionPrintWriter);
        }
        finally {
            exceptionPrintWriter.close();
        }
        this.myStackTrace = exceptionWriter.toString();
    }

    public void printStackTrace(PrintWriter s) {
        s.println(this.myStackTrace);
    }

    public void printStackTrace(PrintStream s) {
        s.println(this.myStackTrace);
    }

    public String serialize() {
        StringBuilder result = new StringBuilder();
        result.append(EncodingUtil.encodeBase64(this.getMessage()));
        result.append(SPLITTER);
        result.append(EncodingUtil.encodeBase64(this.myStackTrace));
        return result.toString();
    }
}

