/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.lang.Language;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.annotator.GrReferenceHighlighter;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptTypeDetector;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.util.GrFileIndexUtil;

public class GrReferenceHighlighterFactory
extends AbstractProjectComponent
implements TextEditorHighlightingPassFactory {
    public GrReferenceHighlighterFactory(Project project, TextEditorHighlightingPassRegistrar registrar) {
        super(project);
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, false, -1);
    }

    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        PsiFile groovyFile;
        if (file == null) {
            GrReferenceHighlighterFactory.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            GrReferenceHighlighterFactory.$$$reportNull$$$0(1);
        }
        return (groovyFile = file.getViewProvider().getPsi((Language)GroovyLanguage.INSTANCE)) instanceof GroovyFileBase ? new GrReferenceHighlighter(editor.getDocument(), (GroovyFileBase)groovyFile) : null;
    }

    static boolean shouldHighlight(@NotNull GroovyFileBase file) {
        if (file == null) {
            GrReferenceHighlighterFactory.$$$reportNull$$$0(2);
        }
        return GrReferenceHighlighterFactory.isSpecificScriptFile(file) || GrFileIndexUtil.isGroovySourceFile(file);
    }

    private static boolean isSpecificScriptFile(@NotNull GroovyFileBase file) {
        if (file == null) {
            GrReferenceHighlighterFactory.$$$reportNull$$$0(3);
        }
        if (!(file instanceof GroovyFile)) {
            return false;
        }
        if (!file.isScript()) {
            return false;
        }
        GroovyFile groovyFile = (GroovyFile)file;
        for (GroovyScriptTypeDetector detector : (GroovyScriptTypeDetector[])GroovyScriptTypeDetector.EP_NAME.getExtensions()) {
            if (!detector.isSpecificScriptFile(groovyFile)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/GrReferenceHighlighterFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createHighlightingPass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldHighlight";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isSpecificScriptFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

