/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import icons.JetgroovyIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.completion.AnnotationAttributeCompletionResultProcessor;
import org.jetbrains.plugins.groovy.lang.completion.GrPropertyForCompletion;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTraitType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrReferenceExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrBindingVariable;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ClosureMissingMethodContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessorImpl;
import org.jetbrains.plugins.groovy.lang.resolve.processors.SubstitutorComputer;

public class CompleteReferenceExpression {
    private static final Logger LOG = Logger.getInstance(CompleteReferenceExpression.class);
    private final PrefixMatcher myMatcher;
    private final Consumer<LookupElement> myConsumer;
    private final GrReferenceExpressionImpl myRefExpr;
    private final CompletionParameters myParameters;
    private final CompleteReferenceProcessor myProcessor;

    private CompleteReferenceExpression(@NotNull PrefixMatcher matcher, @NotNull Consumer<LookupElement> consumer, @NotNull GrReferenceExpressionImpl refExpr, @NotNull CompletionParameters parameters) {
        if (matcher == null) {
            CompleteReferenceExpression.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            CompleteReferenceExpression.$$$reportNull$$$0(1);
        }
        if (refExpr == null) {
            CompleteReferenceExpression.$$$reportNull$$$0(2);
        }
        if (parameters == null) {
            CompleteReferenceExpression.$$$reportNull$$$0(3);
        }
        this.myMatcher = matcher;
        this.myConsumer = consumer;
        this.myParameters = parameters;
        this.myRefExpr = refExpr;
        this.myProcessor = new CompleteReferenceProcessor();
    }

    public static void processVariants(@NotNull PrefixMatcher matcher, @NotNull Consumer<LookupElement> consumer, @NotNull GrReferenceExpressionImpl refExpr, @NotNull CompletionParameters parameters) {
        if (matcher == null) {
            CompleteReferenceExpression.$$$reportNull$$$0(4);
        }
        if (consumer == null) {
            CompleteReferenceExpression.$$$reportNull$$$0(5);
        }
        if (refExpr == null) {
            CompleteReferenceExpression.$$$reportNull$$$0(6);
        }
        if (parameters == null) {
            CompleteReferenceExpression.$$$reportNull$$$0(7);
        }
        new CompleteReferenceExpression(matcher, consumer, refExpr, parameters).processVariantsImpl();
    }

    private void processVariantsImpl() {
        this.processRefInAnnotationImpl();
        this.getVariantsImpl();
        GroovyResolveResult[] candidates = this.myProcessor.getCandidates();
        List<LookupElement> results2 = GroovyCompletionUtil.getCompletionVariants(candidates, JavaClassNameCompletionContributor.AFTER_NEW.accepts((Object)this.myRefExpr), this.myMatcher, (PsiElement)this.myRefExpr);
        if (this.myProcessor.isEmpty() && results2.isEmpty()) {
            results2 = GroovyCompletionUtil.getCompletionVariants(this.myProcessor.getInapplicableResults(), JavaClassNameCompletionContributor.AFTER_NEW.accepts((Object)this.myRefExpr), this.myMatcher, (PsiElement)this.myRefExpr);
        }
        for (LookupElement o : results2) {
            this.myConsumer.consume((Object)o);
        }
    }

    public static void processRefInAnnotation(@NotNull GrReferenceExpression refExpr, @NotNull PrefixMatcher matcher, @NotNull Consumer<LookupElement> consumer, @NotNull CompletionParameters parameters) {
        if (refExpr == null) {
            CompleteReferenceExpression.$$$reportNull$$$0(8);
        }
        if (matcher == null) {
            CompleteReferenceExpression.$$$reportNull$$$0(9);
        }
        if (consumer == null) {
            CompleteReferenceExpression.$$$reportNull$$$0(10);
        }
        if (parameters == null) {
            CompleteReferenceExpression.$$$reportNull$$$0(11);
        }
        new CompleteReferenceExpression(matcher, consumer, (GrReferenceExpressionImpl)refExpr, parameters).processRefInAnnotationImpl();
    }

    private void processRefInAnnotationImpl() {
        if (this.myRefExpr.getParent() instanceof GrAnnotationNameValuePair && ((GrAnnotationNameValuePair)this.myRefExpr.getParent()).getNameIdentifierGroovy() == null) {
            PsiElement parent = this.myRefExpr.getParent().getParent();
            if (!(parent instanceof GrAnnotation)) {
                parent = parent.getParent();
            }
            if (parent instanceof GrAnnotation) {
                new AnnotationAttributeCompletionResultProcessor((GrAnnotation)parent).process(this.myConsumer, this.myMatcher);
            }
        }
    }

    private void processIfJavaLangClass(@Nullable PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return;
        }
        PsiClass psiClass = ((PsiClassType)type).resolve();
        if (psiClass == null || !"java.lang.Class".equals(psiClass.getQualifiedName())) {
            return;
        }
        PsiType[] params = ((PsiClassType)type).getParameters();
        if (params.length != 1) {
            return;
        }
        this.getVariantsFromQualifierType(params[0], this.myRefExpr.getProject());
    }

    private void getVariantsImpl() {
        GrExpression qualifier = this.myRefExpr.getQualifierExpression();
        if (qualifier == null) {
            ResolveUtil.treeWalkUp(this.myRefExpr, this.myProcessor, true);
            ClosureMissingMethodContributor.processMethodsFromClosures(this.myRefExpr, this.myProcessor);
            GrExpression runtimeQualifier = PsiImplUtil.getRuntimeQualifier(this.myRefExpr);
            if (runtimeQualifier != null) {
                this.getVariantsFromQualifier(runtimeQualifier);
            }
            this.getBindings();
        } else if (this.myRefExpr.getDotTokenType() != GroovyTokenTypes.mSPREAD_DOT) {
            if (qualifier instanceof GrReferenceExpression && ("class".equals(((GrReferenceExpression)qualifier).getReferenceName()) || PsiUtil.isThisReference(qualifier) && !PsiUtil.isInstanceThisRef(qualifier) || ((GrReferenceExpression)qualifier).resolve() instanceof PsiClass)) {
                this.processIfJavaLangClass(qualifier.getType());
            }
            this.getVariantsFromQualifier(qualifier);
        } else {
            this.getVariantsFromQualifierForSpreadOperator(qualifier);
        }
        ResolveUtil.processCategoryMembers(this.myRefExpr, this.myProcessor, ResolveState.initial());
    }

    private void getBindings() {
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this.myRefExpr, PsiClass.class);
        if (containingClass != null) {
            return;
        }
        final PsiFile file = FileContextUtil.getContextFile((PsiElement)this.myRefExpr);
        if (file instanceof GroovyFile) {
            ((GroovyFile)file).accept(new GroovyRecursiveElementVisitor(){

                @Override
                public void visitAssignmentExpression(@NotNull GrAssignmentExpression expression) {
                    if (expression == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitAssignmentExpression(expression);
                    GrExpression value = expression.getLValue();
                    if (value instanceof GrReferenceExpression && !((GrReferenceExpression)value).isQualified()) {
                        PsiElement resolved = ((GrReferenceExpression)value).resolve();
                        if (resolved instanceof GrBindingVariable) {
                            CompleteReferenceExpression.this.myProcessor.execute(resolved, ResolveState.initial());
                        } else if (resolved == null) {
                            CompleteReferenceExpression.this.myProcessor.execute(new GrBindingVariable((GroovyFile)file, ((GrReferenceExpression)value).getReferenceName()), ResolveState.initial());
                        }
                    }
                }

                @Override
                public void visitTypeDefinition(@NotNull GrTypeDefinition typeDefinition) {
                    if (typeDefinition == null) {
                        1.$$$reportNull$$$0(1);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "expression";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "typeDefinition";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/plugins/groovy/lang/completion/CompleteReferenceExpression$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitAssignmentExpression";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitTypeDefinition";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    private void getVariantsFromQualifierForSpreadOperator(@NotNull GrExpression qualifier) {
        PsiType spreadType;
        if (qualifier == null) {
            CompleteReferenceExpression.$$$reportNull$$$0(12);
        }
        if ((spreadType = ClosureParameterEnhancer.findTypeForIteration(qualifier, (PsiElement)this.myRefExpr)) != null) {
            this.getVariantsFromQualifierType(spreadType, this.myRefExpr.getProject());
        }
    }

    @NotNull
    public static LookupElementBuilder createPropertyLookupElement(@NotNull String name, @Nullable PsiType type) {
        if (name == null) {
            CompleteReferenceExpression.$$$reportNull$$$0(13);
        }
        LookupElementBuilder res = LookupElementBuilder.create((String)name).withIcon(JetgroovyIcons.Groovy.Property);
        if (type != null) {
            res = res.withTypeText(type.getPresentableText());
        }
        LookupElementBuilder lookupElementBuilder = res;
        if (lookupElementBuilder == null) {
            CompleteReferenceExpression.$$$reportNull$$$0(14);
        }
        return lookupElementBuilder;
    }

    @Nullable
    public static LookupElementBuilder createPropertyLookupElement(@NotNull PsiMethod accessor, @Nullable GroovyResolveResult resolveResult, @Nullable PrefixMatcher matcher) {
        String propName;
        boolean getter;
        if (accessor == null) {
            CompleteReferenceExpression.$$$reportNull$$$0(15);
        }
        if (getter = GroovyPropertyUtils.isSimplePropertyGetter(accessor, null)) {
            propName = GroovyPropertyUtils.getPropertyNameByGetter(accessor);
        } else if (GroovyPropertyUtils.isSimplePropertySetter(accessor, null)) {
            propName = GroovyPropertyUtils.getPropertyNameBySetter(accessor);
        } else {
            return null;
        }
        assert (propName != null);
        if (!PsiUtil.isValidReferenceName(propName)) {
            propName = "'" + propName + "'";
        }
        if (matcher != null && !matcher.prefixMatches(propName)) {
            return null;
        }
        PsiType propType = getter ? PsiUtil.getSmartReturnType(accessor) : accessor.getParameterList().getParameters()[0].getType();
        PsiType substituted = resolveResult != null ? resolveResult.getSubstitutor().substitute(propType) : propType;
        LookupElementBuilder builder = LookupElementBuilder.create((Object)CompleteReferenceExpression.generatePropertyResolveResult(propName, accessor, propType, resolveResult), (String)propName).withIcon(JetgroovyIcons.Groovy.Property);
        if (substituted != null) {
            builder = builder.withTypeText(substituted.getPresentableText());
        }
        return builder;
    }

    @NotNull
    private static GroovyResolveResult generatePropertyResolveResult(@NotNull String name, @NotNull PsiMethod method, @Nullable PsiType type, @Nullable GroovyResolveResult resolveResult) {
        if (name == null) {
            CompleteReferenceExpression.$$$reportNull$$$0(16);
        }
        if (method == null) {
            CompleteReferenceExpression.$$$reportNull$$$0(17);
        }
        PsiType nonNullType = type != null ? type : TypesUtil.getJavaLangObject((PsiElement)method);
        GrPropertyForCompletion field = new GrPropertyForCompletion(method, name, nonNullType);
        if (resolveResult != null) {
            GroovyResolveResultImpl groovyResolveResultImpl = new GroovyResolveResultImpl((PsiElement)field, resolveResult.getCurrentFileResolveContext(), resolveResult.getSpreadState(), resolveResult.getSubstitutor(), resolveResult.isAccessible(), resolveResult.isStaticsOK());
            if (groovyResolveResultImpl == null) {
                CompleteReferenceExpression.$$$reportNull$$$0(18);
            }
            return groovyResolveResultImpl;
        }
        GroovyResolveResultImpl groovyResolveResultImpl = new GroovyResolveResultImpl((PsiElement)field, true);
        if (groovyResolveResultImpl == null) {
            CompleteReferenceExpression.$$$reportNull$$$0(19);
        }
        return groovyResolveResultImpl;
    }

    private void getVariantsFromQualifier(@NotNull GrExpression qualifier) {
        if (qualifier == null) {
            CompleteReferenceExpression.$$$reportNull$$$0(20);
        }
        Project project = qualifier.getProject();
        PsiType qualifierType = TypesUtil.boxPrimitiveType(qualifier.getType(), qualifier.getManager(), qualifier.getResolveScope());
        ResolveState state = ResolveState.initial();
        if (qualifierType == null || PsiType.VOID.equals((Object)qualifierType)) {
            PsiElement resolved;
            if (qualifier instanceof GrReferenceExpression && ((resolved = ((GrReferenceExpression)qualifier).resolve()) instanceof PsiPackage || resolved instanceof PsiVariable)) {
                resolved.processDeclarations((PsiScopeProcessor)this.myProcessor, state, null, (PsiElement)this.myRefExpr);
                return;
            }
            this.getVariantsFromQualifierType((PsiType)TypesUtil.getJavaLangObject(qualifier), project);
        } else if (qualifierType instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)qualifierType).getConjuncts()) {
                this.getVariantsFromQualifierType(conjunct, project);
            }
        } else if (qualifierType instanceof GrTraitType) {
            PsiType[] conjuncts = ((GrTraitType)qualifierType).getConjuncts();
            for (int i = conjuncts.length - 1; i >= 0; --i) {
                this.getVariantsFromQualifierType(conjuncts[i], project);
            }
        } else {
            GlobalSearchScope scope;
            PsiClass javaLangClass;
            PsiElement resolved;
            this.getVariantsFromQualifierType(qualifierType, project);
            if (qualifier instanceof GrReferenceExpression && !PsiUtil.isSuperReference(qualifier) && !PsiUtil.isInstanceThisRef(qualifier) && (resolved = ((GrReferenceExpression)qualifier).resolve()) instanceof PsiClass && (javaLangClass = PsiUtil.getJavaLangClass(resolved, scope = this.myRefExpr.getResolveScope())) != null) {
                PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
                PsiTypeParameter[] typeParameters = javaLangClass.getTypeParameters();
                if (typeParameters.length == 1) {
                    substitutor = substitutor.put(typeParameters[0], qualifierType);
                }
                PsiClassType javaLangClassType = JavaPsiFacade.getElementFactory((Project)this.myRefExpr.getProject()).createType(javaLangClass, substitutor);
                ResolveUtil.processAllDeclarations((PsiType)javaLangClassType, (PsiScopeProcessor)this.myProcessor, state, (PsiElement)this.myRefExpr);
            }
        }
    }

    private void getVariantsFromQualifierType(@NotNull PsiType qualifierType, @NotNull Project project) {
        if (qualifierType == null) {
            CompleteReferenceExpression.$$$reportNull$$$0(21);
        }
        if (project == null) {
            CompleteReferenceExpression.$$$reportNull$$$0(22);
        }
        ResolveState state = ResolveState.initial();
        if (qualifierType instanceof PsiClassType) {
            PsiClassType.ClassResolveResult result = ((PsiClassType)qualifierType).resolveGenerics();
            PsiClass qualifierClass = result.getElement();
            if (qualifierClass != null) {
                qualifierClass.processDeclarations((PsiScopeProcessor)this.myProcessor, state.put(PsiSubstitutor.KEY, (Object)result.getSubstitutor()), null, (PsiElement)this.myRefExpr);
            }
        } else if (qualifierType instanceof PsiArrayType) {
            GrTypeDefinition arrayClass = GroovyPsiManager.getInstance(project).getArrayClass(((PsiArrayType)qualifierType).getComponentType());
            if (arrayClass != null && !arrayClass.processDeclarations(this.myProcessor, state, null, this.myRefExpr)) {
                return;
            }
        } else if (qualifierType instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)qualifierType).getConjuncts()) {
                this.getVariantsFromQualifierType(conjunct, project);
            }
            return;
        }
        ResolveUtil.processNonCodeMembers(qualifierType, this.myProcessor, this.myRefExpr, state);
    }

    @NotNull
    private Set<String> addAllRestrictedProperties() {
        if (this.myRefExpr.getQualifier() != null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                CompleteReferenceExpression.$$$reportNull$$$0(23);
            }
            return set;
        }
        com.intellij.util.containers.hash.HashSet propertyNames = new com.intellij.util.containers.hash.HashSet();
        GrTypeDefinition containingClass = (GrTypeDefinition)PsiTreeUtil.getParentOfType((PsiElement)this.myRefExpr, GrTypeDefinition.class);
        while (containingClass != null) {
            for (GrField field : containingClass.getFields()) {
                propertyNames.add(field.getName());
            }
            containingClass = (GrTypeDefinition)PsiTreeUtil.getParentOfType((PsiElement)containingClass, GrTypeDefinition.class);
        }
        com.intellij.util.containers.hash.HashSet hashSet = propertyNames;
        if (hashSet == null) {
            CompleteReferenceExpression.$$$reportNull$$$0(24);
        }
        return hashSet;
    }

    private boolean isMap() {
        PsiType qType = PsiImplUtil.getQualifierType(this.myRefExpr);
        return InheritanceUtil.isInheritor((PsiType)qType, (String)"java.util.Map");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 18: 
            case 19: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 18: 
            case 19: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 1: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: 
            case 18: 
            case 19: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/completion/CompleteReferenceExpression";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/completion/CompleteReferenceExpression";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createPropertyLookupElement";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePropertyResolveResult";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "addAllRestrictedProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processVariants";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processRefInAnnotation";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getVariantsFromQualifierForSpreadOperator";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createPropertyLookupElement";
                break;
            }
            case 14: 
            case 18: 
            case 19: 
            case 23: 
            case 24: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "generatePropertyResolveResult";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getVariantsFromQualifier";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getVariantsFromQualifierType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 18: 
            case 19: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CompleteReferenceProcessor
    extends ResolverProcessorImpl
    implements Consumer<Object> {
        private final Consumer<LookupElement> myConsumer;
        private final boolean mySkipPackages;
        private final PsiClass myEventListener;
        private final boolean myMethodPointerOperator;
        private final boolean myFieldPointerOperator;
        private final boolean myIsMap;
        private final SubstitutorComputer mySubstitutorComputer;
        private final Collection<String> myPreferredFieldNames;
        private final Set<String> myPropertyNames;
        private final Set<String> myLocalVars;
        private final Set<GrMethod> myProcessedMethodWithOptionalParams;
        private List<GroovyResolveResult> myInapplicable;
        private boolean myIsEmpty;

        protected CompleteReferenceProcessor() {
            super(null, EnumSet.allOf(ElementClassHint.DeclarationKind.class), CompleteReferenceExpression.this.myRefExpr, PsiType.EMPTY_ARRAY);
            this.myPropertyNames = new com.intellij.util.containers.hash.HashSet();
            this.myLocalVars = new com.intellij.util.containers.hash.HashSet();
            this.myProcessedMethodWithOptionalParams = new com.intellij.util.containers.hash.HashSet();
            this.myIsEmpty = true;
            this.myConsumer = element -> {
                this.myIsEmpty = false;
                CompleteReferenceExpression.this.myConsumer.consume(element);
            };
            this.myPreferredFieldNames = CompleteReferenceExpression.this.addAllRestrictedProperties();
            this.mySkipPackages = this.shouldSkipPackages();
            this.myEventListener = JavaPsiFacade.getInstance((Project)CompleteReferenceExpression.this.myRefExpr.getProject()).findClass("java.util.EventListener", CompleteReferenceExpression.this.myRefExpr.getResolveScope());
            this.myPropertyNames.addAll(this.myPreferredFieldNames);
            this.myFieldPointerOperator = CompleteReferenceExpression.this.myRefExpr.hasAt();
            this.myMethodPointerOperator = CompleteReferenceExpression.this.myRefExpr.getDotTokenType() == GroovyTokenTypes.mMEMBER_POINTER;
            this.myIsMap = CompleteReferenceExpression.this.isMap();
            PsiType thisType = PsiImplUtil.getQualifierType(CompleteReferenceExpression.this.myRefExpr);
            this.mySubstitutorComputer = new SubstitutorComputer(thisType, PsiType.EMPTY_ARRAY, PsiType.EMPTY_ARRAY, CompleteReferenceExpression.this.myRefExpr, CompleteReferenceExpression.this.myRefExpr.getParent());
        }

        public boolean isEmpty() {
            return this.myIsEmpty;
        }

        private boolean shouldSkipPackages() {
            if (PsiImplUtil.getRuntimeQualifier(CompleteReferenceExpression.this.myRefExpr) != null) {
                return false;
            }
            PsiElement parent = CompleteReferenceExpression.this.myRefExpr.getParent();
            return parent == null || parent.getLanguage().isKindOf((Language)GroovyLanguage.INSTANCE);
        }

        @Override
        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                CompleteReferenceProcessor.$$$reportNull$$$0(0);
            }
            if (state == null) {
                CompleteReferenceProcessor.$$$reportNull$$$0(1);
            }
            if (element instanceof PsiMethod && ((PsiMethod)element).isConstructor()) {
                return true;
            }
            if (element instanceof PsiNamedElement) {
                PsiNamedElement namedElement = (PsiNamedElement)element;
                boolean isAccessible = this.isAccessible(namedElement);
                PsiElement resolveContext = (PsiElement)state.get(ClassHint.RESOLVE_CONTEXT);
                SpreadState spreadState = (SpreadState)state.get(SpreadState.SPREAD_STATE);
                boolean isStaticsOK = this.isStaticsOK(namedElement, resolveContext, CompleteReferenceExpression.this.myParameters.getInvocationCount() <= 1);
                PsiSubstitutor substitutor = (PsiSubstitutor)state.get(PsiSubstitutor.KEY);
                if (substitutor == null) {
                    substitutor = PsiSubstitutor.EMPTY;
                }
                if (element instanceof PsiMethod) {
                    substitutor = this.mySubstitutorComputer.obtainSubstitutor(substitutor, (PsiMethod)element, resolveContext);
                }
                this.consume(new GroovyResolveResultImpl((PsiElement)namedElement, resolveContext, spreadState, substitutor, isAccessible, isStaticsOK));
            }
            return true;
        }

        public void consume(Object o) {
            if (!(o instanceof GroovyResolveResult)) {
                LOG.error(o);
                return;
            }
            GroovyResolveResult result = (GroovyResolveResult)o;
            if (!result.isStaticsOK()) {
                if (this.myInapplicable == null) {
                    this.myInapplicable = ContainerUtil.newArrayList();
                }
                this.myInapplicable.add(result);
                return;
            }
            if (!result.isAccessible() && CompleteReferenceExpression.this.myParameters.getInvocationCount() < 2) {
                return;
            }
            if (this.mySkipPackages && result.getElement() instanceof PsiPackage) {
                return;
            }
            PsiElement element = result.getElement();
            if (element instanceof PsiVariable && !CompleteReferenceExpression.this.myMatcher.prefixMatches(((PsiVariable)element).getName())) {
                return;
            }
            if (element instanceof GrReflectedMethod) {
                GrMethod base = ((GrReflectedMethod)element).getBaseMethod();
                if (!this.myProcessedMethodWithOptionalParams.add(base)) {
                    return;
                }
                result = PsiImplUtil.reflectedToBase(result, base, (GrReflectedMethod)element);
                element = base;
            }
            if (this.myFieldPointerOperator && !(element instanceof PsiVariable)) {
                return;
            }
            if (this.myMethodPointerOperator && !(element instanceof PsiMethod)) {
                return;
            }
            this.addCandidate(result);
            if (!this.myFieldPointerOperator && !this.myMethodPointerOperator) {
                if (element instanceof PsiMethod) {
                    this.processProperty((PsiMethod)element, result);
                } else if (element instanceof GrField && ((GrField)element).isProperty()) {
                    this.processPropertyFromField((GrField)element, result);
                }
            }
            if (element instanceof GrVariable && !(element instanceof GrField)) {
                this.myLocalVars.add(((GrVariable)element).getName());
            }
        }

        private void processPropertyFromField(@NotNull GrField field, @NotNull GroovyResolveResult resolveResult) {
            if (field == null) {
                CompleteReferenceProcessor.$$$reportNull$$$0(2);
            }
            if (resolveResult == null) {
                CompleteReferenceProcessor.$$$reportNull$$$0(3);
            }
            if (field.getGetters().length != 0 || field.getSetter() != null || !this.myPropertyNames.add(field.getName()) || this.myIsMap) {
                return;
            }
            for (LookupElement lookupElement : GroovyCompletionUtil.createLookupElements(resolveResult, false, CompleteReferenceExpression.this.myMatcher, null)) {
                this.myConsumer.consume((Object)((LookupElementBuilder)lookupElement).withIcon(JetgroovyIcons.Groovy.Property));
            }
        }

        private void processProperty(@NotNull PsiMethod method, @NotNull GroovyResolveResult resolveResult) {
            if (method == null) {
                CompleteReferenceProcessor.$$$reportNull$$$0(4);
            }
            if (resolveResult == null) {
                CompleteReferenceProcessor.$$$reportNull$$$0(5);
            }
            if (this.myIsMap) {
                return;
            }
            LookupElementBuilder lookup = CompleteReferenceExpression.createPropertyLookupElement(method, resolveResult, CompleteReferenceExpression.this.myMatcher);
            if (lookup != null) {
                if (this.myPropertyNames.add(lookup.getLookupString())) {
                    this.myConsumer.consume((Object)lookup);
                }
            } else if (this.myEventListener != null) {
                this.processListenerProperties(method);
            }
        }

        private void processListenerProperties(@NotNull PsiMethod method) {
            if (method == null) {
                CompleteReferenceProcessor.$$$reportNull$$$0(6);
            }
            if (!method.getName().startsWith("add") || method.getParameterList().getParametersCount() != 1) {
                return;
            }
            PsiParameter parameter = method.getParameterList().getParameters()[0];
            PsiType type = parameter.getType();
            if (!(type instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClass listenerClass = classType.resolve();
            if (listenerClass == null) {
                return;
            }
            PsiMethod[] listenerMethods = listenerClass.getMethods();
            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)listenerClass, (PsiClass)this.myEventListener, (boolean)true)) {
                return;
            }
            for (PsiMethod listenerMethod : listenerMethods) {
                String name = listenerMethod.getName();
                if (!this.myPropertyNames.add(name)) continue;
                LookupElementBuilder builder = LookupElementBuilder.create((Object)CompleteReferenceExpression.generatePropertyResolveResult(name, listenerMethod, null, null), (String)name).withIcon(JetgroovyIcons.Groovy.Property);
                this.myConsumer.consume((Object)builder);
            }
        }

        @Override
        @NotNull
        public GroovyResolveResult[] getCandidates() {
            if (!this.hasCandidates()) {
                if (GroovyResolveResult.EMPTY_ARRAY == null) {
                    CompleteReferenceProcessor.$$$reportNull$$$0(7);
                }
                return GroovyResolveResult.EMPTY_ARRAY;
            }
            GroovyResolveResult[] results2 = ResolveUtil.filterSameSignatureCandidates(this.getCandidatesInternal());
            ArrayList<GroovyResolveResult> list = new ArrayList<GroovyResolveResult>(results2.length);
            this.myPropertyNames.removeAll(this.myPreferredFieldNames);
            HashSet usedFields = ContainerUtil.newHashSet();
            for (GroovyResolveResult result : results2) {
                PsiElement element = result.getElement();
                if (element instanceof PsiField) {
                    String name = ((PsiField)element).getName();
                    if (this.myPropertyNames.contains(name) || this.myLocalVars.contains(name) || usedFields.contains(name)) continue;
                    usedFields.add(name);
                }
                list.add(result);
            }
            GroovyResolveResult[] groovyResolveResultArray = list.toArray(new GroovyResolveResult[list.size()]);
            if (groovyResolveResultArray == null) {
                CompleteReferenceProcessor.$$$reportNull$$$0(8);
            }
            return groovyResolveResultArray;
        }

        @NotNull
        private List<GroovyResolveResult> getInapplicableResults() {
            if (this.myInapplicable == null) {
                List<GroovyResolveResult> list = Collections.emptyList();
                if (list == null) {
                    CompleteReferenceProcessor.$$$reportNull$$$0(9);
                }
                return list;
            }
            List<GroovyResolveResult> list = this.myInapplicable;
            if (list == null) {
                CompleteReferenceProcessor.$$$reportNull$$$0(10);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolveResult";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/lang/completion/CompleteReferenceExpression$CompleteReferenceProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/lang/completion/CompleteReferenceExpression$CompleteReferenceProcessor";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCandidates";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInapplicableResults";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "processPropertyFromField";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "processProperty";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "processListenerProperties";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

