/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrRegex;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringContent;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrStringUtil {
    private static final Logger LOG = Logger.getInstance(GrStringUtil.class);
    public static final String TRIPLE_QUOTES = "'''";
    public static final String QUOTE = "'";
    public static final String DOUBLE_QUOTES = "\"";
    public static final String TRIPLE_DOUBLE_QUOTES = "\"\"\"";
    public static final String SLASH = "/";
    public static final String DOLLAR_SLASH = "$/";
    public static final String SLASH_DOLLAR = "/$";

    private GrStringUtil() {
    }

    public static String unescapeString(String s) {
        int length = s.length();
        StringBuilder buffer = new StringBuilder(length);
        boolean escaped = false;
        for (int idx = 0; idx < length; ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            switch (ch) {
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 'b': {
                    buffer.append('\b');
                    break;
                }
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                case '\'': {
                    buffer.append('\'');
                    break;
                }
                case '\"': {
                    buffer.append('\"');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    break;
                }
                case '\n': {
                    break;
                }
                case 'u': {
                    if (idx + 4 < length) {
                        try {
                            int code = Integer.valueOf(s.substring(idx + 1, idx + 5), 16);
                            idx += 4;
                            buffer.append((char)code);
                        }
                        catch (NumberFormatException e) {
                            buffer.append("\\u");
                        }
                        break;
                    }
                    buffer.append("\\u");
                    break;
                }
                default: {
                    buffer.append('\\');
                    buffer.append(ch);
                }
            }
            escaped = false;
        }
        return buffer.toString();
    }

    public static String unescapeSlashyString(String s) {
        return GrStringUtil.unescapeRegex(s, true);
    }

    public static String unescapeDollarSlashyString(String s) {
        return GrStringUtil.unescapeRegex(s, false);
    }

    private static String unescapeRegex(String s, boolean unescapeSlash) {
        int length = s.length();
        StringBuilder buffer = new StringBuilder(length);
        boolean escaped = false;
        for (int idx = 0; idx < length; ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            switch (ch) {
                case '/': {
                    if (!unescapeSlash) {
                        buffer.append('\\');
                    }
                    buffer.append('/');
                    break;
                }
                case 'u': {
                    if (idx + 4 < length) {
                        try {
                            int code = Integer.valueOf(s.substring(idx + 1, idx + 5), 16);
                            idx += 4;
                            buffer.append((char)code);
                        }
                        catch (NumberFormatException e) {
                            buffer.append("\\u");
                        }
                        break;
                    }
                    buffer.append("\\u");
                    break;
                }
                default: {
                    buffer.append('\\');
                    buffer.append(ch);
                }
            }
            escaped = false;
        }
        if (escaped) {
            buffer.append('\\');
        }
        return buffer.toString();
    }

    public static String escapeSymbolsForSlashyStrings(String str) {
        StringBuilder buffer = new StringBuilder(str.length());
        GrStringUtil.escapeSymbolsForSlashyStrings(buffer, str);
        return buffer.toString();
    }

    public static void escapeSymbolsForSlashyStrings(StringBuilder buffer, String str) {
        int length = str.length();
        block3: for (int idx = 0; idx < length; ++idx) {
            char ch = str.charAt(idx);
            switch (ch) {
                case '/': {
                    buffer.append("\\/");
                    continue block3;
                }
                default: {
                    if (Character.isISOControl(ch) || ch == '$') {
                        GrStringUtil.appendUnicode(buffer, ch);
                        continue block3;
                    }
                    buffer.append(ch);
                }
            }
        }
    }

    public static String escapeSymbolsForDollarSlashyStrings(String str) {
        StringBuilder buffer = new StringBuilder(str.length());
        GrStringUtil.escapeSymbolsForDollarSlashyStrings(buffer, str);
        return buffer.toString();
    }

    public static void escapeSymbolsForDollarSlashyStrings(StringBuilder buffer, String str) {
        int length = str.length();
        block3: for (int idx = 0; idx < length; ++idx) {
            char ch = str.charAt(idx);
            switch (ch) {
                case '/': {
                    if (idx + 1 < length && str.charAt(idx + 1) == '$') {
                        GrStringUtil.appendUnicode(buffer, '/');
                        GrStringUtil.appendUnicode(buffer, '$');
                        continue block3;
                    }
                }
                default: {
                    if (Character.isISOControl(ch)) {
                        GrStringUtil.appendUnicode(buffer, ch);
                        continue block3;
                    }
                    buffer.append(ch);
                }
            }
        }
    }

    private static void appendUnicode(StringBuilder buffer, char ch) {
        String hexCode = Integer.toHexString(ch).toUpperCase();
        buffer.append("\\u");
        int paddingCount = 4 - hexCode.length();
        while (paddingCount-- > 0) {
            buffer.append(0);
        }
        buffer.append(hexCode);
    }

    public static String escapeSymbolsForGString(CharSequence s, boolean isSingleLine, boolean unescapeSymbols) {
        StringBuilder b = new StringBuilder();
        GrStringUtil.escapeSymbolsForGString(s, isSingleLine, unescapeSymbols, b);
        return b.toString();
    }

    public static void escapeSymbolsForGString(CharSequence s, boolean isSingleLine, boolean unescapeSymbols, StringBuilder b) {
        GrStringUtil.escapeStringCharacters(s.length(), s, isSingleLine ? "$\"" : "$", isSingleLine, true, b);
        if (unescapeSymbols) {
            GrStringUtil.unescapeCharacters(b, isSingleLine ? QUOTE : "'\"", true);
        }
        if (!isSingleLine) {
            GrStringUtil.escapeLastSymbols(b, '\"');
        }
    }

    public static String escapeSymbolsForString(String s, boolean isSingleLine, boolean forInjection) {
        StringBuilder builder = new StringBuilder();
        GrStringUtil.escapeStringCharacters(s.length(), s, isSingleLine ? QUOTE : "", isSingleLine, true, builder);
        if (!forInjection) {
            GrStringUtil.unescapeCharacters(builder, isSingleLine ? "$\"" : "$'\"", true);
        }
        if (!isSingleLine) {
            GrStringUtil.escapeLastSymbols(builder, '\'');
        }
        return builder.toString();
    }

    private static void escapeLastSymbols(StringBuilder builder, char toEscape) {
        for (int i = builder.length() - 1; i >= 0 && builder.charAt(i) == toEscape; --i) {
            builder.insert(i, '\\');
        }
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull CharSequence str, @Nullable String additionalChars, boolean escapeLineFeeds, boolean escapeBackSlash, @NotNull @NonNls StringBuilder buffer) {
        if (str == null) {
            GrStringUtil.$$$reportNull$$$0(0);
        }
        if (buffer == null) {
            GrStringUtil.$$$reportNull$$$0(1);
        }
        block8: for (int idx = 0; idx < length; ++idx) {
            char ch = str.charAt(idx);
            switch (ch) {
                case '\b': {
                    buffer.append("\\b");
                    continue block8;
                }
                case '\t': {
                    buffer.append("\\t");
                    continue block8;
                }
                case '\f': {
                    buffer.append("\\f");
                    continue block8;
                }
                case '\\': {
                    if (escapeBackSlash) {
                        buffer.append("\\\\");
                        continue block8;
                    }
                    buffer.append('\\');
                    continue block8;
                }
                case '\n': {
                    if (escapeLineFeeds) {
                        buffer.append("\\n");
                        continue block8;
                    }
                    buffer.append('\n');
                    continue block8;
                }
                case '\r': {
                    if (escapeLineFeeds) {
                        buffer.append("\\r");
                        continue block8;
                    }
                    buffer.append('\r');
                    continue block8;
                }
                default: {
                    if (additionalChars != null && additionalChars.indexOf(ch) > -1) {
                        buffer.append("\\").append(ch);
                        continue block8;
                    }
                    if (Character.isISOControl(ch)) {
                        GrStringUtil.appendUnicode(buffer, ch);
                        continue block8;
                    }
                    buffer.append(ch);
                }
            }
        }
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            GrStringUtil.$$$reportNull$$$0(2);
        }
        return stringBuilder;
    }

    public static void unescapeCharacters(StringBuilder builder, String toUnescape, boolean isMultiLine) {
        for (int i = 0; i < builder.length(); ++i) {
            if (builder.charAt(i) != '\\') continue;
            if (i + 1 == builder.length()) break;
            char next = builder.charAt(i + 1);
            if (next == 'n') {
                if (!isMultiLine) continue;
                builder.replace(i, i + 2, "\n");
                continue;
            }
            if (next == 'r') {
                if (!isMultiLine) continue;
                builder.replace(i, i + 2, "\r");
                continue;
            }
            if (toUnescape.indexOf(next) != -1) {
                builder.delete(i, i + 1);
                continue;
            }
            ++i;
        }
    }

    public static String escapeAndUnescapeSymbols(String s, String toEscape, String toUnescape, StringBuilder builder) {
        boolean escaped = false;
        for (int i = 0; i < s.length(); ++i) {
            int ch = s.charAt(i);
            if (escaped) {
                if (toUnescape.indexOf(ch) < 0) {
                    builder.append('\\');
                    builder.append((char)ch);
                } else if (ch == 110) {
                    builder.append('\n');
                } else if (ch == 114) {
                    builder.append('\r');
                } else if (ch == 98) {
                    builder.append('\b');
                } else if (ch == 116) {
                    builder.append('\t');
                } else if (ch == 102) {
                    builder.append('\r');
                } else {
                    builder.append((char)ch);
                }
                escaped = false;
                continue;
            }
            if (ch == 92) {
                escaped = true;
                continue;
            }
            if (toEscape.indexOf(ch) >= 0) {
                builder.append('\\');
                if (ch == 10) {
                    ch = 110;
                } else if (ch == 8) {
                    ch = 98;
                } else if (ch == 9) {
                    ch = 116;
                } else if (ch == 13) {
                    ch = 114;
                } else if (ch == 12) {
                    ch = 102;
                }
            }
            builder.append((char)ch);
        }
        return builder.toString();
    }

    public static String removeQuotes(@NotNull String s) {
        int qL;
        if (s == null) {
            GrStringUtil.$$$reportNull$$$0(3);
        }
        String quote = GrStringUtil.getStartQuote(s);
        int sL = s.length();
        if (sL >= (qL = quote.length()) * 2 && DOLLAR_SLASH.equals(quote)) {
            if (s.endsWith(SLASH_DOLLAR)) {
                return s.substring(qL, sL - qL);
            }
            return s.substring(qL);
        }
        if (sL >= qL * 2 && s.endsWith(quote)) {
            return s.substring(qL, sL - qL);
        }
        return s.substring(qL);
    }

    public static String addQuotes(String s, boolean forGString) {
        if (forGString) {
            if (s.contains("\n") || s.contains("\r")) {
                return TRIPLE_DOUBLE_QUOTES + s + TRIPLE_DOUBLE_QUOTES;
            }
            return DOUBLE_QUOTES + s + DOUBLE_QUOTES;
        }
        if (s.contains("\n") || s.contains("\r")) {
            return TRIPLE_QUOTES + s + TRIPLE_QUOTES;
        }
        return QUOTE + s + QUOTE;
    }

    public static GrString replaceStringInjectionByLiteral(GrStringInjection injection, GrLiteral literal) {
        String literalText;
        GrString grString = (GrString)injection.getParent();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(grString.getProject());
        if (literal instanceof GrString) {
            GrStringInjection last;
            GrStringInjection[] injections = ((GrString)literal).getInjections();
            if (injections.length > 0 && (last = injections[injections.length - 1]).getExpression() != null && !GrStringUtil.checkBraceIsUnnecessary(last.getExpression(), injection.getNextSibling())) {
                GrStringUtil.wrapInjection(last);
            }
            literalText = GrStringUtil.removeQuotes(literal.getText());
        } else {
            String text = GrStringUtil.removeQuotes(literal.getText());
            boolean escapeDoubleQuotes = !text.contains("\n") && grString.isPlainString();
            literalText = GrStringUtil.escapeSymbolsForGString(text, escapeDoubleQuotes, true);
        }
        if (literalText.contains("\n")) {
            GrStringUtil.wrapGStringInto(grString, TRIPLE_DOUBLE_QUOTES);
        }
        GrExpression expression = factory.createExpressionFromText("\"\"\"${}" + literalText + TRIPLE_DOUBLE_QUOTES);
        expression.getFirstChild().delete();
        expression.getFirstChild().delete();
        expression.getFirstChild().delete();
        ASTNode node = grString.getNode();
        if (expression.getFirstChild() != null) {
            if (expression.getFirstChild() == expression.getLastChild()) {
                node.replaceChild(injection.getNode(), expression.getFirstChild().getNode());
            } else {
                node.addChildren(expression.getFirstChild().getNode(), expression.getLastChild().getNode(), injection.getNode());
                node.removeChild(injection.getNode());
            }
        }
        return grString;
    }

    private static void wrapGStringInto(GrString grString, String quotes) {
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(grString.getProject());
        PsiElement firstChild = grString.getFirstChild();
        PsiElement lastChild = grString.getLastChild();
        GrExpression template = factory.createExpressionFromText(quotes + "$x" + quotes);
        if (firstChild != null && firstChild.getNode().getElementType() == GroovyTokenTypes.mGSTRING_BEGIN && !quotes.equals(firstChild.getText())) {
            grString.getNode().replaceChild(firstChild.getNode(), template.getFirstChild().getNode());
        }
        if (lastChild != null && lastChild.getNode().getElementType() == GroovyTokenTypes.mGSTRING_END && !quotes.equals(lastChild.getText())) {
            grString.getNode().replaceChild(lastChild.getNode(), template.getLastChild().getNode());
        }
    }

    public static void wrapInjection(GrStringInjection injection) {
        GrExpression expression = injection.getExpression();
        LOG.assertTrue(expression != null);
        GroovyPsiElementFactory instance = GroovyPsiElementFactory.getInstance(injection.getProject());
        GrClosableBlock closure = instance.createClosureFromText("{foo}");
        closure.getNode().replaceChild(closure.getStatements()[0].getNode(), expression.getNode());
        injection.getNode().addChild(closure.getNode());
        CodeEditUtil.setNodeGeneratedRecursively((ASTNode)expression.getNode(), (boolean)true);
    }

    public static boolean checkGStringInjectionForUnnecessaryBraces(GrStringInjection injection) {
        GrClosableBlock block = injection.getClosableBlock();
        if (block == null) {
            return false;
        }
        GrStatement[] statements = block.getStatements();
        if (statements.length != 1) {
            return false;
        }
        if (!(statements[0] instanceof GrReferenceExpression)) {
            return false;
        }
        return GrStringUtil.checkBraceIsUnnecessary(statements[0], injection.getNextSibling());
    }

    private static boolean checkBraceIsUnnecessary(GrStatement injected, PsiElement next) {
        GrExpression gString;
        char nextChar;
        if (next.getTextLength() == 0) {
            next = next.getNextSibling();
        }
        if ((nextChar = next.getText().charAt(0)) == '\"' || nextChar == '$') {
            return true;
        }
        GroovyPsiElementFactory elementFactory = GroovyPsiElementFactory.getInstance(injected.getProject());
        try {
            gString = elementFactory.createExpressionFromText("\"$" + injected.getText() + next.getText() + '\"');
        }
        catch (Exception e) {
            return false;
        }
        if (!(gString instanceof GrString)) {
            return false;
        }
        PsiElement child = gString.getFirstChild();
        if (child.getNode().getElementType() != GroovyTokenTypes.mGSTRING_BEGIN) {
            return false;
        }
        if (!((child = child.getNextSibling()) instanceof GrStringContent)) {
            return false;
        }
        if (!((child = child.getNextSibling()) instanceof GrStringInjection)) {
            return false;
        }
        GrExpression refExprCopy = ((GrStringInjection)child).getExpression();
        if (!(refExprCopy instanceof GrReferenceExpression)) {
            return false;
        }
        GrReferenceExpression refExpr = (GrReferenceExpression)injected;
        return PsiUtil.checkPsiElementsAreEqual(refExpr, refExprCopy);
    }

    public static void removeUnnecessaryBracesInGString(GrString grString) {
        for (GrStringInjection child : grString.getInjections()) {
            if (!GrStringUtil.checkGStringInjectionForUnnecessaryBraces(child)) continue;
            GrClosableBlock closableBlock = child.getClosableBlock();
            GrReferenceExpression refExpr = (GrReferenceExpression)closableBlock.getStatements()[0];
            GrReferenceExpression copy = (GrReferenceExpression)refExpr.copy();
            ASTNode oldNode = closableBlock.getNode();
            oldNode.getTreeParent().replaceChild(oldNode, copy.getNode());
        }
    }

    public static String getStartQuote(String text) {
        if (text.startsWith(TRIPLE_QUOTES)) {
            return TRIPLE_QUOTES;
        }
        if (text.startsWith(QUOTE)) {
            return QUOTE;
        }
        if (text.startsWith(TRIPLE_DOUBLE_QUOTES)) {
            return TRIPLE_DOUBLE_QUOTES;
        }
        if (text.startsWith(DOUBLE_QUOTES)) {
            return DOUBLE_QUOTES;
        }
        if (text.startsWith(SLASH)) {
            return SLASH;
        }
        if (text.startsWith(DOLLAR_SLASH)) {
            return DOLLAR_SLASH;
        }
        return "";
    }

    public static String getEndQuote(String text) {
        if (text.endsWith(TRIPLE_QUOTES)) {
            return TRIPLE_QUOTES;
        }
        if (text.endsWith(QUOTE)) {
            return QUOTE;
        }
        if (text.endsWith(TRIPLE_DOUBLE_QUOTES)) {
            return TRIPLE_DOUBLE_QUOTES;
        }
        if (text.endsWith(DOUBLE_QUOTES)) {
            return DOUBLE_QUOTES;
        }
        if (text.endsWith(SLASH)) {
            return SLASH;
        }
        if (text.endsWith(SLASH_DOLLAR)) {
            return SLASH_DOLLAR;
        }
        return "";
    }

    @Nullable
    @Contract(value="null -> null")
    public static TextRange getStringContentRange(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        IElementType elementType = element.getNode().getElementType();
        if (elementType != GroovyTokenTypes.mSTRING_LITERAL && elementType != GroovyTokenTypes.mGSTRING_LITERAL) {
            return null;
        }
        String text = element.getText();
        String startQuote = GrStringUtil.getStartQuote(text);
        String endQuote = GrStringUtil.getEndQuote(text.substring(startQuote.length()));
        return new TextRange(startQuote.length(), element.getTextLength() - endQuote.length());
    }

    public static boolean parseRegexCharacters(@NotNull String chars, @NotNull StringBuilder outChars, @Nullable int[] sourceOffsets, boolean escapeSlash) {
        if (chars == null) {
            GrStringUtil.$$$reportNull$$$0(4);
        }
        if (outChars == null) {
            GrStringUtil.$$$reportNull$$$0(5);
        }
        assert (sourceOffsets == null || sourceOffsets.length == chars.length() + 1);
        if (chars.indexOf(92) < 0) {
            outChars.append(chars);
            if (sourceOffsets != null) {
                for (int i = 0; i < sourceOffsets.length; ++i) {
                    sourceOffsets[i] = i;
                }
            }
            return true;
        }
        int index = 0;
        int outOffset = outChars.length();
        block8: while (index < chars.length()) {
            char c = chars.charAt(index++);
            if (sourceOffsets != null) {
                sourceOffsets[outChars.length() - outOffset] = index - 1;
                sourceOffsets[outChars.length() + 1 - outOffset] = index;
            }
            if (c != '\\') {
                outChars.append(c);
                continue;
            }
            if (index == chars.length()) {
                outChars.append('\\');
                return true;
            }
            c = chars.charAt(index++);
            switch (c) {
                case '/': {
                    if (escapeSlash) {
                        outChars.append(c);
                        if (sourceOffsets == null) continue block8;
                        sourceOffsets[outChars.length() - outOffset] = index;
                        break;
                    }
                    outChars.append('\\').append('/');
                    break;
                }
                case '\n': {
                    if (sourceOffsets == null) continue block8;
                    sourceOffsets[outChars.length() - outOffset] = index;
                    break;
                }
                case 'u': {
                    while (index != chars.length() && chars.charAt(index) == 'u') {
                        ++index;
                    }
                    if (index + 4 <= chars.length()) {
                        try {
                            int code = Integer.parseInt(chars.substring(index, index + 4), 16);
                            c = chars.charAt(index);
                            if (c == '+' || c == '-') {
                                return false;
                            }
                            outChars.append((char)code);
                            index += 4;
                            if (sourceOffsets == null) continue block8;
                            sourceOffsets[outChars.length() - outOffset] = index;
                            break;
                        }
                        catch (Exception e) {
                            return false;
                        }
                    }
                    return false;
                }
                default: {
                    outChars.append('\\').append(c);
                    if (sourceOffsets == null) continue block8;
                    sourceOffsets[outChars.length() - outOffset] = index;
                }
            }
        }
        return true;
    }

    public static boolean parseStringCharacters(@NotNull String chars, @NotNull StringBuilder outChars, @Nullable int[] sourceOffsets) {
        if (chars == null) {
            GrStringUtil.$$$reportNull$$$0(6);
        }
        if (outChars == null) {
            GrStringUtil.$$$reportNull$$$0(7);
        }
        assert (sourceOffsets == null || sourceOffsets.length == chars.length() + 1);
        if (chars.indexOf(92) < 0) {
            outChars.append(chars);
            if (sourceOffsets != null) {
                for (int i = 0; i < sourceOffsets.length; ++i) {
                    sourceOffsets[i] = i;
                }
            }
            return true;
        }
        int index = 0;
        int outOffset = outChars.length();
        while (index < chars.length()) {
            char c = chars.charAt(index++);
            if (sourceOffsets != null) {
                sourceOffsets[outChars.length() - outOffset] = index - 1;
                sourceOffsets[outChars.length() + 1 - outOffset] = index;
            }
            if (c != '\\') {
                outChars.append(c);
                continue;
            }
            if (index == chars.length()) {
                return false;
            }
            c = chars.charAt(index++);
            switch (c) {
                case 'b': {
                    outChars.append('\b');
                    break;
                }
                case 't': {
                    outChars.append('\t');
                    break;
                }
                case 'n': {
                    outChars.append('\n');
                    break;
                }
                case 'f': {
                    outChars.append('\f');
                    break;
                }
                case 'r': {
                    outChars.append('\r');
                    break;
                }
                case '\"': {
                    outChars.append('\"');
                    break;
                }
                case '\'': {
                    outChars.append('\'');
                    break;
                }
                case '$': {
                    outChars.append('$');
                    break;
                }
                case '\\': {
                    outChars.append('\\');
                    break;
                }
                case '\n': {
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    char startC = c;
                    int v = c - 48;
                    if (index < chars.length()) {
                        if ('0' <= (c = chars.charAt(index++)) && c <= '7') {
                            v <<= 3;
                            v += c - 48;
                            if (startC <= '3' && index < chars.length()) {
                                if ('0' <= (c = chars.charAt(index++)) && c <= '7') {
                                    v <<= 3;
                                    v += c - 48;
                                } else {
                                    --index;
                                }
                            }
                        } else {
                            --index;
                        }
                    }
                    outChars.append((char)v);
                    break;
                }
                case 'u': {
                    while (index != chars.length() && chars.charAt(index) == 'u') {
                        ++index;
                    }
                    if (index + 4 <= chars.length()) {
                        try {
                            int code = Integer.parseInt(chars.substring(index, index + 4), 16);
                            if (code == 10 || code == 13) {
                                return false;
                            }
                            c = chars.charAt(index);
                            if (c == '+' || c == '-') {
                                return false;
                            }
                            outChars.append((char)code);
                            index += 4;
                            break;
                        }
                        catch (Exception e) {
                            return false;
                        }
                    }
                    return false;
                }
                default: {
                    return false;
                }
            }
            if (sourceOffsets == null) continue;
            sourceOffsets[outChars.length() - outOffset] = index;
        }
        return true;
    }

    public static GrLiteral createStringFromRegex(@NotNull GrLiteral regex) {
        if (regex == null) {
            GrStringUtil.$$$reportNull$$$0(8);
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(regex.getProject());
        if (regex instanceof GrRegex) {
            StringBuilder builder = new StringBuilder();
            String quote = regex.getText().indexOf(10) >= 0 ? TRIPLE_DOUBLE_QUOTES : DOUBLE_QUOTES;
            builder.append(quote);
            for (PsiElement child = regex.getFirstChild(); child != null; child = child.getNextSibling()) {
                IElementType type = child.getNode().getElementType();
                if (type == GroovyTokenTypes.mREGEX_CONTENT || type == GroovyElementTypes.GSTRING_CONTENT) {
                    builder.append(GrStringUtil.escapeSymbolsForGString(GrStringUtil.unescapeSlashyString(child.getText()), quote.equals(DOUBLE_QUOTES), true));
                    continue;
                }
                if (type == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_CONTENT) {
                    builder.append(GrStringUtil.escapeSymbolsForGString(GrStringUtil.unescapeDollarSlashyString(child.getText()), quote.equals(DOUBLE_QUOTES), true));
                    continue;
                }
                if (type != GroovyElementTypes.GSTRING_INJECTION) continue;
                builder.append(child.getText());
            }
            builder.append(quote);
            return (GrLiteral)factory.createExpressionFromText(builder.toString());
        }
        Object value = regex.getValue();
        LOG.assertTrue(value == null || value instanceof String);
        if (value == null) {
            value = GrStringUtil.removeQuotes(regex.getText());
        }
        return factory.createLiteralFromValue(value);
    }

    public static boolean isWellEndedString(PsiElement element) {
        String text = element.getText();
        if (!(text.endsWith(QUOTE) || text.endsWith(DOUBLE_QUOTES) || text.endsWith(TRIPLE_QUOTES) || text.endsWith(TRIPLE_DOUBLE_QUOTES) || text.endsWith(SLASH) || text.endsWith(SLASH_DOLLAR))) {
            return false;
        }
        IElementType type = element.getNode().getElementType();
        if (TokenSets.STRING_LITERAL_SET.contains(type)) {
            return true;
        }
        PsiElement lastChild = element.getLastChild();
        if (lastChild == null) {
            return false;
        }
        IElementType lastType = lastChild.getNode().getElementType();
        if (type == GroovyElementTypes.GSTRING) {
            return lastType == GroovyTokenTypes.mGSTRING_END;
        }
        if (type == GroovyElementTypes.REGEX) {
            return lastType == GroovyTokenTypes.mREGEX_END || lastType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_END;
        }
        return false;
    }

    public static void fixAllTripleQuotes(StringBuilder builder, int position) {
        int i = builder.indexOf(TRIPLE_QUOTES, position);
        while (i >= 0) {
            builder.replace(i + 2, i + 3, "\\'");
            i = builder.indexOf(TRIPLE_QUOTES, i);
        }
    }

    public static void fixAllTripleDoubleQuotes(StringBuilder builder, int position) {
        int i = builder.indexOf(TRIPLE_DOUBLE_QUOTES, position);
        while (i >= 0) {
            builder.replace(i + 2, i + 3, "\\\"");
            i = builder.indexOf(TRIPLE_DOUBLE_QUOTES, i);
        }
    }

    public static boolean isPlainStringLiteral(ASTNode node) {
        String text = node.getText();
        return text.length() < 3 && text.equals("''") || text.length() >= 3 && !text.startsWith(TRIPLE_QUOTES);
    }

    public static boolean isMultilineStringLiteral(GrLiteral literal) {
        String quote = GrStringUtil.getStartQuote(literal.getText());
        return TRIPLE_QUOTES.equals(quote) || TRIPLE_DOUBLE_QUOTES.equals(quote) || SLASH.equals(quote) || DOLLAR_SLASH.equals(quote);
    }

    public static boolean isSinglelineStringLiteral(GrLiteral literal) {
        String quote = GrStringUtil.getStartQuote(literal.getText());
        return QUOTE.equals(quote) || DOUBLE_QUOTES.equals(quote);
    }

    public static StringBuilder getLiteralTextByValue(String value) {
        StringBuilder buffer = new StringBuilder();
        if (value.indexOf(10) >= 0) {
            buffer.append(TRIPLE_QUOTES);
            GrStringUtil.escapeStringCharacters(value.length(), value, "", false, true, buffer);
            buffer.append(TRIPLE_QUOTES);
        } else {
            buffer.append(QUOTE);
            GrStringUtil.escapeStringCharacters(value.length(), value, QUOTE, false, true, buffer);
            buffer.append(QUOTE);
        }
        return buffer;
    }

    public static PsiElement findContainingLiteral(PsiElement token) {
        PsiElement parent = token.getParent();
        if (parent instanceof GrStringContent) {
            parent = parent.getParent();
        }
        return parent;
    }

    public static boolean isStringLiteral(GrLiteral literal) {
        if (literal instanceof GrString) {
            return true;
        }
        if (literal instanceof GrLiteralImpl) {
            IElementType type = GrLiteralImpl.getLiteralType(literal);
            return TokenSets.STRING_LITERAL_SET.contains(type);
        }
        return false;
    }

    public static boolean isRegex(GrLiteral literal) {
        if (literal instanceof GrRegex) {
            return true;
        }
        String quote = GrStringUtil.getStartQuote(literal.getText());
        return SLASH.equals(quote) || DOLLAR_SLASH.equals(quote);
    }

    public static boolean isSlashyString(GrLiteral literal) {
        return SLASH.equals(GrStringUtil.getStartQuote(literal.getText()));
    }

    public static boolean isDollarSlashyString(GrLiteral literal) {
        return DOLLAR_SLASH.equals(GrStringUtil.getStartQuote(literal.getText()));
    }

    public static boolean isSingleQuoteString(GrLiteral literal) {
        return QUOTE.equals(GrStringUtil.getStartQuote(literal.getText()));
    }

    public static boolean isDoubleQuoteString(GrLiteral literal) {
        return DOUBLE_QUOTES.equals(GrStringUtil.getStartQuote(literal.getText()));
    }

    public static boolean isTripleQuoteString(GrLiteral literal) {
        return TRIPLE_QUOTES.equals(GrStringUtil.getStartQuote(literal.getText()));
    }

    public static boolean isTripleDoubleQuoteString(GrLiteral literal) {
        return TRIPLE_DOUBLE_QUOTES.equals(GrStringUtil.getStartQuote(literal.getText()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/util/GrStringUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outChars";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/util/GrStringUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeStringCharacters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "escapeStringCharacters";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeQuotes";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseRegexCharacters";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseStringCharacters";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createStringFromRegex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

