/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.imports;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0014\u0010\u0013\u001a\u00020\u00102\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0006\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\t0\rj\b\u0012\u0004\u0012\u00020\t`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/imports/ReferencedImportsSearcher;", "Lcom/intellij/psi/PsiRecursiveElementWalkingVisitor;", "()V", "referencedStatements", "Lcom/intellij/util/containers/HashSet;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/toplevel/imports/GrImportStatement;", "results", "Lkotlin/Pair;", "", "", "getResults", "()Lkotlin/Pair;", "unresolvedReferenceNames", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "visitElement", "", "element", "Lcom/intellij/psi/PsiElement;", "visitRefElement", "refElement", "Lorg/jetbrains/plugins/groovy/lang/psi/GrReferenceElement;", "groovy-psi"})
final class ReferencedImportsSearcher
extends PsiRecursiveElementWalkingVisitor {
    private final HashSet<GrImportStatement> referencedStatements = new HashSet();
    private final LinkedHashSet<String> unresolvedReferenceNames = new LinkedHashSet();

    @NotNull
    public final Pair<Set<GrImportStatement>, Set<String>> getResults() {
        return TuplesKt.to(this.referencedStatements, this.unresolvedReferenceNames);
    }

    public void visitElement(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (!(element instanceof GrImportStatement) && !(element instanceof GrPackageDefinition)) {
            super.visitElement(element);
        }
        if (element instanceof GrReferenceElement) {
            this.visitRefElement((GrReferenceElement)element);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void visitRefElement(GrReferenceElement<?> refElement) {
        if (refElement.isQualified()) {
            return;
        }
        String refName = refElement.getReferenceName();
        if (refName == null || Intrinsics.areEqual((Object)"super", (Object)refName)) {
            return;
        }
        GroovyResolveResult[] results2 = refElement.multiResolve(false);
        Object[] objectArray = results2;
        if (objectArray.length == 0) {
            this.unresolvedReferenceNames.add(refName);
        } else {
            void $receiver$iv;
            objectArray = results2;
            Collection destination$iv = (Collection)this.referencedStatements;
            for (void element$iv$iv : $receiver$iv) {
                GrImportStatement grImportStatement;
                void element$iv = element$iv$iv;
                GroovyResolveResult it = (GroovyResolveResult)element$iv;
                PsiElement psiElement = it.getCurrentFileResolveContext();
                if (!(psiElement instanceof GrImportStatement)) {
                    psiElement = null;
                }
                if ((GrImportStatement)psiElement == null) continue;
                GrImportStatement it$iv = grImportStatement;
                destination$iv.add(it$iv);
            }
        }
    }
}

