/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionContext;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GenerationUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.Generator;

public class AnnotationGenerator
extends Generator {
    @NotNull
    private List<String> SKIPPED = Collections.singletonList("groovy.transform");
    private final StringBuilder builder;
    private final ExpressionContext context;
    private final ExpressionGenerator expressionGenerator;

    public AnnotationGenerator(StringBuilder builder, ExpressionContext context) {
        this.builder = builder;
        this.context = context.extend();
        this.expressionGenerator = new ExpressionGenerator(builder, context);
    }

    @Override
    public StringBuilder getBuilder() {
        return this.builder;
    }

    @Override
    public ExpressionContext getContext() {
        return this.context;
    }

    @Override
    public void visitExpression(@NotNull GrExpression expression) {
        if (expression == null) {
            AnnotationGenerator.$$$reportNull$$$0(0);
        }
        expression.accept(this.expressionGenerator);
    }

    @Override
    public void visitAnnotationArrayInitializer(@NotNull GrAnnotationArrayInitializer arrayInitializer) {
        if (arrayInitializer == null) {
            AnnotationGenerator.$$$reportNull$$$0(1);
        }
        GrAnnotationMemberValue[] initializers = arrayInitializer.getInitializers();
        this.builder.append('{');
        for (GrAnnotationMemberValue initializer : initializers) {
            initializer.accept(this);
            this.builder.append(", ");
        }
        if (initializers.length > 0) {
            this.builder.delete(this.builder.length() - 2, this.builder.length());
        }
        this.builder.append('}');
    }

    @Override
    public void visitAnnotation(@NotNull GrAnnotation annotation) {
        String qualifiedName;
        if (annotation == null) {
            AnnotationGenerator.$$$reportNull$$$0(2);
        }
        if ((qualifiedName = annotation.getQualifiedName()) != null) {
            if (this.SKIPPED.stream().anyMatch(qualifiedName::contains)) {
                return;
            }
        }
        this.builder.append('@');
        GrCodeReferenceElement classReference = annotation.getClassReference();
        GenerationUtil.writeCodeReferenceElement(this.builder, classReference);
        GrAnnotationArgumentList parameterList = annotation.getParameterList();
        GrAnnotationNameValuePair[] attributes = parameterList.getAttributes();
        if (attributes.length == 0) {
            return;
        }
        this.builder.append('(');
        for (GrAnnotationNameValuePair attribute : attributes) {
            GrAnnotationMemberValue value;
            String name = attribute.getName();
            if (name != null) {
                this.builder.append(name);
                this.builder.append(" = ");
            }
            if ((value = attribute.getValue()) != null) {
                value.accept(this);
            }
            this.builder.append(", ");
        }
        this.builder.delete(this.builder.length() - 2, this.builder.length());
        this.builder.append(')');
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayInitializer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/convertToJava/AnnotationGenerator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAnnotationArrayInitializer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAnnotation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

